/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.mojang.serialization.Codec;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FallenTreeConfiguration;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;

public class FallenTreeFeature
extends Feature<FallenTreeConfiguration> {
    private static final int STUMP_HEIGHT = 1;
    private static final int STUMP_HEIGHT_PLUS_EMPTY_SPACE = 2;
    private static final int FALLEN_LOG_MAX_FALL_HEIGHT_TO_GROUND = 5;
    private static final int FALLEN_LOG_MAX_GROUND_GAP = 2;
    private static final int FALLEN_LOG_MAX_SPACE_FROM_STUMP = 2;
    private static final int BLOCK_UPDATE_FLAGS = 19;

    public FallenTreeFeature(Codec<FallenTreeConfiguration> var0) {
        super(var0);
    }

    @Override
    public boolean place(FeaturePlaceContext<FallenTreeConfiguration> var0) {
        this.placeFallenTree(var0.config(), var0.origin(), var0.level(), var0.random());
        return true;
    }

    private void placeFallenTree(FallenTreeConfiguration var0, BlockPos var1, WorldGenLevel var2, RandomSource var3) {
        this.placeStump(var0, var2, var3, var1.mutable());
        Direction var4 = Direction.Plane.HORIZONTAL.getRandomDirection(var3);
        int var5 = var0.logLength.sample(var3) - 2;
        BlockPos.MutableBlockPos var6 = var1.relative(var4, 2 + var3.nextInt(2)).mutable();
        this.setGroundHeightForFallenLogStartPos(var2, var6);
        if (this.canPlaceEntireFallenLog(var2, var5, var6, var4)) {
            this.placeFallenLog(var0, var2, var3, var5, var6, var4);
        }
    }

    private void setGroundHeightForFallenLogStartPos(WorldGenLevel var0, BlockPos.MutableBlockPos var1) {
        var1.move(Direction.UP, 1);
        for (int var2 = 0; var2 < 6; ++var2) {
            if (this.mayPlaceOn(var0, var1)) {
                return;
            }
            var1.move(Direction.DOWN);
        }
    }

    private void placeStump(FallenTreeConfiguration var0, WorldGenLevel var1, RandomSource var2, BlockPos.MutableBlockPos var3) {
        BlockPos var4 = this.placeLogBlock(var0, var1, var2, var3, Function.identity());
        this.decorateLogs(var1, var2, Set.of(var4), var0.stumpDecorators);
    }

    private boolean canPlaceEntireFallenLog(WorldGenLevel var0, int var1, BlockPos.MutableBlockPos var2, Direction var3) {
        int var4 = 0;
        for (int var5 = 0; var5 < var1; ++var5) {
            if (!TreeFeature.validTreePos(var0, var2)) {
                return false;
            }
            if (!this.isOverSolidGround(var0, var2)) {
                if (++var4 > 2) {
                    return false;
                }
            } else {
                var4 = 0;
            }
            var2.move(var3);
        }
        var2.move(var3.getOpposite(), var1);
        return true;
    }

    private void placeFallenLog(FallenTreeConfiguration var0, WorldGenLevel var1, RandomSource var2, int var3, BlockPos.MutableBlockPos var4, Direction var5) {
        HashSet<BlockPos> var6 = new HashSet<BlockPos>();
        for (int var7 = 0; var7 < var3; ++var7) {
            var6.add(this.placeLogBlock(var0, var1, var2, var4, FallenTreeFeature.getSidewaysStateModifier(var5)));
            var4.move(var5);
        }
        this.decorateLogs(var1, var2, var6, var0.logDecorators);
    }

    private boolean mayPlaceOn(LevelAccessor var0, BlockPos var1) {
        return TreeFeature.validTreePos(var0, var1) && this.isOverSolidGround(var0, var1);
    }

    private boolean isOverSolidGround(LevelAccessor var0, BlockPos var1) {
        return var0.getBlockState(var1.below()).isFaceSturdy(var0, var1, Direction.UP);
    }

    private BlockPos placeLogBlock(FallenTreeConfiguration var0, WorldGenLevel var1, RandomSource var2, BlockPos.MutableBlockPos var3, Function<BlockState, BlockState> var4) {
        var1.setBlock(var3, var4.apply(var0.trunkProvider.getState(var2, var3)), 3);
        this.markAboveForPostProcessing(var1, var3);
        return var3.immutable();
    }

    private void decorateLogs(WorldGenLevel var0, RandomSource var12, Set<BlockPos> var2, List<TreeDecorator> var3) {
        if (!var3.isEmpty()) {
            TreeDecorator.Context var4 = new TreeDecorator.Context(var0, this.getDecorationSetter(var0), var12, var2, Set.of(), Set.of());
            var3.forEach(var1 -> var1.place(var4));
        }
    }

    private BiConsumer<BlockPos, BlockState> getDecorationSetter(WorldGenLevel var0) {
        return (var1, var2) -> var0.setBlock((BlockPos)var1, (BlockState)var2, 19);
    }

    private static Function<BlockState, BlockState> getSidewaysStateModifier(Direction var0) {
        return var1 -> (BlockState)var1.trySetValue(RotatedPillarBlock.AXIS, var0.getAxis());
    }
}

