/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SnowyDirtBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class SnowAndFreezeFeature
extends Feature<NoneFeatureConfiguration> {
    public SnowAndFreezeFeature(Codec<NoneFeatureConfiguration> var0) {
        super(var0);
    }

    @Override
    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> var0) {
        WorldGenLevel var1 = var0.level();
        BlockPos var2 = var0.origin();
        BlockPos.MutableBlockPos var3 = new BlockPos.MutableBlockPos();
        BlockPos.MutableBlockPos var4 = new BlockPos.MutableBlockPos();
        for (int var5 = 0; var5 < 16; ++var5) {
            for (int var6 = 0; var6 < 16; ++var6) {
                int var7 = var2.getX() + var5;
                int var8 = var2.getZ() + var6;
                int var9 = var1.getHeight(Heightmap.Types.MOTION_BLOCKING, var7, var8);
                var3.set(var7, var9, var8);
                var4.set(var3).move(Direction.DOWN, 1);
                Biome var10 = var1.getBiome(var3).value();
                if (var10.shouldFreeze(var1, var4, false)) {
                    var1.setBlock(var4, Blocks.ICE.defaultBlockState(), 2);
                }
                if (!var10.shouldSnow(var1, var3)) continue;
                var1.setBlock(var3, Blocks.SNOW.defaultBlockState(), 2);
                BlockState var11 = var1.getBlockState(var4);
                if (!var11.hasProperty(SnowyDirtBlock.SNOWY)) continue;
                var1.setBlock(var4, (BlockState)var11.setValue(SnowyDirtBlock.SNOWY, true), 2);
            }
        }
        return true;
    }
}

