/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature.configurations;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSize;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.rootplacers.RootPlacer;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;

public class TreeConfiguration
implements FeatureConfiguration {
    public static final Codec<TreeConfiguration> CODEC = RecordCodecBuilder.create(var02 -> var02.group((App)BlockStateProvider.CODEC.fieldOf("trunk_provider").forGetter(var0 -> var0.trunkProvider), (App)TrunkPlacer.CODEC.fieldOf("trunk_placer").forGetter(var0 -> var0.trunkPlacer), (App)BlockStateProvider.CODEC.fieldOf("foliage_provider").forGetter(var0 -> var0.foliageProvider), (App)FoliagePlacer.CODEC.fieldOf("foliage_placer").forGetter(var0 -> var0.foliagePlacer), (App)RootPlacer.CODEC.optionalFieldOf("root_placer").forGetter(var0 -> var0.rootPlacer), (App)BlockStateProvider.CODEC.fieldOf("dirt_provider").forGetter(var0 -> var0.dirtProvider), (App)FeatureSize.CODEC.fieldOf("minimum_size").forGetter(var0 -> var0.minimumSize), (App)TreeDecorator.CODEC.listOf().fieldOf("decorators").forGetter(var0 -> var0.decorators), (App)Codec.BOOL.fieldOf("ignore_vines").orElse((Object)false).forGetter(var0 -> var0.ignoreVines), (App)Codec.BOOL.fieldOf("force_dirt").orElse((Object)false).forGetter(var0 -> var0.forceDirt)).apply((Applicative)var02, TreeConfiguration::new));
    public final BlockStateProvider trunkProvider;
    public final BlockStateProvider dirtProvider;
    public final TrunkPlacer trunkPlacer;
    public final BlockStateProvider foliageProvider;
    public final FoliagePlacer foliagePlacer;
    public final Optional<RootPlacer> rootPlacer;
    public final FeatureSize minimumSize;
    public final List<TreeDecorator> decorators;
    public final boolean ignoreVines;
    public final boolean forceDirt;

    protected TreeConfiguration(BlockStateProvider var0, TrunkPlacer var1, BlockStateProvider var2, FoliagePlacer var3, Optional<RootPlacer> var4, BlockStateProvider var5, FeatureSize var6, List<TreeDecorator> var7, boolean var8, boolean var9) {
        this.trunkProvider = var0;
        this.trunkPlacer = var1;
        this.foliageProvider = var2;
        this.foliagePlacer = var3;
        this.rootPlacer = var4;
        this.dirtProvider = var5;
        this.minimumSize = var6;
        this.decorators = var7;
        this.ignoreVines = var8;
        this.forceDirt = var9;
    }

    public static class TreeConfigurationBuilder {
        public final BlockStateProvider trunkProvider;
        private final TrunkPlacer trunkPlacer;
        public final BlockStateProvider foliageProvider;
        private final FoliagePlacer foliagePlacer;
        private final Optional<RootPlacer> rootPlacer;
        private BlockStateProvider dirtProvider;
        private final FeatureSize minimumSize;
        private List<TreeDecorator> decorators = ImmutableList.of();
        private boolean ignoreVines;
        private boolean forceDirt;

        public TreeConfigurationBuilder(BlockStateProvider var0, TrunkPlacer var1, BlockStateProvider var2, FoliagePlacer var3, Optional<RootPlacer> var4, FeatureSize var5) {
            this.trunkProvider = var0;
            this.trunkPlacer = var1;
            this.foliageProvider = var2;
            this.dirtProvider = BlockStateProvider.simple(Blocks.DIRT);
            this.foliagePlacer = var3;
            this.rootPlacer = var4;
            this.minimumSize = var5;
        }

        public TreeConfigurationBuilder(BlockStateProvider var0, TrunkPlacer var1, BlockStateProvider var2, FoliagePlacer var3, FeatureSize var4) {
            this(var0, var1, var2, var3, Optional.empty(), var4);
        }

        public TreeConfigurationBuilder dirt(BlockStateProvider var0) {
            this.dirtProvider = var0;
            return this;
        }

        public TreeConfigurationBuilder decorators(List<TreeDecorator> var0) {
            this.decorators = var0;
            return this;
        }

        public TreeConfigurationBuilder ignoreVines() {
            this.ignoreVines = true;
            return this;
        }

        public TreeConfigurationBuilder forceDirt() {
            this.forceDirt = true;
            return this;
        }

        public TreeConfiguration build() {
            return new TreeConfiguration(this.trunkProvider, this.trunkPlacer, this.foliageProvider, this.foliagePlacer, this.rootPlacer, this.dirtProvider, this.minimumSize, this.decorators, this.ignoreVines, this.forceDirt);
        }
    }
}

