/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature.stateproviders;

import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProviderType;
import net.minecraft.world.level.levelgen.feature.stateproviders.NoiseBasedStateProvider;
import net.minecraft.world.level.levelgen.synth.NormalNoise;

public class NoiseProvider
extends NoiseBasedStateProvider {
    public static final MapCodec<NoiseProvider> CODEC = RecordCodecBuilder.mapCodec(var0 -> NoiseProvider.noiseProviderCodec(var0).apply((Applicative)var0, NoiseProvider::new));
    protected final List<BlockState> states;

    protected static <P extends NoiseProvider> Products.P4<RecordCodecBuilder.Mu<P>, Long, NormalNoise.NoiseParameters, Float, List<BlockState>> noiseProviderCodec(RecordCodecBuilder.Instance<P> var02) {
        return NoiseProvider.noiseCodec(var02).and((App)ExtraCodecs.nonEmptyList(BlockState.CODEC.listOf()).fieldOf("states").forGetter(var0 -> var0.states));
    }

    public NoiseProvider(long var0, NormalNoise.NoiseParameters var2, float var3, List<BlockState> var4) {
        super(var0, var2, var3);
        this.states = var4;
    }

    @Override
    protected BlockStateProviderType<?> type() {
        return BlockStateProviderType.NOISE_PROVIDER;
    }

    @Override
    public BlockState getState(RandomSource var0, BlockPos var1) {
        return this.getRandomState(this.states, var1, this.scale);
    }

    protected BlockState getRandomState(List<BlockState> var0, BlockPos var1, double var2) {
        double var4 = this.getNoiseValue(var1, var2);
        return this.getRandomState(var0, var4);
    }

    protected BlockState getRandomState(List<BlockState> var0, double var1) {
        double var3 = Mth.clamp((1.0 + var1) / 2.0, 0.0, 0.9999);
        return var0.get((int)(var3 * (double)var0.size()));
    }
}

