/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure;

import java.util.Optional;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;

public abstract class SinglePieceStructure
extends Structure {
    private final PieceConstructor constructor;
    private final int width;
    private final int depth;

    protected SinglePieceStructure(PieceConstructor var0, int var1, int var2, Structure.StructureSettings var3) {
        super(var3);
        this.constructor = var0;
        this.width = var1;
        this.depth = var2;
    }

    @Override
    public Optional<Structure.GenerationStub> findGenerationPoint(Structure.GenerationContext var0) {
        if (SinglePieceStructure.getLowestY(var0, this.width, this.depth) < var0.chunkGenerator().getSeaLevel()) {
            return Optional.empty();
        }
        return SinglePieceStructure.onTopOfChunkCenter(var0, Heightmap.Types.WORLD_SURFACE_WG, var1 -> this.generatePieces((StructurePiecesBuilder)var1, var0));
    }

    private void generatePieces(StructurePiecesBuilder var0, Structure.GenerationContext var1) {
        ChunkPos var2 = var1.chunkPos();
        var0.addPiece(this.constructor.construct(var1.random(), var2.getMinBlockX(), var2.getMinBlockZ()));
    }

    @FunctionalInterface
    protected static interface PieceConstructor {
        public StructurePiece construct(WorldgenRandom var1, int var2, int var3);
    }
}

