/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure;

import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.storage.loot.LootTable;
import org.bukkit.craftbukkit.v1_21_R6.CraftLootTable;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBlockStates;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftChest;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftCreatureSpawner;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftDispenser;
import org.bukkit.craftbukkit.v1_21_R6.util.TransformerGeneratorAccess;
import org.bukkit.entity.EntityType;

public abstract class StructurePiece {
    protected static final BlockState CAVE_AIR = Blocks.CAVE_AIR.defaultBlockState();
    protected BoundingBox boundingBox;
    @Nullable
    private Direction orientation;
    private Mirror mirror;
    private Rotation rotation;
    protected int genDepth;
    private final StructurePieceType type;
    public static final Set<Block> SHAPE_CHECK_BLOCKS = ImmutableSet.builder().add((Object)Blocks.NETHER_BRICK_FENCE).add((Object)Blocks.TORCH).add((Object)Blocks.WALL_TORCH).add((Object)Blocks.OAK_FENCE).add((Object)Blocks.SPRUCE_FENCE).add((Object)Blocks.DARK_OAK_FENCE).add((Object)Blocks.PALE_OAK_FENCE).add((Object)Blocks.ACACIA_FENCE).add((Object)Blocks.BIRCH_FENCE).add((Object)Blocks.JUNGLE_FENCE).add((Object)Blocks.LADDER).add((Object)Blocks.IRON_BARS).build();

    protected StructurePiece(StructurePieceType worldgenfeaturestructurepiecetype, int i, BoundingBox structureboundingbox) {
        this.type = worldgenfeaturestructurepiecetype;
        this.genDepth = i;
        this.boundingBox = structureboundingbox;
    }

    public StructurePiece(StructurePieceType worldgenfeaturestructurepiecetype, CompoundTag nbttagcompound) {
        this(worldgenfeaturestructurepiecetype, nbttagcompound.getIntOr("GD", 0), nbttagcompound.read("BB", BoundingBox.CODEC).orElseThrow());
        int i = nbttagcompound.getIntOr("O", 0);
        this.setOrientation(i == -1 ? null : Direction.from2DDataValue(i));
    }

    protected static BoundingBox makeBoundingBox(int i, int j, int k, Direction enumdirection, int l, int i1, int j1) {
        return enumdirection.getAxis() == Direction.Axis.Z ? new BoundingBox(i, j, k, i + l - 1, j + i1 - 1, k + j1 - 1) : new BoundingBox(i, j, k, i + j1 - 1, j + i1 - 1, k + l - 1);
    }

    protected static Direction getRandomHorizontalDirection(RandomSource randomsource) {
        return Direction.Plane.HORIZONTAL.getRandomDirection(randomsource);
    }

    public final CompoundTag createTag(StructurePieceSerializationContext structurepieceserializationcontext) {
        CompoundTag nbttagcompound = new CompoundTag();
        nbttagcompound.putString("id", BuiltInRegistries.STRUCTURE_PIECE.getKey(this.getType()).toString());
        nbttagcompound.store("BB", BoundingBox.CODEC, this.boundingBox);
        Direction enumdirection = this.getOrientation();
        nbttagcompound.putInt("O", enumdirection == null ? -1 : enumdirection.get2DDataValue());
        nbttagcompound.putInt("GD", this.genDepth);
        this.addAdditionalSaveData(structurepieceserializationcontext, nbttagcompound);
        return nbttagcompound;
    }

    protected abstract void addAdditionalSaveData(StructurePieceSerializationContext var1, CompoundTag var2);

    public void addChildren(StructurePiece structurepiece, StructurePieceAccessor structurepieceaccessor, RandomSource randomsource) {
    }

    public abstract void postProcess(WorldGenLevel var1, StructureManager var2, ChunkGenerator var3, RandomSource var4, BoundingBox var5, ChunkPos var6, BlockPos var7);

    public BoundingBox getBoundingBox() {
        return this.boundingBox;
    }

    public int getGenDepth() {
        return this.genDepth;
    }

    public void setGenDepth(int i) {
        this.genDepth = i;
    }

    public boolean isCloseToChunk(ChunkPos chunkcoordintpair, int i) {
        int j = chunkcoordintpair.getMinBlockX();
        int k = chunkcoordintpair.getMinBlockZ();
        return this.boundingBox.intersects(j - i, k - i, j + 15 + i, k + 15 + i);
    }

    public BlockPos getLocatorPosition() {
        return new BlockPos(this.boundingBox.getCenter());
    }

    protected BlockPos.MutableBlockPos getWorldPos(int i, int j, int k) {
        return new BlockPos.MutableBlockPos(this.getWorldX(i, k), this.getWorldY(j), this.getWorldZ(i, k));
    }

    protected int getWorldX(int i, int j) {
        Direction enumdirection = this.getOrientation();
        if (enumdirection == null) {
            return i;
        }
        switch (enumdirection) {
            case NORTH: 
            case SOUTH: {
                return this.boundingBox.minX() + i;
            }
            case WEST: {
                return this.boundingBox.maxX() - j;
            }
            case EAST: {
                return this.boundingBox.minX() + j;
            }
        }
        return i;
    }

    protected int getWorldY(int i) {
        return this.getOrientation() == null ? i : i + this.boundingBox.minY();
    }

    protected int getWorldZ(int i, int j) {
        Direction enumdirection = this.getOrientation();
        if (enumdirection == null) {
            return j;
        }
        switch (enumdirection) {
            case NORTH: {
                return this.boundingBox.maxZ() - j;
            }
            case SOUTH: {
                return this.boundingBox.minZ() + j;
            }
            case WEST: 
            case EAST: {
                return this.boundingBox.minZ() + i;
            }
        }
        return j;
    }

    protected void placeBlock(WorldGenLevel generatoraccessseed, BlockState iblockdata, int i, int j, int k, BoundingBox structureboundingbox) {
        BlockPos.MutableBlockPos blockposition = this.getWorldPos(i, j, k);
        if (structureboundingbox.isInside(blockposition) && this.canBeReplaced(generatoraccessseed, i, j, k, structureboundingbox)) {
            if (this.mirror != Mirror.NONE) {
                iblockdata = iblockdata.mirror(this.mirror);
            }
            if (this.rotation != Rotation.NONE) {
                iblockdata = iblockdata.rotate(this.rotation);
            }
            generatoraccessseed.setBlock(blockposition, iblockdata, 2);
            if (generatoraccessseed instanceof TransformerGeneratorAccess) {
                return;
            }
            FluidState fluid = generatoraccessseed.getFluidState(blockposition);
            if (!fluid.isEmpty()) {
                generatoraccessseed.scheduleTick((BlockPos)blockposition, fluid.getType(), 0);
            }
            if (SHAPE_CHECK_BLOCKS.contains(iblockdata.getBlock())) {
                generatoraccessseed.getChunk(blockposition).markPosForPostprocessing(blockposition);
            }
        }
    }

    protected boolean placeCraftBlockEntity(ServerLevelAccessor worldAccess, BlockPos position, CraftBlockEntityState<?> craftBlockEntityState, int i) {
        if (worldAccess instanceof TransformerGeneratorAccess) {
            TransformerGeneratorAccess transformerAccess = (TransformerGeneratorAccess)worldAccess;
            return transformerAccess.setCraftBlock(position, craftBlockEntityState, i);
        }
        boolean result = worldAccess.setBlock(position, craftBlockEntityState.getHandle(), i);
        BlockEntity tileEntity = worldAccess.getBlockEntity(position);
        if (tileEntity != null) {
            tileEntity.loadWithComponents(craftBlockEntityState.getSnapshotInput());
        }
        return result;
    }

    protected void placeCraftSpawner(ServerLevelAccessor worldAccess, BlockPos position, EntityType entityType, int i) {
        CraftCreatureSpawner spawner = (CraftCreatureSpawner)CraftBlockStates.getBlockState((LevelReader)worldAccess, position, Blocks.SPAWNER.defaultBlockState(), null);
        spawner.setSpawnedType(entityType);
        this.placeCraftBlockEntity(worldAccess, position, spawner, i);
    }

    protected void setCraftLootTable(ServerLevelAccessor worldAccess, BlockPos position, RandomSource randomSource, ResourceKey<LootTable> loottableKey) {
        BlockEntity tileEntity = worldAccess.getBlockEntity(position);
        if (tileEntity instanceof RandomizableContainerBlockEntity) {
            RandomizableContainerBlockEntity tileEntityLootable = (RandomizableContainerBlockEntity)tileEntity;
            tileEntityLootable.setLootTable(loottableKey, randomSource.nextLong());
            if (worldAccess instanceof TransformerGeneratorAccess) {
                TransformerGeneratorAccess transformerAccess = (TransformerGeneratorAccess)worldAccess;
                transformerAccess.setCraftBlock(position, (CraftBlockState)CraftBlockStates.getBlockState((LevelReader)worldAccess, position, tileEntity.getBlockState(), tileEntityLootable.saveWithFullMetadata(worldAccess.registryAccess())), 3);
            }
        }
    }

    protected boolean canBeReplaced(LevelReader iworldreader, int i, int j, int k, BoundingBox structureboundingbox) {
        return true;
    }

    protected BlockState getBlock(BlockGetter iblockaccess, int i, int j, int k, BoundingBox structureboundingbox) {
        BlockPos.MutableBlockPos blockposition = this.getWorldPos(i, j, k);
        return !structureboundingbox.isInside(blockposition) ? Blocks.AIR.defaultBlockState() : iblockaccess.getBlockState(blockposition);
    }

    protected boolean isInterior(LevelReader iworldreader, int i, int j, int k, BoundingBox structureboundingbox) {
        BlockPos.MutableBlockPos blockposition = this.getWorldPos(i, j + 1, k);
        return !structureboundingbox.isInside(blockposition) ? false : blockposition.getY() < iworldreader.getHeight(Heightmap.Types.OCEAN_FLOOR_WG, blockposition.getX(), blockposition.getZ());
    }

    protected void generateAirBox(WorldGenLevel generatoraccessseed, BoundingBox structureboundingbox, int i, int j, int k, int l, int i1, int j1) {
        for (int k1 = j; k1 <= i1; ++k1) {
            for (int l1 = i; l1 <= l; ++l1) {
                for (int i2 = k; i2 <= j1; ++i2) {
                    this.placeBlock(generatoraccessseed, Blocks.AIR.defaultBlockState(), l1, k1, i2, structureboundingbox);
                }
            }
        }
    }

    protected void generateBox(WorldGenLevel generatoraccessseed, BoundingBox structureboundingbox, int i, int j, int k, int l, int i1, int j1, BlockState iblockdata, BlockState iblockdata1, boolean flag) {
        for (int k1 = j; k1 <= i1; ++k1) {
            for (int l1 = i; l1 <= l; ++l1) {
                for (int i2 = k; i2 <= j1; ++i2) {
                    if (flag && this.getBlock(generatoraccessseed, l1, k1, i2, structureboundingbox).isAir()) continue;
                    if (k1 != j && k1 != i1 && l1 != i && l1 != l && i2 != k && i2 != j1) {
                        this.placeBlock(generatoraccessseed, iblockdata1, l1, k1, i2, structureboundingbox);
                        continue;
                    }
                    this.placeBlock(generatoraccessseed, iblockdata, l1, k1, i2, structureboundingbox);
                }
            }
        }
    }

    protected void generateBox(WorldGenLevel generatoraccessseed, BoundingBox structureboundingbox, BoundingBox structureboundingbox1, BlockState iblockdata, BlockState iblockdata1, boolean flag) {
        this.generateBox(generatoraccessseed, structureboundingbox, structureboundingbox1.minX(), structureboundingbox1.minY(), structureboundingbox1.minZ(), structureboundingbox1.maxX(), structureboundingbox1.maxY(), structureboundingbox1.maxZ(), iblockdata, iblockdata1, flag);
    }

    protected void generateBox(WorldGenLevel generatoraccessseed, BoundingBox structureboundingbox, int i, int j, int k, int l, int i1, int j1, boolean flag, RandomSource randomsource, BlockSelector structurepiece_structurepieceblockselector) {
        for (int k1 = j; k1 <= i1; ++k1) {
            for (int l1 = i; l1 <= l; ++l1) {
                for (int i2 = k; i2 <= j1; ++i2) {
                    if (flag && this.getBlock(generatoraccessseed, l1, k1, i2, structureboundingbox).isAir()) continue;
                    structurepiece_structurepieceblockselector.next(randomsource, l1, k1, i2, k1 == j || k1 == i1 || l1 == i || l1 == l || i2 == k || i2 == j1);
                    this.placeBlock(generatoraccessseed, structurepiece_structurepieceblockselector.getNext(), l1, k1, i2, structureboundingbox);
                }
            }
        }
    }

    protected void generateBox(WorldGenLevel generatoraccessseed, BoundingBox structureboundingbox, BoundingBox structureboundingbox1, boolean flag, RandomSource randomsource, BlockSelector structurepiece_structurepieceblockselector) {
        this.generateBox(generatoraccessseed, structureboundingbox, structureboundingbox1.minX(), structureboundingbox1.minY(), structureboundingbox1.minZ(), structureboundingbox1.maxX(), structureboundingbox1.maxY(), structureboundingbox1.maxZ(), flag, randomsource, structurepiece_structurepieceblockselector);
    }

    protected void generateMaybeBox(WorldGenLevel generatoraccessseed, BoundingBox structureboundingbox, RandomSource randomsource, float f, int i, int j, int k, int l, int i1, int j1, BlockState iblockdata, BlockState iblockdata1, boolean flag, boolean flag1) {
        for (int k1 = j; k1 <= i1; ++k1) {
            for (int l1 = i; l1 <= l; ++l1) {
                for (int i2 = k; i2 <= j1; ++i2) {
                    if (!(randomsource.nextFloat() <= f) || flag && this.getBlock(generatoraccessseed, l1, k1, i2, structureboundingbox).isAir() || flag1 && !this.isInterior(generatoraccessseed, l1, k1, i2, structureboundingbox)) continue;
                    if (k1 != j && k1 != i1 && l1 != i && l1 != l && i2 != k && i2 != j1) {
                        this.placeBlock(generatoraccessseed, iblockdata1, l1, k1, i2, structureboundingbox);
                        continue;
                    }
                    this.placeBlock(generatoraccessseed, iblockdata, l1, k1, i2, structureboundingbox);
                }
            }
        }
    }

    protected void maybeGenerateBlock(WorldGenLevel generatoraccessseed, BoundingBox structureboundingbox, RandomSource randomsource, float f, int i, int j, int k, BlockState iblockdata) {
        if (randomsource.nextFloat() < f) {
            this.placeBlock(generatoraccessseed, iblockdata, i, j, k, structureboundingbox);
        }
    }

    protected void generateUpperHalfSphere(WorldGenLevel generatoraccessseed, BoundingBox structureboundingbox, int i, int j, int k, int l, int i1, int j1, BlockState iblockdata, boolean flag) {
        float f = l - i + 1;
        float f1 = i1 - j + 1;
        float f2 = j1 - k + 1;
        float f3 = (float)i + f / 2.0f;
        float f4 = (float)k + f2 / 2.0f;
        for (int k1 = j; k1 <= i1; ++k1) {
            float f5 = (float)(k1 - j) / f1;
            for (int l1 = i; l1 <= l; ++l1) {
                float f6 = ((float)l1 - f3) / (f * 0.5f);
                for (int i2 = k; i2 <= j1; ++i2) {
                    float f8;
                    float f7 = ((float)i2 - f4) / (f2 * 0.5f);
                    if (flag && this.getBlock(generatoraccessseed, l1, k1, i2, structureboundingbox).isAir() || !((f8 = f6 * f6 + f5 * f5 + f7 * f7) <= 1.05f)) continue;
                    this.placeBlock(generatoraccessseed, iblockdata, l1, k1, i2, structureboundingbox);
                }
            }
        }
    }

    protected void fillColumnDown(WorldGenLevel generatoraccessseed, BlockState iblockdata, int i, int j, int k, BoundingBox structureboundingbox) {
        BlockPos.MutableBlockPos blockposition_mutableblockposition = this.getWorldPos(i, j, k);
        if (structureboundingbox.isInside(blockposition_mutableblockposition)) {
            while (this.isReplaceableByStructures(generatoraccessseed.getBlockState(blockposition_mutableblockposition)) && blockposition_mutableblockposition.getY() > generatoraccessseed.getMinY() + 1) {
                generatoraccessseed.setBlock(blockposition_mutableblockposition, iblockdata, 2);
                blockposition_mutableblockposition.move(Direction.DOWN);
            }
        }
    }

    protected boolean isReplaceableByStructures(BlockState iblockdata) {
        return iblockdata.isAir() || iblockdata.liquid() || iblockdata.is(Blocks.GLOW_LICHEN) || iblockdata.is(Blocks.SEAGRASS) || iblockdata.is(Blocks.TALL_SEAGRASS);
    }

    protected boolean createChest(WorldGenLevel generatoraccessseed, BoundingBox structureboundingbox, RandomSource randomsource, int i, int j, int k, ResourceKey<LootTable> resourcekey) {
        return this.createChest(generatoraccessseed, structureboundingbox, randomsource, this.getWorldPos(i, j, k), resourcekey, null);
    }

    public static BlockState reorient(BlockGetter iblockaccess, BlockPos blockposition, BlockState iblockdata) {
        Direction enumdirection = null;
        for (Direction enumdirection1 : Direction.Plane.HORIZONTAL) {
            BlockPos blockposition1 = blockposition.relative(enumdirection1);
            BlockState iblockdata1 = iblockaccess.getBlockState(blockposition1);
            if (iblockdata1.is(Blocks.CHEST)) {
                return iblockdata;
            }
            if (!iblockdata1.isSolidRender()) continue;
            if (enumdirection != null) {
                enumdirection = null;
                break;
            }
            enumdirection = enumdirection1;
        }
        if (enumdirection != null) {
            return (BlockState)iblockdata.setValue(HorizontalDirectionalBlock.FACING, enumdirection.getOpposite());
        }
        Direction enumdirection2 = iblockdata.getValue(HorizontalDirectionalBlock.FACING);
        BlockPos blockposition2 = blockposition.relative(enumdirection2);
        if (iblockaccess.getBlockState(blockposition2).isSolidRender()) {
            enumdirection2 = enumdirection2.getOpposite();
            blockposition2 = blockposition.relative(enumdirection2);
        }
        if (iblockaccess.getBlockState(blockposition2).isSolidRender()) {
            enumdirection2 = enumdirection2.getClockWise();
            blockposition2 = blockposition.relative(enumdirection2);
        }
        if (iblockaccess.getBlockState(blockposition2).isSolidRender()) {
            enumdirection2 = enumdirection2.getOpposite();
            blockposition.relative(enumdirection2);
        }
        return (BlockState)iblockdata.setValue(HorizontalDirectionalBlock.FACING, enumdirection2);
    }

    protected boolean createChest(ServerLevelAccessor worldaccess, BoundingBox structureboundingbox, RandomSource randomsource, BlockPos blockposition, ResourceKey<LootTable> resourcekey, @Nullable BlockState iblockdata) {
        if (structureboundingbox.isInside(blockposition) && !worldaccess.getBlockState(blockposition).is(Blocks.CHEST)) {
            if (iblockdata == null) {
                iblockdata = StructurePiece.reorient(worldaccess, blockposition, Blocks.CHEST.defaultBlockState());
            }
            CraftChest chestState = (CraftChest)CraftBlockStates.getBlockState((LevelReader)worldaccess, blockposition, iblockdata, null);
            chestState.setLootTable(CraftLootTable.minecraftToBukkit(resourcekey));
            chestState.setSeed(randomsource.nextLong());
            this.placeCraftBlockEntity(worldaccess, blockposition, chestState, 2);
            return true;
        }
        return false;
    }

    protected boolean createDispenser(WorldGenLevel generatoraccessseed, BoundingBox structureboundingbox, RandomSource randomsource, int i, int j, int k, Direction enumdirection, ResourceKey<LootTable> resourcekey) {
        BlockPos.MutableBlockPos blockposition = this.getWorldPos(i, j, k);
        if (structureboundingbox.isInside(blockposition) && !generatoraccessseed.getBlockState(blockposition).is(Blocks.DISPENSER)) {
            if (!this.canBeReplaced(generatoraccessseed, i, j, k, structureboundingbox)) {
                return true;
            }
            BlockState iblockdata = (BlockState)Blocks.DISPENSER.defaultBlockState().setValue(DispenserBlock.FACING, enumdirection);
            if (this.mirror != Mirror.NONE) {
                iblockdata = iblockdata.mirror(this.mirror);
            }
            if (this.rotation != Rotation.NONE) {
                iblockdata = iblockdata.rotate(this.rotation);
            }
            CraftDispenser dispenserState = (CraftDispenser)CraftBlockStates.getBlockState((LevelReader)generatoraccessseed, (BlockPos)blockposition, iblockdata, null);
            dispenserState.setLootTable(CraftLootTable.minecraftToBukkit(resourcekey));
            dispenserState.setSeed(randomsource.nextLong());
            this.placeCraftBlockEntity(generatoraccessseed, blockposition, dispenserState, 2);
            return true;
        }
        return false;
    }

    public void move(int i, int j, int k) {
        this.boundingBox.move(i, j, k);
    }

    public static BoundingBox createBoundingBox(Stream<StructurePiece> stream) {
        Stream<BoundingBox> stream1 = stream.map(StructurePiece::getBoundingBox);
        Objects.requireNonNull(stream1);
        return BoundingBox.encapsulatingBoxes(stream1::iterator).orElseThrow(() -> new IllegalStateException("Unable to calculate boundingbox without pieces"));
    }

    @Nullable
    public static StructurePiece findCollisionPiece(List<StructurePiece> list, BoundingBox structureboundingbox) {
        for (StructurePiece structurepiece : list) {
            if (!structurepiece.getBoundingBox().intersects(structureboundingbox)) continue;
            return structurepiece;
        }
        return null;
    }

    @Nullable
    public Direction getOrientation() {
        return this.orientation;
    }

    public void setOrientation(@Nullable Direction enumdirection) {
        this.orientation = enumdirection;
        if (enumdirection == null) {
            this.rotation = Rotation.NONE;
            this.mirror = Mirror.NONE;
        } else {
            switch (enumdirection) {
                case SOUTH: {
                    this.mirror = Mirror.LEFT_RIGHT;
                    this.rotation = Rotation.NONE;
                    break;
                }
                case WEST: {
                    this.mirror = Mirror.LEFT_RIGHT;
                    this.rotation = Rotation.CLOCKWISE_90;
                    break;
                }
                case EAST: {
                    this.mirror = Mirror.NONE;
                    this.rotation = Rotation.CLOCKWISE_90;
                    break;
                }
                default: {
                    this.mirror = Mirror.NONE;
                    this.rotation = Rotation.NONE;
                }
            }
        }
    }

    public Rotation getRotation() {
        return this.rotation;
    }

    public Mirror getMirror() {
        return this.mirror;
    }

    public StructurePieceType getType() {
        return this.type;
    }

    public static abstract class BlockSelector {
        protected BlockState next = Blocks.AIR.defaultBlockState();

        public abstract void next(RandomSource var1, int var2, int var3, int var4, boolean var5);

        public BlockState getNext() {
            return this.next;
        }
    }
}

