/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.structures;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.ScatteredFeaturePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import org.bukkit.event.entity.CreatureSpawnEvent;

public class SwampHutPiece
extends ScatteredFeaturePiece {
    private boolean spawnedWitch;
    private boolean spawnedCat;

    public SwampHutPiece(RandomSource randomsource, int i, int j) {
        super(StructurePieceType.SWAMPLAND_HUT, i, 64, j, 7, 7, 9, SwampHutPiece.getRandomHorizontalDirection(randomsource));
    }

    public SwampHutPiece(CompoundTag nbttagcompound) {
        super(StructurePieceType.SWAMPLAND_HUT, nbttagcompound);
        this.spawnedWitch = nbttagcompound.getBooleanOr("Witch", false);
        this.spawnedCat = nbttagcompound.getBooleanOr("Cat", false);
    }

    @Override
    protected void addAdditionalSaveData(StructurePieceSerializationContext structurepieceserializationcontext, CompoundTag nbttagcompound) {
        super.addAdditionalSaveData(structurepieceserializationcontext, nbttagcompound);
        nbttagcompound.putBoolean("Witch", this.spawnedWitch);
        nbttagcompound.putBoolean("Cat", this.spawnedCat);
    }

    @Override
    public void postProcess(WorldGenLevel generatoraccessseed, StructureManager structuremanager, ChunkGenerator chunkgenerator, RandomSource randomsource, BoundingBox structureboundingbox, ChunkPos chunkcoordintpair, BlockPos blockposition) {
        if (this.updateAverageGroundHeight(generatoraccessseed, structureboundingbox, 0)) {
            BlockPos.MutableBlockPos blockposition1;
            this.generateBox(generatoraccessseed, structureboundingbox, 1, 1, 1, 5, 1, 7, Blocks.SPRUCE_PLANKS.defaultBlockState(), Blocks.SPRUCE_PLANKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 1, 4, 2, 5, 4, 7, Blocks.SPRUCE_PLANKS.defaultBlockState(), Blocks.SPRUCE_PLANKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 2, 1, 0, 4, 1, 0, Blocks.SPRUCE_PLANKS.defaultBlockState(), Blocks.SPRUCE_PLANKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 2, 2, 2, 3, 3, 2, Blocks.SPRUCE_PLANKS.defaultBlockState(), Blocks.SPRUCE_PLANKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 1, 2, 3, 1, 3, 6, Blocks.SPRUCE_PLANKS.defaultBlockState(), Blocks.SPRUCE_PLANKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 5, 2, 3, 5, 3, 6, Blocks.SPRUCE_PLANKS.defaultBlockState(), Blocks.SPRUCE_PLANKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 2, 2, 7, 4, 3, 7, Blocks.SPRUCE_PLANKS.defaultBlockState(), Blocks.SPRUCE_PLANKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 1, 0, 2, 1, 3, 2, Blocks.OAK_LOG.defaultBlockState(), Blocks.OAK_LOG.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 5, 0, 2, 5, 3, 2, Blocks.OAK_LOG.defaultBlockState(), Blocks.OAK_LOG.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 1, 0, 7, 1, 3, 7, Blocks.OAK_LOG.defaultBlockState(), Blocks.OAK_LOG.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 5, 0, 7, 5, 3, 7, Blocks.OAK_LOG.defaultBlockState(), Blocks.OAK_LOG.defaultBlockState(), false);
            this.placeBlock(generatoraccessseed, Blocks.OAK_FENCE.defaultBlockState(), 2, 3, 2, structureboundingbox);
            this.placeBlock(generatoraccessseed, Blocks.OAK_FENCE.defaultBlockState(), 3, 3, 7, structureboundingbox);
            this.placeBlock(generatoraccessseed, Blocks.AIR.defaultBlockState(), 1, 3, 4, structureboundingbox);
            this.placeBlock(generatoraccessseed, Blocks.AIR.defaultBlockState(), 5, 3, 4, structureboundingbox);
            this.placeBlock(generatoraccessseed, Blocks.AIR.defaultBlockState(), 5, 3, 5, structureboundingbox);
            this.placeBlock(generatoraccessseed, Blocks.POTTED_RED_MUSHROOM.defaultBlockState(), 1, 3, 5, structureboundingbox);
            this.placeBlock(generatoraccessseed, Blocks.CRAFTING_TABLE.defaultBlockState(), 3, 2, 6, structureboundingbox);
            this.placeBlock(generatoraccessseed, Blocks.CAULDRON.defaultBlockState(), 4, 2, 6, structureboundingbox);
            this.placeBlock(generatoraccessseed, Blocks.OAK_FENCE.defaultBlockState(), 1, 2, 1, structureboundingbox);
            this.placeBlock(generatoraccessseed, Blocks.OAK_FENCE.defaultBlockState(), 5, 2, 1, structureboundingbox);
            BlockState iblockdata = (BlockState)Blocks.SPRUCE_STAIRS.defaultBlockState().setValue(StairBlock.FACING, Direction.NORTH);
            BlockState iblockdata1 = (BlockState)Blocks.SPRUCE_STAIRS.defaultBlockState().setValue(StairBlock.FACING, Direction.EAST);
            BlockState iblockdata2 = (BlockState)Blocks.SPRUCE_STAIRS.defaultBlockState().setValue(StairBlock.FACING, Direction.WEST);
            BlockState iblockdata3 = (BlockState)Blocks.SPRUCE_STAIRS.defaultBlockState().setValue(StairBlock.FACING, Direction.SOUTH);
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 4, 1, 6, 4, 1, iblockdata, iblockdata, false);
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 4, 2, 0, 4, 7, iblockdata1, iblockdata1, false);
            this.generateBox(generatoraccessseed, structureboundingbox, 6, 4, 2, 6, 4, 7, iblockdata2, iblockdata2, false);
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 4, 8, 6, 4, 8, iblockdata3, iblockdata3, false);
            this.placeBlock(generatoraccessseed, (BlockState)iblockdata.setValue(StairBlock.SHAPE, StairsShape.OUTER_RIGHT), 0, 4, 1, structureboundingbox);
            this.placeBlock(generatoraccessseed, (BlockState)iblockdata.setValue(StairBlock.SHAPE, StairsShape.OUTER_LEFT), 6, 4, 1, structureboundingbox);
            this.placeBlock(generatoraccessseed, (BlockState)iblockdata3.setValue(StairBlock.SHAPE, StairsShape.OUTER_LEFT), 0, 4, 8, structureboundingbox);
            this.placeBlock(generatoraccessseed, (BlockState)iblockdata3.setValue(StairBlock.SHAPE, StairsShape.OUTER_RIGHT), 6, 4, 8, structureboundingbox);
            for (int i = 2; i <= 7; i += 5) {
                for (int j = 1; j <= 5; j += 4) {
                    this.fillColumnDown(generatoraccessseed, Blocks.OAK_LOG.defaultBlockState(), j, -1, i, structureboundingbox);
                }
            }
            if (!this.spawnedWitch && structureboundingbox.isInside(blockposition1 = this.getWorldPos(2, 2, 5))) {
                this.spawnedWitch = true;
                Witch entitywitch = EntityType.WITCH.create(generatoraccessseed.getLevel(), EntitySpawnReason.STRUCTURE);
                if (entitywitch != null) {
                    entitywitch.setPersistenceRequired();
                    entitywitch.snapTo((double)blockposition1.getX() + 0.5, blockposition1.getY(), (double)blockposition1.getZ() + 0.5, 0.0f, 0.0f);
                    entitywitch.finalizeSpawn(generatoraccessseed, generatoraccessseed.getCurrentDifficultyAt(blockposition1), EntitySpawnReason.STRUCTURE, null);
                    generatoraccessseed.addFreshEntityWithPassengers(entitywitch, CreatureSpawnEvent.SpawnReason.CHUNK_GEN);
                }
            }
            this.spawnCat(generatoraccessseed, structureboundingbox);
        }
    }

    private void spawnCat(ServerLevelAccessor worldaccess, BoundingBox structureboundingbox) {
        BlockPos.MutableBlockPos blockposition;
        if (!this.spawnedCat && structureboundingbox.isInside(blockposition = this.getWorldPos(2, 2, 5))) {
            this.spawnedCat = true;
            Cat entitycat = EntityType.CAT.create(worldaccess.getLevel(), EntitySpawnReason.STRUCTURE);
            if (entitycat != null) {
                entitycat.setPersistenceRequired();
                entitycat.snapTo((double)blockposition.getX() + 0.5, blockposition.getY(), (double)blockposition.getZ() + 0.5, 0.0f, 0.0f);
                entitycat.finalizeSpawn(worldaccess, worldaccess.getCurrentDifficultyAt(blockposition), EntitySpawnReason.STRUCTURE, null);
                worldaccess.addFreshEntityWithPassengers(entitycat, CreatureSpawnEvent.SpawnReason.CHUNK_GEN);
            }
        }
    }
}

