/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.pathfinder;

import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.EnumMap;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.PathNavigationRegion;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.NodeEvaluator;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.PathfindingContext;
import net.minecraft.world.level.pathfinder.Target;

public class SwimNodeEvaluator
extends NodeEvaluator {
    private final boolean allowBreaching;
    private final Long2ObjectMap<PathType> pathTypesByPosCache = new Long2ObjectOpenHashMap();

    public SwimNodeEvaluator(boolean var0) {
        this.allowBreaching = var0;
    }

    @Override
    public void prepare(PathNavigationRegion var0, Mob var1) {
        super.prepare(var0, var1);
        this.pathTypesByPosCache.clear();
    }

    @Override
    public void done() {
        super.done();
        this.pathTypesByPosCache.clear();
    }

    @Override
    public Node getStart() {
        return this.getNode(Mth.floor(this.mob.getBoundingBox().minX), Mth.floor(this.mob.getBoundingBox().minY + 0.5), Mth.floor(this.mob.getBoundingBox().minZ));
    }

    @Override
    public Target getTarget(double var0, double var2, double var4) {
        return this.getTargetNodeAt(var0, var2, var4);
    }

    @Override
    public int getNeighbors(Node[] var0, Node var1) {
        int var2 = 0;
        EnumMap var3 = Maps.newEnumMap(Direction.class);
        for (Direction direction : Direction.values()) {
            Node var8 = this.findAcceptedNode(var1.x + direction.getStepX(), var1.y + direction.getStepY(), var1.z + direction.getStepZ());
            var3.put(direction, var8);
            if (!this.isNodeValid(var8)) continue;
            var0[var2++] = var8;
        }
        for (Direction var5 : Direction.Plane.HORIZONTAL) {
            Node node;
            Direction var6 = var5.getClockWise();
            if (!SwimNodeEvaluator.hasMalus((Node)var3.get(var5)) || !SwimNodeEvaluator.hasMalus((Node)var3.get(var6)) || !this.isNodeValid(node = this.findAcceptedNode(var1.x + var5.getStepX() + var6.getStepX(), var1.y, var1.z + var5.getStepZ() + var6.getStepZ()))) continue;
            var0[var2++] = node;
        }
        return var2;
    }

    protected boolean isNodeValid(@Nullable Node var0) {
        return var0 != null && !var0.closed;
    }

    private static boolean hasMalus(@Nullable Node var0) {
        return var0 != null && var0.costMalus >= 0.0f;
    }

    @Nullable
    protected Node findAcceptedNode(int var0, int var1, int var2) {
        float var5;
        Node var3 = null;
        PathType var4 = this.getCachedBlockType(var0, var1, var2);
        if ((this.allowBreaching && var4 == PathType.BREACH || var4 == PathType.WATER) && (var5 = this.mob.getPathfindingMalus(var4)) >= 0.0f) {
            var3 = this.getNode(var0, var1, var2);
            var3.type = var4;
            var3.costMalus = Math.max(var3.costMalus, var5);
            if (this.currentContext.level().getFluidState(new BlockPos(var0, var1, var2)).isEmpty()) {
                var3.costMalus += 8.0f;
            }
        }
        return var3;
    }

    protected PathType getCachedBlockType(int var0, int var1, int var2) {
        return (PathType)((Object)this.pathTypesByPosCache.computeIfAbsent(BlockPos.asLong(var0, var1, var2), var3 -> this.getPathType(this.currentContext, var0, var1, var2)));
    }

    @Override
    public PathType getPathType(PathfindingContext var0, int var1, int var2, int var3) {
        return this.getPathTypeOfMob(var0, var1, var2, var3, this.mob);
    }

    @Override
    public PathType getPathTypeOfMob(PathfindingContext var0, int var1, int var2, int var3, Mob var4) {
        BlockPos.MutableBlockPos var5 = new BlockPos.MutableBlockPos();
        for (int var6 = var1; var6 < var1 + this.entityWidth; ++var6) {
            for (int var7 = var2; var7 < var2 + this.entityHeight; ++var7) {
                for (int var8 = var3; var8 < var3 + this.entityDepth; ++var8) {
                    BlockState var9 = var0.getBlockState(var5.set(var6, var7, var8));
                    FluidState var10 = var9.getFluidState();
                    if (var10.isEmpty() && var9.isPathfindable(PathComputationType.WATER) && var9.isAir()) {
                        return PathType.BREACH;
                    }
                    if (var10.is(FluidTags.WATER)) continue;
                    return PathType.BLOCKED;
                }
            }
        }
        BlockState var6 = var0.getBlockState(var5);
        if (var6.isPathfindable(PathComputationType.WATER)) {
            return PathType.WATER;
        }
        return PathType.BLOCKED;
    }
}

