/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.redstone;

import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.redstone.Orientation;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_21_R6.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R6.block.data.CraftBlockData;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockPhysicsEvent;

public interface NeighborUpdater {
    public static final Direction[] UPDATE_ORDER = new Direction[]{Direction.WEST, Direction.EAST, Direction.DOWN, Direction.UP, Direction.NORTH, Direction.SOUTH};

    public void shapeUpdate(Direction var1, BlockState var2, BlockPos var3, BlockPos var4, int var5, int var6);

    public void neighborChanged(BlockPos var1, Block var2, @Nullable Orientation var3);

    public void neighborChanged(BlockState var1, BlockPos var2, Block var3, @Nullable Orientation var4, boolean var5);

    default public void updateNeighborsAtExceptFromFacing(BlockPos blockposition, Block block, @Nullable Direction enumdirection, @Nullable Orientation orientation) {
        for (Direction enumdirection1 : UPDATE_ORDER) {
            if (enumdirection1 == enumdirection) continue;
            this.neighborChanged(blockposition.relative(enumdirection1), block, null);
        }
    }

    public static void executeShapeUpdate(LevelAccessor generatoraccess, Direction enumdirection, BlockPos blockposition, BlockPos blockposition1, BlockState iblockdata, int i, int j) {
        BlockState iblockdata1 = generatoraccess.getBlockState(blockposition);
        if ((i & 0x80) == 0 || !iblockdata1.is(Blocks.REDSTONE_WIRE)) {
            BlockState iblockdata2 = iblockdata1.updateShape(generatoraccess, generatoraccess, blockposition, enumdirection, blockposition1, iblockdata, generatoraccess.getRandom());
            Block.updateOrDestroy(iblockdata1, iblockdata2, generatoraccess, blockposition, i, j);
        }
    }

    public static void executeUpdate(Level world, BlockState iblockdata, BlockPos blockposition, Block block, @Nullable Orientation orientation, boolean flag) {
        try {
            if (world.populating) {
                return;
            }
            CraftWorld cworld = ((ServerLevel)world).getWorld();
            if (cworld != null) {
                BlockPhysicsEvent event = new BlockPhysicsEvent((org.bukkit.block.Block)CraftBlock.at(world, blockposition), (BlockData)CraftBlockData.fromData(iblockdata));
                ((ServerLevel)world).getCraftServer().getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    return;
                }
            }
            iblockdata.handleNeighborChanged(world, blockposition, block, orientation, flag);
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.forThrowable(throwable, "Exception while updating neighbours");
            CrashReportCategory crashreportsystemdetails = crashreport.addCategory("Block being updated");
            crashreportsystemdetails.setDetail("Source block type", () -> {
                try {
                    return String.format(Locale.ROOT, "ID #%s (%s // %s)", BuiltInRegistries.BLOCK.getKey(block), block.getDescriptionId(), block.getClass().getCanonicalName());
                }
                catch (Throwable throwable1) {
                    return "ID #" + String.valueOf(BuiltInRegistries.BLOCK.getKey(block));
                }
            });
            CrashReportCategory.populateBlockDetails(crashreportsystemdetails, world, blockposition, iblockdata);
            throw new ReportedException(crashreport);
        }
    }
}

