/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage;

import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.NameAndId;
import net.minecraft.util.ProblemReporter;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.storage.FileNameDateFormatter;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.TagValueOutput;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftPlayer;
import org.slf4j.Logger;

public class PlayerDataStorage {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final File playerDir;
    protected final DataFixer fixerUpper;
    private static final DateTimeFormatter FORMATTER = FileNameDateFormatter.create();

    public PlayerDataStorage(LevelStorageSource.LevelStorageAccess convertable_conversionsession, DataFixer datafixer) {
        this.fixerUpper = datafixer;
        this.playerDir = convertable_conversionsession.getLevelPath(LevelResource.PLAYER_DATA_DIR).toFile();
        this.playerDir.mkdirs();
    }

    public void save(Player entityhuman) {
        try (ProblemReporter.ScopedCollector problemreporter_j = new ProblemReporter.ScopedCollector(entityhuman.problemPath(), LOGGER);){
            TagValueOutput tagvalueoutput = TagValueOutput.createWithContext(problemreporter_j, entityhuman.registryAccess());
            entityhuman.saveWithoutId(tagvalueoutput);
            Path path = this.playerDir.toPath();
            Path path1 = Files.createTempFile(path, entityhuman.getStringUUID() + "-", ".dat", new FileAttribute[0]);
            CompoundTag nbttagcompound = tagvalueoutput.buildResult();
            NbtIo.writeCompressed(nbttagcompound, path1);
            Path path2 = path.resolve(entityhuman.getStringUUID() + ".dat");
            Path path3 = path.resolve(entityhuman.getStringUUID() + ".dat_old");
            Util.safeReplaceFile(path2, path1, path3);
        }
        catch (Exception exception) {
            LOGGER.warn("Failed to save player data for {}", (Object)entityhuman.getPlainTextName());
        }
    }

    private void backup(NameAndId nameandid, String s) {
        Path path = this.playerDir.toPath();
        String s1 = nameandid.id().toString();
        Path path1 = path.resolve(s1 + s);
        Path path2 = path.resolve(s1 + "_corrupted_" + LocalDateTime.now().format(FORMATTER) + s);
        if (Files.isRegularFile(path1, new LinkOption[0])) {
            try {
                Files.copy(path1, path2, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
            }
            catch (Exception exception) {
                LOGGER.warn("Failed to copy the player.dat file for {}", (Object)nameandid.name(), (Object)exception);
            }
        }
    }

    private Optional<CompoundTag> load(NameAndId nameandid, String s) {
        File file = this.playerDir;
        String s1 = nameandid.id().toString();
        File file1 = new File(file, s1 + s);
        if (file1.exists() && file1.isFile()) {
            try {
                return Optional.of(NbtIo.readCompressed(file1.toPath(), NbtAccounter.unlimitedHeap()));
            }
            catch (Exception exception) {
                LOGGER.warn("Failed to load player data for {}", (Object)nameandid.name());
            }
        }
        return Optional.empty();
    }

    public Optional<CompoundTag> load(Player entityhuman) {
        return this.load(entityhuman.nameAndId()).map(nbttagcompound -> {
            if (entityhuman instanceof ServerPlayer) {
                CraftPlayer player = (CraftPlayer)entityhuman.getBukkitEntity();
                long modified = new File(this.playerDir, entityhuman.getStringUUID() + ".dat").lastModified();
                if (modified < player.getFirstPlayed()) {
                    player.setFirstPlayed(modified);
                }
            }
            return nbttagcompound;
        });
    }

    public Optional<CompoundTag> load(NameAndId nameandid) {
        Optional<CompoundTag> optional = this.load(nameandid, ".dat");
        if (optional.isEmpty()) {
            this.backup(nameandid, ".dat");
        }
        return optional.or(() -> this.load(nameandid, ".dat_old")).map(nbttagcompound -> {
            int i = NbtUtils.getDataVersion(nbttagcompound, -1);
            nbttagcompound = DataFixTypes.PLAYER.updateToCurrentVersion(this.fixerUpper, (CompoundTag)nbttagcompound, i);
            return nbttagcompound;
        });
    }

    public File getPlayerDir() {
        return this.playerDir;
    }
}

