/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage;

import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Streams;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import java.lang.runtime.SwitchBootstraps;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagType;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueInputContextHelper;

public class TagValueInput
implements ValueInput {
    private final ProblemReporter problemReporter;
    private final ValueInputContextHelper context;
    public final CompoundTag input;

    private TagValueInput(ProblemReporter var0, ValueInputContextHelper var1, CompoundTag var2) {
        this.problemReporter = var0;
        this.context = var1;
        this.input = var2;
    }

    public static ValueInput create(ProblemReporter var0, HolderLookup.Provider var1, CompoundTag var2) {
        return new TagValueInput(var0, new ValueInputContextHelper(var1, NbtOps.INSTANCE), var2);
    }

    public static ValueInput.ValueInputList create(ProblemReporter var0, HolderLookup.Provider var1, List<CompoundTag> var2) {
        return new CompoundListWrapper(var0, new ValueInputContextHelper(var1, NbtOps.INSTANCE), var2);
    }

    @Override
    public <T> Optional<T> read(String var0, Codec<T> var1) {
        Tag var2 = this.input.get(var0);
        if (var2 == null) {
            return Optional.empty();
        }
        DataResult dataResult = var1.parse(this.context.ops(), (Object)var2);
        Objects.requireNonNull(dataResult);
        DataResult dataResult2 = dataResult;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DataResult.Success.class, DataResult.Error.class}, (Object)dataResult2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                DataResult.Success var5 = (DataResult.Success)dataResult2;
                yield Optional.of(var5.value());
            }
            case 1 -> {
                DataResult.Error var6 = (DataResult.Error)dataResult2;
                this.problemReporter.report(new DecodeFromFieldFailedProblem(var0, var2, var6));
                yield var6.partialValue();
            }
        };
    }

    @Override
    public <T> Optional<T> read(MapCodec<T> var0) {
        DynamicOps<Tag> var1 = this.context.ops();
        DataResult dataResult = var1.getMap((Object)this.input).flatMap(var2 -> var0.decode(var1, var2));
        Objects.requireNonNull(dataResult);
        DataResult dataResult2 = dataResult;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DataResult.Success.class, DataResult.Error.class}, (Object)dataResult2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                DataResult.Success var4 = (DataResult.Success)dataResult2;
                yield Optional.of(var4.value());
            }
            case 1 -> {
                DataResult.Error var5 = (DataResult.Error)dataResult2;
                this.problemReporter.report(new DecodeFromMapFailedProblem(var5));
                yield var5.partialValue();
            }
        };
    }

    @Nullable
    private <T extends Tag> T getOptionalTypedTag(String var0, TagType<T> var1) {
        Tag var2 = this.input.get(var0);
        if (var2 == null) {
            return null;
        }
        TagType<?> var3 = var2.getType();
        if (var3 != var1) {
            this.problemReporter.report(new UnexpectedTypeProblem(var0, var1, var3));
            return null;
        }
        return (T)var2;
    }

    @Nullable
    private NumericTag getNumericTag(String var0) {
        Tag var1 = this.input.get(var0);
        if (var1 == null) {
            return null;
        }
        if (var1 instanceof NumericTag) {
            NumericTag var2 = (NumericTag)var1;
            return var2;
        }
        this.problemReporter.report(new UnexpectedNonNumberProblem(var0, var1.getType()));
        return null;
    }

    @Override
    public Optional<ValueInput> child(String var0) {
        CompoundTag var1 = this.getOptionalTypedTag(var0, CompoundTag.TYPE);
        return var1 != null ? Optional.of(this.wrapChild(var0, var1)) : Optional.empty();
    }

    @Override
    public ValueInput childOrEmpty(String var0) {
        CompoundTag var1 = this.getOptionalTypedTag(var0, CompoundTag.TYPE);
        return var1 != null ? this.wrapChild(var0, var1) : this.context.empty();
    }

    @Override
    public Optional<ValueInput.ValueInputList> childrenList(String var0) {
        ListTag var1 = this.getOptionalTypedTag(var0, ListTag.TYPE);
        return var1 != null ? Optional.of(this.wrapList(var0, this.context, var1)) : Optional.empty();
    }

    @Override
    public ValueInput.ValueInputList childrenListOrEmpty(String var0) {
        ListTag var1 = this.getOptionalTypedTag(var0, ListTag.TYPE);
        return var1 != null ? this.wrapList(var0, this.context, var1) : this.context.emptyList();
    }

    @Override
    public <T> Optional<ValueInput.TypedInputList<T>> list(String var0, Codec<T> var1) {
        ListTag var2 = this.getOptionalTypedTag(var0, ListTag.TYPE);
        return var2 != null ? Optional.of(this.wrapTypedList(var0, var2, var1)) : Optional.empty();
    }

    @Override
    public <T> ValueInput.TypedInputList<T> listOrEmpty(String var0, Codec<T> var1) {
        ListTag var2 = this.getOptionalTypedTag(var0, ListTag.TYPE);
        return var2 != null ? this.wrapTypedList(var0, var2, var1) : this.context.emptyTypedList();
    }

    @Override
    public boolean getBooleanOr(String var0, boolean var1) {
        NumericTag var2 = this.getNumericTag(var0);
        return var2 != null ? var2.byteValue() != 0 : var1;
    }

    @Override
    public byte getByteOr(String var0, byte var1) {
        NumericTag var2 = this.getNumericTag(var0);
        return var2 != null ? var2.byteValue() : var1;
    }

    @Override
    public int getShortOr(String var0, short var1) {
        NumericTag var2 = this.getNumericTag(var0);
        return var2 != null ? var2.shortValue() : var1;
    }

    @Override
    public Optional<Integer> getInt(String var0) {
        NumericTag var1 = this.getNumericTag(var0);
        return var1 != null ? Optional.of(var1.intValue()) : Optional.empty();
    }

    @Override
    public int getIntOr(String var0, int var1) {
        NumericTag var2 = this.getNumericTag(var0);
        return var2 != null ? var2.intValue() : var1;
    }

    @Override
    public long getLongOr(String var0, long var1) {
        NumericTag var3 = this.getNumericTag(var0);
        return var3 != null ? var3.longValue() : var1;
    }

    @Override
    public Optional<Long> getLong(String var0) {
        NumericTag var1 = this.getNumericTag(var0);
        return var1 != null ? Optional.of(var1.longValue()) : Optional.empty();
    }

    @Override
    public float getFloatOr(String var0, float var1) {
        NumericTag var2 = this.getNumericTag(var0);
        return var2 != null ? var2.floatValue() : var1;
    }

    @Override
    public double getDoubleOr(String var0, double var1) {
        NumericTag var3 = this.getNumericTag(var0);
        return var3 != null ? var3.doubleValue() : var1;
    }

    @Override
    public Optional<String> getString(String var0) {
        StringTag var1 = this.getOptionalTypedTag(var0, StringTag.TYPE);
        return var1 != null ? Optional.of(var1.value()) : Optional.empty();
    }

    @Override
    public String getStringOr(String var0, String var1) {
        StringTag var2 = this.getOptionalTypedTag(var0, StringTag.TYPE);
        return var2 != null ? var2.value() : var1;
    }

    @Override
    public Optional<int[]> getIntArray(String var0) {
        IntArrayTag var1 = this.getOptionalTypedTag(var0, IntArrayTag.TYPE);
        return var1 != null ? Optional.of(var1.getAsIntArray()) : Optional.empty();
    }

    @Override
    public HolderLookup.Provider lookup() {
        return this.context.lookup();
    }

    private ValueInput wrapChild(String var0, CompoundTag var1) {
        return var1.isEmpty() ? this.context.empty() : new TagValueInput(this.problemReporter.forChild(new ProblemReporter.FieldPathElement(var0)), this.context, var1);
    }

    static ValueInput wrapChild(ProblemReporter var0, ValueInputContextHelper var1, CompoundTag var2) {
        return var2.isEmpty() ? var1.empty() : new TagValueInput(var0, var1, var2);
    }

    private ValueInput.ValueInputList wrapList(String var0, ValueInputContextHelper var1, ListTag var2) {
        return var2.isEmpty() ? var1.emptyList() : new ListWrapper(this.problemReporter, var0, var1, var2);
    }

    private <T> ValueInput.TypedInputList<T> wrapTypedList(String var0, ListTag var1, Codec<T> var2) {
        return var1.isEmpty() ? this.context.emptyTypedList() : new TypedListWrapper<T>(this.problemReporter, var0, this.context, var2, var1);
    }

    static class CompoundListWrapper
    implements ValueInput.ValueInputList {
        private final ProblemReporter problemReporter;
        private final ValueInputContextHelper context;
        private final List<CompoundTag> list;

        public CompoundListWrapper(ProblemReporter var0, ValueInputContextHelper var1, List<CompoundTag> var2) {
            this.problemReporter = var0;
            this.context = var1;
            this.list = var2;
        }

        ValueInput wrapChild(int var0, CompoundTag var1) {
            return TagValueInput.wrapChild(this.problemReporter.forChild(new ProblemReporter.IndexedPathElement(var0)), this.context, var1);
        }

        @Override
        public boolean isEmpty() {
            return this.list.isEmpty();
        }

        @Override
        public Stream<ValueInput> stream() {
            return Streams.mapWithIndex(this.list.stream(), (var0, var1) -> this.wrapChild((int)var1, (CompoundTag)var0));
        }

        @Override
        public Iterator<ValueInput> iterator() {
            final ListIterator<CompoundTag> var0 = this.list.listIterator();
            return new AbstractIterator<ValueInput>(){

                @Nullable
                protected ValueInput computeNext() {
                    if (var0.hasNext()) {
                        int var02 = var0.nextIndex();
                        CompoundTag var1 = (CompoundTag)var0.next();
                        return this.wrapChild(var02, var1);
                    }
                    return (ValueInput)this.endOfData();
                }

                @Nullable
                protected /* synthetic */ Object computeNext() {
                    return this.computeNext();
                }
            };
        }
    }

    public record DecodeFromFieldFailedProblem(String name, Tag tag, DataResult.Error<?> error) implements ProblemReporter.Problem
    {
        @Override
        public String description() {
            return "Failed to decode value '" + String.valueOf(this.tag) + "' from field '" + this.name + "': " + this.error.message();
        }
    }

    public record DecodeFromMapFailedProblem(DataResult.Error<?> error) implements ProblemReporter.Problem
    {
        @Override
        public String description() {
            return "Failed to decode from map: " + this.error.message();
        }
    }

    public record UnexpectedTypeProblem(String name, TagType<?> expected, TagType<?> actual) implements ProblemReporter.Problem
    {
        @Override
        public String description() {
            return "Expected field '" + this.name + "' to contain value of type " + this.expected.getName() + ", but got " + this.actual.getName();
        }
    }

    public record UnexpectedNonNumberProblem(String name, TagType<?> actual) implements ProblemReporter.Problem
    {
        @Override
        public String description() {
            return "Expected field '" + this.name + "' to contain number, but got " + this.actual.getName();
        }
    }

    static class ListWrapper
    implements ValueInput.ValueInputList {
        private final ProblemReporter problemReporter;
        private final String name;
        final ValueInputContextHelper context;
        private final ListTag list;

        ListWrapper(ProblemReporter var0, String var1, ValueInputContextHelper var2, ListTag var3) {
            this.problemReporter = var0;
            this.name = var1;
            this.context = var2;
            this.list = var3;
        }

        @Override
        public boolean isEmpty() {
            return this.list.isEmpty();
        }

        ProblemReporter reporterForChild(int var0) {
            return this.problemReporter.forChild(new ProblemReporter.IndexedFieldPathElement(this.name, var0));
        }

        void reportIndexUnwrapProblem(int var0, Tag var1) {
            this.problemReporter.report(new UnexpectedListElementTypeProblem(this.name, var0, CompoundTag.TYPE, var1.getType()));
        }

        @Override
        public Stream<ValueInput> stream() {
            return Streams.mapWithIndex(this.list.stream(), (var0, var1) -> {
                if (var0 instanceof CompoundTag) {
                    CompoundTag var3 = (CompoundTag)var0;
                    return TagValueInput.wrapChild(this.reporterForChild((int)var1), this.context, var3);
                }
                this.reportIndexUnwrapProblem((int)var1, (Tag)var0);
                return null;
            }).filter(Objects::nonNull);
        }

        @Override
        public Iterator<ValueInput> iterator() {
            final Iterator var0 = this.list.iterator();
            return new AbstractIterator<ValueInput>(){
                private int index;

                @Nullable
                protected ValueInput computeNext() {
                    while (var0.hasNext()) {
                        int var1;
                        Tag var02 = (Tag)var0.next();
                        ++this.index;
                        if (var02 instanceof CompoundTag) {
                            CompoundTag var2 = (CompoundTag)var02;
                            return TagValueInput.wrapChild(this.reporterForChild(var1), context, var2);
                        }
                        this.reportIndexUnwrapProblem(var1, var02);
                    }
                    return (ValueInput)this.endOfData();
                }

                @Nullable
                protected /* synthetic */ Object computeNext() {
                    return this.computeNext();
                }
            };
        }
    }

    static class TypedListWrapper<T>
    implements ValueInput.TypedInputList<T> {
        private final ProblemReporter problemReporter;
        private final String name;
        final ValueInputContextHelper context;
        final Codec<T> codec;
        private final ListTag list;

        TypedListWrapper(ProblemReporter var0, String var1, ValueInputContextHelper var2, Codec<T> var3, ListTag var4) {
            this.problemReporter = var0;
            this.name = var1;
            this.context = var2;
            this.codec = var3;
            this.list = var4;
        }

        @Override
        public boolean isEmpty() {
            return this.list.isEmpty();
        }

        void reportIndexUnwrapProblem(int var0, Tag var1, DataResult.Error<?> var2) {
            this.problemReporter.report(new DecodeFromListFailedProblem(this.name, var0, var1, var2));
        }

        @Override
        public Stream<T> stream() {
            return Streams.mapWithIndex(this.list.stream(), (var0, var1) -> {
                DataResult dataResult = this.codec.parse(this.context.ops(), var0);
                Objects.requireNonNull(dataResult);
                DataResult var3 = dataResult;
                int var4 = 0;
                return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DataResult.Success.class, DataResult.Error.class}, (Object)var3, var4)) {
                    default -> throw new MatchException(null, null);
                    case 0 -> {
                        DataResult.Success var5 = (DataResult.Success)var3;
                        yield var5.value();
                    }
                    case 1 -> {
                        DataResult.Error var6 = (DataResult.Error)var3;
                        this.reportIndexUnwrapProblem((int)var1, (Tag)var0, (DataResult.Error<?>)var6);
                        yield var6.partialValue().orElse(null);
                    }
                };
            }).filter(Objects::nonNull);
        }

        @Override
        public Iterator<T> iterator() {
            final ListIterator var0 = this.list.listIterator();
            return new AbstractIterator<T>(){

                @Nullable
                protected T computeNext() {
                    while (var0.hasNext()) {
                        DataResult dataResult;
                        int var02 = var0.nextIndex();
                        Tag var1 = (Tag)var0.next();
                        Objects.requireNonNull(codec.parse(context.ops(), (Object)var1));
                        int n = 0;
                        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DataResult.Success.class, DataResult.Error.class}, (Object)dataResult, n)) {
                            default: {
                                throw new MatchException(null, null);
                            }
                            case 0: {
                                DataResult.Success var4 = (DataResult.Success)dataResult;
                                return var4.value();
                            }
                            case 1: 
                        }
                        DataResult.Error var5 = (DataResult.Error)dataResult;
                        this.reportIndexUnwrapProblem(var02, var1, var5);
                        if (!var5.partialValue().isPresent()) continue;
                        return var5.partialValue().get();
                    }
                    return this.endOfData();
                }
            };
        }
    }

    public record UnexpectedListElementTypeProblem(String name, int index, TagType<?> expected, TagType<?> actual) implements ProblemReporter.Problem
    {
        @Override
        public String description() {
            return "Expected list '" + this.name + "' to contain at index " + this.index + " value of type " + this.expected.getName() + ", but got " + this.actual.getName();
        }
    }

    public record DecodeFromListFailedProblem(String name, int index, Tag tag, DataResult.Error<?> error) implements ProblemReporter.Problem
    {
        @Override
        public String description() {
            return "Failed to decode value '" + String.valueOf(this.tag) + "' from field '" + this.name + "' at index " + this.index + "': " + this.error.message();
        }
    }
}

