/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.HolderGetter;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.ProblemReporter;
import net.minecraft.util.context.ContextKey;
import net.minecraft.util.context.ContextKeySet;
import net.minecraft.world.level.storage.loot.LootContextUser;

public class ValidationContext {
    private final ProblemReporter reporter;
    private final ContextKeySet contextKeySet;
    private final Optional<HolderGetter.Provider> resolver;
    private final Set<ResourceKey<?>> visitedElements;

    public ValidationContext(ProblemReporter var0, ContextKeySet var1, HolderGetter.Provider var2) {
        this(var0, var1, Optional.of(var2), Set.of());
    }

    public ValidationContext(ProblemReporter var0, ContextKeySet var1) {
        this(var0, var1, Optional.empty(), Set.of());
    }

    private ValidationContext(ProblemReporter var0, ContextKeySet var1, Optional<HolderGetter.Provider> var2, Set<ResourceKey<?>> var3) {
        this.reporter = var0;
        this.contextKeySet = var1;
        this.resolver = var2;
        this.visitedElements = var3;
    }

    public ValidationContext forChild(ProblemReporter.PathElement var0) {
        return new ValidationContext(this.reporter.forChild(var0), this.contextKeySet, this.resolver, this.visitedElements);
    }

    public ValidationContext enterElement(ProblemReporter.PathElement var0, ResourceKey<?> var1) {
        ImmutableSet var2 = ImmutableSet.builder().addAll(this.visitedElements).add(var1).build();
        return new ValidationContext(this.reporter.forChild(var0), this.contextKeySet, this.resolver, (Set<ResourceKey<?>>)var2);
    }

    public boolean hasVisitedElement(ResourceKey<?> var0) {
        return this.visitedElements.contains(var0);
    }

    public void reportProblem(ProblemReporter.Problem var0) {
        this.reporter.report(var0);
    }

    public void validateContextUsage(LootContextUser var0) {
        Set<ContextKey<?>> var1 = var0.getReferencedContextParams();
        Sets.SetView var2 = Sets.difference(var1, this.contextKeySet.allowed());
        if (!var2.isEmpty()) {
            this.reporter.report(new ParametersNotProvidedProblem((Set<ContextKey<?>>)var2));
        }
    }

    public HolderGetter.Provider resolver() {
        return this.resolver.orElseThrow(() -> new UnsupportedOperationException("References not allowed"));
    }

    public boolean allowsReferences() {
        return this.resolver.isPresent();
    }

    public ValidationContext setContextKeySet(ContextKeySet var0) {
        return new ValidationContext(this.reporter, var0, this.resolver, this.visitedElements);
    }

    public ProblemReporter reporter() {
        return this.reporter;
    }

    public record ParametersNotProvidedProblem(Set<ContextKey<?>> notProvided) implements ProblemReporter.Problem
    {
        @Override
        public String description() {
            return "Parameters " + String.valueOf(this.notProvided) + " are not provided in this context";
        }
    }

    public record MissingReferenceProblem(ResourceKey<?> referenced) implements ProblemReporter.Problem
    {
        @Override
        public String description() {
            return "Missing element " + String.valueOf(this.referenced.location()) + " of type " + String.valueOf(this.referenced.registry());
        }
    }

    public record RecursiveReferenceProblem(ResourceKey<?> referenced) implements ProblemReporter.Problem
    {
        @Override
        public String description() {
            return String.valueOf(this.referenced.location()) + " of type " + String.valueOf(this.referenced.registry()) + " is recursively called";
        }
    }

    public record ReferenceNotAllowedProblem(ResourceKey<?> referenced) implements ProblemReporter.Problem
    {
        @Override
        public String description() {
            return "Reference to " + String.valueOf(this.referenced.location()) + " of type " + String.valueOf(this.referenced.registry()) + " was used, but references are not allowed";
        }
    }
}

