/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.List;
import java.util.Set;
import net.minecraft.core.component.DataComponents;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.context.ContextKey;
import net.minecraft.world.Nameable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class CopyNameFunction
extends LootItemConditionalFunction {
    private static final ExtraCodecs.LateBoundIdMapper<String, Source> SOURCES = new ExtraCodecs.LateBoundIdMapper();
    public static final MapCodec<CopyNameFunction> CODEC;
    private final Source source;

    private CopyNameFunction(List<LootItemCondition> var0, Source var1) {
        super(var0);
        this.source = var1;
    }

    public LootItemFunctionType<CopyNameFunction> getType() {
        return LootItemFunctions.COPY_NAME;
    }

    @Override
    public Set<ContextKey<?>> getReferencedContextParams() {
        return Set.of(this.source.param);
    }

    @Override
    public ItemStack run(ItemStack var0, LootContext var1) {
        Object var2 = var1.getOptionalParameter(this.source.param);
        if (var2 instanceof Nameable) {
            Nameable var3 = (Nameable)var2;
            var0.set(DataComponents.CUSTOM_NAME, var3.getCustomName());
        }
        return var0;
    }

    public static LootItemConditionalFunction.Builder<?> copyName(Source var0) {
        return CopyNameFunction.simpleBuilder(var1 -> new CopyNameFunction((List<LootItemCondition>)var1, var0));
    }

    static {
        for (LootContext.EntityTarget entityTarget : LootContext.EntityTarget.values()) {
            SOURCES.put(entityTarget.getSerializedName(), new Source(entityTarget.getParam()));
        }
        for (Enum enum_ : LootContext.BlockEntityTarget.values()) {
            SOURCES.put(((LootContext.BlockEntityTarget)enum_).getSerializedName(), new Source(((LootContext.BlockEntityTarget)enum_).getParam()));
        }
        CODEC = RecordCodecBuilder.mapCodec(var02 -> CopyNameFunction.commonFields(var02).and((App)SOURCES.codec((Codec<String>)Codec.STRING).fieldOf("source").forGetter(var0 -> var0.source)).apply((Applicative)var02, CopyNameFunction::new));
    }

    public static final class Source
    extends Record {
        final ContextKey<?> param;

        public Source(ContextKey<?> var0) {
            this.param = var0;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Source.class, "param", "param"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Source.class, "param", "param"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Source.class, "param", "param"}, this, var0);
        }

        public ContextKey<?> param() {
            return this.param;
        }
    }
}

