/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.predicates;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public abstract class CompositeLootItemCondition
implements LootItemCondition {
    protected final List<LootItemCondition> terms;
    private final Predicate<LootContext> composedPredicate;

    protected CompositeLootItemCondition(List<LootItemCondition> var0, Predicate<LootContext> var1) {
        this.terms = var0;
        this.composedPredicate = var1;
    }

    protected static <T extends CompositeLootItemCondition> MapCodec<T> createCodec(Function<List<LootItemCondition>, T> var0) {
        return RecordCodecBuilder.mapCodec(var1 -> var1.group((App)LootItemCondition.DIRECT_CODEC.listOf().fieldOf("terms").forGetter(var0 -> var0.terms)).apply((Applicative)var1, var0));
    }

    protected static <T extends CompositeLootItemCondition> Codec<T> createInlineCodec(Function<List<LootItemCondition>, T> var02) {
        return LootItemCondition.DIRECT_CODEC.listOf().xmap(var02, var0 -> var0.terms);
    }

    @Override
    public final boolean test(LootContext var0) {
        return this.composedPredicate.test(var0);
    }

    @Override
    public void validate(ValidationContext var0) {
        LootItemCondition.super.validate(var0);
        for (int var1 = 0; var1 < this.terms.size(); ++var1) {
            this.terms.get(var1).validate(var0.forChild(new ProblemReporter.IndexedFieldPathElement("terms", var1)));
        }
    }

    @Override
    public /* synthetic */ boolean test(Object object) {
        return this.test((LootContext)object);
    }

    public static abstract class Builder
    implements LootItemCondition.Builder {
        private final ImmutableList.Builder<LootItemCondition> terms = ImmutableList.builder();

        protected Builder(LootItemCondition.Builder ... var0) {
            for (LootItemCondition.Builder var4 : var0) {
                this.terms.add((Object)var4.build());
            }
        }

        public void addTerm(LootItemCondition.Builder var0) {
            this.terms.add((Object)var0.build());
        }

        @Override
        public LootItemCondition build() {
            return this.create((List<LootItemCondition>)this.terms.build());
        }

        protected abstract LootItemCondition create(List<LootItemCondition> var1);
    }
}

