/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.phys;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class BlockHitResult
extends HitResult {
    private final Direction direction;
    private final BlockPos blockPos;
    private final boolean miss;
    private final boolean inside;
    private final boolean worldBorderHit;

    public static BlockHitResult miss(Vec3 var0, Direction var1, BlockPos var2) {
        return new BlockHitResult(true, var0, var1, var2, false, false);
    }

    public BlockHitResult(Vec3 var0, Direction var1, BlockPos var2, boolean var3) {
        this(false, var0, var1, var2, var3, false);
    }

    public BlockHitResult(Vec3 var0, Direction var1, BlockPos var2, boolean var3, boolean var4) {
        this(false, var0, var1, var2, var3, var4);
    }

    private BlockHitResult(boolean var0, Vec3 var1, Direction var2, BlockPos var3, boolean var4, boolean var5) {
        super(var1);
        this.miss = var0;
        this.direction = var2;
        this.blockPos = var3;
        this.inside = var4;
        this.worldBorderHit = var5;
    }

    public BlockHitResult withDirection(Direction var0) {
        return new BlockHitResult(this.miss, this.location, var0, this.blockPos, this.inside, this.worldBorderHit);
    }

    public BlockHitResult withPosition(BlockPos var0) {
        return new BlockHitResult(this.miss, this.location, this.direction, var0, this.inside, this.worldBorderHit);
    }

    public BlockHitResult hitBorder() {
        return new BlockHitResult(this.miss, this.location, this.direction, this.blockPos, this.inside, true);
    }

    public BlockPos getBlockPos() {
        return this.blockPos;
    }

    public Direction getDirection() {
        return this.direction;
    }

    @Override
    public HitResult.Type getType() {
        return this.miss ? HitResult.Type.MISS : HitResult.Type.BLOCK;
    }

    public boolean isInside() {
        return this.inside;
    }

    public boolean isWorldBorderHit() {
        return this.worldBorderHit;
    }
}

