/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.phys.shapes;

import com.mojang.math.OctahedralGroup;
import net.minecraft.core.AxisCycle;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.shapes.BitSetDiscreteVoxelShape;

public abstract class DiscreteVoxelShape {
    private static final Direction.Axis[] AXIS_VALUES = Direction.Axis.values();
    protected final int xSize;
    protected final int ySize;
    protected final int zSize;

    protected DiscreteVoxelShape(int var0, int var1, int var2) {
        if (var0 < 0 || var1 < 0 || var2 < 0) {
            throw new IllegalArgumentException("Need all positive sizes: x: " + var0 + ", y: " + var1 + ", z: " + var2);
        }
        this.xSize = var0;
        this.ySize = var1;
        this.zSize = var2;
    }

    public DiscreteVoxelShape rotate(OctahedralGroup var0) {
        if (var0 == OctahedralGroup.IDENTITY) {
            return this;
        }
        Direction.Axis var1 = var0.permute(Direction.Axis.X);
        Direction.Axis var2 = var0.permute(Direction.Axis.Y);
        Direction.Axis var3 = var0.permute(Direction.Axis.Z);
        int var4 = var1.choose(this.xSize, this.ySize, this.zSize);
        int var5 = var2.choose(this.xSize, this.ySize, this.zSize);
        int var6 = var3.choose(this.xSize, this.ySize, this.zSize);
        boolean var7 = var0.inverts(var1);
        boolean var8 = var0.inverts(var2);
        boolean var9 = var0.inverts(var3);
        boolean var10 = var1.choose(var7, var8, var9);
        boolean var11 = var2.choose(var7, var8, var9);
        boolean var12 = var3.choose(var7, var8, var9);
        BitSetDiscreteVoxelShape var13 = new BitSetDiscreteVoxelShape(var4, var5, var6);
        for (int var14 = 0; var14 < this.xSize; ++var14) {
            for (int var15 = 0; var15 < this.ySize; ++var15) {
                for (int var16 = 0; var16 < this.zSize; ++var16) {
                    if (!this.isFull(var14, var15, var16)) continue;
                    int var17 = var1.choose(var14, var15, var16);
                    int var18 = var2.choose(var14, var15, var16);
                    int var19 = var3.choose(var14, var15, var16);
                    ((DiscreteVoxelShape)var13).fill(var10 ? var4 - 1 - var17 : var17, var11 ? var5 - 1 - var18 : var18, var12 ? var6 - 1 - var19 : var19);
                }
            }
        }
        return var13;
    }

    public boolean isFullWide(AxisCycle var0, int var1, int var2, int var3) {
        return this.isFullWide(var0.cycle(var1, var2, var3, Direction.Axis.X), var0.cycle(var1, var2, var3, Direction.Axis.Y), var0.cycle(var1, var2, var3, Direction.Axis.Z));
    }

    public boolean isFullWide(int var0, int var1, int var2) {
        if (var0 < 0 || var1 < 0 || var2 < 0) {
            return false;
        }
        if (var0 >= this.xSize || var1 >= this.ySize || var2 >= this.zSize) {
            return false;
        }
        return this.isFull(var0, var1, var2);
    }

    public boolean isFull(AxisCycle var0, int var1, int var2, int var3) {
        return this.isFull(var0.cycle(var1, var2, var3, Direction.Axis.X), var0.cycle(var1, var2, var3, Direction.Axis.Y), var0.cycle(var1, var2, var3, Direction.Axis.Z));
    }

    public abstract boolean isFull(int var1, int var2, int var3);

    public abstract void fill(int var1, int var2, int var3);

    public boolean isEmpty() {
        for (Direction.Axis var3 : AXIS_VALUES) {
            if (this.firstFull(var3) < this.lastFull(var3)) continue;
            return true;
        }
        return false;
    }

    public abstract int firstFull(Direction.Axis var1);

    public abstract int lastFull(Direction.Axis var1);

    public int firstFull(Direction.Axis var0, int var1, int var2) {
        int var3 = this.getSize(var0);
        if (var1 < 0 || var2 < 0) {
            return var3;
        }
        Direction.Axis var4 = AxisCycle.FORWARD.cycle(var0);
        Direction.Axis var5 = AxisCycle.BACKWARD.cycle(var0);
        if (var1 >= this.getSize(var4) || var2 >= this.getSize(var5)) {
            return var3;
        }
        AxisCycle var6 = AxisCycle.between(Direction.Axis.X, var0);
        for (int var7 = 0; var7 < var3; ++var7) {
            if (!this.isFull(var6, var7, var1, var2)) continue;
            return var7;
        }
        return var3;
    }

    public int lastFull(Direction.Axis var0, int var1, int var2) {
        if (var1 < 0 || var2 < 0) {
            return 0;
        }
        Direction.Axis var3 = AxisCycle.FORWARD.cycle(var0);
        Direction.Axis var4 = AxisCycle.BACKWARD.cycle(var0);
        if (var1 >= this.getSize(var3) || var2 >= this.getSize(var4)) {
            return 0;
        }
        int var5 = this.getSize(var0);
        AxisCycle var6 = AxisCycle.between(Direction.Axis.X, var0);
        for (int var7 = var5 - 1; var7 >= 0; --var7) {
            if (!this.isFull(var6, var7, var1, var2)) continue;
            return var7 + 1;
        }
        return 0;
    }

    public int getSize(Direction.Axis var0) {
        return var0.choose(this.xSize, this.ySize, this.zSize);
    }

    public int getXSize() {
        return this.getSize(Direction.Axis.X);
    }

    public int getYSize() {
        return this.getSize(Direction.Axis.Y);
    }

    public int getZSize() {
        return this.getSize(Direction.Axis.Z);
    }

    public void forAllEdges(IntLineConsumer var0, boolean var1) {
        this.forAllAxisEdges(var0, AxisCycle.NONE, var1);
        this.forAllAxisEdges(var0, AxisCycle.FORWARD, var1);
        this.forAllAxisEdges(var0, AxisCycle.BACKWARD, var1);
    }

    private void forAllAxisEdges(IntLineConsumer var0, AxisCycle var1, boolean var2) {
        AxisCycle var4 = var1.inverse();
        int var5 = this.getSize(var4.cycle(Direction.Axis.X));
        int var6 = this.getSize(var4.cycle(Direction.Axis.Y));
        int var7 = this.getSize(var4.cycle(Direction.Axis.Z));
        for (int var8 = 0; var8 <= var5; ++var8) {
            for (int var9 = 0; var9 <= var6; ++var9) {
                int var3 = -1;
                for (int var10 = 0; var10 <= var7; ++var10) {
                    int var11 = 0;
                    int var12 = 0;
                    for (int var13 = 0; var13 <= 1; ++var13) {
                        for (int var14 = 0; var14 <= 1; ++var14) {
                            if (!this.isFullWide(var4, var8 + var13 - 1, var9 + var14 - 1, var10)) continue;
                            ++var11;
                            var12 ^= var13 ^ var14;
                        }
                    }
                    if (var11 == 1 || var11 == 3 || var11 == 2 && !(var12 & true)) {
                        if (var2) {
                            if (var3 != -1) continue;
                            var3 = var10;
                            continue;
                        }
                        var0.consume(var4.cycle(var8, var9, var10, Direction.Axis.X), var4.cycle(var8, var9, var10, Direction.Axis.Y), var4.cycle(var8, var9, var10, Direction.Axis.Z), var4.cycle(var8, var9, var10 + 1, Direction.Axis.X), var4.cycle(var8, var9, var10 + 1, Direction.Axis.Y), var4.cycle(var8, var9, var10 + 1, Direction.Axis.Z));
                        continue;
                    }
                    if (var3 == -1) continue;
                    var0.consume(var4.cycle(var8, var9, var3, Direction.Axis.X), var4.cycle(var8, var9, var3, Direction.Axis.Y), var4.cycle(var8, var9, var3, Direction.Axis.Z), var4.cycle(var8, var9, var10, Direction.Axis.X), var4.cycle(var8, var9, var10, Direction.Axis.Y), var4.cycle(var8, var9, var10, Direction.Axis.Z));
                    var3 = -1;
                }
            }
        }
    }

    public void forAllBoxes(IntLineConsumer var0, boolean var1) {
        BitSetDiscreteVoxelShape.forAllBoxes(this, var0, var1);
    }

    public void forAllFaces(IntFaceConsumer var0) {
        this.forAllAxisFaces(var0, AxisCycle.NONE);
        this.forAllAxisFaces(var0, AxisCycle.FORWARD);
        this.forAllAxisFaces(var0, AxisCycle.BACKWARD);
    }

    private void forAllAxisFaces(IntFaceConsumer var0, AxisCycle var1) {
        AxisCycle var2 = var1.inverse();
        Direction.Axis var3 = var2.cycle(Direction.Axis.Z);
        int var4 = this.getSize(var2.cycle(Direction.Axis.X));
        int var5 = this.getSize(var2.cycle(Direction.Axis.Y));
        int var6 = this.getSize(var3);
        Direction var7 = Direction.fromAxisAndDirection(var3, Direction.AxisDirection.NEGATIVE);
        Direction var8 = Direction.fromAxisAndDirection(var3, Direction.AxisDirection.POSITIVE);
        for (int var9 = 0; var9 < var4; ++var9) {
            for (int var10 = 0; var10 < var5; ++var10) {
                boolean var11 = false;
                for (int var12 = 0; var12 <= var6; ++var12) {
                    boolean var13;
                    boolean bl = var13 = var12 != var6 && this.isFull(var2, var9, var10, var12);
                    if (!var11 && var13) {
                        var0.consume(var7, var2.cycle(var9, var10, var12, Direction.Axis.X), var2.cycle(var9, var10, var12, Direction.Axis.Y), var2.cycle(var9, var10, var12, Direction.Axis.Z));
                    }
                    if (var11 && !var13) {
                        var0.consume(var8, var2.cycle(var9, var10, var12 - 1, Direction.Axis.X), var2.cycle(var9, var10, var12 - 1, Direction.Axis.Y), var2.cycle(var9, var10, var12 - 1, Direction.Axis.Z));
                    }
                    var11 = var13;
                }
            }
        }
    }

    public static interface IntLineConsumer {
        public void consume(int var1, int var2, int var3, int var4, int var5, int var6);
    }

    public static interface IntFaceConsumer {
        public void consume(Direction var1, int var2, int var3, int var4);
    }
}

