/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.phys.shapes;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class EntityCollisionContext
implements CollisionContext {
    private final boolean descending;
    private final double entityBottom;
    private final boolean placement;
    private final ItemStack heldItem;
    private final boolean alwaysCollideWithFluid;
    @Nullable
    private final Entity entity;

    protected EntityCollisionContext(boolean var0, boolean var1, double var2, ItemStack var4, boolean var5, @Nullable Entity var6) {
        this.descending = var0;
        this.placement = var1;
        this.entityBottom = var2;
        this.heldItem = var4;
        this.alwaysCollideWithFluid = var5;
        this.entity = var6;
    }

    @Deprecated
    protected EntityCollisionContext(Entity var0, boolean var1, boolean var2) {
        ItemStack itemStack;
        boolean bl = var0.isDescending();
        double d = var0.getY();
        if (var0 instanceof LivingEntity) {
            LivingEntity var3 = (LivingEntity)var0;
            itemStack = var3.getMainHandItem();
        } else {
            itemStack = ItemStack.EMPTY;
        }
        this(bl, var2, d, itemStack, var1, var0);
    }

    @Override
    public boolean isHoldingItem(Item var0) {
        return this.heldItem.is(var0);
    }

    @Override
    public boolean alwaysCollideWithFluid() {
        return this.alwaysCollideWithFluid;
    }

    @Override
    public boolean canStandOnFluid(FluidState var0, FluidState var1) {
        Entity entity = this.entity;
        if (entity instanceof LivingEntity) {
            LivingEntity var2 = (LivingEntity)entity;
            return var2.canStandOnFluid(var1) && !var0.getType().isSame(var1.getType());
        }
        return false;
    }

    @Override
    public VoxelShape getCollisionShape(BlockState var0, CollisionGetter var1, BlockPos var2) {
        return var0.getCollisionShape(var1, var2, this);
    }

    @Override
    public boolean isDescending() {
        return this.descending;
    }

    @Override
    public boolean isAbove(VoxelShape var0, BlockPos var1, boolean var2) {
        return this.entityBottom > (double)var1.getY() + var0.max(Direction.Axis.Y) - (double)1.0E-5f;
    }

    @Nullable
    public Entity getEntity() {
        return this.entity;
    }

    @Override
    public boolean isPlacement() {
        return this.placement;
    }

    protected static class Empty
    extends EntityCollisionContext {
        protected static final CollisionContext WITHOUT_FLUID_COLLISIONS = new Empty(false);
        protected static final CollisionContext WITH_FLUID_COLLISIONS = new Empty(true);

        public Empty(boolean var0) {
            super(false, false, -1.7976931348623157E308, ItemStack.EMPTY, var0, null);
        }

        @Override
        public boolean isAbove(VoxelShape var0, BlockPos var1, boolean var2) {
            return var2;
        }
    }
}

