/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R6.block;

import com.google.common.base.Preconditions;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.BellBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BellBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Bell;
import org.bukkit.block.BlockFace;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftEntity;
import org.bukkit.entity.Entity;

public class CraftBell
extends CraftBlockEntityState<BellBlockEntity>
implements Bell {
    public CraftBell(World world, BellBlockEntity tileEntity) {
        super(world, tileEntity);
    }

    protected CraftBell(CraftBell state, Location location) {
        super(state, location);
    }

    public boolean ring(Entity entity, BlockFace direction) {
        Preconditions.checkArgument((direction == null || direction.isCartesian() ? 1 : 0) != 0, (String)"direction must be cartesian, given %s", (Object)direction);
        BlockEntity tileEntity = this.getTileEntityFromWorld();
        if (tileEntity == null) {
            return false;
        }
        net.minecraft.world.entity.Entity nmsEntity = entity != null ? ((CraftEntity)entity).getHandle() : null;
        Direction enumDirection = CraftBlock.blockFaceToNotch(direction);
        return ((BellBlock)Blocks.BELL).attemptToRing(nmsEntity, this.world.getHandle(), this.getPosition(), enumDirection);
    }

    public boolean ring(Entity entity) {
        return this.ring(entity, null);
    }

    public boolean ring(BlockFace direction) {
        return this.ring(null, direction);
    }

    public boolean ring() {
        return this.ring(null, null);
    }

    public boolean isShaking() {
        return ((BellBlockEntity)this.getSnapshot()).shaking;
    }

    public int getShakingTicks() {
        return ((BellBlockEntity)this.getSnapshot()).ticks;
    }

    public boolean isResonating() {
        return ((BellBlockEntity)this.getSnapshot()).resonating;
    }

    public int getResonatingTicks() {
        return this.isResonating() ? ((BellBlockEntity)this.getSnapshot()).ticks : 0;
    }

    @Override
    public CraftBell copy() {
        return new CraftBell(this, null);
    }

    @Override
    public CraftBell copy(Location location) {
        return new CraftBell(this, location);
    }
}

