/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R6.inventory.view.builder;

import com.google.common.base.Preconditions;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.MerchantMenu;
import net.minecraft.world.item.trading.Merchant;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftMerchant;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftMerchantCustom;
import org.bukkit.craftbukkit.v1_21_R6.inventory.view.builder.CraftAbstractInventoryViewBuilder;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftChatMessage;
import org.bukkit.entity.HumanEntity;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.view.builder.MerchantInventoryViewBuilder;

public class CraftMerchantInventoryViewBuilder<V extends InventoryView>
extends CraftAbstractInventoryViewBuilder<V>
implements MerchantInventoryViewBuilder<V> {
    private Merchant merchant;

    public CraftMerchantInventoryViewBuilder(MenuType<?> handle) {
        super(handle);
    }

    @Override
    public MerchantInventoryViewBuilder<V> title(String title) {
        return (MerchantInventoryViewBuilder)super.title(title);
    }

    public MerchantInventoryViewBuilder<V> merchant(org.bukkit.inventory.Merchant merchant) {
        this.merchant = ((CraftMerchant)merchant).getMerchant();
        return this;
    }

    public MerchantInventoryViewBuilder<V> checkReachable(boolean checkReachable) {
        this.checkReachable = checkReachable;
        return this;
    }

    @Override
    public V build(HumanEntity player) {
        Preconditions.checkArgument((player != null ? 1 : 0) != 0, (Object)"The given player must not be null");
        Preconditions.checkArgument((this.title != null ? 1 : 0) != 0, (Object)"The given title must not be null");
        Preconditions.checkArgument((boolean)(player instanceof CraftHumanEntity), (Object)"The given player must be a CraftHumanEntity");
        CraftHumanEntity craftHuman = (CraftHumanEntity)player;
        Preconditions.checkArgument((boolean)(craftHuman.getHandle() instanceof ServerPlayer), (Object)"The given player must be an EntityPlayer");
        ServerPlayer serverPlayer = (ServerPlayer)craftHuman.getHandle();
        MerchantMenu container = this.merchant == null ? new MerchantMenu(serverPlayer.nextContainerCounter(), serverPlayer.getInventory(), new CraftMerchantCustom(this.title).getMerchant()) : new MerchantMenu(serverPlayer.nextContainerCounter(), serverPlayer.getInventory(), this.merchant);
        container.checkReachable = this.checkReachable;
        container.setTitle(CraftChatMessage.fromString(this.title)[0]);
        return (V)container.getBukkitView();
    }

    @Override
    protected AbstractContainerMenu buildContainer(ServerPlayer player) {
        throw new UnsupportedOperationException("buildContainer is not supported for CraftMerchantInventoryViewBuilder");
    }

    public MerchantInventoryViewBuilder<V> copy() {
        CraftMerchantInventoryViewBuilder<V> copy = new CraftMerchantInventoryViewBuilder<V>(this.handle);
        copy.checkReachable = this.checkReachable;
        copy.merchant = this.merchant;
        copy.title = this.title;
        return copy;
    }
}

