/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.DataFixer;
import com.mojang.jtracy.DiscontinuousFrame;
import com.mojang.jtracy.TracyClient;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.Lifecycle;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.lang.invoke.MethodHandle;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.lang.runtime.ObjectMethods;
import java.net.Proxy;
import java.nio.file.FileStore;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.KeyPair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import joptsimple.OptionSet;
import net.minecraft.obfuscate.DontObfuscate;
import net.minecraft.server.Main;
import org.apache.commons.io.FileUtils;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.craftbukkit.v1_21_R6.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R6.CraftServer;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R6.generator.CraftWorldInfo;
import org.bukkit.craftbukkit.v1_21_R6.scoreboard.CraftScoreboardManager;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftLocation;
import org.bukkit.craftbukkit.v1_21_R6.util.ServerShutdownThread;
import org.bukkit.event.Event;
import org.bukkit.event.server.ServerLoadEvent;
import org.bukkit.event.world.SpawnChangeEvent;
import org.bukkit.event.world.WorldInitEvent;
import org.bukkit.event.world.WorldLoadEvent;
import org.bukkit.generator.BiomeProvider;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.generator.WorldInfo;
import org.bukkit.plugin.PluginLoadOrder;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;
import org.slf4j.Logger;

public abstract class MinecraftServer
extends caj<ang>
implements amz,
ei,
emv {
    public static final Logger m = LogUtils.getLogger();
    public static final String b = "vanilla";
    private static final float n = 0.8f;
    private static final int o = 100;
    private static final long p = 30L * bgm.a / 20L;
    private static final int q = 20;
    private static final long r = 10L * bgm.a;
    private static final int s = 100;
    private static final long t = 5L * bgm.a;
    private static final long u = 10L * bgm.b;
    private static final int v = 12;
    public static final int c = 5;
    private static final int w = 6000;
    private static final int x = 100;
    private static final int y = 3;
    public static final int d = 29999984;
    public static final dru e = new dru("Demo World", drn.a, false, cbn.c, false, new drm(dcz.h), dso.d);
    public static final bbb f = new bbb(ag.e, "Anonymous Player");
    public fih.c g;
    public final fik h;
    private final List<Runnable> z = Lists.newArrayList();
    private bzr A;
    private Consumer<bxy> B;
    private Consumer<Path> C;
    private boolean D;
    @Nullable
    private c E;
    private boolean F;
    private axy G;
    public final axi H;
    @Nullable
    private alg I;
    @Nullable
    private alg.a J;
    private final bfq K;
    public final DataFixer L;
    private String M;
    private int N = -1;
    private final jr<ams> O;
    private Map<ami<drq>, awx> P;
    private bbd Q;
    private volatile boolean R = true;
    private boolean S;
    private int T;
    private int U = 6000;
    protected final Proxy i;
    private boolean V;
    private boolean W;
    @Nullable
    private String X;
    private int Y;
    private final long[] Z;
    private long aa = 0L;
    @Nullable
    private KeyPair ab;
    @Nullable
    private GameProfile ac;
    private boolean ad;
    private volatile boolean ae;
    private long af;
    protected final ane j;
    private final ayo ag;
    private long ah;
    public final Thread ai;
    private long aj;
    private long ak;
    private long al;
    private long am;
    private boolean an = false;
    private long ao;
    private boolean ap;
    private final baa aq;
    private final anc ar;
    @Nullable
    private fhy as;
    private final anm at;
    private final amy au;
    private boolean av;
    private boolean aw;
    private float ax;
    public final Executor ay;
    @Nullable
    private String az;
    public a aA;
    private final feq aB;
    private final and aC;
    private final bvx aD;
    protected fis k;
    private fid.a aE;
    private final djl aF;
    private ehg aG;
    private int aH;
    private volatile boolean aI;
    private static final AtomicReference<RuntimeException> aJ = new AtomicReference();
    private final anf aK;
    private final DiscontinuousFrame aL;
    private final xb aM;
    public final anh.a worldLoader;
    public CraftServer server;
    public OptionSet options;
    public ConsoleCommandSender console;
    public Terminal terminal;
    public static int currentTick = (int)(System.currentTimeMillis() / 50L);
    public Queue<Runnable> processQueue = new ConcurrentLinkedQueue<Runnable>();
    public int autosavePeriod;
    public ek vanillaCommandDispatcher;
    private boolean forceTicks;
    private boolean hasStopped = false;
    private final Object stopLock = new Object();
    public final ExecutorService chatExecutor = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Async Chat Thread - #%d").build());

    public static <S extends MinecraftServer> S a(Function<Thread, S> function) {
        AtomicReference<MinecraftServer> atomicreference = new AtomicReference<MinecraftServer>();
        Thread thread = new Thread(() -> ((MinecraftServer)atomicreference.get()).C(), "Server thread");
        thread.setUncaughtExceptionHandler((thread1, throwable) -> m.error("Uncaught exception in server thread", throwable));
        if (Runtime.getRuntime().availableProcessors() > 4) {
            thread.setPriority(8);
        }
        MinecraftServer s0 = (MinecraftServer)function.apply(thread);
        atomicreference.set(s0);
        thread.start();
        return (S)s0;
    }

    public MinecraftServer(OptionSet options, anh.a worldLoader, Thread thread, fih.c convertable_conversionsession, baa resourcepackrepository, ani worldstem, Proxy proxy, DataFixer datafixer, ane services, axi levelloadlistener) {
        super("Server");
        this.A = bzq.a;
        this.B = methodprofilerresults -> this.ba();
        this.C = path -> {};
        this.K = bfq.a();
        this.P = Maps.newLinkedHashMap();
        this.Z = new long[100];
        this.aj = ag.d();
        this.ak = ag.d();
        this.am = ag.d();
        this.ar = new anc(this);
        this.at = new anm();
        this.aD = new bvx(this);
        this.aE = fid.a.a;
        this.aK = new anf();
        this.O = worldstem.c();
        this.k = worldstem.d();
        this.i = proxy;
        this.aq = resourcepackrepository;
        this.aA = new a(worldstem.a(), worldstem.b());
        this.j = services;
        this.G = new axy(this);
        this.aC = new and(this);
        this.H = levelloadlistener;
        this.g = convertable_conversionsession;
        this.h = convertable_conversionsession.g();
        this.L = datafixer;
        this.au = new amy(this, this.aA.b.a());
        jm.b holdergetter = this.O.a().f(mp.i).a(this.k.J());
        this.aB = new feq(worldstem.a(), convertable_conversionsession, datafixer, holdergetter);
        this.ai = thread;
        this.ay = ag.h();
        this.aF = djl.a(this.k.J());
        this.aA.b.c().a(this.k.J());
        this.aG = ehg.a(this.O.a(), this.k.J());
        this.aL = TracyClient.createDiscontinuousFrame((String)"Server Tick");
        this.ag = new ayo();
        this.aM = new xb(thread);
        this.options = options;
        this.worldLoader = worldLoader;
        this.vanillaCommandDispatcher = worldstem.b().d;
        if (System.console() == null && System.getProperty("org.jline.terminal.provider") == null) {
            System.setProperty("org.jline.terminal.provider", "dumb");
            org.bukkit.craftbukkit.Main.useJline = false;
        }
        try {
            this.terminal = TerminalBuilder.builder().dumb(false).build();
        }
        catch (Throwable e2) {
            try {
                System.setProperty("org.jline.terminal.provider", "dumb");
                org.bukkit.craftbukkit.Main.useJline = false;
                this.terminal = TerminalBuilder.builder().build();
            }
            catch (IOException ex2) {
                m.warn((String)null, (Throwable)ex2);
            }
        }
        Runtime.getRuntime().addShutdownHook(new ServerShutdownThread(this));
    }

    private void a(fib worldpersistentdata) {
        worldpersistentdata.a(anc.a);
    }

    protected abstract boolean e() throws IOException;

    public axh a(final int i2) {
        return new axh(){
            @Nullable
            private awb c;
            private int d;
            private int e;

            @Override
            public void a(ami<drq> resourcekey, dqv chunkcoordintpair) {
                awx worldserver = MinecraftServer.this.a(resourcekey);
                this.c = worldserver != null ? worldserver.n().a : null;
                this.d = chunkcoordintpair.h;
                this.e = chunkcoordintpair.i;
            }

            @Override
            @Nullable
            public emo a(int j2, int k2) {
                return this.c == null ? null : this.c.c(dqv.c(j2 + this.d - i2, k2 + this.e - i2));
            }

            @Override
            public int a() {
                return i2;
            }
        };
    }

    protected void loadLevel(String s2) {
        boolean flag = !byi.f.c() && ac.aB && byi.f.a(byg.a(this));
        byl profiledduration = byi.f.e();
        this.loadWorld0(s2);
        if (profiledduration != null) {
            profiledduration.finish(true);
        }
        if (flag) {
            try {
                byi.f.b();
            }
            catch (Throwable throwable) {
                m.warn("Failed to stop JFR profiling", throwable);
            }
        }
    }

    protected void v() {
    }

    private void loadWorld0(String s2) {
        fih.c worldSession = this.g;
        jy.b iregistrycustom_dimension = this.O.a();
        jx<eno> dimensions = iregistrycustom_dimension.f(mp.by);
        for (eno worldDimension : dimensions) {
            awx world;
            fil worlddata;
            Dynamic<?> dynamic;
            String name;
            ami<eno> dimensionKey = dimensions.d(worldDimension).get();
            int dimension = 0;
            if (dimensionKey == eno.c) {
                if (!this.server.getAllowNether()) continue;
                dimension = -1;
            } else if (dimensionKey == eno.d) {
                if (!this.server.getAllowEnd()) continue;
                dimension = 1;
            } else if (dimensionKey != eno.b) {
                dimension = -999;
            }
            String worldType = dimension == -999 ? dimensionKey.a().b() + "_" + dimensionKey.a().a() : World.Environment.getEnvironment((int)dimension).toString().toLowerCase(Locale.ROOT);
            String string = name = dimensionKey == eno.b ? s2 : s2 + "_" + worldType;
            if (dimension != 0) {
                File newWorld = fih.getStorageFolder(new File(name).toPath(), dimensionKey).toFile();
                File oldWorld = fih.getStorageFolder(new File(s2).toPath(), dimensionKey).toFile();
                File oldLevelDat = new File(new File(s2), "level.dat");
                if (!newWorld.isDirectory() && oldWorld.isDirectory() && oldLevelDat.isFile()) {
                    m.info("---- Migration of old " + worldType + " folder required ----");
                    m.info("Unfortunately due to the way that Minecraft implemented multiworld support in 1.6, Bukkit requires that you move your " + worldType + " folder to a new location in order to operate correctly.");
                    m.info("We will move this folder for you, but it will mean that you need to move it back should you wish to stop using Bukkit in the future.");
                    m.info("Attempting to move " + String.valueOf(oldWorld) + " to " + String.valueOf(newWorld) + "...");
                    if (newWorld.exists()) {
                        m.warn("A file or folder already exists at " + String.valueOf(newWorld) + "!");
                        m.info("---- Migration of old " + worldType + " folder failed ----");
                    } else if (newWorld.getParentFile().mkdirs()) {
                        if (oldWorld.renameTo(newWorld)) {
                            m.info("Success! To restore " + worldType + " in the future, simply move " + String.valueOf(newWorld) + " to " + String.valueOf(oldWorld));
                            try {
                                Files.copy((File)oldLevelDat, (File)new File(new File(name), "level.dat"));
                                FileUtils.copyDirectory((File)new File(new File(s2), "data"), (File)new File(new File(name), "data"));
                            }
                            catch (IOException exception) {
                                m.warn("Unable to migrate world data.");
                            }
                            m.info("---- Migration of old " + worldType + " folder complete ----");
                        } else {
                            m.warn("Could not move folder " + String.valueOf(oldWorld) + " to " + String.valueOf(newWorld) + "!");
                            m.info("---- Migration of old " + worldType + " folder failed ----");
                        }
                    } else {
                        m.warn("Could not create path for " + String.valueOf(newWorld) + "!");
                        m.info("---- Migration of old " + worldType + " folder failed ----");
                    }
                }
                try {
                    worldSession = fih.b(this.server.getWorldContainer().toPath()).validateAndCreateAccess(name, dimensionKey);
                }
                catch (fnw | IOException ex2) {
                    throw new RuntimeException(ex2);
                }
            }
            if (worldSession.m()) {
                fii worldinfo;
                try {
                    dynamic = worldSession.h();
                    worldinfo = worldSession.a(dynamic);
                }
                catch (IOException | va | vh ioexception) {
                    fih.b convertable_b = worldSession.e();
                    m.warn("Failed to load world data from {}", (Object)convertable_b.b(), (Object)ioexception);
                    m.info("Attempting to use fallback");
                    try {
                        dynamic = worldSession.i();
                        worldinfo = worldSession.a(dynamic);
                    }
                    catch (IOException | va | vh ioexception1) {
                        m.error("Failed to load world data from {}", (Object)convertable_b.c(), (Object)ioexception1);
                        m.error("Failed to load world data from {} and {}. World files may be corrupted. Shutting down.", (Object)convertable_b.b(), (Object)convertable_b.c());
                        return;
                    }
                    worldSession.n();
                }
                if (worldinfo.d()) {
                    m.info("This world must be opened in an older version (like 1.6.4) to be safely converted");
                    return;
                }
                if (!worldinfo.r()) {
                    m.info("This world was created by an incompatible version.");
                    return;
                }
            } else {
                dynamic = null;
            }
            ChunkGenerator gen = this.server.getGenerator(name);
            BiomeProvider biomeProvider = this.server.getBiomeProvider(name);
            anh.a worldloader_a = this.worldLoader;
            jx<eno> iregistry = worldloader_a.d().f(mp.by);
            if (dynamic != null) {
                fie leveldataanddimensions = fih.a(dynamic, worldloader_a.b(), iregistry, worldloader_a.c());
                worlddata = (fil)leveldataanddimensions.a();
            } else {
                eqk worlddimensions;
                eqn worldoptions;
                dru worldsettings;
                if (this.ac()) {
                    worldsettings = e;
                    worldoptions = eqn.b;
                    worlddimensions = fad.a(worldloader_a.c());
                } else {
                    arp dedicatedserverproperties = ((aro)this).a();
                    worldsettings = new dru(dedicatedserverproperties.o, dedicatedserverproperties.n.get(), dedicatedserverproperties.D, dedicatedserverproperties.m.get(), false, new drm(worldloader_a.b().b()), worldloader_a.b());
                    worldoptions = this.options.has("bonusChest") ? dedicatedserverproperties.ai.a(true) : dedicatedserverproperties.ai;
                    worlddimensions = dedicatedserverproperties.a(worldloader_a.c());
                }
                eqk.b worlddimensions_b = worlddimensions.a(iregistry);
                Lifecycle lifecycle = worlddimensions_b.a().add(worldloader_a.c().d());
                worlddata = new fil(worldsettings, worldoptions, worlddimensions_b.d(), lifecycle);
            }
            worlddata.checkName(name);
            if (this.options.has("forceUpgrade")) {
                Main.a(worldSession, worlddata, bgy.a(), this.options.has("eraseCache"), () -> true, iregistrycustom_dimension, this.options.has("recreateRegionFiles"));
            }
            fil iworlddataserver = worlddata;
            boolean flag = worlddata.z();
            eqn worldoptions = worlddata.x();
            long i2 = worldoptions.c();
            long j2 = dsv.a(i2);
            ImmutableList list = ImmutableList.of((Object)new eqb(), (Object)new eqa(), (Object)new cyt(), (Object)new cqa(), (Object)new cze(iworlddataserver));
            eno worlddimension = dimensions.c(dimensionKey);
            CraftWorldInfo worldInfo = new CraftWorldInfo(iworlddataserver, worldSession, World.Environment.getEnvironment((int)dimension), worlddimension.a().a());
            if (biomeProvider == null && gen != null) {
                biomeProvider = gen.getDefaultBiomeProvider((WorldInfo)worldInfo);
            }
            ami<drq> worldKey = ami.a(mp.bx, dimensionKey.a());
            if (dimensionKey == eno.b) {
                this.k = worlddata;
                this.k.a(((aro)this).a().n.get());
                world = new awx(this, this.ay, worldSession, iworlddataserver, worldKey, worlddimension, flag, j2, (List<drc>)list, true, null, World.Environment.getEnvironment((int)dimension), gen, biomeProvider);
                fib worldpersistentdata = world.y();
                this.a(worldpersistentdata);
                this.server.scoreboardManager = new CraftScoreboardManager(this, world.g());
                this.as = new fhy(worldpersistentdata);
            } else {
                world = new awx(this, this.ay, worldSession, iworlddataserver, worldKey, worlddimension, flag, j2, (List<drc>)ImmutableList.of(), true, this.O().R(), World.Environment.getEnvironment((int)dimension), gen, biomeProvider);
            }
            worlddata.a(this.getServerModName(), this.U().a());
            this.initWorld(world, worlddata, this.k, worldoptions);
            this.addLevel(world);
            this.am().a(world);
            if (worlddata.D() == null) continue;
            this.aR().a(worlddata.D(), this.bg());
        }
        this.v();
        for (awx worldserver : this.Q()) {
            this.prepareLevels(worldserver);
            worldserver.M.b();
            this.server.getPluginManager().callEvent((Event)new WorldLoadEvent((World)worldserver.getWorld()));
        }
        this.server.enablePlugins(PluginLoadOrder.POSTWORLD);
        this.server.getPluginManager().callEvent((Event)new ServerLoadEvent(ServerLoadEvent.LoadType.STARTUP));
        this.G.acceptConnections();
    }

    public void initWorld(awx worldserver, fim iworlddataserver, fis saveData, eqn worldoptions) {
        boolean flag = saveData.z();
        if (worldserver.generator != null) {
            worldserver.getWorld().getPopulators().addAll(worldserver.generator.getDefaultPopulators((World)worldserver.getWorld()));
        }
        this.initWorldBorder(worldserver, iworlddataserver);
        this.server.getPluginManager().callEvent((Event)new WorldInitEvent((World)worldserver.getWorld()));
        if (!iworlddataserver.m()) {
            try {
                MinecraftServer.a(worldserver, iworlddataserver, worldoptions.e(), flag, this.H);
                iworlddataserver.c(true);
                if (flag) {
                    this.a(this.k);
                }
            }
            catch (Throwable throwable) {
                p crashreport = p.a(throwable, "Exception initializing level");
                try {
                    worldserver.a(crashreport);
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
                throw new aa(crashreport);
            }
            iworlddataserver.c(true);
        }
        jj globalpos = new jj(worldserver.al(), worldserver.A().b());
        this.H.a(globalpos.a(), new dqv(globalpos.b()));
    }

    private void initWorldBorder(awx worldserver1, fim iworlddataserver) {
        boolean flag1 = false;
        Optional<elf.c> optional = iworlddataserver.o();
        if (optional.isPresent()) {
            elf.c worldborder_c = optional.get();
            fib worldpersistentdata1 = worldserver1.y();
            if (worldpersistentdata1.b(elf.d) == null) {
                double d0 = worldserver1.H_().k();
                elf.c worldborder_c1 = new elf.c(worldborder_c.b() / d0, worldborder_c.c() / d0, worldborder_c.d(), worldborder_c.e(), worldborder_c.f(), worldborder_c.g(), worldborder_c.h(), worldborder_c.i(), worldborder_c.j());
                worldpersistentdata1.a(elf.d, worldborder_c1.a());
            }
            flag1 = true;
        }
        worldserver1.u().a(this.ay());
        this.am().a(worldserver1);
        if (flag1) {
            iworlddataserver.a(Optional.empty());
        }
    }

    private static void a(awx worldserver, fim iworlddataserver, boolean flag, boolean flag1, axi levelloadlistener) {
        if (ac.aE && ac.aU) {
            iworlddataserver.a(fid.a.a(worldserver.al(), new ja(0, 64, -100), 0.0f, 0.0f));
        } else if (flag1) {
            iworlddataserver.a(fid.a.a(worldserver.al(), ja.c.b(80), 0.0f, 0.0f));
        } else {
            awu chunkproviderserver = worldserver.n();
            dqv chunkcoordintpair = new dqv(chunkproviderserver.i().b().a());
            if (worldserver.generator != null) {
                Random rand = new Random(worldserver.H());
                Location spawn = worldserver.generator.getFixedSpawnLocation((World)worldserver.getWorld(), rand);
                if (spawn != null) {
                    if (spawn.getWorld() != worldserver.getWorld()) {
                        throw new IllegalStateException("Cannot set spawn point for " + iworlddataserver.d() + " to be in another world (" + spawn.getWorld().getName() + ")");
                    }
                    iworlddataserver.a(fid.a.a(worldserver.al(), new ja(spawn.getBlockX(), spawn.getBlockY(), spawn.getBlockZ()), spawn.getYaw(), spawn.getPitch()));
                    return;
                }
            }
            levelloadlistener.a(axi.a.b, 0);
            levelloadlistener.a(worldserver.al(), chunkcoordintpair);
            int i2 = chunkproviderserver.g().a(worldserver);
            if (i2 < worldserver.M_()) {
                ja blockposition = chunkcoordintpair.l();
                i2 = worldserver.a(epp.a.b, blockposition.u() + 8, blockposition.w() + 8);
            }
            iworlddataserver.a(fid.a.a(worldserver.al(), chunkcoordintpair.l().b(8, i2, 8), 0.0f, 0.0f));
            int j2 = 0;
            int k2 = 0;
            int l2 = 0;
            int i1 = -1;
            for (int j1 = 0; j1 < bfh.i(11); ++j1) {
                ja blockposition1;
                if (j2 >= -5 && j2 <= 5 && k2 >= -5 && k2 <= 5 && (blockposition1 = awr.a(worldserver, new dqv(chunkcoordintpair.h + j2, chunkcoordintpair.i + k2))) != null) {
                    iworlddataserver.a(fid.a.a(worldserver.al(), blockposition1, 0.0f, 0.0f));
                    break;
                }
                if (j2 == k2 || j2 < 0 && j2 == -k2 || j2 > 0 && j2 == 1 - k2) {
                    int k1 = l2;
                    l2 = -i1;
                    i1 = k1;
                }
                j2 += l2;
                k2 += i1;
            }
            if (flag) {
                worldserver.L_().a(mp.aS).flatMap(iregistry -> iregistry.a(ry.m)).ifPresent(holder_c -> ((esh)holder_c.a()).a(worldserver, chunkproviderserver.g(), worldserver.z, iworlddataserver.a().b()));
            }
            levelloadlistener.a(axi.a.b);
        }
    }

    private void a(fis savedata) {
        savedata.a(cbn.a);
        savedata.d(true);
        fim iworlddataserver = savedata.H();
        iworlddataserver.b(false);
        iworlddataserver.a(false);
        iworlddataserver.a(1000000000);
        iworlddataserver.b(6000L);
        iworlddataserver.a(drn.d);
    }

    public void prepareLevels(awx worldserver) {
        this.forceTicks = true;
        awa chunkloadcounter = new awa();
        chunkloadcounter.a(worldserver, () -> {
            dsn ticketstorage = worldserver.y().b(dsn.b);
            if (ticketstorage != null) {
                ticketstorage.a();
            }
        });
        this.H.a(axi.a.c, chunkloadcounter.c());
        do {
            this.H.a(axi.a.c, chunkloadcounter.a(), chunkloadcounter.c());
            this.executeModerately();
        } while (chunkloadcounter.b() > 0);
        this.H.a(axi.a.c);
        this.forceTicks = false;
        this.bM();
    }

    protected jj x() {
        return this.k.H().a().c();
    }

    public drn y() {
        return this.k.j();
    }

    public boolean w_() {
        return this.k.k();
    }

    public abstract int k();

    public abstract int l();

    public abstract boolean m();

    public boolean a(boolean flag, boolean flag1, boolean flag2) {
        boolean flag3 = false;
        for (awx worldserver : this.Q()) {
            if (!flag) {
                m.info("Saving chunks for level '{}'/{}", (Object)worldserver, (Object)worldserver.al().a());
            }
            worldserver.a((bfp)null, flag1, ac.af || worldserver.e && !flag2);
            flag3 = true;
        }
        if (flag1) {
            for (awx worldserver1 : this.Q()) {
                m.info("ThreadedAnvilChunkStorage ({}): All chunks are saved", (Object)worldserver1.n().a.l());
            }
            m.info("ThreadedAnvilChunkStorage: All dimensions are saved");
        }
        return flag3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean b(boolean flag, boolean flag1, boolean flag2) {
        boolean flag3;
        try {
            this.aI = true;
            this.am().h();
            flag3 = this.a(flag, flag1, flag2);
        }
        finally {
            this.aI = false;
        }
        return flag3;
    }

    @Override
    public void close() {
        this.z();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean hasStopped() {
        Object object = this.stopLock;
        synchronized (object) {
            return this.hasStopped;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void z() {
        Iterator<awx> iterator = this.stopLock;
        synchronized (iterator) {
            if (this.hasStopped) {
                return;
            }
            this.hasStopped = true;
        }
        this.aM.close();
        if (this.A.e()) {
            this.bc();
        }
        m.info("Stopping server");
        if (this.server != null) {
            this.server.disablePlugins();
        }
        this.an().b();
        this.aI = true;
        if (this.Q != null) {
            m.info("Saving players");
            this.Q.h();
            this.Q.s();
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        m.info("Saving worlds");
        for (awx worldserver : this.Q()) {
            if (worldserver == null) continue;
            worldserver.e = false;
        }
        while (this.P.values().stream().anyMatch(worldserver1 -> worldserver1.n().a.e())) {
            this.am = ag.d() + bgm.b;
            for (awx worldserver12 : this.Q()) {
                worldserver12.n().q();
                worldserver12.n().a(() -> true, false);
            }
            this.x_();
        }
        this.a(false, true, false);
        for (awx worldserver2 : this.Q()) {
            if (worldserver2 == null) continue;
            try {
                worldserver2.close();
            }
            catch (IOException ioexception) {
                m.error("Exception closing the level", (Throwable)ioexception);
            }
        }
        this.aI = false;
        this.aA.close();
        try {
            this.g.close();
        }
        catch (IOException ioexception1) {
            m.error("Failed to unlock level {}", (Object)this.g.f(), (Object)ioexception1);
        }
    }

    public String A() {
        return this.M;
    }

    @Override
    public void a_(String s2) {
        this.M = s2;
    }

    public boolean B() {
        return this.R;
    }

    public void a(boolean flag) {
        this.R = false;
        if (flag) {
            try {
                this.ai.join();
            }
            catch (InterruptedException interruptedexception) {
                m.error("Error while shutting down", (Throwable)interruptedexception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void C() {
        try {
            if (!this.e()) {
                throw new IllegalStateException("Failed to initialize server");
            }
            this.am = ag.d();
            this.J = this.bH().orElse(null);
            this.I = this.bK();
            while (this.R) {
                boolean flag;
                long i2;
                if (!this.J() && this.aC.a() && this.aC.d()) {
                    i2 = 0L;
                    this.af = this.am = ag.d();
                } else {
                    i2 = this.aC.h();
                    long j2 = ag.d() - this.am;
                    if (j2 > p + 20L * i2 && this.am - this.af >= r + 100L * i2) {
                        long k2 = j2 / i2;
                        if (this.server.getWarnOnOverload()) {
                            m.warn("Can't keep up! Is the server overloaded? Running {}ms or {} ticks behind", (Object)(j2 / bgm.b), (Object)k2);
                        }
                        this.am += k2 * i2;
                        this.af = this.am;
                    }
                }
                boolean bl2 = flag = i2 == 0L;
                if (this.F) {
                    this.F = false;
                    this.E = new c(ag.d(), this.T);
                }
                currentTick = (int)(System.currentTimeMillis() / 50L);
                this.am += i2;
                try (bxz.a profiler_a = bxz.a(this.bU());){
                    bya gameprofilerfiller = bxz.a();
                    gameprofilerfiller.a("tick");
                    this.aL.start();
                    gameprofilerfiller.a("scheduledPacketProcessing");
                    this.aM.b();
                    gameprofilerfiller.c();
                    this.a(flag ? () -> false : this::bF);
                    this.aL.end();
                    gameprofilerfiller.b("nextTickWait");
                    this.ap = true;
                    this.ao = Math.max(ag.d() + i2, this.am);
                    this.bD();
                    this.x_();
                    this.bE();
                    if (flag) {
                        this.aC.e();
                    }
                    gameprofilerfiller.c();
                    this.bC();
                }
                finally {
                    this.aY();
                }
                this.ae = true;
                byi.f.a(this.ax);
            }
            return;
        }
        catch (Throwable throwable2) {
            m.error("Encountered an unexpected exception", throwable2);
            p crashreport = MinecraftServer.b(throwable2);
            this.b(crashreport.f());
            Path path = this.I().resolve("crash-reports").resolve("crash-" + ag.f() + "-server.txt");
            if (crashreport.a(path, z.a)) {
                m.error("This crash report has been saved to: {}", (Object)path.toAbsolutePath());
            } else {
                m.error("We were unable to save this crash report to disk.");
            }
            this.a(crashreport);
            return;
        }
        finally {
            try {
                this.S = true;
                this.z();
            }
            catch (Throwable throwable3) {
                m.error("Exception stopping the server", throwable3);
            }
            finally {
                try {
                    this.terminal.close();
                }
                catch (Exception i2) {}
                this.i();
            }
        }
    }

    private void bC() {
        long i2 = ag.d();
        if (this.g()) {
            this.f().a(i2 - this.aj);
        }
        this.aj = i2;
    }

    private void bD() {
        if (this.g()) {
            this.ak = ag.d();
            this.al = 0L;
        }
    }

    private void bE() {
        if (this.g()) {
            bwe samplelogger = this.f();
            samplelogger.a(ag.d() - this.ak - this.al, bwg.c.ordinal());
            samplelogger.a(this.al, bwg.d.ordinal());
        }
    }

    private static p b(Throwable throwable) {
        p crashreport;
        aa reportedexception = null;
        for (Throwable throwable1 = throwable; throwable1 != null; throwable1 = throwable1.getCause()) {
            aa reportedexception1;
            if (!(throwable1 instanceof aa)) continue;
            reportedexception = reportedexception1 = (aa)throwable1;
        }
        if (reportedexception != null) {
            crashreport = reportedexception.a();
            if (reportedexception != throwable) {
                crashreport.a("Wrapped in").a("Wrapping exception", throwable);
            }
        } else {
            crashreport = new p("Exception in server tick loop", throwable);
        }
        return crashreport;
    }

    private boolean bF() {
        return this.forceTicks || this.bT() || ag.d() < (this.ap ? this.ao : this.am);
    }

    private void executeModerately() {
        this.bR();
        LockSupport.parkNanos("executing tasks", 1000L);
    }

    public static boolean D() {
        RuntimeException runtimeexception = aJ.get();
        if (runtimeexception != null) {
            throw runtimeexception;
        }
        return true;
    }

    public static void a(RuntimeException runtimeexception) {
        aJ.compareAndSet(null, runtimeexception);
    }

    @Override
    public void b(BooleanSupplier booleansupplier) {
        super.b(() -> MinecraftServer.D() && booleansupplier.getAsBoolean());
    }

    public ayo E() {
        return this.ag;
    }

    protected void x_() {
        bya gameprofilerfiller = bxz.a();
        gameprofilerfiller.a("scheduledPacketProcessing");
        this.aM.b();
        gameprofilerfiller.c();
        this.bR();
        this.an = true;
        try {
            this.b(() -> !this.bF());
        }
        finally {
            this.an = false;
        }
    }

    @Override
    public void F() {
        boolean flag = this.g();
        long i2 = flag ? ag.d() : 0L;
        long j2 = this.an ? this.am - ag.d() : 100000L;
        LockSupport.parkNanos("waiting for tasks", j2);
        if (flag) {
            this.al += ag.d() - i2;
        }
    }

    public ang a(Runnable runnable) {
        return new ang(this.T, runnable);
    }

    protected boolean a(ang ticktask) {
        return ticktask.a() + 3 < this.T || this.bF();
    }

    @Override
    public boolean G() {
        boolean flag;
        this.ap = flag = this.bG();
        return flag;
    }

    private boolean bG() {
        if (super.G()) {
            return true;
        }
        if (this.aC.a() || this.bS() || this.bF()) {
            for (awx worldserver : this.Q()) {
                if (!worldserver.n().c()) continue;
                return true;
            }
        }
        return false;
    }

    public void b(ang ticktask) {
        bxz.a().f("runTask");
        super.d(ticktask);
    }

    private Optional<alg.a> bH() {
        Optional<Path> optional = Optional.of(this.c("server-icon.png")).filter(path -> java.nio.file.Files.isRegularFile(path, new LinkOption[0])).or(() -> this.g.j().filter(path -> java.nio.file.Files.isRegularFile(path, new LinkOption[0])));
        return optional.flatMap(path -> {
            try {
                BufferedImage bufferedimage = ImageIO.read(path.toFile());
                Preconditions.checkState((bufferedimage.getWidth() == 64 ? 1 : 0) != 0, (Object)"Must be 64 pixels wide");
                Preconditions.checkState((bufferedimage.getHeight() == 64 ? 1 : 0) != 0, (Object)"Must be 64 pixels high");
                ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)bufferedimage, "PNG", bytearrayoutputstream);
                return Optional.of(new alg.a(bytearrayoutputstream.toByteArray()));
            }
            catch (Exception exception) {
                m.error("Couldn't load server icon", (Throwable)exception);
                return Optional.empty();
            }
        });
    }

    public Optional<Path> H() {
        return this.g.j();
    }

    public Path I() {
        return Path.of("", new String[0]);
    }

    public void a(p crashreport) {
    }

    public void i() {
    }

    public boolean J() {
        return false;
    }

    public void a(BooleanSupplier booleansupplier) {
        long i2 = ag.d();
        int j2 = this.by() * 20;
        if (j2 > 0) {
            this.aH = this.Q.m() == 0 && !this.aC.a() ? ++this.aH : 0;
            if (this.aH >= j2) {
                if (this.aH == j2) {
                    m.info("Server empty for {} seconds, pausing", (Object)this.by());
                    this.bI();
                }
                this.server.getScheduler().mainThreadHeartbeat();
                this.L();
                return;
            }
        }
        ++this.T;
        this.aC.m();
        this.c(booleansupplier);
        if (i2 - this.ah >= t) {
            this.ah = i2;
            this.I = this.bK();
        }
        --this.U;
        if (this.autosavePeriod > 0 && this.U <= 0) {
            this.bI();
        }
        bya gameprofilerfiller = bxz.a();
        gameprofilerfiller.a("tallying");
        long k2 = ag.d() - i2;
        int l2 = this.T % 100;
        this.aa -= this.Z[l2];
        this.aa += k2;
        this.Z[l2] = k2;
        this.ax = this.ax * 0.8f + (float)k2 / (float)bgm.b * 0.19999999f;
        this.a(i2);
        gameprofilerfiller.c();
    }

    private void bI() {
        this.U = this.autosavePeriod;
        m.debug("Autosave started");
        bya gameprofilerfiller = bxz.a();
        gameprofilerfiller.a("save");
        this.b(true, false, false);
        gameprofilerfiller.c();
        m.debug("Autosave finished");
    }

    private void a(long i2) {
        if (this.g()) {
            this.f().a(ag.d() - i2, bwg.b.ordinal());
        }
    }

    private int bJ() {
        float f2;
        if (this.aC.a()) {
            long i2 = this.aW() + 1L;
            f2 = (float)bgm.a / (float)i2;
        } else {
            f2 = this.aC.f();
        }
        int j2 = 300;
        return Math.max(100, (int)(f2 * 300.0f));
    }

    public void K() {
        int i2 = this.bJ();
        if (i2 < this.U) {
            this.U = i2;
        }
    }

    protected abstract bwe f();

    public abstract boolean g();

    private alg bK() {
        alg.b serverping_serverpingplayersample = this.bL();
        return new alg(xx.a(this.ak()), Optional.of(serverping_serverpingplayersample), Optional.of(alg.c.a()), Optional.ofNullable(this.J), this.aC());
    }

    private alg.b bL() {
        List<awy> list = this.Q.t();
        int i2 = this.t();
        if (this.as()) {
            return new alg.b(i2, list.size(), List.of());
        }
        int j2 = Math.min(list.size(), 12);
        ObjectArrayList objectarraylist = new ObjectArrayList(j2);
        int k2 = bfh.a(this.K, 0, list.size() - j2);
        for (int l2 = 0; l2 < j2; ++l2) {
            awy entityplayer = list.get(k2 + l2);
            objectarraylist.add((Object)(entityplayer.aa() ? entityplayer.gA() : f));
        }
        ag.c(objectarraylist, this.K);
        return new alg.b(i2, list.size(), (List<bbb>)objectarraylist);
    }

    protected void c(BooleanSupplier booleansupplier) {
        bya gameprofilerfiller = bxz.a();
        this.am().t().forEach(entityplayer -> entityplayer.g.f());
        this.server.getScheduler().mainThreadHeartbeat();
        gameprofilerfiller.a("commandFunctions");
        this.aG().b();
        gameprofilerfiller.b("levels");
        this.bM();
        while (!this.processQueue.isEmpty()) {
            this.processQueue.remove().run();
        }
        if (this.T % 20 == 0) {
            for (int i2 = 0; i2 < this.am().k.size(); ++i2) {
                awy entityplayer2 = this.am().k.get(i2);
                entityplayer2.g.b(new agt(entityplayer2.A().ag(), entityplayer2.getPlayerTime(), entityplayer2.A().S().c(drm.m)));
            }
        }
        for (awx worldserver : this.Q()) {
            gameprofilerfiller.a(() -> {
                String s2 = String.valueOf(worldserver);
                return s2 + " " + String.valueOf(worldserver.al().a());
            });
            gameprofilerfiller.a("tick");
            try {
                worldserver.a(booleansupplier);
            }
            catch (Throwable throwable) {
                p crashreport = p.a(throwable, "Exception ticking world");
                worldserver.a(crashreport);
                throw new aa(crashreport);
            }
            gameprofilerfiller.c();
            gameprofilerfiller.c();
        }
        gameprofilerfiller.b("connection");
        this.L();
        gameprofilerfiller.b("players");
        this.Q.d();
        gameprofilerfiller.b("debugSubscribers");
        this.aD.a();
        if (this.aC.i()) {
            gameprofilerfiller.b("gameTests");
            tn.a.b();
        }
        gameprofilerfiller.b("server gui refresh");
        for (int i3 = 0; i3 < this.z.size(); ++i3) {
            this.z.get(i3).run();
        }
        gameprofilerfiller.b("send chunks");
        for (awy entityplayer2 : this.Q.t()) {
            entityplayer2.g.g.a(entityplayer2);
            entityplayer2.g.g();
        }
        gameprofilerfiller.c();
    }

    private void bM() {
        fid.a worlddata_a = this.k.H().a();
        awx worldserver = this.aL();
        this.aE = worldserver.b(worlddata_a);
    }

    public void L() {
        this.an().c();
    }

    private void a(awx worldserver) {
        this.Q.a(new agt(worldserver.ag(), worldserver.ah(), worldserver.S().c(drm.m)), worldserver.al());
    }

    public void M() {
        bya gameprofilerfiller = bxz.a();
        gameprofilerfiller.a("timeSync");
        for (awx worldserver : this.Q()) {
            this.a(worldserver);
        }
        gameprofilerfiller.c();
    }

    public boolean a(drq world) {
        return world.al() == drq.i ? this.aQ().c(drm.af) : true;
    }

    public void b(Runnable runnable) {
        this.z.add(runnable);
    }

    protected void b(String s2) {
        this.az = s2;
    }

    public boolean N() {
        return !this.ai.isAlive();
    }

    public Path c(String s2) {
        return this.I().resolve(s2);
    }

    public final awx O() {
        return this.P.get(drq.h);
    }

    @Nullable
    public awx a(ami<drq> resourcekey) {
        return this.P.get(resourcekey);
    }

    public void addLevel(awx level) {
        Map<ami<drq>, awx> oldLevels = this.P;
        LinkedHashMap newLevels = Maps.newLinkedHashMap(oldLevels);
        newLevels.put(level.al(), level);
        this.P = Collections.unmodifiableMap(newLevels);
    }

    public void removeLevel(awx level) {
        Map<ami<drq>, awx> oldLevels = this.P;
        LinkedHashMap newLevels = Maps.newLinkedHashMap(oldLevels);
        newLevels.remove(level.al());
        this.P = Collections.unmodifiableMap(newLevels);
    }

    public Set<ami<drq>> P() {
        return this.P.keySet();
    }

    public Iterable<awx> Q() {
        return this.P.values();
    }

    @Override
    public String R() {
        return ac.b().c();
    }

    @Override
    public int S() {
        return this.Q.m();
    }

    public String[] T() {
        return this.Q.e();
    }

    @DontObfuscate
    public String getServerModName() {
        return this.server.getName();
    }

    public ae b(ae systemreport) {
        systemreport.a("Server Running", () -> Boolean.toString(this.R));
        if (this.Q != null) {
            systemreport.a("Player Count", () -> {
                int i2 = this.Q.m();
                return i2 + " / " + this.Q.n() + "; " + String.valueOf(this.Q.t());
            });
        }
        systemreport.a("Active Data Packs", () -> baa.a(this.aq.g()));
        systemreport.a("Available Data Packs", () -> baa.a(this.aq.d()));
        systemreport.a("Enabled Feature Flags", () -> dcz.e.b(this.k.J()).stream().map(amj::toString).collect(Collectors.joining(", ")));
        systemreport.a("World Generation", () -> this.k.A().toString());
        systemreport.a("World Seed", () -> String.valueOf(this.k.x().c()));
        anf suppressedexceptioncollector = this.aK;
        Objects.requireNonNull(this.aK);
        systemreport.a("Suppressed Exceptions", suppressedexceptioncollector::a);
        if (this.az != null) {
            systemreport.a("Server Id", () -> this.az);
        }
        return this.a(systemreport);
    }

    public abstract ae a(ae var1);

    public bfg U() {
        return bfg.a(b, this::getServerModName, "Server", MinecraftServer.class);
    }

    @Override
    public void a(xx ichatbasecomponent) {
        m.info(ichatbasecomponent.getString());
    }

    public KeyPair V() {
        return this.ab;
    }

    public int W() {
        return this.N;
    }

    public void b(int i2) {
        this.N = i2;
    }

    @Nullable
    public GameProfile X() {
        return this.ac;
    }

    public void a(@Nullable GameProfile gameprofile) {
        this.ac = gameprofile;
    }

    public boolean Y() {
        return this.ac != null;
    }

    protected void Z() {
        m.info("Generating keypair");
        try {
            this.ab = bed.b();
        }
        catch (bee cryptographyexception) {
            throw new IllegalStateException("Failed to generate key pair", cryptographyexception);
        }
    }

    public void a(cbn enumdifficulty, boolean flag) {
        if (flag || !this.k.q()) {
            this.k.a(this.k.k() ? cbn.d : enumdifficulty);
            this.aa();
            this.am().t().forEach(this::c);
        }
    }

    public int c(int i2) {
        return i2;
    }

    private void aa() {
        for (awx worldserver : this.Q()) {
            worldserver.b(MinecraftServer.isSpawningMonsters(worldserver));
        }
    }

    public void b(boolean flag) {
        this.k.d(flag);
        this.am().t().forEach(this::c);
    }

    private void c(awy entityplayer) {
        fid worlddata = entityplayer.A().F_();
        entityplayer.g.b(new add(worlddata.p(), worlddata.q()));
    }

    public static boolean isSpawningMonsters(awx worldserver) {
        return worldserver.aq() != cbn.a && worldserver.S().c(drm.f) && worldserver.S().c(drm.ag);
    }

    public boolean ac() {
        return this.ad;
    }

    public void c(boolean flag) {
        this.ad = flag;
    }

    public Map<String, String> ad() {
        return Map.of();
    }

    public Optional<b> ae() {
        return Optional.empty();
    }

    public boolean af() {
        return this.ae().filter(b::d).isPresent();
    }

    public abstract boolean n();

    public abstract int o();

    public boolean ag() {
        return this.V;
    }

    @Override
    public void d(boolean flag) {
        this.V = flag;
    }

    public boolean ah() {
        return this.W;
    }

    public void e(boolean flag) {
        this.W = flag;
    }

    public abstract boolean p();

    public boolean ai() {
        return this.aQ().c(drm.ae);
    }

    public boolean aj() {
        return true;
    }

    public boolean y_() {
        return this.aQ().c(drm.ah);
    }

    public boolean r() {
        return this.aQ().c(drm.ai);
    }

    @Override
    public String ak() {
        return this.X;
    }

    @Override
    public void d(String s2) {
        this.X = s2;
    }

    public boolean al() {
        return this.S;
    }

    public bbd am() {
        return this.Q;
    }

    public void a(bbd playerlist) {
        this.Q = playerlist;
    }

    public abstract boolean s();

    public void a(drn enumgamemode) {
        this.k.a(enumgamemode);
    }

    public int b(@Nullable drn enumgamemode) {
        if (enumgamemode == null) {
            return 0;
        }
        int i2 = 0;
        for (awy entityplayer : this.am().t()) {
            if (!entityplayer.a(enumgamemode)) continue;
            ++i2;
        }
        return i2;
    }

    public axy an() {
        return this.G;
    }

    public boolean ao() {
        return this.ae;
    }

    public boolean ap() {
        return false;
    }

    public boolean a(@Nullable drn enumgamemode, boolean flag, int i2) {
        return false;
    }

    public int aq() {
        return this.T;
    }

    public boolean a(awx worldserver, ja blockposition, czl entityhuman) {
        return false;
    }

    public boolean ar() {
        return true;
    }

    public boolean as() {
        return false;
    }

    public Proxy at() {
        return this.i;
    }

    public int au() {
        return this.Y;
    }

    @Override
    public void d(int i2) {
        this.Y = i2;
    }

    public ane av() {
        return this.j;
    }

    @Nullable
    public alg aw() {
        return this.I;
    }

    public void ax() {
        this.ah = 0L;
    }

    public int ay() {
        return 29999984;
    }

    @Override
    public boolean az() {
        return super.az() && !this.al();
    }

    @Override
    public void c(Runnable runnable) {
        if (this.al()) {
            throw new RejectedExecutionException("Server already shutting down");
        }
        super.c(runnable);
    }

    @Override
    public Thread aA() {
        return this.ai;
    }

    public int aB() {
        return 256;
    }

    public boolean aC() {
        return false;
    }

    public long aD() {
        return this.am;
    }

    public DataFixer aE() {
        return this.L;
    }

    public amw aF() {
        return this.aA.b.e();
    }

    public amy aG() {
        return this.au;
    }

    @Override
    public CompletableFuture<Void> a(Collection<String> collection) {
        CompletionStage completablefuture = ((CompletableFuture)CompletableFuture.supplyAsync(() -> {
            Stream stream = collection.stream();
            baa resourcepackrepository = this.aq;
            Objects.requireNonNull(this.aq);
            return (ImmutableList)stream.map(resourcepackrepository::c).filter(Objects::nonNull).map(azx::f).collect(ImmutableList.toImmutableList());
        }, this).thenCompose(immutablelist -> {
            bai ireloadableresourcemanager = new bai(azd.b, (List<azb>)immutablelist);
            List<jx.a<?>> list = bdk.a((bap)ireloadableresourcemanager, this.O.a());
            return ((CompletableFuture)amu.a(ireloadableresourcemanager, this.O, list, this.k.J(), this.n() ? ek.a.b : ek.a.c, this.l(), this.ay, this).whenComplete((datapackresources, throwable) -> {
                if (throwable != null) {
                    ireloadableresourcemanager.close();
                }
            })).thenApply(datapackresources -> new a(ireloadableresourcemanager, (amu)datapackresources));
        })).thenAcceptAsync(minecraftserver_reloadableresources -> {
            this.aA.close();
            this.aA = minecraftserver_reloadableresources;
            this.server.syncCommands();
            this.aq.b(collection);
            dso worlddataconfiguration = new dso(MinecraftServer.a(this.aq, true), this.k.J());
            this.k.a(worlddataconfiguration);
            this.aA.b.g();
            this.aA.b.c().a(this.k.J());
            this.am().h();
            this.am().u();
            this.au.a(this.aA.b.a());
            this.aB.a(this.aA.a);
            this.aG = ehg.a(this.O.a(), this.k.J());
        }, (Executor)this);
        if (this.bO()) {
            Objects.requireNonNull(completablefuture);
            this.b(((CompletableFuture)completablefuture)::isDone);
        }
        return completablefuture;
    }

    public static dso a(baa resourcepackrepository, dso worlddataconfiguration, boolean flag, boolean flag1) {
        drd datapackconfiguration = worlddataconfiguration.a();
        dcx featureflagset = flag ? dcx.a() : worlddataconfiguration.b();
        dcx featureflagset1 = flag ? dcz.e.a() : worlddataconfiguration.b();
        resourcepackrepository.a();
        if (flag1) {
            return MinecraftServer.a(resourcepackrepository, List.of(b), featureflagset, false);
        }
        LinkedHashSet set = Sets.newLinkedHashSet();
        for (String s2 : datapackconfiguration.a()) {
            if (resourcepackrepository.d(s2)) {
                set.add(s2);
                continue;
            }
            m.warn("Missing data pack {}", (Object)s2);
        }
        for (azx resourcepackloader : resourcepackrepository.d()) {
            String s1 = resourcepackloader.g();
            if (datapackconfiguration.b().contains(s1)) continue;
            dcx featureflagset2 = resourcepackloader.e();
            boolean flag2 = set.contains(s1);
            if (!flag2 && resourcepackloader.l().a()) {
                if (featureflagset2.a(featureflagset1)) {
                    m.info("Found new data pack {}, loading it automatically", (Object)s1);
                    set.add(s1);
                } else {
                    m.info("Found new data pack {}, but can't load it due to missing features {}", (Object)s1, (Object)dcz.a(featureflagset1, featureflagset2));
                }
            }
            if (!flag2 || featureflagset2.a(featureflagset1)) continue;
            m.warn("Pack {} requires features {} that are not enabled for this world, disabling pack.", (Object)s1, (Object)dcz.a(featureflagset1, featureflagset2));
            set.remove(s1);
        }
        if (set.isEmpty()) {
            m.info("No datapacks selected, forcing vanilla");
            set.add(b);
        }
        return MinecraftServer.a(resourcepackrepository, set, featureflagset, true);
    }

    private static dso a(baa resourcepackrepository, Collection<String> collection, dcx featureflagset, boolean flag) {
        resourcepackrepository.b(collection);
        MinecraftServer.a(resourcepackrepository, featureflagset);
        drd datapackconfiguration = MinecraftServer.a(resourcepackrepository, flag);
        dcx featureflagset1 = resourcepackrepository.f().c(featureflagset);
        return new dso(datapackconfiguration, featureflagset1);
    }

    private static void a(baa resourcepackrepository, dcx featureflagset) {
        dcx featureflagset1 = resourcepackrepository.f();
        dcx featureflagset2 = featureflagset.d(featureflagset1);
        if (!featureflagset2.b()) {
            ObjectArraySet set = new ObjectArraySet(resourcepackrepository.e());
            for (azx resourcepackloader : resourcepackrepository.d()) {
                if (featureflagset2.b()) break;
                if (resourcepackloader.l() != bab.d) continue;
                String s2 = resourcepackloader.g();
                dcx featureflagset3 = resourcepackloader.e();
                if (featureflagset3.b() || !featureflagset3.b(featureflagset2) || !featureflagset3.a(featureflagset)) continue;
                if (!set.add(s2)) {
                    throw new IllegalStateException("Tried to force '" + s2 + "', but it was already enabled");
                }
                m.info("Found feature pack ('{}') for requested feature, forcing to enabled", (Object)s2);
                featureflagset2 = featureflagset2.d(featureflagset3);
            }
            resourcepackrepository.b((Collection<String>)set);
        }
    }

    private static drd a(baa resourcepackrepository, boolean flag) {
        Collection<String> collection = resourcepackrepository.e();
        ImmutableList list = ImmutableList.copyOf(collection);
        List<String> list1 = flag ? resourcepackrepository.c().stream().filter(s2 -> !collection.contains(s2)).toList() : List.of();
        return new drd((List<String>)list, list1);
    }

    public void aH() {
        if (this.aS() && this.aT()) {
            bbd playerlist = this.am();
            bbn whitelist = playerlist.i();
            for (awy entityplayer : Lists.newArrayList(playerlist.t())) {
                if (whitelist.a(entityplayer.gA())) continue;
                entityplayer.g.a(xx.c("multiplayer.disconnect.not_whitelisted"));
            }
        }
    }

    public baa aI() {
        return this.aq;
    }

    public ek aJ() {
        return this.aA.b.d();
    }

    public ej aK() {
        awx worldserver = this.aL();
        return new ej(this, worldserver == null ? foh.c : foh.a(this.aM().b()), fog.a, worldserver, 4, "Server", xx.b("Server"), this, null);
    }

    public awx aL() {
        return this.findRespawnDimension(this.O());
    }

    public awx findRespawnDimension(awx world) {
        fid.a worlddata_a = world.A();
        ami<drq> resourcekey = worlddata_a.a();
        awx worldserver = this.a(resourcekey);
        return worldserver != null ? worldserver : this.O();
    }

    public void a(fid.a worlddata_a) {
        this.setRespawnData(worlddata_a, this.O());
    }

    public void setRespawnData(fid.a worlddata_a, awx world) {
        fil iworlddataserver = world.J;
        fid.a worlddata_a1 = iworlddataserver.a();
        if (!worlddata_a1.equals(worlddata_a)) {
            iworlddataserver.a(worlddata_a);
            SpawnChangeEvent event = new SpawnChangeEvent((World)world.getWorld(), CraftLocation.toBukkit(worlddata_a1.b(), (World)world.getWorld(), worlddata_a1.d(), worlddata_a1.e()));
            this.server.getPluginManager().callEvent((Event)event);
            this.am().a(new agd(worlddata_a));
            this.bM();
        }
    }

    public fid.a aM() {
        return this.aE;
    }

    @Override
    public boolean z_() {
        return true;
    }

    @Override
    public boolean A_() {
        return true;
    }

    @Override
    public abstract boolean c();

    public dmp aN() {
        return this.aA.b.c();
    }

    public anc aO() {
        return this.ar;
    }

    public fhy aP() {
        if (this.as == null) {
            throw new NullPointerException("Called before server init");
        }
        return this.as;
    }

    public drm aQ() {
        return this.O().S();
    }

    public anm aR() {
        return this.at;
    }

    public boolean aS() {
        return this.av;
    }

    public void f(boolean flag) {
        this.av = flag;
    }

    public boolean aT() {
        return this.aw;
    }

    public void g(boolean flag) {
        this.aw = flag;
    }

    public float aU() {
        return this.ax;
    }

    public and aV() {
        return this.aC;
    }

    public long aW() {
        return this.aa / (long)Math.min(100, Math.max(this.T, 1));
    }

    public long[] aX() {
        return this.Z;
    }

    public int b(bbb nameandid) {
        if (this.am().f(nameandid)) {
            bbg oplistentry = (bbg)this.am().k().c(nameandid);
            return oplistentry != null ? oplistentry.a() : (this.a(nameandid) ? 4 : (this.Y() ? (this.am().v() ? 4 : 0) : this.k()));
        }
        return 0;
    }

    public abstract boolean a(bbb var1);

    public void a(Path path) throws IOException {
    }

    private void b(Path path) {
        Path path1 = path.resolve("levels");
        try {
            for (Map.Entry<ami<drq>, awx> map_entry : this.P.entrySet()) {
                amj minecraftkey = map_entry.getKey().a();
                Path path2 = path1.resolve(minecraftkey.b()).resolve(minecraftkey.a());
                java.nio.file.Files.createDirectories(path2, new FileAttribute[0]);
                map_entry.getValue().a(path2);
            }
            this.d(path.resolve("gamerules.txt"));
            this.e(path.resolve("classpath.txt"));
            this.c(path.resolve("stats.txt"));
            this.f(path.resolve("threads.txt"));
            this.a(path.resolve("server.properties.txt"));
            this.g(path.resolve("modules.txt"));
        }
        catch (IOException ioexception) {
            m.warn("Failed to save debug report", (Throwable)ioexception);
        }
    }

    private void c(Path path) throws IOException {
        try (BufferedWriter writer = java.nio.file.Files.newBufferedWriter(path, new OpenOption[0]);){
            writer.write(String.format(Locale.ROOT, "pending_tasks: %d\n", this.bP()));
            writer.write(String.format(Locale.ROOT, "average_tick_time: %f\n", Float.valueOf(this.aU())));
            writer.write(String.format(Locale.ROOT, "tick_times: %s\n", Arrays.toString(this.Z)));
            writer.write(String.format(Locale.ROOT, "queue: %s\n", ag.h()));
        }
    }

    @Override
    private void d(Path path) throws IOException {
        try (BufferedWriter writer = java.nio.file.Files.newBufferedWriter(path, new OpenOption[0]);){
            final ArrayList list = Lists.newArrayList();
            final drm gamerules = this.aQ();
            gamerules.a(new drm.c(){

                @Override
                public <T extends drm.g<T>> void a(drm.e<T> gamerules_gamerulekey, drm.f<T> gamerules_gameruledefinition) {
                    list.add(String.format(Locale.ROOT, "%s=%s\n", gamerules_gamerulekey.a(), gamerules.b(gamerules_gamerulekey)));
                }
            });
            for (String s2 : list) {
                writer.write(s2);
            }
        }
    }

    private void e(Path path) throws IOException {
        try (BufferedWriter writer = java.nio.file.Files.newBufferedWriter(path, new OpenOption[0]);){
            String s2 = System.getProperty("java.class.path");
            String s1 = System.getProperty("path.separator");
            for (String s22 : Splitter.on((String)s1).split((CharSequence)s2)) {
                writer.write(s22);
                writer.write("\n");
            }
        }
    }

    private void f(Path path) throws IOException {
        ThreadMXBean threadmxbean = ManagementFactory.getThreadMXBean();
        ThreadInfo[] athreadinfo = threadmxbean.dumpAllThreads(true, true);
        Arrays.sort(athreadinfo, Comparator.comparing(ThreadInfo::getThreadName));
        try (BufferedWriter writer = java.nio.file.Files.newBufferedWriter(path, new OpenOption[0]);){
            for (ThreadInfo threadinfo : athreadinfo) {
                writer.write(threadinfo.toString());
                ((Writer)writer).write(10);
            }
        }
    }

    private void g(Path path) throws IOException {
        BufferedWriter writer = java.nio.file.Files.newBufferedWriter(path, new OpenOption[0]);
        try {
            ArrayList list;
            try {
                list = Lists.newArrayList(bfi.a());
            }
            catch (Throwable throwable) {
                m.warn("Failed to list native modules", throwable);
                if (writer != null) {
                    ((Writer)writer).close();
                }
                return;
            }
            list.sort(Comparator.comparing(nativemodulelister_a -> nativemodulelister_a.a));
            for (bfi.a nativemodulelister_a2 : list) {
                writer.write(nativemodulelister_a2.toString());
                ((Writer)writer).write(10);
            }
        }
        finally {
            if (writer != null) {
                try {
                    ((Writer)writer).close();
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    throwable2.addSuppressed(throwable);
                }
            }
        }
    }

    public boolean isDebugging() {
        return false;
    }

    @Deprecated
    public static MinecraftServer getServer() {
        return Bukkit.getServer() instanceof CraftServer ? ((CraftServer)Bukkit.getServer()).getServer() : null;
    }

    @Deprecated
    public static jy getDefaultRegistryAccess() {
        return CraftRegistry.getMinecraftRegistry();
    }

    private bya bU() {
        if (this.D) {
            this.A = bzp.a(new bzt(ag.c, this.n()), ag.c, ag.i(), new bzv("server"), this.B, path -> {
                this.h(() -> this.b(path.resolve("server")));
                this.C.accept((Path)path);
            });
            this.D = false;
        }
        this.A.c();
        return byd.a(this.A.f(), byd.a("Server"));
    }

    public void aY() {
        this.A.d();
    }

    public boolean aZ() {
        return this.A.e();
    }

    public void a(Consumer<bxy> consumer, Consumer<Path> consumer1) {
        this.B = methodprofilerresults -> {
            this.ba();
            consumer.accept((bxy)methodprofilerresults);
        };
        this.C = consumer1;
        this.D = true;
    }

    public void ba() {
        this.A = bzq.a;
    }

    public void bb() {
        this.A.a();
    }

    public void bc() {
        this.A.b();
    }

    public Path a(fif savedfile) {
        return this.g.a(savedfile);
    }

    public boolean bd() {
        return true;
    }

    public feq be() {
        return this.aB;
    }

    public fis bf() {
        return this.k;
    }

    public jy.b bg() {
        return this.O.a();
    }

    public jr<ams> bh() {
        return this.O;
    }

    public amt.a bi() {
        return this.aA.b.b();
    }

    public ayf a(awy entityplayer) {
        return ayf.e;
    }

    public awz b(awy entityplayer) {
        return this.ac() ? new awj(entityplayer) : new awz(entityplayer);
    }

    @Nullable
    public drn bj() {
        return null;
    }

    public bap bk() {
        return this.aA.a;
    }

    public boolean bl() {
        return this.aI;
    }

    public boolean bm() {
        return this.F || this.E != null;
    }

    public void bn() {
        this.F = true;
    }

    public bxy bo() {
        if (this.E == null) {
            return bxu.a;
        }
        bxy methodprofilerresults = this.E.a(ag.d(), this.T);
        this.E = null;
        return methodprofilerresults;
    }

    public int bp() {
        return 1000000;
    }

    public void a(xx ichatbasecomponent, xt.a chatmessagetype_a, @Nullable String s2) {
        String s1 = chatmessagetype_a.a(ichatbasecomponent).getString();
        if (s2 != null) {
            m.info("[{}] {}", (Object)s2, (Object)s1);
        } else {
            m.info("{}", (Object)s1);
        }
    }

    public xs bq() {
        return xs.a;
    }

    public boolean br() {
        return true;
    }

    public void handleCustomClickAction(amj minecraftkey, Optional<vp> optional, awy player) {
        m.debug("Received custom click action {} with payload {}", (Object)minecraftkey, optional.orElse(null));
        CraftEventFactory.callPlayerCustomClickEvent(minecraftkey, optional, player);
    }

    public axi bs() {
        return this.H;
    }

    public boolean h(boolean flag) {
        boolean flag1 = false;
        for (awx worldserver : this.Q()) {
            if (worldserver == null || worldserver.e != flag) continue;
            worldserver.e = !flag;
            flag1 = true;
        }
        return flag1;
    }

    public boolean bt() {
        for (awx worldserver : this.Q()) {
            if (worldserver == null || worldserver.e) continue;
            return true;
        }
        return false;
    }

    public void a(String s2, drm.g<?> gamerules_gamerulevalue) {
        this.E().a(s2, gamerules_gamerulevalue);
    }

    public boolean bu() {
        return false;
    }

    private void a(p crashreport, dqv chunkcoordintpair, eng regionstorageinfo) {
        ag.i().execute(() -> {
            try {
                Path path = this.c("debug");
                w.c(path);
                String s2 = w.a(regionstorageinfo.a());
                Path path1 = path.resolve("chunk-" + s2 + "-" + ag.f() + "-server.txt");
                FileStore filestore = java.nio.file.Files.getFileStore(path);
                long i2 = filestore.getUsableSpace();
                if (i2 < 8192L) {
                    m.warn("Not storing chunk IO report due to low space on drive {}", (Object)filestore.name());
                    return;
                }
                q crashreportsystemdetails = crashreport.a("Chunk Info");
                Objects.requireNonNull(regionstorageinfo);
                crashreportsystemdetails.a("Level", regionstorageinfo::a);
                crashreportsystemdetails.a("Dimension", () -> regionstorageinfo.b().a().toString());
                Objects.requireNonNull(regionstorageinfo);
                crashreportsystemdetails.a("Storage", regionstorageinfo::c);
                Objects.requireNonNull(chunkcoordintpair);
                crashreportsystemdetails.a("Position", chunkcoordintpair::toString);
                crashreport.a(path1, z.e);
                m.info("Saved details to {}", (Object)crashreport.e());
            }
            catch (Exception exception) {
                m.warn("Failed to store chunk IO exception", (Throwable)exception);
            }
        });
    }

    @Override
    public void a(Throwable throwable, eng regionstorageinfo, dqv chunkcoordintpair) {
        m.error("Failed to load chunk {},{}", new Object[]{chunkcoordintpair.h, chunkcoordintpair.i, throwable});
        this.aK.a("chunk/load", throwable);
        this.a(p.a(throwable, "Chunk load failure"), chunkcoordintpair, regionstorageinfo);
    }

    @Override
    public void b(Throwable throwable, eng regionstorageinfo, dqv chunkcoordintpair) {
        m.error("Failed to save chunk {},{}", new Object[]{chunkcoordintpair.h, chunkcoordintpair.i, throwable});
        this.aK.a("chunk/save", throwable);
        this.a(p.a(throwable, "Chunk save failure"), chunkcoordintpair, regionstorageinfo);
    }

    public void a(Throwable throwable, aaq<?> packettype) {
        this.aK.a("packet/" + packettype.toString(), throwable);
    }

    public djl bv() {
        return this.aF;
    }

    public ehg bw() {
        return this.aG;
    }

    public anb bx() {
        return anb.a;
    }

    protected int by() {
        return 0;
    }

    public xb bz() {
        return this.aM;
    }

    public bvx bA() {
        return this.aD;
    }

    public record a(baf a, amu b) implements AutoCloseable
    {
        @Override
        public void close() {
            this.a.close();
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "resourceManager;managers", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "resourceManager;managers", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "resourceManager;managers", "a", "b"}, this, o2);
        }
    }

    private static class c {
        final long a;
        final int b;

        c(long i2, int j2) {
            this.a = i2;
            this.b = j2;
        }

        bxy a(final long i2, final int j2) {
            return new bxy(){

                @Override
                public List<byc> a(String s2) {
                    return Collections.emptyList();
                }

                @Override
                public boolean a(Path path) {
                    return false;
                }

                @Override
                public long a() {
                    return a;
                }

                @Override
                public int b() {
                    return b;
                }

                @Override
                public long c() {
                    return i2;
                }

                @Override
                public int d() {
                    return j2;
                }

                @Override
                public String e() {
                    return "";
                }
            };
        }
    }

    public record b(UUID a, String b, String c, boolean d, @Nullable xx e) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "id;url;hash;isRequired;prompt", "a", "b", "c", "d", "e"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "id;url;hash;isRequired;prompt", "a", "b", "c", "d", "e"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "id;url;hash;isRequired;prompt", "a", "b", "c", "d", "e"}, this, o2);
        }
    }
}

