/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R6;

import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import org.bukkit.Material;
import org.bukkit.Statistic;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBlockType;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftEntityType;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftItemType;
import org.bukkit.entity.EntityType;

public enum CraftStatistic {
    DAMAGE_DEALT(bco.H),
    DAMAGE_TAKEN(bco.K),
    DEATHS(bco.O),
    MOB_KILLS(bco.P),
    PLAYER_KILLS(bco.R),
    FISH_CAUGHT(bco.S),
    ANIMALS_BRED(bco.Q),
    LEAVE_GAME(bco.j),
    JUMP(bco.F),
    DROP_COUNT(bco.G),
    DROP(amj.b("dropped")),
    PICKUP(amj.b("picked_up")),
    PLAY_ONE_MINUTE(bco.k),
    TOTAL_WORLD_TIME(bco.l),
    WALK_ONE_CM(bco.p),
    WALK_ON_WATER_ONE_CM(bco.s),
    FALL_ONE_CM(bco.t),
    SNEAK_TIME(bco.o),
    CLIMB_ONE_CM(bco.u),
    FLY_ONE_CM(bco.v),
    WALK_UNDER_WATER_ONE_CM(bco.w),
    MINECART_ONE_CM(bco.x),
    BOAT_ONE_CM(bco.y),
    PIG_ONE_CM(bco.z),
    HAPPY_GHAST_ONE_CM(bco.A),
    HORSE_ONE_CM(bco.B),
    SPRINT_ONE_CM(bco.r),
    CROUCH_ONE_CM(bco.q),
    AVIATE_ONE_CM(bco.C),
    MINE_BLOCK(amj.b("mined")),
    USE_ITEM(amj.b("used")),
    BREAK_ITEM(amj.b("broken")),
    CRAFT_ITEM(amj.b("crafted")),
    KILL_ENTITY(amj.b("killed")),
    ENTITY_KILLED_BY(amj.b("killed_by")),
    TIME_SINCE_DEATH(bco.m),
    TALKED_TO_VILLAGER(bco.T),
    TRADED_WITH_VILLAGER(bco.U),
    CAKE_SLICES_EATEN(bco.V),
    CAULDRON_FILLED(bco.W),
    CAULDRON_USED(bco.X),
    ARMOR_CLEANED(bco.Y),
    BANNER_CLEANED(bco.Z),
    BREWINGSTAND_INTERACTION(bco.ab),
    BEACON_INTERACTION(bco.ac),
    DROPPER_INSPECTED(bco.ad),
    HOPPER_INSPECTED(bco.ae),
    DISPENSER_INSPECTED(bco.af),
    NOTEBLOCK_PLAYED(bco.ag),
    NOTEBLOCK_TUNED(bco.ah),
    FLOWER_POTTED(bco.ai),
    TRAPPED_CHEST_TRIGGERED(bco.aj),
    ENDERCHEST_OPENED(bco.ak),
    ITEM_ENCHANTED(bco.al),
    RECORD_PLAYED(bco.am),
    FURNACE_INTERACTION(bco.an),
    CRAFTING_TABLE_INTERACTION(bco.ao),
    CHEST_OPENED(bco.ap),
    SLEEP_IN_BED(bco.aq),
    SHULKER_BOX_OPENED(bco.ar),
    TIME_SINCE_REST(bco.n),
    SWIM_ONE_CM(bco.D),
    DAMAGE_DEALT_ABSORBED(bco.I),
    DAMAGE_DEALT_RESISTED(bco.J),
    DAMAGE_BLOCKED_BY_SHIELD(bco.L),
    DAMAGE_ABSORBED(bco.M),
    DAMAGE_RESISTED(bco.N),
    CLEAN_SHULKER_BOX(bco.aa),
    OPEN_BARREL(bco.as),
    INTERACT_WITH_BLAST_FURNACE(bco.at),
    INTERACT_WITH_SMOKER(bco.au),
    INTERACT_WITH_LECTERN(bco.av),
    INTERACT_WITH_CAMPFIRE(bco.aw),
    INTERACT_WITH_CARTOGRAPHY_TABLE(bco.ax),
    INTERACT_WITH_LOOM(bco.ay),
    INTERACT_WITH_STONECUTTER(bco.az),
    BELL_RING(bco.aA),
    RAID_TRIGGER(bco.aB),
    RAID_WIN(bco.aC),
    INTERACT_WITH_ANVIL(bco.aD),
    INTERACT_WITH_GRINDSTONE(bco.aE),
    TARGET_HIT(bco.aF),
    INTERACT_WITH_SMITHING_TABLE(bco.aG),
    STRIDER_ONE_CM(bco.E);

    private final amj minecraftKey;
    private final Statistic bukkit;
    private static final BiMap<amj, Statistic> statistics;

    private CraftStatistic(amj minecraftKey) {
        this.minecraftKey = minecraftKey;
        this.bukkit = Statistic.valueOf((String)this.name());
        Preconditions.checkState((this.bukkit != null ? 1 : 0) != 0, (String)"Bukkit statistic %s does not exist", (Object)this.name());
    }

    public static Statistic getBukkitStatistic(bcl<?> statistic) {
        Preconditions.checkArgument((statistic != null ? 1 : 0) != 0, (Object)"NMS Statistic cannot be null");
        jx<?> statRegistry = statistic.a().b();
        amj nmsKey = mo.w.b(statistic.a());
        if (statRegistry == mo.l) {
            nmsKey = (amj)statistic.b();
        }
        return (Statistic)statistics.get((Object)nmsKey);
    }

    public static bcl getNMSStatistic(Statistic bukkit) {
        Preconditions.checkArgument((bukkit.getType() == Statistic.Type.UNTYPED ? 1 : 0) != 0, (Object)"This method only accepts untyped statistics");
        bcl<amj> nms = bco.i.b((amj)statistics.inverse().get((Object)bukkit));
        Preconditions.checkArgument((nms != null ? 1 : 0) != 0, (String)"NMS Statistic %s does not exist", (Object)bukkit);
        return nms;
    }

    public static bcl getMaterialStatistic(Statistic stat, Material material) {
        Statistic.Type type = stat.getType();
        switch (type) {
            case BLOCK: {
                Preconditions.checkArgument((boolean)material.isBlock(), (String)"statistic type is BLOCK but got non-block Material, %s", (Object)material);
                if (stat != Statistic.MINE_BLOCK) break;
                return bco.a.b(CraftBlockType.bukkitToMinecraft(material));
            }
            case ITEM: {
                Preconditions.checkArgument((boolean)material.isItem(), (String)"statistic type is ITEM but got non-item Material, %s", (Object)material);
                if (stat == Statistic.CRAFT_ITEM) {
                    return bco.b.b(CraftItemType.bukkitToMinecraft(material));
                }
                if (stat == Statistic.USE_ITEM) {
                    return bco.c.b(CraftItemType.bukkitToMinecraft(material));
                }
                if (stat == Statistic.BREAK_ITEM) {
                    return bco.d.b(CraftItemType.bukkitToMinecraft(material));
                }
                if (stat == Statistic.PICKUP) {
                    return bco.e.b(CraftItemType.bukkitToMinecraft(material));
                }
                if (stat != Statistic.DROP) break;
                return bco.f.b(CraftItemType.bukkitToMinecraft(material));
            }
            default: {
                throw new IllegalArgumentException("statistic type must be either BLOCK or ITEM, given " + String.valueOf(type));
            }
        }
        throw new IllegalArgumentException("Unknwon material statistic " + String.valueOf(stat));
    }

    public static bcl getEntityStatistic(Statistic stat, EntityType entity) {
        Preconditions.checkArgument((entity != null ? 1 : 0) != 0, (Object)"EntityType cannot be null");
        if (entity.getName() != null) {
            cee<?> nmsEntity = CraftEntityType.bukkitToMinecraft(entity);
            if (stat == Statistic.KILL_ENTITY) {
                return bco.g.b(nmsEntity);
            }
            if (stat == Statistic.ENTITY_KILLED_BY) {
                return bco.h.b(nmsEntity);
            }
        }
        return null;
    }

    public static EntityType getEntityTypeFromStatistic(bcl<cee<?>> statistic) {
        Preconditions.checkArgument((statistic != null ? 1 : 0) != 0, (Object)"NMS Statistic cannot be null");
        return CraftEntityType.minecraftToBukkit(statistic.b());
    }

    public static Material getMaterialFromStatistic(bcl<?> statistic) {
        Object obj = statistic.b();
        if (obj instanceof dhl) {
            dhl statisticItemValue = (dhl)obj;
            return CraftItemType.minecraftToBukkit(statisticItemValue);
        }
        obj = statistic.b();
        if (obj instanceof duv) {
            duv statisticBlockValue = (duv)obj;
            return CraftBlockType.minecraftToBukkit(statisticBlockValue);
        }
        return null;
    }

    public static void incrementStatistic(bck manager, Statistic statistic, awy player) {
        CraftStatistic.incrementStatistic(manager, statistic, 1, player);
    }

    public static void decrementStatistic(bck manager, Statistic statistic, awy player) {
        CraftStatistic.decrementStatistic(manager, statistic, 1, player);
    }

    public static int getStatistic(bck manager, Statistic statistic) {
        Preconditions.checkArgument((statistic != null ? 1 : 0) != 0, (Object)"Statistic cannot be null");
        Preconditions.checkArgument((statistic.getType() == Statistic.Type.UNTYPED ? 1 : 0) != 0, (Object)"Must supply additional parameter for this statistic");
        return manager.a(CraftStatistic.getNMSStatistic(statistic));
    }

    public static void incrementStatistic(bck manager, Statistic statistic, int amount, awy player) {
        Preconditions.checkArgument((amount > 0 ? 1 : 0) != 0, (Object)"Amount must be greater than 0");
        CraftStatistic.setStatistic(manager, statistic, CraftStatistic.getStatistic(manager, statistic) + amount, player);
    }

    public static void decrementStatistic(bck manager, Statistic statistic, int amount, awy player) {
        Preconditions.checkArgument((amount > 0 ? 1 : 0) != 0, (Object)"Amount must be greater than 0");
        CraftStatistic.setStatistic(manager, statistic, CraftStatistic.getStatistic(manager, statistic) - amount, player);
    }

    public static void setStatistic(bck manager, Statistic statistic, int newValue, awy player) {
        Preconditions.checkArgument((statistic != null ? 1 : 0) != 0, (Object)"Statistic cannot be null");
        Preconditions.checkArgument((statistic.getType() == Statistic.Type.UNTYPED ? 1 : 0) != 0, (Object)"Must supply additional parameter for this statistic");
        Preconditions.checkArgument((newValue >= 0 ? 1 : 0) != 0, (Object)"Value must be greater than or equal to 0");
        bcl nmsStatistic = CraftStatistic.getNMSStatistic(statistic);
        manager.a(null, nmsStatistic, newValue);
        if (player != null) {
            player.A().getCraftServer().getScoreboardManager().forAllObjectives(nmsStatistic, player, score -> score.a(newValue));
        }
    }

    public static void incrementStatistic(bck manager, Statistic statistic, Material material, awy player) {
        CraftStatistic.incrementStatistic(manager, statistic, material, 1, player);
    }

    public static void decrementStatistic(bck manager, Statistic statistic, Material material, awy player) {
        CraftStatistic.decrementStatistic(manager, statistic, material, 1, player);
    }

    public static int getStatistic(bck manager, Statistic statistic, Material material) {
        Preconditions.checkArgument((statistic != null ? 1 : 0) != 0, (Object)"Statistic cannot be null");
        Preconditions.checkArgument((material != null ? 1 : 0) != 0, (Object)"Material cannot be null");
        Preconditions.checkArgument((statistic.getType() == Statistic.Type.BLOCK || statistic.getType() == Statistic.Type.ITEM ? 1 : 0) != 0, (Object)"This statistic does not take a Material parameter");
        bcl nmsStatistic = CraftStatistic.getMaterialStatistic(statistic, material);
        Preconditions.checkArgument((nmsStatistic != null ? 1 : 0) != 0, (String)"The supplied Material %s does not have a corresponding statistic", (Object)material);
        return manager.a(nmsStatistic);
    }

    public static void incrementStatistic(bck manager, Statistic statistic, Material material, int amount, awy player) {
        Preconditions.checkArgument((amount > 0 ? 1 : 0) != 0, (Object)"Amount must be greater than 0");
        CraftStatistic.setStatistic(manager, statistic, material, CraftStatistic.getStatistic(manager, statistic, material) + amount, player);
    }

    public static void decrementStatistic(bck manager, Statistic statistic, Material material, int amount, awy player) {
        Preconditions.checkArgument((amount > 0 ? 1 : 0) != 0, (Object)"Amount must be greater than 0");
        CraftStatistic.setStatistic(manager, statistic, material, CraftStatistic.getStatistic(manager, statistic, material) - amount, player);
    }

    public static void setStatistic(bck manager, Statistic statistic, Material material, int newValue, awy player) {
        Preconditions.checkArgument((statistic != null ? 1 : 0) != 0, (Object)"Statistic cannot be null");
        Preconditions.checkArgument((material != null ? 1 : 0) != 0, (Object)"Material cannot be null");
        Preconditions.checkArgument((newValue >= 0 ? 1 : 0) != 0, (Object)"Value must be greater than or equal to 0");
        Preconditions.checkArgument((statistic.getType() == Statistic.Type.BLOCK || statistic.getType() == Statistic.Type.ITEM ? 1 : 0) != 0, (Object)"This statistic does not take a Material parameter");
        bcl nmsStatistic = CraftStatistic.getMaterialStatistic(statistic, material);
        Preconditions.checkArgument((nmsStatistic != null ? 1 : 0) != 0, (String)"The supplied Material %s does not have a corresponding statistic", (Object)material);
        manager.a(null, nmsStatistic, newValue);
        if (player != null) {
            player.A().getCraftServer().getScoreboardManager().forAllObjectives(nmsStatistic, player, score -> score.a(newValue));
        }
    }

    public static void incrementStatistic(bck manager, Statistic statistic, EntityType entityType, awy player) {
        CraftStatistic.incrementStatistic(manager, statistic, entityType, 1, player);
    }

    public static void decrementStatistic(bck manager, Statistic statistic, EntityType entityType, awy player) {
        CraftStatistic.decrementStatistic(manager, statistic, entityType, 1, player);
    }

    public static int getStatistic(bck manager, Statistic statistic, EntityType entityType) {
        Preconditions.checkArgument((statistic != null ? 1 : 0) != 0, (Object)"Statistic cannot be null");
        Preconditions.checkArgument((entityType != null ? 1 : 0) != 0, (Object)"EntityType cannot be null");
        Preconditions.checkArgument((statistic.getType() == Statistic.Type.ENTITY ? 1 : 0) != 0, (Object)"This statistic does not take an EntityType parameter");
        bcl nmsStatistic = CraftStatistic.getEntityStatistic(statistic, entityType);
        Preconditions.checkArgument((nmsStatistic != null ? 1 : 0) != 0, (String)"The supplied EntityType %s does not have a corresponding statistic", (Object)entityType);
        return manager.a(nmsStatistic);
    }

    public static void incrementStatistic(bck manager, Statistic statistic, EntityType entityType, int amount, awy player) {
        Preconditions.checkArgument((amount > 0 ? 1 : 0) != 0, (Object)"Amount must be greater than 0");
        CraftStatistic.setStatistic(manager, statistic, entityType, CraftStatistic.getStatistic(manager, statistic, entityType) + amount, player);
    }

    public static void decrementStatistic(bck manager, Statistic statistic, EntityType entityType, int amount, awy player) {
        Preconditions.checkArgument((amount > 0 ? 1 : 0) != 0, (Object)"Amount must be greater than 0");
        CraftStatistic.setStatistic(manager, statistic, entityType, CraftStatistic.getStatistic(manager, statistic, entityType) - amount, player);
    }

    public static void setStatistic(bck manager, Statistic statistic, EntityType entityType, int newValue, awy player) {
        Preconditions.checkArgument((statistic != null ? 1 : 0) != 0, (Object)"Statistic cannot be null");
        Preconditions.checkArgument((entityType != null ? 1 : 0) != 0, (Object)"EntityType cannot be null");
        Preconditions.checkArgument((newValue >= 0 ? 1 : 0) != 0, (Object)"Value must be greater than or equal to 0");
        Preconditions.checkArgument((statistic.getType() == Statistic.Type.ENTITY ? 1 : 0) != 0, (Object)"This statistic does not take an EntityType parameter");
        bcl nmsStatistic = CraftStatistic.getEntityStatistic(statistic, entityType);
        Preconditions.checkArgument((nmsStatistic != null ? 1 : 0) != 0, (String)"The supplied EntityType %s does not have a corresponding statistic", (Object)entityType);
        manager.a(null, nmsStatistic, newValue);
        if (player != null) {
            player.A().getCraftServer().getScoreboardManager().forAllObjectives(nmsStatistic, player, score -> score.a(newValue));
        }
    }

    static {
        ImmutableBiMap.Builder statisticBuilder = ImmutableBiMap.builder();
        for (CraftStatistic statistic : CraftStatistic.values()) {
            statisticBuilder.put((Object)statistic.minecraftKey, (Object)statistic.bukkit);
        }
        statistics = statisticBuilder.build();
    }
}

