/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R6.block;

import com.google.common.base.Preconditions;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.function.Consumer;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.World;
import org.bukkit.block.BlockType;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_21_R6.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R6.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R6.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftItemType;
import org.bukkit.craftbukkit.v1_21_R6.registry.CraftRegistryItem;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftMagicNumbers;
import org.bukkit.inventory.ItemType;
import org.jetbrains.annotations.NotNull;

public class CraftBlockType<B extends BlockData>
extends CraftRegistryItem<duv>
implements BlockType.Typed<B> {
    private final Class<B> blockDataClass = CraftBlockData.fromData(((duv)this.getHandle()).m()).getClass().getInterfaces()[0];
    private final boolean interactable = CraftBlockType.isInteractable((duv)this.getHandle());
    private static final Class<?>[] USE_WITHOUT_ITEM_ARGS = new Class[]{ejm.class, drq.class, ja.class, czl.class, fod.class};
    private static final Class<?>[] USE_ITEM_ON_ARGS = new Class[]{dhp.class, ejm.class, drq.class, ja.class, czl.class, cbp.class, fod.class};

    public static Material minecraftToBukkit(duv block) {
        return CraftMagicNumbers.getMaterial(block);
    }

    public static duv bukkitToMinecraft(Material material) {
        return CraftMagicNumbers.getBlock(material);
    }

    public static BlockType minecraftToBukkitNew(duv minecraft) {
        return (BlockType)CraftRegistry.minecraftToBukkit(minecraft, mp.i, Registry.BLOCK);
    }

    public static duv bukkitToMinecraftNew(BlockType bukkit) {
        return (duv)CraftRegistry.bukkitToMinecraft(bukkit);
    }

    private static boolean hasMethod(Class<?> clazz, Class<?> ... params) {
        boolean hasMethod = false;
        for (Method method : clazz.getDeclaredMethods()) {
            if (!Arrays.equals(method.getParameterTypes(), params)) continue;
            Preconditions.checkArgument((!hasMethod ? 1 : 0) != 0, (String)"More than one matching method for %s, args %s", clazz, (Object)Arrays.toString(params));
            hasMethod = true;
        }
        return hasMethod;
    }

    private static boolean isInteractable(duv block) {
        boolean hasMethod;
        Class<?> clazz = block.getClass();
        boolean bl2 = hasMethod = CraftBlockType.hasMethod(clazz, USE_WITHOUT_ITEM_ARGS) || CraftBlockType.hasMethod(clazz, USE_ITEM_ON_ARGS);
        if (!hasMethod && clazz.getSuperclass() != ejl.class) {
            hasMethod = CraftBlockType.hasMethod(clazz = clazz.getSuperclass(), USE_WITHOUT_ITEM_ARGS) || CraftBlockType.hasMethod(clazz, USE_ITEM_ON_ARGS);
        }
        return hasMethod;
    }

    public CraftBlockType(NamespacedKey key, jk<duv> handle) {
        super(key, handle);
    }

    @NotNull
    public BlockType.Typed<BlockData> typed() {
        return this.typed(BlockData.class);
    }

    @NotNull
    public <Other extends BlockData> BlockType.Typed<Other> typed(@NotNull Class<Other> blockDataType) {
        if (blockDataType.isAssignableFrom(this.blockDataClass)) {
            return this;
        }
        throw new IllegalArgumentException("Cannot type block type " + String.valueOf(this.isRegistered() ? this.getKeyOrThrow() : this.toString()) + " to blockdata type " + blockDataType.getSimpleName());
    }

    public boolean hasItemType() {
        if (this == AIR) {
            return true;
        }
        return ((duv)this.getHandle()).h() != dht.a;
    }

    @NotNull
    public ItemType getItemType() {
        if (this == AIR) {
            return ItemType.AIR;
        }
        dhl item = ((duv)this.getHandle()).h();
        Preconditions.checkArgument((item != dht.a ? 1 : 0) != 0, (String)"The block type %s has no corresponding item type", (Object)(this.isRegistered() ? this.getKeyOrThrow() : this.toString()));
        return CraftItemType.minecraftToBukkitNew(item);
    }

    public Class<B> getBlockDataClass() {
        return this.blockDataClass;
    }

    public B createBlockData() {
        return this.createBlockData((String)null);
    }

    public B createBlockData(Consumer<? super B> consumer) {
        B data = this.createBlockData();
        if (consumer != null) {
            consumer.accept(data);
        }
        return data;
    }

    public B createBlockData(String data) {
        return (B)CraftBlockData.newData((BlockType)this, data);
    }

    public boolean isSolid() {
        return ((duv)this.getHandle()).m().d();
    }

    public boolean isAir() {
        return ((duv)this.getHandle()).m().l();
    }

    public boolean isEnabledByFeature(@NotNull World world) {
        Preconditions.checkNotNull((Object)world, (Object)"World cannot be null");
        return ((duv)this.getHandle()).a(((CraftWorld)world).getHandle().O());
    }

    public boolean isFlammable() {
        return ((duv)this.getHandle()).m().m();
    }

    public boolean isBurnable() {
        return ((dya)dux.cN).aa.getOrDefault(this.getHandle(), 0) > 0;
    }

    public boolean isOccluding() {
        return ((duv)this.getHandle()).m().d(drg.a, ja.c);
    }

    public boolean hasGravity() {
        return this.getHandle() instanceof dxv;
    }

    public boolean isInteractable() {
        return this.interactable;
    }

    public float getHardness() {
        return ((duv)this.getHandle()).m().p;
    }

    public float getBlastResistance() {
        return ((duv)this.getHandle()).e();
    }

    public float getSlipperiness() {
        return ((duv)this.getHandle()).g();
    }

    @NotNull
    public String getTranslationKey() {
        return ((duv)this.getHandle()).z();
    }

    public NamespacedKey getKey() {
        return this.getKeyOrThrow();
    }

    public Material asMaterial() {
        return (Material)Registry.MATERIAL.get(this.getKeyOrThrow());
    }
}

