/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R6.block.impl;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.MultipleFacing;
import org.bukkit.block.data.Waterlogged;
import org.bukkit.block.data.type.GlassPane;
import org.bukkit.craftbukkit.v1_21_R6.block.data.CraftBlockData;

public final class CraftStainedGlassPane
extends CraftBlockData
implements GlassPane,
MultipleFacing,
Waterlogged {
    private static final ekd[] FACES = new ekd[]{CraftStainedGlassPane.getBoolean(edd.class, "north", true), CraftStainedGlassPane.getBoolean(edd.class, "east", true), CraftStainedGlassPane.getBoolean(edd.class, "south", true), CraftStainedGlassPane.getBoolean(edd.class, "west", true), CraftStainedGlassPane.getBoolean(edd.class, "up", true), CraftStainedGlassPane.getBoolean(edd.class, "down", true)};
    private static final ekd WATERLOGGED = CraftStainedGlassPane.getBoolean(edd.class, "waterlogged");

    public CraftStainedGlassPane() {
    }

    public CraftStainedGlassPane(ejm state) {
        super(state);
    }

    public boolean hasFace(BlockFace face) {
        ekd state = FACES[face.ordinal()];
        if (state == null) {
            throw new IllegalArgumentException("Non-allowed face " + String.valueOf(face) + ". Check MultipleFacing.getAllowedFaces.");
        }
        return this.get(state);
    }

    public void setFace(BlockFace face, boolean has) {
        ekd state = FACES[face.ordinal()];
        if (state == null) {
            throw new IllegalArgumentException("Non-allowed face " + String.valueOf(face) + ". Check MultipleFacing.getAllowedFaces.");
        }
        this.set(state, has);
    }

    public Set<BlockFace> getFaces() {
        ImmutableSet.Builder faces = ImmutableSet.builder();
        for (int i2 = 0; i2 < FACES.length; ++i2) {
            if (FACES[i2] == null || !this.get(FACES[i2]).booleanValue()) continue;
            faces.add((Object)BlockFace.values()[i2]);
        }
        return faces.build();
    }

    public Set<BlockFace> getAllowedFaces() {
        ImmutableSet.Builder faces = ImmutableSet.builder();
        for (int i2 = 0; i2 < FACES.length; ++i2) {
            if (FACES[i2] == null) continue;
            faces.add((Object)BlockFace.values()[i2]);
        }
        return faces.build();
    }

    public boolean isWaterlogged() {
        return this.get(WATERLOGGED);
    }

    public void setWaterlogged(boolean waterlogged) {
        this.set(WATERLOGGED, waterlogged);
    }
}

