/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R6.entity;

import org.bukkit.craftbukkit.v1_21_R6.CraftEquipmentSlot;
import org.bukkit.craftbukkit.v1_21_R6.CraftServer;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftLivingEntity;
import org.bukkit.entity.ArmorStand;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.EulerAngle;

public class CraftArmorStand
extends CraftLivingEntity
implements ArmorStand {
    public CraftArmorStand(CraftServer server, cvf entity) {
        super(server, entity);
    }

    @Override
    public String toString() {
        return "CraftArmorStand";
    }

    @Override
    public cvf getHandle() {
        return (cvf)super.getHandle();
    }

    public ItemStack getItemInHand() {
        return this.getEquipment().getItemInHand();
    }

    public void setItemInHand(ItemStack item) {
        this.getEquipment().setItemInHand(item);
    }

    public ItemStack getBoots() {
        return this.getEquipment().getBoots();
    }

    public void setBoots(ItemStack item) {
        this.getEquipment().setBoots(item);
    }

    public ItemStack getLeggings() {
        return this.getEquipment().getLeggings();
    }

    public void setLeggings(ItemStack item) {
        this.getEquipment().setLeggings(item);
    }

    public ItemStack getChestplate() {
        return this.getEquipment().getChestplate();
    }

    public void setChestplate(ItemStack item) {
        this.getEquipment().setChestplate(item);
    }

    public ItemStack getHelmet() {
        return this.getEquipment().getHelmet();
    }

    public void setHelmet(ItemStack item) {
        this.getEquipment().setHelmet(item);
    }

    public EulerAngle getBodyPose() {
        return CraftArmorStand.fromNMS(this.getHandle().w());
    }

    public void setBodyPose(EulerAngle pose) {
        this.getHandle().b(CraftArmorStand.toNMS(pose));
    }

    public EulerAngle getLeftArmPose() {
        return CraftArmorStand.fromNMS(this.getHandle().x());
    }

    public void setLeftArmPose(EulerAngle pose) {
        this.getHandle().c(CraftArmorStand.toNMS(pose));
    }

    public EulerAngle getRightArmPose() {
        return CraftArmorStand.fromNMS(this.getHandle().z());
    }

    public void setRightArmPose(EulerAngle pose) {
        this.getHandle().d(CraftArmorStand.toNMS(pose));
    }

    public EulerAngle getLeftLegPose() {
        return CraftArmorStand.fromNMS(this.getHandle().A());
    }

    public void setLeftLegPose(EulerAngle pose) {
        this.getHandle().e(CraftArmorStand.toNMS(pose));
    }

    public EulerAngle getRightLegPose() {
        return CraftArmorStand.fromNMS(this.getHandle().B());
    }

    public void setRightLegPose(EulerAngle pose) {
        this.getHandle().f(CraftArmorStand.toNMS(pose));
    }

    public EulerAngle getHeadPose() {
        return CraftArmorStand.fromNMS(this.getHandle().v());
    }

    public void setHeadPose(EulerAngle pose) {
        this.getHandle().a(CraftArmorStand.toNMS(pose));
    }

    public boolean hasBasePlate() {
        return this.getHandle().p();
    }

    public void setBasePlate(boolean basePlate) {
        this.getHandle().b(!basePlate);
    }

    @Override
    public void setGravity(boolean gravity) {
        super.setGravity(gravity);
        this.getHandle().ar = !gravity;
    }

    public boolean isVisible() {
        return !this.getHandle().cB();
    }

    public void setVisible(boolean visible) {
        this.getHandle().l(!visible);
    }

    public boolean hasArms() {
        return this.getHandle().n();
    }

    public void setArms(boolean arms) {
        this.getHandle().a(arms);
    }

    public boolean isSmall() {
        return this.getHandle().m();
    }

    public void setSmall(boolean small) {
        this.getHandle().u(small);
    }

    private static EulerAngle fromNMS(kc old) {
        return new EulerAngle(Math.toRadians(old.a()), Math.toRadians(old.b()), Math.toRadians(old.c()));
    }

    private static kc toNMS(EulerAngle old) {
        return new kc((float)Math.toDegrees(old.getX()), (float)Math.toDegrees(old.getY()), (float)Math.toDegrees(old.getZ()));
    }

    public boolean isMarker() {
        return this.getHandle().s();
    }

    public void setMarker(boolean marker) {
        this.getHandle().v(marker);
    }

    public void addEquipmentLock(EquipmentSlot equipmentSlot, ArmorStand.LockType lockType) {
        this.getHandle().cq |= 1 << CraftEquipmentSlot.getNMS(equipmentSlot).b(lockType.ordinal() * 8);
    }

    public void removeEquipmentLock(EquipmentSlot equipmentSlot, ArmorStand.LockType lockType) {
        this.getHandle().cq &= ~(1 << CraftEquipmentSlot.getNMS(equipmentSlot).b(lockType.ordinal() * 8));
    }

    public boolean hasEquipmentLock(EquipmentSlot equipmentSlot, ArmorStand.LockType lockType) {
        return (this.getHandle().cq & 1 << CraftEquipmentSlot.getNMS(equipmentSlot).b(lockType.ordinal() * 8)) != 0;
    }
}

