/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R6.entity;

import com.google.common.base.Preconditions;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_21_R6.CraftServer;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftLocation;
import org.bukkit.entity.EnderSignal;
import org.bukkit.inventory.ItemStack;

public class CraftEnderSignal
extends CraftEntity
implements EnderSignal {
    public CraftEnderSignal(CraftServer server, dab entity) {
        super(server, entity);
    }

    @Override
    public dab getHandle() {
        return (dab)this.entity;
    }

    @Override
    public String toString() {
        return "CraftEnderSignal";
    }

    public Location getTargetLocation() {
        return CraftLocation.toBukkit(this.getHandle().e, this.getWorld(), this.getHandle().dX(), this.getHandle().dZ());
    }

    public void setTargetLocation(Location location) {
        Preconditions.checkArgument((boolean)this.getWorld().equals((Object)location.getWorld()), (Object)"Cannot target EnderSignal across worlds");
        this.getHandle().a(CraftLocation.toVec3D(location));
    }

    public boolean getDropItem() {
        return this.getHandle().g;
    }

    public void setDropItem(boolean shouldDropItem) {
        this.getHandle().g = shouldDropItem;
    }

    public ItemStack getItem() {
        return CraftItemStack.asBukkitCopy(this.getHandle().e());
    }

    public void setItem(ItemStack item) {
        this.getHandle().a(item != null ? CraftItemStack.asNMSCopy(item) : dht.uw.m());
    }

    public int getDespawnTimer() {
        return this.getHandle().f;
    }

    public void setDespawnTimer(int time) {
        this.getHandle().f = time;
    }
}

