/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R6.entity;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.BaseEncoding;
import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Pair;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.shorts.ShortArraySet;
import it.unimi.dsi.fastutil.shorts.ShortSet;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.bukkit.BanEntry;
import org.bukkit.BanList;
import org.bukkit.Bukkit;
import org.bukkit.DyeColor;
import org.bukkit.Effect;
import org.bukkit.GameMode;
import org.bukkit.Input;
import org.bukkit.Instrument;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Note;
import org.bukkit.OfflinePlayer;
import org.bukkit.Particle;
import org.bukkit.ServerLinks;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.Statistic;
import org.bukkit.WeatherType;
import org.bukkit.World;
import org.bukkit.WorldBorder;
import org.bukkit.advancement.Advancement;
import org.bukkit.advancement.AdvancementProgress;
import org.bukkit.ban.IpBanList;
import org.bukkit.ban.ProfileBanList;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.block.TileState;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.sign.Side;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.serialization.DelegateDeserialization;
import org.bukkit.conversations.Conversation;
import org.bukkit.conversations.ConversationAbandonedEvent;
import org.bukkit.conversations.ConversationCanceller;
import org.bukkit.conversations.ManuallyAbandonedConversationCanceller;
import org.bukkit.craftbukkit.v1_21_R6.CraftEffect;
import org.bukkit.craftbukkit.v1_21_R6.CraftEquipmentSlot;
import org.bukkit.craftbukkit.v1_21_R6.CraftInput;
import org.bukkit.craftbukkit.v1_21_R6.CraftOfflinePlayer;
import org.bukkit.craftbukkit.v1_21_R6.CraftParticle;
import org.bukkit.craftbukkit.v1_21_R6.CraftServer;
import org.bukkit.craftbukkit.v1_21_R6.CraftServerLinks;
import org.bukkit.craftbukkit.v1_21_R6.CraftSound;
import org.bukkit.craftbukkit.v1_21_R6.CraftStatistic;
import org.bukkit.craftbukkit.v1_21_R6.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R6.CraftWorldBorder;
import org.bukkit.craftbukkit.v1_21_R6.advancement.CraftAdvancement;
import org.bukkit.craftbukkit.v1_21_R6.advancement.CraftAdvancementProgress;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftSign;
import org.bukkit.craftbukkit.v1_21_R6.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_21_R6.conversations.ConversationTracker;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftRecipe;
import org.bukkit.craftbukkit.v1_21_R6.map.CraftMapCursor;
import org.bukkit.craftbukkit.v1_21_R6.map.CraftMapView;
import org.bukkit.craftbukkit.v1_21_R6.map.RenderData;
import org.bukkit.craftbukkit.v1_21_R6.potion.CraftPotionEffectType;
import org.bukkit.craftbukkit.v1_21_R6.potion.CraftPotionUtil;
import org.bukkit.craftbukkit.v1_21_R6.profile.CraftPlayerProfile;
import org.bukkit.craftbukkit.v1_21_R6.scoreboard.CraftScoreboard;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftChatMessage;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftLocation;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftMagicNumbers;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftNamespacedKey;
import org.bukkit.entity.EnderPearl;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerExpCooldownChangeEvent;
import org.bukkit.event.player.PlayerHideEntityEvent;
import org.bukkit.event.player.PlayerRegisterChannelEvent;
import org.bukkit.event.player.PlayerShowEntityEvent;
import org.bukkit.event.player.PlayerSpawnChangeEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.player.PlayerUnregisterChannelEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.map.MapCursor;
import org.bukkit.map.MapView;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.messaging.Messenger;
import org.bukkit.plugin.messaging.StandardMessenger;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.profile.PlayerProfile;
import org.bukkit.scoreboard.Scoreboard;
import org.jetbrains.annotations.NotNull;

@DelegateDeserialization(value=CraftOfflinePlayer.class)
public class CraftPlayer
extends CraftHumanEntity
implements Player {
    private long firstPlayed = 0L;
    private long lastPlayed = 0L;
    private String lastKnownName;
    private boolean hasPlayedBefore = false;
    private final ConversationTracker conversationTracker = new ConversationTracker();
    private final Set<String> channels = new HashSet<String>();
    private final Map<UUID, Set<WeakReference<Plugin>>> invertedVisibilityEntities = new HashMap<UUID, Set<WeakReference<Plugin>>>();
    private static final WeakHashMap<Plugin, WeakReference<Plugin>> pluginWeakReferences = new WeakHashMap();
    private int hash = 0;
    private double health = 20.0;
    private boolean scaledHealth = false;
    private double healthScale = 20.0;
    private CraftWorldBorder clientWorldBorder = null;
    private eld clientWorldBorderListener = this.createWorldBorderListener();
    private final Queue<CookieFuture> requestedCookies = new LinkedList<CookieFuture>();
    private xx playerListHeader;
    private xx playerListFooter;

    public CraftPlayer(CraftServer server, awy entity) {
        super(server, entity);
        this.firstPlayed = System.currentTimeMillis();
    }

    public GameProfile getProfile() {
        return this.getHandle().gz();
    }

    private bbb nameAndId() {
        return this.getHandle().gA();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException(String.format("Cannot remove player %s, use Player#kickPlayer(String) instead.", this.getName()));
    }

    @Override
    public boolean isOp() {
        return this.server.getHandle().f(this.nameAndId());
    }

    @Override
    public void setOp(boolean value) {
        if (value == this.isOp()) {
            return;
        }
        if (value) {
            this.server.getHandle().d(this.nameAndId());
        } else {
            this.server.getHandle().e(this.nameAndId());
        }
        this.perm.recalculatePermissions();
    }

    public boolean isOnline() {
        return this.server.getPlayer(this.getUniqueId()) != null;
    }

    public PlayerProfile getPlayerProfile() {
        return new CraftPlayerProfile(this.nameAndId());
    }

    public InetSocketAddress getAddress() {
        if (this.getHandle().g.b() == null) {
            return null;
        }
        SocketAddress addr = this.getHandle().g.m();
        if (addr instanceof InetSocketAddress) {
            return (InetSocketAddress)addr;
        }
        return null;
    }

    public boolean isAwaitingCookies() {
        return !this.requestedCookies.isEmpty();
    }

    public boolean handleCookieResponse(acp response) {
        CookieFuture future = this.requestedCookies.peek();
        if (future != null && future.key.equals(response.b())) {
            Preconditions.checkState((future == this.requestedCookies.poll() ? 1 : 0) != 0, (Object)"requestedCookies queue mismatch");
            future.future().complete(response.e());
            return true;
        }
        return false;
    }

    public boolean isTransferred() {
        return this.getHandle().transferCookieConnection.isTransferred();
    }

    public CompletableFuture<byte[]> retrieveCookie(NamespacedKey key) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"Cookie key cannot be null");
        CompletableFuture<byte[]> future = new CompletableFuture<byte[]>();
        amj nms = CraftNamespacedKey.toMinecraft(key);
        this.requestedCookies.add(new CookieFuture(nms, future));
        this.getHandle().transferCookieConnection.sendPacket(new acm(nms));
        return future;
    }

    public void storeCookie(NamespacedKey key, byte[] value) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"Cookie key cannot be null");
        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (Object)"Cookie value cannot be null");
        Preconditions.checkArgument((value.length <= 5120 ? 1 : 0) != 0, (Object)"Cookie value too large, must be smaller than 5120 bytes");
        Preconditions.checkState((this.getHandle().transferCookieConnection.getProtocol() == wl.e || this.getHandle().transferCookieConnection.getProtocol() == wl.b ? 1 : 0) != 0, (Object)"Can only store cookie in CONFIGURATION or PLAY protocol.");
        this.getHandle().transferCookieConnection.sendPacket(new abh(CraftNamespacedKey.toMinecraft(key), value));
    }

    public void transfer(String host, int port) {
        Preconditions.checkArgument((host != null ? 1 : 0) != 0, (Object)"Host cannot be null");
        Preconditions.checkState((this.getHandle().transferCookieConnection.getProtocol() == wl.e || this.getHandle().transferCookieConnection.getProtocol() == wl.b ? 1 : 0) != 0, (Object)"Can only transfer in CONFIGURATION or PLAY protocol.");
        this.getHandle().transferCookieConnection.sendPacket(new abi(host, port));
    }

    @Override
    public double getEyeHeight(boolean ignorePose) {
        if (ignorePose) {
            return 1.62;
        }
        return this.getEyeHeight();
    }

    public void sendRawMessage(String message) {
        this.sendRawMessage(null, message);
    }

    public void sendRawMessage(UUID sender, String message) {
        Preconditions.checkArgument((message != null ? 1 : 0) != 0, (Object)"message cannot be null");
        if (this.getHandle().g == null) {
            return;
        }
        for (xx component : CraftChatMessage.fromString(message)) {
            this.getHandle().a(component);
        }
    }

    @Override
    public void sendMessage(String message) {
        if (!this.conversationTracker.isConversingModaly()) {
            this.sendRawMessage(message);
        }
    }

    @Override
    public void sendMessage(String ... messages) {
        for (String message : messages) {
            this.sendMessage(message);
        }
    }

    @Override
    public void sendMessage(UUID sender, String message) {
        if (!this.conversationTracker.isConversingModaly()) {
            this.sendRawMessage(sender, message);
        }
    }

    @Override
    public void sendMessage(UUID sender, String ... messages) {
        for (String message : messages) {
            this.sendMessage(sender, message);
        }
    }

    public String getDisplayName() {
        return this.getHandle().displayName;
    }

    public void setDisplayName(String name) {
        this.getHandle().displayName = name == null ? this.getName() : name;
    }

    public String getPlayerListName() {
        return this.getHandle().listName == null ? this.getName() : CraftChatMessage.fromComponent(this.getHandle().listName);
    }

    public void setPlayerListName(String name) {
        if (name == null) {
            name = this.getName();
        }
        this.getHandle().listName = name.equals(this.getName()) ? null : CraftChatMessage.fromStringOrNull(name);
        for (awy player : this.server.getHandle().k) {
            if (!player.getBukkitEntity().canSee(this)) continue;
            player.g.b(new afd(afd.a.f, this.getHandle()));
        }
    }

    public int getPlayerListOrder() {
        return this.getHandle().listOrder;
    }

    public void setPlayerListOrder(int order) {
        Preconditions.checkArgument((order >= 0 ? 1 : 0) != 0, (Object)"order cannot be negative");
        this.getHandle().listOrder = order;
    }

    public String getPlayerListHeader() {
        return this.playerListHeader == null ? null : CraftChatMessage.fromComponent(this.playerListHeader);
    }

    public String getPlayerListFooter() {
        return this.playerListFooter == null ? null : CraftChatMessage.fromComponent(this.playerListFooter);
    }

    public void setPlayerListHeader(String header) {
        this.playerListHeader = CraftChatMessage.fromStringOrNull(header, true);
        this.updatePlayerListHeaderFooter();
    }

    public void setPlayerListFooter(String footer) {
        this.playerListFooter = CraftChatMessage.fromStringOrNull(footer, true);
        this.updatePlayerListHeaderFooter();
    }

    public void setPlayerListHeaderFooter(String header, String footer) {
        this.playerListHeader = CraftChatMessage.fromStringOrNull(header, true);
        this.playerListFooter = CraftChatMessage.fromStringOrNull(footer, true);
        this.updatePlayerListHeaderFooter();
    }

    private void updatePlayerListHeaderFooter() {
        if (this.getHandle().g == null) {
            return;
        }
        ahb packet = new ahb(this.playerListHeader == null ? xx.i() : this.playerListHeader, this.playerListFooter == null ? xx.i() : this.playerListFooter);
        this.getHandle().g.b(packet);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof OfflinePlayer)) {
            return false;
        }
        OfflinePlayer other = (OfflinePlayer)obj;
        if (this.getUniqueId() == null || other.getUniqueId() == null) {
            return false;
        }
        boolean uuidEquals = this.getUniqueId().equals(other.getUniqueId());
        boolean idEquals = true;
        if (other instanceof CraftPlayer) {
            idEquals = this.getEntityId() == ((CraftPlayer)other).getEntityId();
        }
        return uuidEquals && idEquals;
    }

    public void kickPlayer(String message) {
        this.getHandle().transferCookieConnection.kickPlayer(CraftChatMessage.fromStringOrEmpty(message, true));
    }

    public void setCompassTarget(Location loc) {
        Preconditions.checkArgument((loc != null ? 1 : 0) != 0, (Object)"Location cannot be null");
        if (this.getHandle().g == null) {
            return;
        }
        this.getHandle().g.b(new agd(fid.a.a(((CraftWorld)loc.getWorld()).getHandle().al(), CraftLocation.toBlockPosition(loc), loc.getYaw(), loc.getPitch())));
    }

    public Location getCompassTarget() {
        return this.getHandle().compassTarget;
    }

    public void chat(String msg) {
        Preconditions.checkArgument((msg != null ? 1 : 0) != 0, (Object)"msg cannot be null");
        if (this.getHandle().g == null) {
            return;
        }
        this.getHandle().g.chat(msg, yo.a(msg), false);
    }

    public boolean performCommand(String command) {
        Preconditions.checkArgument((command != null ? 1 : 0) != 0, (Object)"command cannot be null");
        return this.server.dispatchCommand((CommandSender)this, command);
    }

    public void playNote(Location loc, byte instrument, byte note) {
        this.playNote(loc, Instrument.getByType((byte)instrument), new Note((int)note));
    }

    public void playNote(Location loc, Instrument instrument, Note note) {
        Preconditions.checkArgument((loc != null ? 1 : 0) != 0, (Object)"Location cannot be null");
        Preconditions.checkArgument((instrument != null ? 1 : 0) != 0, (Object)"Instrument cannot be null");
        Preconditions.checkArgument((note != null ? 1 : 0) != 0, (Object)"Note cannot be null");
        if (this.getHandle().g == null) {
            return;
        }
        Sound instrumentSound = instrument.getSound();
        if (instrumentSound == null) {
            return;
        }
        float pitch = note.getPitch();
        this.getHandle().g.b(new agx(CraftSound.bukkitToMinecraftHolder(instrumentSound), bcf.c, loc.getBlockX(), loc.getBlockY(), loc.getBlockZ(), 3.0f, pitch, this.getHandle().ek().g()));
    }

    public void playSound(Location loc, Sound sound, float volume, float pitch) {
        this.playSound(loc, sound, SoundCategory.MASTER, volume, pitch);
    }

    public void playSound(Location loc, String sound, float volume, float pitch) {
        this.playSound(loc, sound, SoundCategory.MASTER, volume, pitch);
    }

    public void playSound(Location loc, Sound sound, SoundCategory category, float volume, float pitch) {
        this.playSound(loc, sound, category, volume, pitch, this.getHandle().as.g());
    }

    public void playSound(Location loc, String sound, SoundCategory category, float volume, float pitch) {
        this.playSound(loc, sound, category, volume, pitch, this.getHandle().as.g());
    }

    public void playSound(Location loc, Sound sound, SoundCategory category, float volume, float pitch, long seed) {
        if (loc == null || sound == null || category == null || this.getHandle().g == null) {
            return;
        }
        this.playSound0(loc, CraftSound.bukkitToMinecraftHolder(sound), bcf.valueOf(category.name()), volume, pitch, seed);
    }

    public void playSound(Location loc, String sound, SoundCategory category, float volume, float pitch, long seed) {
        if (loc == null || sound == null || category == null || this.getHandle().g == null) {
            return;
        }
        this.playSound0(loc, jk.a(bcd.a(amj.a(sound))), bcf.valueOf(category.name()), volume, pitch, seed);
    }

    private void playSound0(Location loc, jk<bcd> soundEffectHolder, bcf categoryNMS, float volume, float pitch, long seed) {
        Preconditions.checkArgument((loc != null ? 1 : 0) != 0, (Object)"Location cannot be null");
        if (this.getHandle().g == null) {
            return;
        }
        agx packet = new agx(soundEffectHolder, categoryNMS, loc.getX(), loc.getY(), loc.getZ(), volume, pitch, seed);
        this.getHandle().g.b(packet);
    }

    public void playSound(Entity entity, Sound sound, float volume, float pitch) {
        this.playSound(entity, sound, SoundCategory.MASTER, volume, pitch);
    }

    public void playSound(Entity entity, String sound, float volume, float pitch) {
        this.playSound(entity, sound, SoundCategory.MASTER, volume, pitch);
    }

    public void playSound(Entity entity, Sound sound, SoundCategory category, float volume, float pitch) {
        this.playSound(entity, sound, category, volume, pitch, this.getHandle().as.g());
    }

    public void playSound(Entity entity, String sound, SoundCategory category, float volume, float pitch) {
        this.playSound(entity, sound, category, volume, pitch, this.getHandle().as.g());
    }

    public void playSound(Entity entity, Sound sound, SoundCategory category, float volume, float pitch, long seed) {
        block3: {
            block2: {
                if (!(entity instanceof CraftEntity)) break block2;
                CraftEntity craftEntity = (CraftEntity)entity;
                if (sound != null && category != null && this.getHandle().g != null) break block3;
            }
            return;
        }
        this.playSound0(entity, CraftSound.bukkitToMinecraftHolder(sound), bcf.valueOf(category.name()), volume, pitch, seed);
    }

    public void playSound(Entity entity, String sound, SoundCategory category, float volume, float pitch, long seed) {
        block3: {
            block2: {
                if (!(entity instanceof CraftEntity)) break block2;
                CraftEntity craftEntity = (CraftEntity)entity;
                if (sound != null && category != null && this.getHandle().g != null) break block3;
            }
            return;
        }
        this.playSound0(entity, jk.a(bcd.a(amj.a(sound))), bcf.valueOf(category.name()), volume, pitch, seed);
    }

    private void playSound0(Entity entity, jk<bcd> soundEffectHolder, bcf categoryNMS, float volume, float pitch, long seed) {
        Preconditions.checkArgument((entity != null ? 1 : 0) != 0, (Object)"Entity cannot be null");
        Preconditions.checkArgument((soundEffectHolder != null ? 1 : 0) != 0, (Object)"Holder of SoundEffect cannot be null");
        Preconditions.checkArgument((categoryNMS != null ? 1 : 0) != 0, (Object)"SoundCategory cannot be null");
        if (this.getHandle().g == null) {
            return;
        }
        if (!(entity instanceof CraftEntity)) {
            return;
        }
        CraftEntity craftEntity = (CraftEntity)entity;
        agw packet = new agw(soundEffectHolder, categoryNMS, craftEntity.getHandle(), volume, pitch, seed);
        this.getHandle().g.b(packet);
    }

    public void stopSound(Sound sound) {
        this.stopSound(sound, null);
    }

    public void stopSound(String sound) {
        this.stopSound(sound, null);
    }

    public void stopSound(Sound sound, SoundCategory category) {
        this.stopSound(sound.getKey().getKey(), category);
    }

    public void stopSound(String sound, SoundCategory category) {
        if (this.getHandle().g == null) {
            return;
        }
        this.getHandle().g.b(new agz(amj.a(sound), category == null ? bcf.a : bcf.valueOf(category.name())));
    }

    public void stopSound(SoundCategory category) {
        if (this.getHandle().g == null) {
            return;
        }
        this.getHandle().g.b(new agz(null, bcf.valueOf(category.name())));
    }

    public void stopAllSounds() {
        if (this.getHandle().g == null) {
            return;
        }
        this.getHandle().g.b(new agz(null, null));
    }

    public void playEffect(Location loc, Effect effect, int data) {
        Preconditions.checkArgument((effect != null ? 1 : 0) != 0, (Object)"Effect cannot be null");
        Preconditions.checkArgument((loc != null ? 1 : 0) != 0, (Object)"Location cannot be null");
        if (this.getHandle().g == null) {
            return;
        }
        int packetData = effect.getId();
        aej packet = new aej(packetData, CraftLocation.toBlockPosition(loc), data, false);
        this.getHandle().g.b(packet);
    }

    public <T> void playEffect(Location loc, Effect effect, T data) {
        Preconditions.checkArgument((effect != null ? 1 : 0) != 0, (Object)"Effect cannot be null");
        if (data != null) {
            Preconditions.checkArgument((effect.getData() != null ? 1 : 0) != 0, (String)"Effect.%s does not have a valid Data", (Object)effect);
            Preconditions.checkArgument((boolean)effect.getData().isAssignableFrom(data.getClass()), (String)"%s data cannot be used for the %s effect", (Object)data.getClass().getName(), (Object)effect);
        } else {
            Preconditions.checkArgument((effect.getData() == null || effect == Effect.ELECTRIC_SPARK ? 1 : 0) != 0, (String)"Wrong kind of data for the %s effect", (Object)effect);
        }
        int datavalue = CraftEffect.getDataValue(effect, data);
        this.playEffect(loc, effect, datavalue);
    }

    public boolean breakBlock(Block block) {
        Preconditions.checkArgument((block != null ? 1 : 0) != 0, (Object)"Block cannot be null");
        Preconditions.checkArgument((boolean)block.getWorld().equals((Object)this.getWorld()), (Object)"Cannot break blocks across worlds");
        return this.getHandle().h.a(new ja(block.getX(), block.getY(), block.getZ()));
    }

    public void sendBlockChange(Location loc, Material material, byte data) {
        if (this.getHandle().g == null) {
            return;
        }
        acz packet = new acz(CraftLocation.toBlockPosition(loc), CraftMagicNumbers.getBlock(material, data));
        this.getHandle().g.b(packet);
    }

    public void sendBlockChange(Location loc, BlockData block) {
        if (this.getHandle().g == null) {
            return;
        }
        acz packet = new acz(CraftLocation.toBlockPosition(loc), ((CraftBlockData)block).getState());
        this.getHandle().g.b(packet);
    }

    public void sendBlockChanges(Collection<BlockState> blocks) {
        Preconditions.checkArgument((blocks != null ? 1 : 0) != 0, (Object)"blocks must not be null");
        if (this.getHandle().g == null || blocks.isEmpty()) {
            return;
        }
        HashMap<kd, ChunkSectionChanges> changes = new HashMap<kd, ChunkSectionChanges>();
        for (BlockState blockState : blocks) {
            CraftBlockState cstate = (CraftBlockState)blockState;
            ja blockPosition = cstate.getPosition();
            kd sectionPosition = kd.a(blockPosition);
            ChunkSectionChanges sectionChanges = changes.computeIfAbsent(sectionPosition, ignore -> new ChunkSectionChanges());
            sectionChanges.positions().add(kd.b(blockPosition));
            sectionChanges.blockData().add(cstate.getHandle());
        }
        for (Map.Entry entry : changes.entrySet()) {
            ChunkSectionChanges chunkChanges = (ChunkSectionChanges)entry.getValue();
            afq packet = new afq((kd)entry.getKey(), chunkChanges.positions(), (ejm[])chunkChanges.blockData().toArray(ejm[]::new));
            this.getHandle().g.b(packet);
        }
    }

    public void sendBlockChanges(Collection<BlockState> blocks, boolean suppressLightUpdates) {
        this.sendBlockChanges(blocks);
    }

    public void sendBlockDamage(Location loc, float progress) {
        this.sendBlockDamage(loc, progress, this.getEntityId());
    }

    public void sendBlockDamage(Location loc, float progress, Entity source) {
        Preconditions.checkArgument((source != null ? 1 : 0) != 0, (Object)"source must not be null");
        this.sendBlockDamage(loc, progress, source.getEntityId());
    }

    public void sendBlockDamage(Location loc, float progress, int sourceId) {
        Preconditions.checkArgument((loc != null ? 1 : 0) != 0, (Object)"loc must not be null");
        Preconditions.checkArgument(((double)progress >= 0.0 && (double)progress <= 1.0 ? 1 : 0) != 0, (Object)"progress must be between 0.0 and 1.0 (inclusive)");
        if (this.getHandle().g == null) {
            return;
        }
        int stage = (int)(9.0f * progress);
        if (progress == 0.0f) {
            stage = -1;
        }
        acw packet = new acw(sourceId, CraftLocation.toBlockPosition(loc), stage);
        this.getHandle().g.b(packet);
    }

    public void sendSignChange(Location loc, String[] lines) {
        this.sendSignChange(loc, lines, DyeColor.BLACK);
    }

    public void sendSignChange(Location loc, String[] lines, DyeColor dyeColor) {
        this.sendSignChange(loc, lines, dyeColor, false);
    }

    public void sendSignChange(Location loc, String[] lines, DyeColor dyeColor, boolean hasGlowingText) {
        Preconditions.checkArgument((loc != null ? 1 : 0) != 0, (Object)"Location cannot be null");
        Preconditions.checkArgument((dyeColor != null ? 1 : 0) != 0, (Object)"DyeColor cannot be null");
        if (lines == null) {
            lines = new String[4];
        }
        Preconditions.checkArgument((lines.length >= 4 ? 1 : 0) != 0, (String)"Must have at least 4 lines (%s)", (int)lines.length);
        if (this.getHandle().g == null) {
            return;
        }
        xx[] components = CraftSign.sanitizeLines(lines);
        ehx sign = new ehx(CraftLocation.toBlockPosition(loc), dux.db.m());
        ehy text = sign.h();
        text = text.a(dgn.a(dyeColor.getWoolData()));
        text = text.a(hasGlowingText);
        for (int i2 = 0; i2 < components.length; ++i2) {
            text = text.a(i2, components[i2]);
        }
        sign.a(text, true);
        this.getHandle().g.b(new acx(sign.aD_(), sign.s(), sign.a(this.getHandle().ej())));
    }

    public void sendBlockUpdate(@NotNull Location location, @NotNull TileState tileState) throws IllegalArgumentException {
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"Location can not be null");
        Preconditions.checkArgument((tileState != null ? 1 : 0) != 0, (Object)"TileState can not be null");
        if (this.getHandle().g == null) {
            return;
        }
        CraftBlockEntityState craftState = (CraftBlockEntityState)tileState;
        this.getHandle().g.b(craftState.getUpdatePacket(location));
    }

    public void sendEquipmentChange(LivingEntity entity, EquipmentSlot slot, ItemStack item) {
        this.sendEquipmentChange(entity, Map.of(slot, item));
    }

    public void sendEquipmentChange(LivingEntity entity, Map<EquipmentSlot, ItemStack> items) {
        Preconditions.checkArgument((entity != null ? 1 : 0) != 0, (Object)"Entity cannot be null");
        Preconditions.checkArgument((items != null ? 1 : 0) != 0, (Object)"items cannot be null");
        if (this.getHandle().g == null) {
            return;
        }
        ArrayList<Pair<cef, dhp>> equipment = new ArrayList<Pair<cef, dhp>>(items.size());
        for (Map.Entry<EquipmentSlot, ItemStack> entry : items.entrySet()) {
            EquipmentSlot slot = entry.getKey();
            Preconditions.checkArgument((slot != null ? 1 : 0) != 0, (Object)"Cannot set null EquipmentSlot");
            equipment.add((Pair<cef, dhp>)new Pair((Object)CraftEquipmentSlot.getNMS(slot), (Object)CraftItemStack.asNMSCopy(entry.getValue())));
        }
        this.getHandle().g.b(new agi(entity.getEntityId(), equipment));
    }

    public void sendPotionEffectChange(LivingEntity entity, PotionEffect effect) {
        Preconditions.checkArgument((entity != null ? 1 : 0) != 0, (Object)"Entity cannot be null");
        Preconditions.checkArgument((effect != null ? 1 : 0) != 0, (Object)"Effect cannot be null");
        if (this.getHandle().g == null) {
            return;
        }
        this.getHandle().g.b(new ahl(entity.getEntityId(), CraftPotionUtil.fromBukkit(effect), true));
    }

    public void sendPotionEffectChangeRemove(LivingEntity entity, PotionEffectType type) {
        Preconditions.checkArgument((entity != null ? 1 : 0) != 0, (Object)"Entity cannot be null");
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"Type cannot be null");
        if (this.getHandle().g == null) {
            return;
        }
        this.getHandle().g.b(new afm(entity.getEntityId(), CraftPotionEffectType.bukkitToMinecraftHolder(type)));
    }

    public WorldBorder getWorldBorder() {
        return this.clientWorldBorder;
    }

    public void setWorldBorder(WorldBorder border) {
        elf newWorldBorder;
        CraftWorldBorder craftBorder = (CraftWorldBorder)border;
        if (border != null && !craftBorder.isVirtual() && !craftBorder.getWorld().equals((Object)this.getWorld())) {
            throw new UnsupportedOperationException("Cannot set player world border to that of another world");
        }
        if (this.clientWorldBorder != null) {
            this.clientWorldBorder.getHandle().b(this.clientWorldBorderListener);
        }
        if (craftBorder == null || !craftBorder.isVirtual()) {
            this.clientWorldBorder = null;
            newWorldBorder = ((CraftWorldBorder)this.getWorld().getWorldBorder()).getHandle();
        } else {
            this.clientWorldBorder = craftBorder;
            this.clientWorldBorder.getHandle().a(this.clientWorldBorderListener);
            newWorldBorder = this.clientWorldBorder.getHandle();
        }
        axz connection = this.getHandle().g;
        connection.b(new afw(newWorldBorder));
        connection.b(new afv(newWorldBorder));
        connection.b(new afu(newWorldBorder));
        connection.b(new afx(newWorldBorder));
        connection.b(new afy(newWorldBorder));
    }

    private eld createWorldBorderListener() {
        return new eld(){

            @Override
            public void a(elf border, double size) {
                CraftPlayer.this.getHandle().g.b(new afw(border));
            }

            @Override
            public void a(elf border, double size, double newSize, long time) {
                CraftPlayer.this.getHandle().g.b(new afv(border));
            }

            @Override
            public void a(elf border, double x2, double z2) {
                CraftPlayer.this.getHandle().g.b(new afu(border));
            }

            @Override
            public void a(elf border, int warningTime) {
                CraftPlayer.this.getHandle().g.b(new afx(border));
            }

            @Override
            public void b(elf border, int warningBlocks) {
                CraftPlayer.this.getHandle().g.b(new afy(border));
            }

            @Override
            public void b(elf border, double damage) {
            }

            @Override
            public void c(elf border, double blocks) {
            }
        };
    }

    public boolean hasClientWorldBorder() {
        return this.clientWorldBorder != null;
    }

    public void sendMap(MapView map) {
        if (this.getHandle().g == null) {
            return;
        }
        RenderData data = ((CraftMapView)map).render(this);
        ArrayList<fhp> icons = new ArrayList<fhp>();
        for (MapCursor cursor : data.cursors) {
            if (!cursor.isVisible()) continue;
            icons.add(new fhp(CraftMapCursor.CraftType.bukkitToMinecraftHolder(cursor.getType()), cursor.getX(), cursor.getY(), cursor.getDirection(), CraftChatMessage.fromStringOrOptional(cursor.getCaption())));
        }
        aeo packet = new aeo(new fht(map.getId()), map.getScale().getValue(), map.isLocked(), icons, new fhv.c(0, 0, 128, 128, data.buffer));
        this.getHandle().g.b(packet);
    }

    public void sendHurtAnimation(float yaw) {
        if (this.getHandle().g == null) {
            return;
        }
        float actualYaw = yaw + 90.0f;
        this.getHandle().g.b(new aef(this.getEntityId(), actualYaw));
    }

    public void sendLinks(ServerLinks links) {
        if (this.getHandle().g == null) {
            return;
        }
        Preconditions.checkArgument((links != null ? 1 : 0) != 0, (Object)"links cannot be null");
        anb nms = ((CraftServerLinks)links).getServerLinks();
        this.getHandle().g.b(new abf(nms.b()));
    }

    public void addCustomChatCompletions(Collection<String> completions) {
        this.sendCustomChatCompletionPacket(completions, adp.a.a);
    }

    public void removeCustomChatCompletions(Collection<String> completions) {
        this.sendCustomChatCompletionPacket(completions, adp.a.b);
    }

    public void setCustomChatCompletions(Collection<String> completions) {
        this.sendCustomChatCompletionPacket(completions, adp.a.c);
    }

    private void sendCustomChatCompletionPacket(Collection<String> completions, adp.a action) {
        if (this.getHandle().g == null) {
            return;
        }
        adp packet = new adp(action, new ArrayList<String>(completions));
        this.getHandle().g.b(packet);
    }

    @Override
    public void setRotation(float yaw, float pitch) {
        throw new UnsupportedOperationException("Cannot set rotation of players. Consider teleporting instead.");
    }

    @Override
    public boolean teleport(Location location, PlayerTeleportEvent.TeleportCause cause) {
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"location");
        Preconditions.checkArgument((location.getWorld() != null ? 1 : 0) != 0, (Object)"location.world");
        location.checkFinite();
        awy entity = this.getHandle();
        if (this.getHealth() == 0.0 || entity.ec()) {
            return false;
        }
        if (entity.g == null) {
            return false;
        }
        if (entity.cm()) {
            return false;
        }
        Location from = this.getLocation();
        Location to2 = location;
        PlayerTeleportEvent event = new PlayerTeleportEvent((Player)this, from, to2, cause);
        this.server.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return false;
        }
        entity.cb();
        if (this.isSleeping()) {
            this.wakeup(false);
        }
        from = event.getFrom();
        to2 = event.getTo();
        awx fromWorld = ((CraftWorld)from.getWorld()).getHandle();
        awx toWorld = ((CraftWorld)to2.getWorld()).getHandle();
        if (this.getHandle().cl != this.getHandle().ck) {
            this.getHandle().r();
        }
        if (fromWorld == toWorld) {
            entity.g.teleport(to2);
        } else {
            entity.aG = null;
            this.server.getHandle().respawn(entity, true, cdv.e.e, null, to2);
        }
        return true;
    }

    public void setSneaking(boolean sneak) {
        this.getHandle().h(sneak);
    }

    public boolean isSneaking() {
        return this.getHandle().cp();
    }

    public boolean isSprinting() {
        return this.getHandle().cv();
    }

    public void setSprinting(boolean sprinting) {
        this.getHandle().i(sprinting);
    }

    public void loadData() {
        Optional<fip> optional = this.server.getHandle().s.a(this.nameAndId()).map(nbttagcompound -> fin.a(bfo.a, (jm.a)this.getHandle().ej(), nbttagcompound));
        optional.ifPresent(this.getHandle()::d);
    }

    public void saveData() {
        this.server.getHandle().s.a(this.getHandle());
    }

    @Deprecated
    public void updateInventory() {
        this.getHandle().cl.b();
    }

    public void setSleepingIgnored(boolean isSleeping) {
        this.getHandle().fauxSleeping = isSleeping;
        ((CraftWorld)this.getWorld()).getHandle().f();
    }

    public boolean isSleepingIgnored() {
        return this.getHandle().fauxSleeping;
    }

    public Location getBedSpawnLocation() {
        return this.getRespawnLocation();
    }

    public Location getRespawnLocation() {
        Optional<awy.b> spawnLoc;
        awy.a respawnConfig = this.getHandle().V();
        if (respawnConfig == null) {
            return null;
        }
        awx world = this.getHandle().cK.a(respawnConfig.a().a());
        ja bed2 = respawnConfig.a().b();
        if (world != null && bed2 != null && (spawnLoc = awy.a(world, respawnConfig, true)).isPresent()) {
            awy.b vec = spawnLoc.get();
            return CraftLocation.toBukkit(vec.a(), (World)world.getWorld(), vec.b(), vec.c());
        }
        return null;
    }

    public void setBedSpawnLocation(Location location) {
        this.setBedSpawnLocation(location, false);
    }

    public void setRespawnLocation(Location location) {
        this.setRespawnLocation(location, false);
    }

    public void setBedSpawnLocation(Location location, boolean override) {
        this.setRespawnLocation(location, override);
    }

    public void setRespawnLocation(Location location, boolean override) {
        if (location == null) {
            this.getHandle().setRespawnPosition(null, override, PlayerSpawnChangeEvent.Cause.PLUGIN);
        } else {
            this.getHandle().setRespawnPosition(new awy.a(fid.a.a(((CraftWorld)location.getWorld()).getHandle().al(), CraftLocation.toBlockPosition(location), location.getYaw(), location.getPitch()), false), override, PlayerSpawnChangeEvent.Cause.PLUGIN);
        }
    }

    public Collection<EnderPearl> getEnderPearls() {
        return this.getHandle().aj().stream().map(e2 -> (EnderPearl)e2.getBukkitEntity()).collect(Collectors.toList());
    }

    public Input getCurrentInput() {
        return new CraftInput(this.getHandle().ah());
    }

    @Override
    public Location getBedLocation() {
        Optional<ja> bed2 = this.getHandle().ge();
        Preconditions.checkState((boolean)bed2.isPresent(), (Object)"Not sleeping");
        return CraftLocation.toBukkit(bed2.get(), this.getWorld());
    }

    @Override
    public boolean hasDiscoveredRecipe(NamespacedKey recipe) {
        Preconditions.checkArgument((recipe != null ? 1 : 0) != 0, (Object)"recipe cannot be null");
        return this.getHandle().L().b(CraftRecipe.toMinecraft(recipe));
    }

    @Override
    public Set<NamespacedKey> getDiscoveredRecipes() {
        ImmutableSet.Builder bukkitRecipeKeys = ImmutableSet.builder();
        this.getHandle().L().c.forEach(key -> bukkitRecipeKeys.add((Object)CraftNamespacedKey.fromMinecraft(key.a())));
        return bukkitRecipeKeys.build();
    }

    public void incrementStatistic(Statistic statistic) {
        CraftStatistic.incrementStatistic(this.getHandle().K(), statistic, this.getHandle());
    }

    public void decrementStatistic(Statistic statistic) {
        CraftStatistic.decrementStatistic(this.getHandle().K(), statistic, this.getHandle());
    }

    public int getStatistic(Statistic statistic) {
        return CraftStatistic.getStatistic(this.getHandle().K(), statistic);
    }

    public void incrementStatistic(Statistic statistic, int amount) {
        CraftStatistic.incrementStatistic(this.getHandle().K(), statistic, amount, this.getHandle());
    }

    public void decrementStatistic(Statistic statistic, int amount) {
        CraftStatistic.decrementStatistic(this.getHandle().K(), statistic, amount, this.getHandle());
    }

    public void setStatistic(Statistic statistic, int newValue) {
        CraftStatistic.setStatistic(this.getHandle().K(), statistic, newValue, this.getHandle());
    }

    public void incrementStatistic(Statistic statistic, Material material) {
        CraftStatistic.incrementStatistic(this.getHandle().K(), statistic, material, this.getHandle());
    }

    public void decrementStatistic(Statistic statistic, Material material) {
        CraftStatistic.decrementStatistic(this.getHandle().K(), statistic, material, this.getHandle());
    }

    public int getStatistic(Statistic statistic, Material material) {
        return CraftStatistic.getStatistic(this.getHandle().K(), statistic, material);
    }

    public void incrementStatistic(Statistic statistic, Material material, int amount) {
        CraftStatistic.incrementStatistic(this.getHandle().K(), statistic, material, amount, this.getHandle());
    }

    public void decrementStatistic(Statistic statistic, Material material, int amount) {
        CraftStatistic.decrementStatistic(this.getHandle().K(), statistic, material, amount, this.getHandle());
    }

    public void setStatistic(Statistic statistic, Material material, int newValue) {
        CraftStatistic.setStatistic(this.getHandle().K(), statistic, material, newValue, this.getHandle());
    }

    public void incrementStatistic(Statistic statistic, EntityType entityType) {
        CraftStatistic.incrementStatistic(this.getHandle().K(), statistic, entityType, this.getHandle());
    }

    public void decrementStatistic(Statistic statistic, EntityType entityType) {
        CraftStatistic.decrementStatistic(this.getHandle().K(), statistic, entityType, this.getHandle());
    }

    public int getStatistic(Statistic statistic, EntityType entityType) {
        return CraftStatistic.getStatistic(this.getHandle().K(), statistic, entityType);
    }

    public void incrementStatistic(Statistic statistic, EntityType entityType, int amount) {
        CraftStatistic.incrementStatistic(this.getHandle().K(), statistic, entityType, amount, this.getHandle());
    }

    public void decrementStatistic(Statistic statistic, EntityType entityType, int amount) {
        CraftStatistic.decrementStatistic(this.getHandle().K(), statistic, entityType, amount, this.getHandle());
    }

    public void setStatistic(Statistic statistic, EntityType entityType, int newValue) {
        CraftStatistic.setStatistic(this.getHandle().K(), statistic, entityType, newValue, this.getHandle());
    }

    public void setPlayerTime(long time, boolean relative) {
        this.getHandle().timeOffset = time;
        this.getHandle().relativeTime = relative;
    }

    public long getPlayerTimeOffset() {
        return this.getHandle().timeOffset;
    }

    public long getPlayerTime() {
        return this.getHandle().getPlayerTime();
    }

    public boolean isPlayerTimeRelative() {
        return this.getHandle().relativeTime;
    }

    public void resetPlayerTime() {
        this.setPlayerTime(0L, true);
    }

    public void setPlayerWeather(WeatherType type) {
        this.getHandle().setPlayerWeather(type, true);
    }

    public WeatherType getPlayerWeather() {
        return this.getHandle().getPlayerWeather();
    }

    public int getExpCooldown() {
        return this.getHandle().cp;
    }

    public void setExpCooldown(int ticks) {
        this.getHandle().cp = CraftEventFactory.callPlayerXpCooldownEvent(this.getHandle(), ticks, PlayerExpCooldownChangeEvent.ChangeReason.PLUGIN).getNewCooldown();
    }

    public void resetPlayerWeather() {
        this.getHandle().resetPlayerWeather();
    }

    public boolean isBanned() {
        return ((ProfileBanList)this.server.getBanList(BanList.Type.PROFILE)).isBanned((Object)this.getPlayerProfile());
    }

    public BanEntry<PlayerProfile> ban(String reason, Date expires, String source) {
        return this.ban(reason, expires, source, true);
    }

    public BanEntry<PlayerProfile> ban(String reason, Instant expires, String source) {
        return this.ban(reason, expires != null ? Date.from(expires) : null, source);
    }

    public BanEntry<PlayerProfile> ban(String reason, Duration duration, String source) {
        return this.ban(reason, duration != null ? Instant.now().plus(duration) : null, source);
    }

    public BanEntry<PlayerProfile> ban(String reason, Date expires, String source, boolean kickPlayer) {
        BanEntry banEntry = ((ProfileBanList)this.server.getBanList(BanList.Type.PROFILE)).addBan(this.getPlayerProfile(), reason, expires, source);
        if (kickPlayer) {
            this.kickPlayer(reason);
        }
        return banEntry;
    }

    public BanEntry<PlayerProfile> ban(String reason, Instant instant, String source, boolean kickPlayer) {
        return this.ban(reason, instant != null ? Date.from(instant) : null, source, kickPlayer);
    }

    public BanEntry<PlayerProfile> ban(String reason, Duration duration, String source, boolean kickPlayer) {
        return this.ban(reason, duration != null ? Instant.now().plus(duration) : null, source, kickPlayer);
    }

    public BanEntry<InetAddress> banIp(String reason, Date expires, String source, boolean kickPlayer) {
        Preconditions.checkArgument((this.getAddress() != null ? 1 : 0) != 0, (Object)"The Address of this Player is null");
        BanEntry banEntry = ((IpBanList)this.server.getBanList(BanList.Type.IP)).addBan((Object)this.getAddress().getAddress(), reason, expires, source);
        if (kickPlayer) {
            this.kickPlayer(reason);
        }
        return banEntry;
    }

    public BanEntry<InetAddress> banIp(String reason, Instant instant, String source, boolean kickPlayer) {
        return this.banIp(reason, instant != null ? Date.from(instant) : null, source, kickPlayer);
    }

    public BanEntry<InetAddress> banIp(String reason, Duration duration, String source, boolean kickPlayer) {
        return this.banIp(reason, duration != null ? Instant.now().plus(duration) : null, source, kickPlayer);
    }

    public boolean isWhitelisted() {
        return this.server.getHandle().i().a(this.nameAndId());
    }

    public void setWhitelisted(boolean value) {
        if (value) {
            this.server.getHandle().i().a(new bbo(this.nameAndId()));
        } else {
            this.server.getHandle().i().b(this.nameAndId());
        }
    }

    @Override
    public void setGameMode(GameMode mode) {
        Preconditions.checkArgument((mode != null ? 1 : 0) != 0, (Object)"GameMode cannot be null");
        if (this.getHandle().g == null) {
            return;
        }
        this.getHandle().a(drn.a(mode.getValue()));
    }

    @Override
    public GameMode getGameMode() {
        return GameMode.getByValue((int)this.getHandle().h.b().a());
    }

    public GameMode getPreviousGameMode() {
        drn previousGameMode = this.getHandle().h.c();
        return previousGameMode == null ? null : GameMode.getByValue((int)previousGameMode.a());
    }

    public void giveExp(int exp2) {
        this.getHandle().d(exp2);
    }

    public void giveExpLevels(int levels) {
        this.getHandle().c(levels);
    }

    public float getExp() {
        return this.getHandle().ct;
    }

    public void setExp(float exp2) {
        Preconditions.checkArgument(((double)exp2 >= 0.0 && (double)exp2 <= 1.0 ? 1 : 0) != 0, (String)"Experience progress must be between 0.0 and 1.0 (%s)", (Object)Float.valueOf(exp2));
        this.getHandle().ct = exp2;
        this.getHandle().cY = -1;
    }

    public int getLevel() {
        return this.getHandle().cr;
    }

    public void setLevel(int level) {
        Preconditions.checkArgument((level >= 0 ? 1 : 0) != 0, (String)"Experience level must not be negative (%s)", (int)level);
        this.getHandle().cr = level;
        this.getHandle().cY = -1;
    }

    public int getTotalExperience() {
        return this.getHandle().cs;
    }

    public void setTotalExperience(int exp2) {
        Preconditions.checkArgument((exp2 >= 0 ? 1 : 0) != 0, (String)"Total experience points must not be negative (%s)", (int)exp2);
        this.getHandle().cs = exp2;
    }

    public void sendExperienceChange(float progress) {
        this.sendExperienceChange(progress, this.getLevel());
    }

    public void sendExperienceChange(float progress, int level) {
        Preconditions.checkArgument(((double)progress >= 0.0 && (double)progress <= 1.0 ? 1 : 0) != 0, (String)"Experience progress must be between 0.0 and 1.0 (%s)", (Object)Float.valueOf(progress));
        Preconditions.checkArgument((level >= 0 ? 1 : 0) != 0, (String)"Experience level must not be negative (%s)", (int)level);
        if (this.getHandle().g == null) {
            return;
        }
        agj packet = new agj(progress, this.getTotalExperience(), level);
        this.getHandle().g.b(packet);
    }

    @Nullable
    private static WeakReference<Plugin> getPluginWeakReference(@Nullable Plugin plugin) {
        return plugin == null ? null : pluginWeakReferences.computeIfAbsent(plugin, WeakReference::new);
    }

    @Deprecated
    public void hidePlayer(Player player) {
        this.hideEntity0(null, (Entity)player);
    }

    public void hidePlayer(Plugin plugin, Player player) {
        this.hideEntity(plugin, (Entity)player);
    }

    public void hideEntity(Plugin plugin, Entity entity) {
        Preconditions.checkArgument((plugin != null ? 1 : 0) != 0, (Object)"Plugin cannot be null");
        Preconditions.checkArgument((boolean)plugin.isEnabled(), (String)"Plugin (%s) cannot be disabled", (Object)plugin.getName());
        this.hideEntity0(plugin, entity);
    }

    private void hideEntity0(@Nullable Plugin plugin, Entity entity) {
        Preconditions.checkArgument((entity != null ? 1 : 0) != 0, (Object)"Entity hidden cannot be null");
        if (this.getHandle().g == null) {
            return;
        }
        if (this.equals(entity)) {
            return;
        }
        boolean shouldHide = entity.isVisibleByDefault() ? this.addInvertedVisibility(plugin, entity) : this.removeInvertedVisibility(plugin, entity);
        if (shouldHide) {
            this.untrackAndHideEntity(entity);
        }
    }

    private boolean addInvertedVisibility(@Nullable Plugin plugin, Entity entity) {
        Set<WeakReference<Plugin>> invertedPlugins = this.invertedVisibilityEntities.get(entity.getUniqueId());
        if (invertedPlugins != null) {
            invertedPlugins.add(CraftPlayer.getPluginWeakReference(plugin));
            return false;
        }
        invertedPlugins = new HashSet<WeakReference<Plugin>>();
        invertedPlugins.add(CraftPlayer.getPluginWeakReference(plugin));
        this.invertedVisibilityEntities.put(entity.getUniqueId(), invertedPlugins);
        return true;
    }

    private void untrackAndHideEntity(Entity entity) {
        awb tracker = this.getHandle().A().n().a;
        cdv other = ((CraftEntity)entity).getHandle();
        awb.b entry = (awb.b)tracker.J.get(other.az());
        if (entry != null) {
            entry.a(this.getHandle());
        }
        if (other instanceof awy) {
            awy otherPlayer = (awy)other;
            if (otherPlayer.sentListPacket) {
                this.getHandle().g.b(new afc(List.of(otherPlayer.cT())));
            }
        }
        this.server.getPluginManager().callEvent((Event)new PlayerHideEntityEvent((Player)this, entity));
    }

    void resetAndHideEntity(Entity entity) {
        if (this.equals(entity)) {
            return;
        }
        if (this.invertedVisibilityEntities.remove(entity.getUniqueId()) == null) {
            this.untrackAndHideEntity(entity);
        }
    }

    @Deprecated
    public void showPlayer(Player player) {
        this.showEntity0(null, (Entity)player);
    }

    public void showPlayer(Plugin plugin, Player player) {
        this.showEntity(plugin, (Entity)player);
    }

    public void showEntity(Plugin plugin, Entity entity) {
        Preconditions.checkArgument((plugin != null ? 1 : 0) != 0, (Object)"Plugin cannot be null");
        this.showEntity0(plugin, entity);
    }

    private void showEntity0(@Nullable Plugin plugin, Entity entity) {
        Preconditions.checkArgument((entity != null ? 1 : 0) != 0, (Object)"Entity show cannot be null");
        if (this.getHandle().g == null) {
            return;
        }
        if (this.equals(entity)) {
            return;
        }
        boolean shouldShow = entity.isVisibleByDefault() ? this.removeInvertedVisibility(plugin, entity) : this.addInvertedVisibility(plugin, entity);
        if (shouldShow) {
            this.trackAndShowEntity(entity);
        }
    }

    private boolean removeInvertedVisibility(@Nullable Plugin plugin, Entity entity) {
        Set<WeakReference<Plugin>> invertedPlugins = this.invertedVisibilityEntities.get(entity.getUniqueId());
        if (invertedPlugins == null) {
            return false;
        }
        invertedPlugins.remove(CraftPlayer.getPluginWeakReference(plugin));
        if (!invertedPlugins.isEmpty()) {
            return false;
        }
        this.invertedVisibilityEntities.remove(entity.getUniqueId());
        return true;
    }

    private void trackAndShowEntity(Entity entity) {
        awb.b entry;
        awb tracker = this.getHandle().A().n().a;
        cdv other = ((CraftEntity)entity).getHandle();
        if (other instanceof awy) {
            awy otherPlayer = (awy)other;
            this.getHandle().g.b(afd.a(List.of(otherPlayer)));
        }
        if ((entry = (awb.b)tracker.J.get(other.az())) != null && !entry.f.contains(this.getHandle().g)) {
            entry.b(this.getHandle());
        }
        this.server.getPluginManager().callEvent((Event)new PlayerShowEntityEvent((Player)this, entity));
    }

    void resetAndShowEntity(Entity entity) {
        if (this.equals(entity)) {
            return;
        }
        if (this.invertedVisibilityEntities.remove(entity.getUniqueId()) == null) {
            this.trackAndShowEntity(entity);
        }
    }

    public void onEntityRemove(cdv entity) {
        this.invertedVisibilityEntities.remove(entity.cT());
    }

    public boolean canSee(Player player) {
        return this.canSee((Entity)player);
    }

    public boolean canSee(Entity entity) {
        return this.equals(entity) || entity.isVisibleByDefault() ^ this.invertedVisibilityEntities.containsKey(entity.getUniqueId());
    }

    public boolean canSeePlayer(UUID uuid) {
        Player entity = this.getServer().getPlayer(uuid);
        return entity != null ? this.canSee((Entity)entity) : false;
    }

    public Map<String, Object> serialize() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("name", this.getName());
        return result;
    }

    public Player getPlayer() {
        return this;
    }

    @Override
    public awy getHandle() {
        return (awy)this.entity;
    }

    public void setHandle(awy entity) {
        super.setHandle(entity);
    }

    @Override
    public String toString() {
        return "CraftPlayer{name=" + this.getName() + "}";
    }

    @Override
    public int hashCode() {
        if (this.hash == 0 || this.hash == 485) {
            this.hash = 485 + (this.getUniqueId() != null ? this.getUniqueId().hashCode() : 0);
        }
        return this.hash;
    }

    public long getFirstPlayed() {
        return this.firstPlayed;
    }

    public long getLastPlayed() {
        return this.lastPlayed;
    }

    public boolean hasPlayedBefore() {
        return this.hasPlayedBefore;
    }

    public String getLastKnownName() {
        return this.lastKnownName;
    }

    public void setFirstPlayed(long firstPlayed) {
        this.firstPlayed = firstPlayed;
    }

    public void readExtraData(fip valueinput) {
        this.hasPlayedBefore = true;
        valueinput.a("bukkit").ifPresent(data -> {
            this.firstPlayed = data.a("firstPlayed", this.firstPlayed);
            this.lastPlayed = data.a("lastPlayed", this.lastPlayed);
            this.lastKnownName = data.a("lastKnownName", "");
            awy handle = this.getHandle();
            handle.newExp = data.a("newExp", handle.newExp);
            handle.newTotalExp = data.a("newTotalExp", handle.newTotalExp);
            handle.newLevel = data.a("newLevel", handle.newLevel);
            handle.expToDrop = data.a("expToDrop", handle.expToDrop);
            handle.keepLevel = data.a("keepLevel", handle.keepLevel);
        });
    }

    public void setExtraData(fir valueoutput) {
        fir data = valueoutput.a("bukkit");
        awy handle = this.getHandle();
        data.a("newExp", handle.newExp);
        data.a("newTotalExp", handle.newTotalExp);
        data.a("newLevel", handle.newLevel);
        data.a("expToDrop", handle.expToDrop);
        data.a("keepLevel", handle.keepLevel);
        data.a("firstPlayed", this.getFirstPlayed());
        data.a("lastPlayed", System.currentTimeMillis());
        data.a("lastKnownName", handle.cV());
    }

    public boolean beginConversation(Conversation conversation) {
        return this.conversationTracker.beginConversation(conversation);
    }

    public void abandonConversation(Conversation conversation) {
        this.conversationTracker.abandonConversation(conversation, new ConversationAbandonedEvent(conversation, (ConversationCanceller)new ManuallyAbandonedConversationCanceller()));
    }

    public void abandonConversation(Conversation conversation, ConversationAbandonedEvent details) {
        this.conversationTracker.abandonConversation(conversation, details);
    }

    public void acceptConversationInput(String input) {
        this.conversationTracker.acceptConversationInput(input);
    }

    public boolean isConversing() {
        return this.conversationTracker.isConversing();
    }

    public void sendPluginMessage(Plugin source, String channel, byte[] message) {
        StandardMessenger.validatePluginMessage((Messenger)this.server.getMessenger(), (Plugin)source, (String)channel, (byte[])message);
        if (this.getHandle().g == null) {
            return;
        }
        if (this.channels.contains(channel)) {
            amj id2 = amj.a(StandardMessenger.validateAndCorrectChannel((String)channel));
            this.sendCustomPayload(id2, message);
        }
    }

    private void sendCustomPayload(amj id2, byte[] message) {
        aay packet = new aay(new abu(id2, Unpooled.wrappedBuffer((byte[])message)));
        this.getHandle().g.b(packet);
    }

    public void setTexturePack(String url) {
        this.setResourcePack(url);
    }

    public void setResourcePack(String url) {
        this.setResourcePack(url, null);
    }

    public void setResourcePack(String url, byte[] hash) {
        this.setResourcePack(url, hash, false);
    }

    public void setResourcePack(String url, byte[] hash, String prompt) {
        this.setResourcePack(url, hash, prompt, false);
    }

    public void setResourcePack(String url, byte[] hash, boolean force) {
        this.setResourcePack(url, hash, null, force);
    }

    public void setResourcePack(String url, byte[] hash, String prompt, boolean force) {
        Preconditions.checkArgument((url != null ? 1 : 0) != 0, (Object)"Resource pack URL cannot be null");
        this.setResourcePack(UUID.nameUUIDFromBytes(url.getBytes(StandardCharsets.UTF_8)), url, hash, prompt, force);
    }

    public void setResourcePack(UUID id2, String url, byte[] hash, String prompt, boolean force) {
        Preconditions.checkArgument((id2 != null ? 1 : 0) != 0, (Object)"Resource pack ID cannot be null");
        Preconditions.checkArgument((url != null ? 1 : 0) != 0, (Object)"Resource pack URL cannot be null");
        String hashStr = "";
        if (hash != null) {
            Preconditions.checkArgument((hash.length == 20 ? 1 : 0) != 0, (String)"Resource pack hash should be 20 bytes long but was %s", (int)hash.length);
            hashStr = BaseEncoding.base16().lowerCase().encode(hash);
        }
        this.handlePushResourcePack(new abe(id2, url, hashStr, force, CraftChatMessage.fromStringOrOptional(prompt, true)), true);
    }

    public void addResourcePack(UUID id2, String url, byte[] hash, String prompt, boolean force) {
        Preconditions.checkArgument((url != null ? 1 : 0) != 0, (Object)"Resource pack URL cannot be null");
        String hashStr = "";
        if (hash != null) {
            Preconditions.checkArgument((hash.length == 20 ? 1 : 0) != 0, (String)"Resource pack hash should be 20 bytes long but was %s", (int)hash.length);
            hashStr = BaseEncoding.base16().lowerCase().encode(hash);
        }
        this.handlePushResourcePack(new abe(id2, url, hashStr, force, CraftChatMessage.fromStringOrOptional(prompt, true)), false);
    }

    public void removeResourcePack(UUID id2) {
        Preconditions.checkArgument((id2 != null ? 1 : 0) != 0, (Object)"Resource pack id cannot be null");
        if (this.getHandle().g == null) {
            return;
        }
        this.getHandle().g.b(new abd(Optional.of(id2)));
    }

    public void removeResourcePacks() {
        if (this.getHandle().g == null) {
            return;
        }
        this.getHandle().g.b(new abd(Optional.empty()));
    }

    private void handlePushResourcePack(abe resourcePackPushPacket, boolean resetBeforePush) {
        if (this.getHandle().g == null) {
            return;
        }
        if (resetBeforePush) {
            this.removeResourcePacks();
        }
        this.getHandle().g.b(resourcePackPushPacket);
    }

    public void addChannel(String channel) {
        Preconditions.checkState((this.channels.size() < 128 ? 1 : 0) != 0, (String)"Cannot register channel '%s'. Too many channels registered!", (Object)channel);
        channel = StandardMessenger.validateAndCorrectChannel((String)channel);
        if (this.channels.add(channel)) {
            this.server.getPluginManager().callEvent((Event)new PlayerRegisterChannelEvent((Player)this, channel));
        }
    }

    public void removeChannel(String channel) {
        if (this.channels.remove(channel = StandardMessenger.validateAndCorrectChannel((String)channel))) {
            this.server.getPluginManager().callEvent((Event)new PlayerUnregisterChannelEvent((Player)this, channel));
        }
    }

    public Set<String> getListeningPluginChannels() {
        return ImmutableSet.copyOf(this.channels);
    }

    public void sendSupportedChannels() {
        if (this.getHandle().g == null) {
            return;
        }
        Set listening = this.server.getMessenger().getIncomingChannels();
        if (!listening.isEmpty()) {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            for (String channel : listening) {
                try {
                    stream.write(channel.getBytes("UTF8"));
                    stream.write(0);
                }
                catch (IOException ex2) {
                    Logger.getLogger(CraftPlayer.class.getName()).log(Level.SEVERE, "Could not send Plugin Channel REGISTER to " + this.getName(), ex2);
                }
            }
            this.sendCustomPayload(amj.b("register"), stream.toByteArray());
        }
    }

    @Override
    public void setMetadata(String metadataKey, MetadataValue newMetadataValue) {
        this.server.getPlayerMetadata().setMetadata(this, metadataKey, newMetadataValue);
    }

    @Override
    public List<MetadataValue> getMetadata(String metadataKey) {
        return this.server.getPlayerMetadata().getMetadata(this, metadataKey);
    }

    @Override
    public boolean hasMetadata(String metadataKey) {
        return this.server.getPlayerMetadata().hasMetadata(this, metadataKey);
    }

    @Override
    public void removeMetadata(String metadataKey, Plugin owningPlugin) {
        this.server.getPlayerMetadata().removeMetadata(this, metadataKey, owningPlugin);
    }

    @Override
    public boolean setWindowProperty(InventoryView.Property prop, int value) {
        ddg container = this.getHandle().cl;
        if (container.getBukkitView().getType() != prop.getType()) {
            return false;
        }
        container.b(prop.getId(), value);
        return true;
    }

    public void disconnect(String reason) {
        this.conversationTracker.abandonAllConversations();
        this.perm.clearPermissions();
    }

    public boolean isFlying() {
        return this.getHandle().gC().b;
    }

    public void setFlying(boolean value) {
        if (!this.getAllowFlight()) {
            Preconditions.checkArgument((!value ? 1 : 0) != 0, (Object)"Player is not allowed to fly (check #getAllowFlight())");
        }
        this.getHandle().gC().b = value;
        this.getHandle().z();
    }

    public boolean getAllowFlight() {
        return this.getHandle().gC().c;
    }

    public void setAllowFlight(boolean value) {
        if (this.isFlying() && !value) {
            this.getHandle().gC().b = false;
        }
        this.getHandle().gC().c = value;
        this.getHandle().z();
    }

    public void setFlySpeed(float value) {
        this.validateSpeed(value);
        awy player = this.getHandle();
        player.gC().m = value / 2.0f;
        player.z();
    }

    public void setWalkSpeed(float value) {
        this.validateSpeed(value);
        awy player = this.getHandle();
        player.gC().n = value / 2.0f;
        player.z();
        this.getHandle().h(cgc.w).a(player.gC().n);
    }

    public float getFlySpeed() {
        return this.getHandle().gC().m * 2.0f;
    }

    public float getWalkSpeed() {
        return this.getHandle().gC().n * 2.0f;
    }

    private void validateSpeed(float value) {
        Preconditions.checkArgument((value <= 1.0f && value >= -1.0f ? 1 : 0) != 0, (String)"Speed value (%s) need to be between -1f and 1f", (Object)Float.valueOf(value));
    }

    @Override
    public void setMaxHealth(double amount) {
        super.setMaxHealth(amount);
        this.health = Math.min(this.health, amount);
        this.getHandle().x();
    }

    @Override
    public void resetMaxHealth() {
        super.resetMaxHealth();
        this.getHandle().x();
    }

    public CraftScoreboard getScoreboard() {
        return this.server.getScoreboardManager().getPlayerBoard(this);
    }

    public void setScoreboard(Scoreboard scoreboard) {
        Preconditions.checkArgument((scoreboard != null ? 1 : 0) != 0, (Object)"Scoreboard cannot be null");
        Preconditions.checkState((this.getHandle().g != null ? 1 : 0) != 0, (Object)"Cannot set scoreboard yet (invalid player connection)");
        this.server.getScoreboardManager().setPlayerBoard(this, scoreboard);
    }

    public void setHealthScale(double value) {
        Preconditions.checkArgument((value > 0.0 ? 1 : 0) != 0, (String)"Health value (%s) must be greater than 0", (Object)value);
        this.healthScale = value;
        this.scaledHealth = true;
        this.updateScaledHealth();
    }

    public double getHealthScale() {
        return this.healthScale;
    }

    public void setHealthScaled(boolean scale) {
        this.scaledHealth = scale;
        if (this.scaledHealth != this.scaledHealth) {
            this.updateScaledHealth();
        }
    }

    public boolean isHealthScaled() {
        return this.scaledHealth;
    }

    public float getScaledHealth() {
        return (float)(this.isHealthScaled() ? this.getHealth() * this.getHealthScale() / this.getMaxHealth() : this.getHealth());
    }

    @Override
    public double getHealth() {
        return this.health;
    }

    public void setRealHealth(double health) {
        this.health = health;
    }

    public void updateScaledHealth() {
        this.updateScaledHealth(true);
    }

    public void updateScaledHealth(boolean sendHealth) {
        cfz attributemapserver = this.getHandle().fp();
        Collection<cfy> set = attributemapserver.c();
        this.injectScaledMaxHealth(set, true);
        if (this.getHandle().g != null) {
            this.getHandle().g.b(new ahk(this.getHandle().az(), set));
            if (sendHealth) {
                this.sendHealthUpdate();
            }
        }
        this.getHandle().aC().a(cew.cb, Float.valueOf(this.getScaledHealth()));
        this.getHandle().maxHealthCache = this.getMaxHealth();
    }

    public void sendHealthUpdate(double health, int foodLevel, float saturation) {
        this.getHandle().g.b(new agk((float)health, foodLevel, saturation));
    }

    public void sendHealthUpdate() {
        ddc foodData = this.getHandle().gM();
        this.sendHealthUpdate(this.getScaledHealth(), foodData.a(), foodData.c());
    }

    public void injectScaledMaxHealth(Collection<cfy> collection, boolean force) {
        if (!this.scaledHealth && !force) {
            return;
        }
        for (cfy genericInstance : collection) {
            if (genericInstance.a() != cgc.t) continue;
            collection.remove(genericInstance);
            break;
        }
        cfy dummy = new cfy(cgc.t, attribute -> {});
        dummy.a(this.scaledHealth ? this.healthScale : this.getMaxHealth());
        collection.add(dummy);
    }

    public Entity getSpectatorTarget() {
        cdv followed = this.getHandle().N();
        return followed == this.getHandle() ? null : followed.getBukkitEntity();
    }

    public void setSpectatorTarget(Entity entity) {
        Preconditions.checkArgument((this.getGameMode() == GameMode.SPECTATOR ? 1 : 0) != 0, (Object)"Player must be in spectator mode");
        this.getHandle().d(entity == null ? null : ((CraftEntity)entity).getHandle());
    }

    public void sendTitle(String title, String subtitle) {
        this.sendTitle(title, subtitle, 10, 70, 20);
    }

    public void sendTitle(String title, String subtitle, int fadeIn, int stay, int fadeOut) {
        agv times = new agv(fadeIn, stay, fadeOut);
        this.getHandle().g.b(times);
        if (title != null) {
            agu packetTitle = new agu(CraftChatMessage.fromString(title)[0]);
            this.getHandle().g.b(packetTitle);
        }
        if (subtitle != null) {
            ags packetSubtitle = new ags(CraftChatMessage.fromString(subtitle)[0]);
            this.getHandle().g.b(packetSubtitle);
        }
    }

    public void resetTitle() {
        adh packetReset = new adh(true);
        this.getHandle().g.b(packetReset);
    }

    public void spawnParticle(Particle particle, Location location, int count) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count);
    }

    public void spawnParticle(Particle particle, double x2, double y2, double z2, int count) {
        this.spawnParticle(particle, x2, y2, z2, count, null);
    }

    public <T> void spawnParticle(Particle particle, Location location, int count, T data) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count, data);
    }

    public <T> void spawnParticle(Particle particle, double x2, double y2, double z2, int count, T data) {
        this.spawnParticle(particle, x2, y2, z2, count, 0.0, 0.0, 0.0, data);
    }

    public void spawnParticle(Particle particle, Location location, int count, double offsetX, double offsetY, double offsetZ) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count, offsetX, offsetY, offsetZ);
    }

    public void spawnParticle(Particle particle, double x2, double y2, double z2, int count, double offsetX, double offsetY, double offsetZ) {
        this.spawnParticle(particle, x2, y2, z2, count, offsetX, offsetY, offsetZ, null);
    }

    public <T> void spawnParticle(Particle particle, Location location, int count, double offsetX, double offsetY, double offsetZ, T data) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count, offsetX, offsetY, offsetZ, data);
    }

    public <T> void spawnParticle(Particle particle, double x2, double y2, double z2, int count, double offsetX, double offsetY, double offsetZ, T data) {
        this.spawnParticle(particle, x2, y2, z2, count, offsetX, offsetY, offsetZ, 1.0, data);
    }

    public void spawnParticle(Particle particle, Location location, int count, double offsetX, double offsetY, double offsetZ, double extra) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count, offsetX, offsetY, offsetZ, extra);
    }

    public void spawnParticle(Particle particle, double x2, double y2, double z2, int count, double offsetX, double offsetY, double offsetZ, double extra) {
        this.spawnParticle(particle, x2, y2, z2, count, offsetX, offsetY, offsetZ, extra, null);
    }

    public <T> void spawnParticle(Particle particle, Location location, int count, double offsetX, double offsetY, double offsetZ, double extra, T data) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count, offsetX, offsetY, offsetZ, extra, data);
    }

    public <T> void spawnParticle(Particle particle, double x2, double y2, double z2, int count, double offsetX, double offsetY, double offsetZ, double extra, T data) {
        this.spawnParticle(particle, x2, y2, z2, count, offsetX, offsetY, offsetZ, extra, data, false);
    }

    public <T> void spawnParticle(Particle particle, Location location, int count, double offsetX, double offsetY, double offsetZ, double extra, T data, boolean force) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count, offsetX, offsetY, offsetZ, extra, data, force);
    }

    public <T> void spawnParticle(Particle particle, double x2, double y2, double z2, int count, double offsetX, double offsetY, double offsetZ, double extra, T data, boolean force) {
        aek packetplayoutworldparticles = new aek(CraftParticle.createParticleParam(particle, data), force, false, (float)x2, (float)y2, (float)z2, (float)offsetX, (float)offsetY, (float)offsetZ, (float)extra, count);
        this.getHandle().g.b(packetplayoutworldparticles);
    }

    public AdvancementProgress getAdvancementProgress(Advancement advancement) {
        Preconditions.checkArgument((advancement != null ? 1 : 0) != 0, (Object)"advancement");
        CraftAdvancement craft = (CraftAdvancement)advancement;
        amr data = this.getHandle().U();
        al progress = data.b(craft.getHandle());
        return new CraftAdvancementProgress(craft, data, progress);
    }

    public int getClientViewDistance() {
        return this.getHandle().H() == 0 ? Bukkit.getViewDistance() : this.getHandle().H();
    }

    public int getPing() {
        return this.getHandle().g.k();
    }

    public String getLocale() {
        return this.getHandle().dk;
    }

    public void updateCommands() {
        if (this.getHandle().g == null) {
            return;
        }
        this.getHandle().cK.aJ().a(this.getHandle());
    }

    public void openBook(ItemStack book) {
        Preconditions.checkArgument((book != null ? 1 : 0) != 0, (Object)"ItemStack cannot be null");
        Preconditions.checkArgument((book.getType() == Material.WRITTEN_BOOK ? 1 : 0) != 0, (String)"ItemStack Material (%s) must be Material.WRITTEN_BOOK", (Object)book.getType());
        ItemStack hand = this.getInventory().getItemInMainHand();
        this.getInventory().setItemInMainHand(book);
        this.getHandle().a(CraftItemStack.asNMSCopy(book), cbp.a);
        this.getInventory().setItemInMainHand(hand);
    }

    public void openSign(Sign sign) {
        this.openSign(sign, Side.FRONT);
    }

    public void openSign(@NotNull Sign sign, @NotNull Side side) {
        CraftSign.openSign(sign, this, side);
    }

    public void showDemoScreen() {
        if (this.getHandle().g == null) {
            return;
        }
        this.getHandle().g.b(new aec(aec.g, 0.0f));
    }

    public boolean isAllowingServerListings() {
        return this.getHandle().aa();
    }

    public void clearDialog() {
        if (this.getHandle().g == null) {
            return;
        }
        this.getHandle().g.b(aax.a);
    }

    public void showDialog(NamespacedKey dialog) {
        Preconditions.checkArgument((dialog != null ? 1 : 0) != 0, (Object)"Dialog cannot be null");
        ami<arz> key = ami.a(mp.aW, CraftNamespacedKey.toMinecraft(dialog));
        Optional nms = this.getHandle().ej().f(mp.aW).a(key);
        this.showDialog((jk)nms.orElseThrow(() -> new IllegalArgumentException("Dialog does not exist on server: " + String.valueOf(dialog))));
    }

    private void showDialog(jk<arz> dialog) {
        if (this.getHandle().g == null) {
            return;
        }
        if (dialog == null) {
            return;
        }
        this.getHandle().b(dialog);
    }

    public record CookieFuture(amj key, CompletableFuture<byte[]> future) {
    }

    public static interface TransferCookieConnection {
        public boolean isTransferred();

        public wl getProtocol();

        public void sendPacket(aao<?> var1);

        public void kickPlayer(xx var1);
    }

    private record ChunkSectionChanges(ShortSet positions, List<ejm> blockData) {
        public ChunkSectionChanges() {
            this((ShortSet)new ShortArraySet(), new ArrayList<ejm>());
        }
    }
}

