/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R6.generator;

import com.google.common.base.Preconditions;
import com.mojang.serialization.MapCodec;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.bukkit.block.Biome;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBiome;
import org.bukkit.craftbukkit.v1_21_R6.generator.CraftBiomeParameterPoint;
import org.bukkit.generator.BiomeProvider;
import org.bukkit.generator.WorldInfo;

public class CustomWorldChunkManager
extends dsx {
    private final WorldInfo worldInfo;
    private final BiomeProvider biomeProvider;
    private final jx<dst> registry;

    private static List<jk<dst>> biomeListToBiomeBaseList(List<Biome> biomes, jx<dst> registry) {
        ArrayList<jk<dst>> biomeBases = new ArrayList<jk<dst>>();
        for (Biome biome : biomes) {
            Preconditions.checkArgument((biome != Biome.CUSTOM ? 1 : 0) != 0, (String)"Cannot use the biome %s", (Object)biome);
            biomeBases.add(CraftBiome.bukkitToMinecraftHolder(biome));
        }
        return biomeBases;
    }

    public CustomWorldChunkManager(WorldInfo worldInfo, BiomeProvider biomeProvider, jx<dst> registry) {
        this.worldInfo = worldInfo;
        this.biomeProvider = biomeProvider;
        this.registry = registry;
    }

    @Override
    protected MapCodec<? extends dsx> a() {
        throw new UnsupportedOperationException("Cannot serialize CustomWorldChunkManager");
    }

    @Override
    public jk<dst> getNoiseBiome(int x2, int y2, int z2, dtc.f sampler) {
        Biome biome = this.biomeProvider.getBiome(this.worldInfo, x2 << 2, y2 << 2, z2 << 2, CraftBiomeParameterPoint.createBiomeParameterPoint(sampler, sampler.a(x2, y2, z2)));
        Preconditions.checkArgument((biome != Biome.CUSTOM ? 1 : 0) != 0, (String)"Cannot set the biome to %s", (Object)biome);
        return CraftBiome.bukkitToMinecraftHolder(biome);
    }

    @Override
    protected Stream<jk<dst>> b() {
        return CustomWorldChunkManager.biomeListToBiomeBaseList(this.biomeProvider.getBiomes(this.worldInfo), this.registry).stream();
    }
}

