/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R6.inventory;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.bukkit.Material;
import org.bukkit.configuration.serialization.DelegateDeserialization;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftMetaBookSigned;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftMetaItem;
import org.bukkit.craftbukkit.v1_21_R6.inventory.ItemMetaKey;
import org.bukkit.craftbukkit.v1_21_R6.inventory.SerializableMeta;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftChatMessage;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.WritableBookMeta;

@DelegateDeserialization(value=SerializableMeta.class)
public class CraftMetaBook
extends CraftMetaItem
implements BookMeta,
WritableBookMeta {
    static final CraftMetaItem.ItemMetaKeyType<dla> BOOK_CONTENT = new CraftMetaItem.ItemMetaKeyType<dla>(kp.U);
    static final ItemMetaKey BOOK_PAGES = new ItemMetaKey("pages");
    static final int MAX_PAGES = Integer.MAX_VALUE;
    static final int MAX_PAGE_LENGTH = 1024;
    protected List<String> pages;

    CraftMetaBook(CraftMetaItem meta) {
        super(meta);
        if (meta instanceof CraftMetaBook) {
            CraftMetaBook bookMeta = (CraftMetaBook)meta;
            if (bookMeta.pages != null) {
                this.pages = new ArrayList<String>(bookMeta.pages.size());
                this.pages.addAll(bookMeta.pages);
            }
        } else if (meta instanceof CraftMetaBookSigned) {
            CraftMetaBookSigned bookMeta = (CraftMetaBookSigned)meta;
            if (bookMeta.pages != null) {
                this.pages = new ArrayList<String>(bookMeta.pages.size());
                this.pages.addAll(Lists.transform(bookMeta.pages, CraftChatMessage::fromComponent));
            }
        }
    }

    CraftMetaBook(kn tag) {
        super(tag);
        CraftMetaBook.getOrEmpty(tag, BOOK_CONTENT).ifPresent(writable -> {
            List<axo<String>> pages = writable.a();
            this.pages = new ArrayList<String>(pages.size());
            for (int i2 = 0; i2 < Math.min(pages.size(), Integer.MAX_VALUE); ++i2) {
                String page = pages.get(i2).a();
                page = this.validatePage(page);
                this.pages.add(page);
            }
        });
    }

    CraftMetaBook(Map<String, Object> map) {
        super(map);
        Iterable pages = SerializableMeta.getObject(Iterable.class, map, CraftMetaBook.BOOK_PAGES.BUKKIT, true);
        if (pages != null) {
            this.pages = new ArrayList<String>();
            for (Object page : pages) {
                if (!(page instanceof String)) continue;
                this.internalAddPage(this.validatePage((String)page));
            }
        }
    }

    @Override
    void applyToItem(CraftMetaItem.Applicator itemData) {
        super.applyToItem(itemData);
        if (this.pages != null) {
            ArrayList<axo<String>> list = new ArrayList<axo<String>>();
            for (String page : this.pages) {
                list.add(axo.a(axp.a(page)));
            }
            itemData.put(BOOK_CONTENT, new dla(list));
        }
    }

    @Override
    boolean isEmpty() {
        return super.isEmpty() && this.isBookEmpty();
    }

    boolean isBookEmpty() {
        return this.pages == null;
    }

    @Override
    boolean applicableTo(Material type) {
        return type == Material.WRITABLE_BOOK;
    }

    public boolean hasAuthor() {
        return false;
    }

    public boolean hasTitle() {
        return false;
    }

    public boolean hasPages() {
        return this.pages != null && !this.pages.isEmpty();
    }

    public boolean hasGeneration() {
        return false;
    }

    public String getTitle() {
        return null;
    }

    public boolean setTitle(String title) {
        return false;
    }

    public String getAuthor() {
        return null;
    }

    public void setAuthor(String author) {
    }

    public BookMeta.Generation getGeneration() {
        return null;
    }

    public void setGeneration(BookMeta.Generation generation) {
    }

    public String getPage(int page) {
        Preconditions.checkArgument((boolean)this.isValidPage(page), (String)"Invalid page number (%s)", (int)page);
        return this.pages.get(page - 1);
    }

    public void setPage(int page, String text) {
        Preconditions.checkArgument((boolean)this.isValidPage(page), (String)"Invalid page number (%s/%s)", (int)page, (int)this.getPageCount());
        String newText = this.validatePage(text);
        this.pages.set(page - 1, newText);
    }

    public void setPages(String ... pages) {
        this.setPages(Arrays.asList(pages));
    }

    public void addPage(String ... pages) {
        for (String page : pages) {
            page = this.validatePage(page);
            this.internalAddPage(page);
        }
    }

    String validatePage(String page) {
        if (page == null) {
            page = "";
        } else if (page.length() > 1024) {
            page = page.substring(0, 1024);
        }
        return page;
    }

    private void internalAddPage(String page) {
        if (this.pages == null) {
            this.pages = new ArrayList<String>();
        } else if (this.pages.size() >= Integer.MAX_VALUE) {
            return;
        }
        this.pages.add(page);
    }

    public int getPageCount() {
        return this.pages == null ? 0 : this.pages.size();
    }

    public List<String> getPages() {
        if (this.pages == null) {
            return ImmutableList.of();
        }
        return (List)this.pages.stream().collect(ImmutableList.toImmutableList());
    }

    public void setPages(List<String> pages) {
        if (pages.isEmpty()) {
            this.pages = null;
            return;
        }
        if (this.pages != null) {
            this.pages.clear();
        }
        for (String page : pages) {
            this.addPage(page);
        }
    }

    private boolean isValidPage(int page) {
        return page > 0 && page <= this.getPageCount();
    }

    @Override
    public CraftMetaBook clone() {
        CraftMetaBook meta = (CraftMetaBook)super.clone();
        if (this.pages != null) {
            meta.pages = new ArrayList<String>(this.pages);
        }
        return meta;
    }

    @Override
    int applyHash() {
        int original;
        int hash = original = super.applyHash();
        if (this.pages != null) {
            hash = 61 * hash + 17 * this.pages.hashCode();
        }
        return original != hash ? CraftMetaBook.class.hashCode() ^ hash : hash;
    }

    @Override
    boolean equalsCommon(CraftMetaItem meta) {
        if (!super.equalsCommon(meta)) {
            return false;
        }
        if (meta instanceof CraftMetaBook) {
            CraftMetaBook that = (CraftMetaBook)meta;
            return Objects.equals(this.pages, that.pages);
        }
        return true;
    }

    @Override
    boolean notUncommon(CraftMetaItem meta) {
        return super.notUncommon(meta) && (meta instanceof CraftMetaBook || this.isBookEmpty());
    }

    @Override
    ImmutableMap.Builder<String, Object> serialize(ImmutableMap.Builder<String, Object> builder) {
        super.serialize(builder);
        if (this.pages != null) {
            builder.put((Object)CraftMetaBook.BOOK_PAGES.BUKKIT, (Object)ImmutableList.copyOf(this.pages));
        }
        return builder;
    }
}

