/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R6.util;

import org.bukkit.entity.SpawnCategory;

public class CraftSpawnCategory {
    public static boolean isValidForLimits(SpawnCategory spawnCategory) {
        return spawnCategory != null && spawnCategory != SpawnCategory.MISC;
    }

    public static String getConfigNameSpawnLimit(SpawnCategory spawnCategory) {
        return switch (spawnCategory) {
            case SpawnCategory.MONSTER -> "spawn-limits.monsters";
            case SpawnCategory.ANIMAL -> "spawn-limits.animals";
            case SpawnCategory.WATER_ANIMAL -> "spawn-limits.water-animals";
            case SpawnCategory.WATER_AMBIENT -> "spawn-limits.water-ambient";
            case SpawnCategory.WATER_UNDERGROUND_CREATURE -> "spawn-limits.water-underground-creature";
            case SpawnCategory.AMBIENT -> "spawn-limits.ambient";
            case SpawnCategory.AXOLOTL -> "spawn-limits.axolotls";
            default -> throw new UnsupportedOperationException("Unknown Config value " + String.valueOf(spawnCategory) + " for spawn-limits");
        };
    }

    public static String getConfigNameTicksPerSpawn(SpawnCategory spawnCategory) {
        return switch (spawnCategory) {
            case SpawnCategory.MONSTER -> "ticks-per.monster-spawns";
            case SpawnCategory.ANIMAL -> "ticks-per.animal-spawns";
            case SpawnCategory.WATER_ANIMAL -> "ticks-per.water-spawns";
            case SpawnCategory.WATER_AMBIENT -> "ticks-per.water-ambient-spawns";
            case SpawnCategory.WATER_UNDERGROUND_CREATURE -> "ticks-per.water-underground-creature-spawns";
            case SpawnCategory.AMBIENT -> "ticks-per.ambient-spawns";
            case SpawnCategory.AXOLOTL -> "ticks-per.axolotl-spawns";
            default -> throw new UnsupportedOperationException("Unknown Config value " + String.valueOf(spawnCategory) + " for ticks-per");
        };
    }

    public static long getDefaultTicksPerSpawn(SpawnCategory spawnCategory) {
        return switch (spawnCategory) {
            case SpawnCategory.MONSTER, SpawnCategory.WATER_ANIMAL, SpawnCategory.WATER_AMBIENT, SpawnCategory.WATER_UNDERGROUND_CREATURE, SpawnCategory.AMBIENT, SpawnCategory.AXOLOTL -> 1L;
            case SpawnCategory.ANIMAL -> 400L;
            default -> throw new UnsupportedOperationException("Unknown Config value " + String.valueOf(spawnCategory) + " for ticks-per");
        };
    }

    public static SpawnCategory toBukkit(cez enumCreatureType) {
        return switch (enumCreatureType) {
            case cez.a -> SpawnCategory.MONSTER;
            case cez.b -> SpawnCategory.ANIMAL;
            case cez.c -> SpawnCategory.AMBIENT;
            case cez.d -> SpawnCategory.AXOLOTL;
            case cez.f -> SpawnCategory.WATER_ANIMAL;
            case cez.g -> SpawnCategory.WATER_AMBIENT;
            case cez.e -> SpawnCategory.WATER_UNDERGROUND_CREATURE;
            case cez.h -> SpawnCategory.MISC;
            default -> throw new UnsupportedOperationException("Unknown EnumCreatureType " + String.valueOf(enumCreatureType) + " for SpawnCategory");
        };
    }

    public static cez toNMS(SpawnCategory spawnCategory) {
        return switch (spawnCategory) {
            case SpawnCategory.MONSTER -> cez.a;
            case SpawnCategory.ANIMAL -> cez.b;
            case SpawnCategory.AMBIENT -> cez.c;
            case SpawnCategory.AXOLOTL -> cez.d;
            case SpawnCategory.WATER_ANIMAL -> cez.f;
            case SpawnCategory.WATER_AMBIENT -> cez.g;
            case SpawnCategory.WATER_UNDERGROUND_CREATURE -> cez.e;
            case SpawnCategory.MISC -> cez.h;
            default -> throw new UnsupportedOperationException("Unknown SpawnCategory " + String.valueOf(spawnCategory) + " for EnumCreatureType");
        };
    }
}

