/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.math;

import com.mojang.math.GivensParameters;
import org.apache.commons.lang3.tuple.Triple;
import org.joml.Math;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class MatrixUtil {
    private static final float a = 3.0f + 2.0f * Math.sqrt((float)2.0f);
    private static final GivensParameters b = GivensParameters.a(0.7853982f);

    private MatrixUtil() {
    }

    public static Matrix4f a(Matrix4f var0, float var1) {
        return var0.set(var0.m00() * var1, var0.m01() * var1, var0.m02() * var1, var0.m03() * var1, var0.m10() * var1, var0.m11() * var1, var0.m12() * var1, var0.m13() * var1, var0.m20() * var1, var0.m21() * var1, var0.m22() * var1, var0.m23() * var1, var0.m30() * var1, var0.m31() * var1, var0.m32() * var1, var0.m33() * var1);
    }

    private static GivensParameters a(float var0, float var1, float var2) {
        float var4 = var1;
        float var3 = 2.0f * (var0 - var2);
        if (a * var4 * var4 < var3 * var3) {
            return GivensParameters.a(var4, var3);
        }
        return b;
    }

    private static GivensParameters a(float var0, float var1) {
        float var2 = (float)java.lang.Math.hypot(var0, var1);
        float var3 = var2 > 1.0E-6f ? var1 : 0.0f;
        float var4 = Math.abs((float)var0) + Math.max((float)var2, (float)1.0E-6f);
        if (var0 < 0.0f) {
            float var5 = var3;
            var3 = var4;
            var4 = var5;
        }
        return GivensParameters.a(var3, var4);
    }

    private static void a(Matrix3f var0, Matrix3f var1) {
        var0.mul((Matrix3fc)var1);
        var1.transpose();
        var1.mul((Matrix3fc)var0);
        var0.set((Matrix3fc)var1);
    }

    private static void a(Matrix3f var0, Matrix3f var1, Quaternionf var2, Quaternionf var3) {
        Quaternionf var5;
        GivensParameters var4;
        if (var0.m01 * var0.m01 + var0.m10 * var0.m10 > 1.0E-6f) {
            var4 = MatrixUtil.a(var0.m00, 0.5f * (var0.m01 + var0.m10), var0.m11);
            var5 = var4.c(var2);
            var3.mul((Quaternionfc)var5);
            var4.c(var1);
            MatrixUtil.a(var0, var1);
        }
        if (var0.m02 * var0.m02 + var0.m20 * var0.m20 > 1.0E-6f) {
            var4 = MatrixUtil.a(var0.m00, 0.5f * (var0.m02 + var0.m20), var0.m22).a();
            var5 = var4.b(var2);
            var3.mul((Quaternionfc)var5);
            var4.b(var1);
            MatrixUtil.a(var0, var1);
        }
        if (var0.m12 * var0.m12 + var0.m21 * var0.m21 > 1.0E-6f) {
            var4 = MatrixUtil.a(var0.m11, 0.5f * (var0.m12 + var0.m21), var0.m22);
            var5 = var4.a(var2);
            var3.mul((Quaternionfc)var5);
            var4.a(var1);
            MatrixUtil.a(var0, var1);
        }
    }

    public static Quaternionf a(Matrix3f var0, int var1) {
        Quaternionf var2 = new Quaternionf();
        Matrix3f var3 = new Matrix3f();
        Quaternionf var4 = new Quaternionf();
        for (int var5 = 0; var5 < var1; ++var5) {
            MatrixUtil.a(var0, var3, var4, var2);
        }
        var2.normalize();
        return var2;
    }

    public static Triple<Quaternionf, Vector3f, Quaternionf> a(Matrix3f var0) {
        Matrix3f var1 = new Matrix3f((Matrix3fc)var0);
        var1.transpose();
        var1.mul((Matrix3fc)var0);
        Quaternionf var2 = MatrixUtil.a(var1, 5);
        float var3 = var1.m00;
        float var4 = var1.m11;
        boolean var5 = (double)var3 < 1.0E-6;
        boolean var6 = (double)var4 < 1.0E-6;
        Matrix3f var7 = var1;
        Matrix3f var8 = var0.rotate((Quaternionfc)var2);
        Quaternionf var9 = new Quaternionf();
        Quaternionf var10 = new Quaternionf();
        GivensParameters var11 = var5 ? MatrixUtil.a(var8.m11, -var8.m10) : MatrixUtil.a(var8.m00, var8.m01);
        Quaternionf var12 = var11.c(var10);
        Matrix3f var13 = var11.c(var7);
        var9.mul((Quaternionfc)var12);
        var13.transpose().mul((Matrix3fc)var8);
        var7 = var8;
        var11 = var5 ? MatrixUtil.a(var13.m22, -var13.m20) : MatrixUtil.a(var13.m00, var13.m02);
        var11 = var11.a();
        Quaternionf var14 = var11.b(var10);
        Matrix3f var15 = var11.b(var7);
        var9.mul((Quaternionfc)var14);
        var15.transpose().mul((Matrix3fc)var13);
        var7 = var13;
        var11 = var6 ? MatrixUtil.a(var15.m22, -var15.m21) : MatrixUtil.a(var15.m11, var15.m12);
        Quaternionf var16 = var11.a(var10);
        Matrix3f var17 = var11.a(var7);
        var9.mul((Quaternionfc)var16);
        var17.transpose().mul((Matrix3fc)var15);
        Vector3f var18 = new Vector3f(var17.m00, var17.m11, var17.m22);
        return Triple.of((Object)var9, (Object)var18, (Object)var2.conjugate());
    }

    private static boolean b(Matrix4fc var0, int var1) {
        return (var0.properties() & var1) != 0;
    }

    public static boolean a(Matrix4fc var0, int var1) {
        if (MatrixUtil.b(var0, var1)) {
            return true;
        }
        if (var0 instanceof Matrix4f) {
            Matrix4f var2 = (Matrix4f)var0;
            var2.determineProperties();
            return MatrixUtil.b(var0, var1);
        }
        return false;
    }

    public static boolean a(Matrix4fc var0) {
        return MatrixUtil.a(var0, 4);
    }

    public static boolean b(Matrix4fc var0) {
        return MatrixUtil.a(var0, 8);
    }

    public static boolean c(Matrix4fc var0) {
        return MatrixUtil.a(var0, 16);
    }
}

