/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments.selector.options;

import com.google.common.collect.Maps;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.logging.LogUtils;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.CriterionProgress;
import net.minecraft.advancements.critereon.CriterionConditionValue;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.commands.arguments.selector.ArgumentParserSelector;
import net.minecraft.commands.arguments.selector.EntitySelector;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.MojangsonParser;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.AdvancementDataPlayer;
import net.minecraft.server.AdvancementDataWorld;
import net.minecraft.server.ScoreboardServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.scores.ReadOnlyScoreInfo;
import net.minecraft.world.scores.ScoreHolder;
import net.minecraft.world.scores.ScoreboardObjective;
import net.minecraft.world.scores.ScoreboardTeam;
import net.minecraft.world.scores.ScoreboardTeamBase;
import org.slf4j.Logger;

public class PlayerSelector {
    private static final Logger i = LogUtils.getLogger();
    private static final Map<String, b> j = Maps.newHashMap();
    public static final DynamicCommandExceptionType a = new DynamicCommandExceptionType(var0 -> IChatBaseComponent.b("argument.entity.options.unknown", var0));
    public static final DynamicCommandExceptionType b = new DynamicCommandExceptionType(var0 -> IChatBaseComponent.b("argument.entity.options.inapplicable", var0));
    public static final SimpleCommandExceptionType c = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("argument.entity.options.distance.negative"));
    public static final SimpleCommandExceptionType d = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("argument.entity.options.level.negative"));
    public static final SimpleCommandExceptionType e = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("argument.entity.options.limit.toosmall"));
    public static final DynamicCommandExceptionType f = new DynamicCommandExceptionType(var0 -> IChatBaseComponent.b("argument.entity.options.sort.irreversible", var0));
    public static final DynamicCommandExceptionType g = new DynamicCommandExceptionType(var0 -> IChatBaseComponent.b("argument.entity.options.mode.invalid", var0));
    public static final DynamicCommandExceptionType h = new DynamicCommandExceptionType(var0 -> IChatBaseComponent.b("argument.entity.options.type.invalid", var0));

    private static void a(String var0, a var1, Predicate<ArgumentParserSelector> var2, IChatBaseComponent var3) {
        j.put(var0, new b(var1, var2, var3));
    }

    public static void a() {
        if (!j.isEmpty()) {
            return;
        }
        PlayerSelector.a("name", var0 -> {
            int var1 = var0.g().getCursor();
            boolean var22 = var0.e();
            String var3 = var0.g().readString();
            if (var0.w() && !var22) {
                var0.g().setCursor(var1);
                throw b.createWithContext((ImmutableStringReader)var0.g(), (Object)"name");
            }
            if (var22) {
                var0.c(true);
            } else {
                var0.b(true);
            }
            var0.a(var2 -> var2.ap().equals(var3) != var22);
        }, var0 -> !var0.v(), IChatBaseComponent.c("argument.entity.options.name.description"));
        PlayerSelector.a("distance", var0 -> {
            int var1 = var0.g().getCursor();
            CriterionConditionValue.DoubleRange var2 = CriterionConditionValue.DoubleRange.a(var0.g());
            if (var2.b().isPresent() && (Double)var2.b().get() < 0.0 || var2.c().isPresent() && (Double)var2.c().get() < 0.0) {
                var0.g().setCursor(var1);
                throw c.createWithContext((ImmutableStringReader)var0.g());
            }
            var0.a(var2);
            var0.h();
        }, var0 -> var0.i() == null, IChatBaseComponent.c("argument.entity.options.distance.description"));
        PlayerSelector.a("level", var0 -> {
            int var1 = var0.g().getCursor();
            CriterionConditionValue.IntegerRange var2 = CriterionConditionValue.IntegerRange.a(var0.g());
            if (var2.b().isPresent() && (Integer)var2.b().get() < 0 || var2.c().isPresent() && (Integer)var2.c().get() < 0) {
                var0.g().setCursor(var1);
                throw d.createWithContext((ImmutableStringReader)var0.g());
            }
            var0.a(var2);
            var0.a(false);
        }, var0 -> var0.j() == null, IChatBaseComponent.c("argument.entity.options.level.description"));
        PlayerSelector.a("x", var0 -> {
            var0.h();
            var0.a(var0.g().readDouble());
        }, var0 -> var0.m() == null, IChatBaseComponent.c("argument.entity.options.x.description"));
        PlayerSelector.a("y", var0 -> {
            var0.h();
            var0.b(var0.g().readDouble());
        }, var0 -> var0.n() == null, IChatBaseComponent.c("argument.entity.options.y.description"));
        PlayerSelector.a("z", var0 -> {
            var0.h();
            var0.c(var0.g().readDouble());
        }, var0 -> var0.o() == null, IChatBaseComponent.c("argument.entity.options.z.description"));
        PlayerSelector.a("dx", var0 -> {
            var0.h();
            var0.d(var0.g().readDouble());
        }, var0 -> var0.p() == null, IChatBaseComponent.c("argument.entity.options.dx.description"));
        PlayerSelector.a("dy", var0 -> {
            var0.h();
            var0.e(var0.g().readDouble());
        }, var0 -> var0.q() == null, IChatBaseComponent.c("argument.entity.options.dy.description"));
        PlayerSelector.a("dz", var0 -> {
            var0.h();
            var0.f(var0.g().readDouble());
        }, var0 -> var0.r() == null, IChatBaseComponent.c("argument.entity.options.dz.description"));
        PlayerSelector.a("x_rotation", var0 -> var0.a(CriterionConditionValue.c.a(var0.g())), var0 -> var0.k() == null, IChatBaseComponent.c("argument.entity.options.x_rotation.description"));
        PlayerSelector.a("y_rotation", var0 -> var0.b(CriterionConditionValue.c.a(var0.g())), var0 -> var0.l() == null, IChatBaseComponent.c("argument.entity.options.y_rotation.description"));
        PlayerSelector.a("limit", var0 -> {
            int var1 = var0.g().getCursor();
            int var2 = var0.g().readInt();
            if (var2 < 1) {
                var0.g().setCursor(var1);
                throw e.createWithContext((ImmutableStringReader)var0.g());
            }
            var0.a(var2);
            var0.d(true);
        }, var0 -> !var0.u() && !var0.x(), IChatBaseComponent.c("argument.entity.options.limit.description"));
        PlayerSelector.a("sort", var02 -> {
            int var12 = var02.g().getCursor();
            String var2 = var02.g().readUnquotedString();
            var02.a((var0, var1) -> ICompletionProvider.b(Arrays.asList("nearest", "furthest", "random", "arbitrary"), var0));
            var02.a(switch (var2) {
                case "nearest" -> ArgumentParserSelector.k;
                case "furthest" -> ArgumentParserSelector.l;
                case "random" -> ArgumentParserSelector.m;
                case "arbitrary" -> EntitySelector.b;
                default -> {
                    var02.g().setCursor(var12);
                    throw f.createWithContext((ImmutableStringReader)var02.g(), (Object)var2);
                }
            });
            var02.e(true);
        }, var0 -> !var0.u() && !var0.y(), IChatBaseComponent.c("argument.entity.options.sort.description"));
        PlayerSelector.a("gamemode", var0 -> {
            var0.a((var1, var2) -> {
                String var3 = var1.getRemaining().toLowerCase(Locale.ROOT);
                boolean var4 = !var0.A();
                boolean var5 = true;
                if (!var3.isEmpty()) {
                    if (var3.charAt(0) == '!') {
                        var4 = false;
                        var3 = var3.substring(1);
                    } else {
                        var5 = false;
                    }
                }
                for (EnumGamemode var9 : EnumGamemode.values()) {
                    if (!var9.b().toLowerCase(Locale.ROOT).startsWith(var3)) continue;
                    if (var5) {
                        var1.suggest("!" + var9.b());
                    }
                    if (!var4) continue;
                    var1.suggest(var9.b());
                }
                return var1.buildFuture();
            });
            int var12 = var0.g().getCursor();
            boolean var22 = var0.e();
            if (var0.A() && !var22) {
                var0.g().setCursor(var12);
                throw b.createWithContext((ImmutableStringReader)var0.g(), (Object)"gamemode");
            }
            String var3 = var0.g().readUnquotedString();
            EnumGamemode var4 = EnumGamemode.a(var3, null);
            if (var4 == null) {
                var0.g().setCursor(var12);
                throw g.createWithContext((ImmutableStringReader)var0.g(), (Object)var3);
            }
            var0.a(false);
            var0.a(var2 -> {
                if (var2 instanceof EntityPlayer) {
                    EntityPlayer var3 = (EntityPlayer)var2;
                    EnumGamemode var4 = var3.a();
                    return var4 == var4 ^ var22;
                }
                return false;
            });
            if (var22) {
                var0.g(true);
            } else {
                var0.f(true);
            }
        }, var0 -> !var0.z(), IChatBaseComponent.c("argument.entity.options.gamemode.description"));
        PlayerSelector.a("team", var0 -> {
            boolean var1 = var0.e();
            String var22 = var0.g().readUnquotedString();
            var0.a(var2 -> {
                ScoreboardTeam var3 = var2.cD();
                String var4 = var3 == null ? "" : ((ScoreboardTeamBase)var3).c();
                return var4.equals(var22) != var1;
            });
            if (var1) {
                var0.i(true);
            } else {
                var0.h(true);
            }
        }, var0 -> !var0.B(), IChatBaseComponent.c("argument.entity.options.team.description"));
        PlayerSelector.a("type", var0 -> {
            var0.a((var1, var2) -> {
                ICompletionProvider.a(BuiltInRegistries.g.i(), var1, String.valueOf('!'));
                ICompletionProvider.a(BuiltInRegistries.g.l().map(var0 -> var0.h().b()), var1, "!#");
                if (!var0.F()) {
                    ICompletionProvider.a(BuiltInRegistries.g.i(), var1);
                    ICompletionProvider.a(BuiltInRegistries.g.l().map(var0 -> var0.h().b()), var1, String.valueOf('#'));
                }
                return var1.buildFuture();
            });
            int var12 = var0.g().getCursor();
            boolean var22 = var0.e();
            if (var0.F() && !var22) {
                var0.g().setCursor(var12);
                throw b.createWithContext((ImmutableStringReader)var0.g(), (Object)"type");
            }
            if (var22) {
                var0.D();
            }
            if (var0.f()) {
                TagKey<EntityTypes<?>> var3 = TagKey.a(Registries.E, MinecraftKey.a(var0.g()));
                var0.a(var2 -> var2.ax().a(var3) != var22);
            } else {
                MinecraftKey var3 = MinecraftKey.a(var0.g());
                EntityTypes var4 = (EntityTypes)BuiltInRegistries.g.b(var3).orElseThrow(() -> {
                    var0.g().setCursor(var12);
                    return h.createWithContext((ImmutableStringReader)var0.g(), (Object)var3.toString());
                });
                if (Objects.equals(EntityTypes.bX, var4) && !var22) {
                    var0.a(false);
                }
                var0.a(var2 -> Objects.equals(var4, var2.ax()) != var22);
                if (!var22) {
                    var0.a(var4);
                }
            }
        }, var0 -> !var0.E(), IChatBaseComponent.c("argument.entity.options.type.description"));
        PlayerSelector.a("tag", var0 -> {
            boolean var1 = var0.e();
            String var22 = var0.g().readUnquotedString();
            var0.a(var2 -> {
                if ("".equals(var22)) {
                    return var2.aA().isEmpty() != var1;
                }
                return var2.aA().contains(var22) != var1;
            });
        }, var0 -> true, IChatBaseComponent.c("argument.entity.options.tag.description"));
        PlayerSelector.a("nbt", var0 -> {
            boolean var1 = var0.e();
            NBTTagCompound var22 = MojangsonParser.c(var0.g());
            var0.a(var2 -> {
                try (ProblemReporter.j var3 = new ProblemReporter.j(var2.en(), i);){
                    EntityPlayer var5;
                    ItemStack var6;
                    TagValueOutput var4 = TagValueOutput.a(var3, var2.ej());
                    var2.d(var4);
                    if (var2 instanceof EntityPlayer && !(var6 = (var5 = (EntityPlayer)var2).gB().h()).f()) {
                        var4.a("SelectedItem", ItemStack.b, var6);
                    }
                    boolean bl = GameProfileSerializer.a((NBTBase)var22, var4.b(), true) != var1;
                    return bl;
                }
            });
        }, var0 -> true, IChatBaseComponent.c("argument.entity.options.nbt.description"));
        PlayerSelector.a("scores", var0 -> {
            StringReader var12 = var0.g();
            HashMap var2 = Maps.newHashMap();
            var12.expect('{');
            var12.skipWhitespace();
            while (var12.canRead() && var12.peek() != '}') {
                var12.skipWhitespace();
                String var3 = var12.readUnquotedString();
                var12.skipWhitespace();
                var12.expect('=');
                var12.skipWhitespace();
                CriterionConditionValue.IntegerRange var4 = CriterionConditionValue.IntegerRange.a(var12);
                var2.put(var3, var4);
                var12.skipWhitespace();
                if (!var12.canRead() || var12.peek() != ',') continue;
                var12.skip();
            }
            var12.expect('}');
            if (!var2.isEmpty()) {
                var0.a(var1 -> {
                    ScoreboardServer var2 = var1.an().q().aO();
                    for (Map.Entry var4 : var2.entrySet()) {
                        ScoreboardObjective var5 = var2.a((String)var4.getKey());
                        if (var5 == null) {
                            return false;
                        }
                        ReadOnlyScoreInfo var6 = var2.d((ScoreHolder)var1, var5);
                        if (var6 == null) {
                            return false;
                        }
                        if (((CriterionConditionValue.IntegerRange)var4.getValue()).d(var6.a())) continue;
                        return false;
                    }
                    return true;
                });
            }
            var0.j(true);
        }, var0 -> !var0.G(), IChatBaseComponent.c("argument.entity.options.scores.description"));
        PlayerSelector.a("advancements", var0 -> {
            StringReader var12 = var0.g();
            HashMap var2 = Maps.newHashMap();
            var12.expect('{');
            var12.skipWhitespace();
            while (var12.canRead() && var12.peek() != '}') {
                var12.skipWhitespace();
                MinecraftKey var3 = MinecraftKey.a(var12);
                var12.skipWhitespace();
                var12.expect('=');
                var12.skipWhitespace();
                if (var12.canRead() && var12.peek() == '{') {
                    HashMap var4 = Maps.newHashMap();
                    var12.skipWhitespace();
                    var12.expect('{');
                    var12.skipWhitespace();
                    while (var12.canRead() && var12.peek() != '}') {
                        var12.skipWhitespace();
                        String var5 = var12.readUnquotedString();
                        var12.skipWhitespace();
                        var12.expect('=');
                        var12.skipWhitespace();
                        boolean var6 = var12.readBoolean();
                        var4.put(var5, var1 -> var1.a() == var6);
                        var12.skipWhitespace();
                        if (!var12.canRead() || var12.peek() != ',') continue;
                        var12.skip();
                    }
                    var12.skipWhitespace();
                    var12.expect('}');
                    var12.skipWhitespace();
                    var2.put(var3, var1 -> {
                        for (Map.Entry var3 : var4.entrySet()) {
                            CriterionProgress var4 = var1.c((String)var3.getKey());
                            if (var4 != null && ((Predicate)var3.getValue()).test(var4)) continue;
                            return false;
                        }
                        return true;
                    });
                } else {
                    boolean var4 = var12.readBoolean();
                    var2.put(var3, var1 -> var1.a() == var4);
                }
                var12.skipWhitespace();
                if (!var12.canRead() || var12.peek() != ',') continue;
                var12.skip();
            }
            var12.expect('}');
            if (!var2.isEmpty()) {
                var0.a(var1 -> {
                    if (!(var1 instanceof EntityPlayer)) {
                        return false;
                    }
                    EntityPlayer var2 = (EntityPlayer)var1;
                    AdvancementDataPlayer var3 = var2.U();
                    AdvancementDataWorld var4 = var2.A().q().aF();
                    for (Map.Entry var6 : var2.entrySet()) {
                        AdvancementHolder var7 = var4.a((MinecraftKey)var6.getKey());
                        if (var7 != null && ((Predicate)var6.getValue()).test(var3.b(var7))) continue;
                        return false;
                    }
                    return true;
                });
                var0.a(false);
            }
            var0.k(true);
        }, var0 -> !var0.H(), IChatBaseComponent.c("argument.entity.options.advancements.description"));
        PlayerSelector.a("predicate", var0 -> {
            boolean var1 = var0.e();
            ResourceKey<LootItemCondition> var22 = ResourceKey.a(Registries.bB, MinecraftKey.a(var0.g()));
            var0.a(var2 -> {
                Object var4 = var2.an();
                if (!(var4 instanceof WorldServer)) {
                    return false;
                }
                WorldServer var3 = (WorldServer)var4;
                var4 = var3.q().bi().a().c(var22).map(Holder::a);
                if (((Optional)var4).isEmpty()) {
                    return false;
                }
                LootParams var5 = new LootParams.a(var3).a(LootContextParameters.a, var2).a(LootContextParameters.h, var2.dD()).a(LootContextParameterSets.e);
                LootTableInfo var6 = new LootTableInfo.Builder(var5).a(Optional.empty());
                var6.b(LootTableInfo.a((LootItemCondition)((Optional)var4).get()));
                return var1 ^ ((LootItemCondition)((Optional)var4).get()).test(var6);
            });
        }, var0 -> true, IChatBaseComponent.c("argument.entity.options.predicate.description"));
    }

    public static a a(ArgumentParserSelector var0, String var1, int var2) throws CommandSyntaxException {
        b var3 = j.get(var1);
        if (var3 != null) {
            if (var3.b.test(var0)) {
                return var3.a;
            }
            throw b.createWithContext((ImmutableStringReader)var0.g(), (Object)var1);
        }
        var0.g().setCursor(var2);
        throw a.createWithContext((ImmutableStringReader)var0.g(), (Object)var1);
    }

    public static void a(ArgumentParserSelector var0, SuggestionsBuilder var1) {
        String var2 = var1.getRemaining().toLowerCase(Locale.ROOT);
        for (Map.Entry<String, b> var4 : j.entrySet()) {
            if (!var4.getValue().b.test(var0) || !var4.getKey().toLowerCase(Locale.ROOT).startsWith(var2)) continue;
            var1.suggest(var4.getKey() + "=", (Message)var4.getValue().c);
        }
    }

    static final class b
    extends Record {
        final a a;
        final Predicate<ArgumentParserSelector> b;
        final IChatBaseComponent c;

        b(a var0, Predicate<ArgumentParserSelector> var1, IChatBaseComponent var2) {
            this.a = var0;
            this.b = var1;
            this.c = var2;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "modifier;canUse;description", "a", "b", "c"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "modifier;canUse;description", "a", "b", "c"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "modifier;canUse;description", "a", "b", "c"}, this, var0);
        }

        public a a() {
            return this.a;
        }

        public Predicate<ArgumentParserSelector> b() {
            return this.b;
        }

        public IChatBaseComponent c() {
            return this.c;
        }
    }

    @FunctionalInterface
    public static interface a {
        public void handle(ArgumentParserSelector var1) throws CommandSyntaxException;
    }
}

