/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.resources;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.IRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;

public final class RegistryFileCodec<E>
implements Codec<Holder<E>> {
    private final ResourceKey<? extends IRegistry<E>> a;
    private final Codec<E> b;
    private final boolean c;

    public static <E> RegistryFileCodec<E> a(ResourceKey<? extends IRegistry<E>> var0, Codec<E> var1) {
        return RegistryFileCodec.a(var0, var1, true);
    }

    public static <E> RegistryFileCodec<E> a(ResourceKey<? extends IRegistry<E>> var0, Codec<E> var1, boolean var2) {
        return new RegistryFileCodec<E>(var0, var1, var2);
    }

    private RegistryFileCodec(ResourceKey<? extends IRegistry<E>> var0, Codec<E> var1, boolean var2) {
        this.a = var0;
        this.b = var1;
        this.c = var2;
    }

    public <T> DataResult<T> a(Holder<E> var0, DynamicOps<T> var1, T var22) {
        RegistryOps var3;
        Optional var4;
        if (var1 instanceof RegistryOps && (var4 = (var3 = (RegistryOps)var1).a(this.a)).isPresent()) {
            if (!var0.a(var4.get())) {
                return DataResult.error(() -> "Element " + String.valueOf(var0) + " is not valid in current registry set");
            }
            return (DataResult)var0.d().map(var2 -> MinecraftKey.a.encode((Object)var2.a(), var1, var22), var2 -> this.b.encode(var2, var1, var22));
        }
        return this.b.encode(var0.a(), var1, var22);
    }

    public <T> DataResult<Pair<Holder<E>, T>> decode(DynamicOps<T> var02, T var12) {
        if (var02 instanceof RegistryOps) {
            RegistryOps var2 = (RegistryOps)var02;
            Optional var3 = var2.b(this.a);
            if (var3.isEmpty()) {
                return DataResult.error(() -> "Registry does not exist: " + String.valueOf(this.a));
            }
            HolderGetter var4 = var3.get();
            DataResult var5 = MinecraftKey.a.decode(var02, var12);
            if (var5.result().isEmpty()) {
                if (!this.c) {
                    return DataResult.error(() -> "Inline definitions not allowed here");
                }
                return this.b.decode(var02, var12).map(var0 -> var0.mapFirst(Holder::a));
            }
            Pair var6 = (Pair)var5.result().get();
            ResourceKey var7 = ResourceKey.a(this.a, (MinecraftKey)var6.getFirst());
            return var4.a(var7).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Failed to get element " + String.valueOf(var7))).map(var1 -> Pair.of((Object)var1, (Object)var6.getSecond())).setLifecycle(Lifecycle.stable());
        }
        return this.b.decode(var02, var12).map(var0 -> var0.mapFirst(Holder::a));
    }

    public String toString() {
        return "RegistryFileCodec[" + String.valueOf(this.a) + " " + String.valueOf(this.b) + "]";
    }

    public /* synthetic */ DataResult encode(Object object, DynamicOps dynamicOps, Object object2) {
        return this.a((Holder)object, dynamicOps, object2);
    }
}

