/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.dedicated;

import com.google.common.base.MoreObjects;
import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import joptsimple.OptionSet;
import net.minecraft.core.IRegistryCustom;
import org.slf4j.Logger;

public abstract class PropertyManager<T extends PropertyManager<T>> {
    private static final Logger a = LogUtils.getLogger();
    public final Properties ak;
    private OptionSet options = null;

    public PropertyManager(Properties properties, OptionSet options) {
        this.ak = properties;
        this.options = options;
    }

    private String getOverride(String name, String value) {
        if (this.options != null && this.options.has(name)) {
            return String.valueOf(this.options.valueOf(name));
        }
        return value;
    }

    public static Properties b(Path path) {
        Properties properties;
        block18: {
            if (!path.toFile().exists()) {
                return new Properties();
            }
            InputStream inputstream = Files.newInputStream(path, new OpenOption[0]);
            try {
                CharsetDecoder charsetdecoder = StandardCharsets.UTF_8.newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
                Properties properties2 = new Properties();
                properties2.load(new InputStreamReader(inputstream, charsetdecoder));
                properties = properties2;
                if (inputstream == null) break block18;
            }
            catch (Throwable charsetdecoder) {
                try {
                    if (inputstream != null) {
                        try {
                            inputstream.close();
                        }
                        catch (Throwable properties2) {
                            charsetdecoder.addSuppressed(properties2);
                        }
                    }
                    throw charsetdecoder;
                }
                catch (CharacterCodingException charactercodingexception) {
                    Properties properties3;
                    block19: {
                        a.info("Failed to load properties as UTF-8 from file {}, trying ISO_8859_1", (Object)path);
                        BufferedReader reader = Files.newBufferedReader(path, StandardCharsets.ISO_8859_1);
                        try {
                            Properties properties1 = new Properties();
                            properties1.load(reader);
                            properties3 = properties1;
                            if (reader == null) break block19;
                        }
                        catch (Throwable throwable) {
                            try {
                                if (reader != null) {
                                    try {
                                        ((Reader)reader).close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            catch (IOException ioexception) {
                                a.error("Failed to load properties from file: {}", (Object)path, (Object)ioexception);
                                return new Properties();
                            }
                        }
                        ((Reader)reader).close();
                    }
                    return properties3;
                }
            }
            inputstream.close();
        }
        return properties;
    }

    public void c(Path path) {
        if (path.toFile().exists() && !path.toFile().canWrite()) {
            return;
        }
        try (BufferedWriter writer = Files.newBufferedWriter(path, StandardCharsets.UTF_8, new OpenOption[0]);){
            this.ak.store(writer, "Minecraft server properties");
        }
        catch (IOException ioexception) {
            a.error("Failed to store properties to file: {}", (Object)path);
        }
    }

    private static <V extends Number> Function<String, V> a(Function<String, V> function) {
        return s2 -> {
            try {
                return (Number)function.apply((String)s2);
            }
            catch (NumberFormatException numberformatexception) {
                return null;
            }
        };
    }

    protected static <V> Function<String, V> a(IntFunction<V> intfunction, Function<String, V> function) {
        return s2 -> {
            try {
                return intfunction.apply(Integer.parseInt(s2));
            }
            catch (NumberFormatException numberformatexception) {
                return function.apply((String)s2);
            }
        };
    }

    @Nullable
    private String c(String s2) {
        return this.getOverride(s2, this.ak.getProperty(s2));
    }

    @Nullable
    protected <V> V a(String s2, Function<String, V> function) {
        String s1 = this.c(s2);
        if (s1 == null) {
            return null;
        }
        this.ak.remove(s2);
        return function.apply(s1);
    }

    protected <V> V a(String s2, Function<String, V> function, Function<V, String> function1, V v0) {
        try {
            return this.get0(s2, function, function1, v0);
        }
        catch (Exception ex) {
            throw new RuntimeException("Could not load invalidly configured property '" + s2 + "'", ex);
        }
    }

    private <V> V get0(String s2, Function<String, V> function, Function<V, String> function1, V v0) {
        String s1 = this.c(s2);
        Object v1 = MoreObjects.firstNonNull(s1 != null ? function.apply(s1) : null, v0);
        this.ak.put(s2, function1.apply(v1));
        return (V)v1;
    }

    protected <V> EditableProperty<V> b(String s2, Function<String, V> function, Function<V, String> function1, V v0) {
        String s1 = this.c(s2);
        Object v1 = MoreObjects.firstNonNull(s1 != null ? function.apply(s1) : null, v0);
        this.ak.put(s2, function1.apply(v1));
        return new EditableProperty<Object>(s2, v1, function1);
    }

    protected <V> V a(String s2, Function<String, V> function, UnaryOperator<V> unaryoperator, Function<V, String> function1, V v0) {
        return (V)this.a(s2, s1 -> {
            Object v1 = function.apply((String)s1);
            return v1 != null ? unaryoperator.apply(v1) : null;
        }, function1, v0);
    }

    protected <V> V a(String s2, Function<String, V> function, V v0) {
        return (V)this.a(s2, function, Objects::toString, v0);
    }

    protected <V> EditableProperty<V> b(String s2, Function<String, V> function, V v0) {
        return this.b(s2, function, Objects::toString, v0);
    }

    protected String a(String s2, String s1) {
        return this.a(s2, Function.identity(), Function.identity(), s1);
    }

    @Nullable
    protected String a(String s2) {
        return (String)this.a(s2, Function.identity());
    }

    protected int a(String s2, int i2) {
        return this.a(s2, PropertyManager.a(Integer::parseInt), Integer.valueOf(i2));
    }

    protected EditableProperty<Integer> b(String s2, int i2) {
        return this.b(s2, PropertyManager.a(Integer::parseInt), i2);
    }

    protected EditableProperty<String> b(String s2, String s1) {
        return this.b(s2, String::new, s1);
    }

    protected int a(String s2, UnaryOperator<Integer> unaryoperator, int i2) {
        return this.a(s2, PropertyManager.a(Integer::parseInt), unaryoperator, Objects::toString, i2);
    }

    protected long a(String s2, long i2) {
        return this.a(s2, PropertyManager.a(Long::parseLong), i2);
    }

    protected boolean a(String s2, boolean flag) {
        return this.a(s2, Boolean::valueOf, flag);
    }

    protected EditableProperty<Boolean> b(String s2, boolean flag) {
        return this.b(s2, Boolean::valueOf, flag);
    }

    @Nullable
    protected Boolean b(String s2) {
        return this.a(s2, Boolean::valueOf);
    }

    protected Properties a() {
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.ak);
        return properties;
    }

    protected abstract T reload(IRegistryCustom var1, Properties var2, OptionSet var3);

    public class EditableProperty<V>
    implements Supplier<V> {
        private final String b;
        private final V c;
        private final Function<V, String> d;

        EditableProperty(String s2, V object, Function function) {
            this.b = s2;
            this.c = object;
            this.d = function;
        }

        @Override
        public V get() {
            return this.c;
        }

        public T a(IRegistryCustom iregistrycustom, V v0) {
            Properties properties = PropertyManager.this.a();
            properties.put(this.b, this.d.apply(v0));
            return PropertyManager.this.reload(iregistrycustom, properties, PropertyManager.this.options);
        }
    }
}

