/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.dedicated;

import com.google.common.collect.Streams;
import com.mojang.logging.LogUtils;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.nio.file.Path;
import java.util.Locale;
import java.util.Timer;
import java.util.TimerTask;
import java.util.stream.Collectors;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportType;
import net.minecraft.SystemUtils;
import net.minecraft.server.DispenserRegistry;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.util.TimeRange;
import net.minecraft.world.level.GameRules;
import org.slf4j.Logger;

public class ThreadWatchdog
implements Runnable {
    private static final Logger a = LogUtils.getLogger();
    private static final long b = 10000L;
    private static final int c = 1;
    private final DedicatedServer d;
    private final long e;

    public ThreadWatchdog(DedicatedServer var0) {
        this.d = var0;
        this.e = var0.bJ() * TimeRange.b;
    }

    @Override
    public void run() {
        while (this.d.B()) {
            long var0 = this.d.aD();
            long var2 = SystemUtils.d();
            long var4 = var2 - var0;
            if (var4 > this.e) {
                a.error(LogUtils.FATAL_MARKER, "A single server tick took {} seconds (should be max {})", (Object)String.format(Locale.ROOT, "%.2f", Float.valueOf((float)var4 / (float)TimeRange.a)), (Object)String.format(Locale.ROOT, "%.2f", Float.valueOf(this.d.aV().g() / (float)TimeRange.c)));
                a.error(LogUtils.FATAL_MARKER, "Considering it to be crashed, server will forcibly shutdown.");
                CrashReport var6 = ThreadWatchdog.a("Watching Server", this.d.aA().threadId());
                this.d.b(var6.f());
                CrashReportSystemDetails var7 = var6.a("Performance stats");
                var7.a("Random tick rate", () -> this.d.bf().n().b(GameRules.p).toString());
                var7.a("Level stats", () -> Streams.stream(this.d.Q()).map(var0 -> String.valueOf(var0.al().a()) + ": " + var0.J()).collect(Collectors.joining(",\n")));
                DispenserRegistry.a("Crash report:\n" + var6.a(ReportType.a));
                Path var8 = this.d.I().resolve("crash-reports").resolve("crash-" + SystemUtils.f() + "-server.txt");
                if (var6.a(var8, ReportType.a)) {
                    a.error("This crash report has been saved to: {}", (Object)var8.toAbsolutePath());
                } else {
                    a.error("We were unable to save this crash report to disk.");
                }
                this.a();
            }
            try {
                Thread.sleep((var0 + this.e - var2) / TimeRange.b);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public static CrashReport a(String var0, long var1) {
        ThreadMXBean var3 = ManagementFactory.getThreadMXBean();
        ThreadInfo[] var4 = var3.dumpAllThreads(true, true);
        StringBuilder var5 = new StringBuilder();
        Error var6 = new Error("Watchdog");
        for (ThreadInfo var10 : var4) {
            if (var10.getThreadId() == var1) {
                var6.setStackTrace(var10.getStackTrace());
            }
            var5.append(var10);
            var5.append("\n");
        }
        CrashReport var7 = new CrashReport(var0, var6);
        CrashReportSystemDetails var8 = var7.a("Thread Dump");
        var8.a("Threads", var5);
        return var7;
    }

    private void a() {
        try {
            Timer var0 = new Timer();
            var0.schedule(new TimerTask(this){

                @Override
                public void run() {
                    Runtime.getRuntime().halt(1);
                }
            }, 10000L);
            System.exit(1);
        }
        catch (Throwable var0) {
            Runtime.getRuntime().halt(1);
        }
    }
}

