/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import java.util.EnumSet;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerMove;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.monster.IMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityLargeFireball;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;

public class EntityGhast
extends EntityInsentient
implements IMonster {
    private static final DataWatcherObject<Boolean> a = DataWatcher.a(EntityGhast.class, DataWatcherRegistry.k);
    private static final byte b = 1;
    private int c = 1;

    public EntityGhast(EntityTypes<? extends EntityGhast> entitytypes, World world) {
        super((EntityTypes<? extends EntityInsentient>)entitytypes, world);
        this.cl = 5;
        this.cn = new ControllerGhast(this, false, () -> false);
    }

    @Override
    protected void H() {
        this.cq.a(5, new PathfinderGoalGhastIdleMove(this));
        this.cq.a(7, new PathfinderGoalGhastMoveTowardsTarget(this));
        this.cq.a(7, new PathfinderGoalGhastAttackTarget(this));
        this.cr.a(1, new PathfinderGoalNearestAttackableTarget<EntityHuman>(this, EntityHuman.class, 10, true, false, (entityliving, worldserver) -> Math.abs(entityliving.dM() - this.dM()) <= 4.0));
    }

    public boolean k() {
        return this.az.a(a);
    }

    public void x(boolean flag) {
        this.az.a(a, flag);
    }

    public int m() {
        return this.c;
    }

    private static boolean i(DamageSource damagesource) {
        return damagesource.c() instanceof EntityLargeFireball && damagesource.d() instanceof EntityHuman;
    }

    @Override
    public boolean a(WorldServer worldserver, DamageSource damagesource) {
        return this.cP() && !damagesource.a(DamageTypeTags.d) || !EntityGhast.i(damagesource) && super.a(worldserver, damagesource);
    }

    @Override
    protected void a(double d0, boolean flag, IBlockData iblockdata, BlockPosition blockposition) {
    }

    @Override
    public boolean fe() {
        return false;
    }

    @Override
    public void m(Vec3D vec3d) {
        this.a(vec3d, 0.02f);
    }

    @Override
    public boolean a(WorldServer worldserver, DamageSource damagesource, float f2) {
        if (EntityGhast.i(damagesource)) {
            super.a(worldserver, damagesource, 1000.0f);
            return true;
        }
        return this.a(worldserver, damagesource) ? false : super.a(worldserver, damagesource, f2);
    }

    @Override
    protected void a(DataWatcher.a datawatcher_a) {
        super.a(datawatcher_a);
        datawatcher_a.a(a, false);
    }

    public static AttributeProvider.Builder n() {
        return EntityInsentient.I().a(GenericAttributes.t, 10.0).a(GenericAttributes.n, 100.0).a(GenericAttributes.i, 8.0).a(GenericAttributes.m, 0.06);
    }

    @Override
    public SoundCategory dw() {
        return SoundCategory.f;
    }

    @Override
    protected SoundEffect p() {
        return SoundEffects.lC;
    }

    @Override
    protected SoundEffect e(DamageSource damagesource) {
        return SoundEffects.lE;
    }

    @Override
    protected SoundEffect f_() {
        return SoundEffects.lD;
    }

    @Override
    protected float ft() {
        return 5.0f;
    }

    public static boolean b(EntityTypes<EntityGhast> entitytypes, GeneratorAccess generatoraccess, EntitySpawnReason entityspawnreason, BlockPosition blockposition, RandomSource randomsource) {
        return generatoraccess.aq() != EnumDifficulty.a && randomsource.a(20) == 0 && EntityGhast.a(entitytypes, generatoraccess, entityspawnreason, blockposition, randomsource);
    }

    @Override
    public int ak() {
        return 1;
    }

    @Override
    protected void a(ValueOutput valueoutput) {
        super.a(valueoutput);
        valueoutput.a("ExplosionPower", (byte)this.c);
    }

    @Override
    protected void a(ValueInput valueinput) {
        super.a(valueinput);
        this.c = valueinput.a("ExplosionPower", (byte)1);
    }

    @Override
    public boolean dT() {
        return true;
    }

    @Override
    public double B() {
        return 10.0;
    }

    @Override
    public double A() {
        return 16.0;
    }

    public static void a(EntityInsentient entityinsentient) {
        if (entityinsentient.e() == null) {
            Vec3D vec3d = entityinsentient.dI();
            entityinsentient.v(-((float)MathHelper.d(vec3d.g, vec3d.i)) * 57.295776f);
            entityinsentient.bB = entityinsentient.dX();
        } else {
            EntityLiving entityliving = entityinsentient.e();
            double d0 = 64.0;
            if (entityliving.g(entityinsentient) < 4096.0) {
                double d1 = entityliving.dK() - entityinsentient.dK();
                double d2 = entityliving.dQ() - entityinsentient.dQ();
                entityinsentient.v(-((float)MathHelper.d(d1, d2)) * 57.295776f);
                entityinsentient.bB = entityinsentient.dX();
            }
        }
    }

    public static class ControllerGhast
    extends ControllerMove {
        private final EntityInsentient l;
        private int m;
        private final boolean n;
        private final BooleanSupplier o;

        public ControllerGhast(EntityInsentient entityinsentient, boolean flag, BooleanSupplier booleansupplier) {
            super(entityinsentient);
            this.l = entityinsentient;
            this.n = flag;
            this.o = booleansupplier;
        }

        @Override
        public void a() {
            if (this.o.getAsBoolean()) {
                this.k = ControllerMove.Operation.a;
                this.l.aa();
            }
            if (this.k == ControllerMove.Operation.b && this.m-- <= 0) {
                this.m += this.l.ek().a(5) + 2;
                Vec3D vec3d = new Vec3D(this.e - this.l.dK(), this.f - this.l.dM(), this.g - this.l.dQ());
                if (this.a(vec3d)) {
                    this.l.k(this.l.dI().e(vec3d.d().c(this.l.i(GenericAttributes.m) * 5.0 / 3.0)));
                } else {
                    this.k = ControllerMove.Operation.a;
                }
            }
        }

        private boolean a(Vec3D vec3d) {
            AxisAlignedBB axisalignedbb = this.l.de();
            AxisAlignedBB axisalignedbb1 = axisalignedbb.c(vec3d);
            if (this.n) {
                for (BlockPosition blockposition : BlockPosition.a(axisalignedbb1.g(1.0))) {
                    if (this.a(this.l.an(), null, null, blockposition, false, false)) continue;
                    return false;
                }
            }
            boolean flag = this.l.bu();
            boolean flag1 = this.l.bJ();
            Vec3D vec3d1 = this.l.dD();
            Vec3D vec3d2 = vec3d1.e(vec3d);
            return IBlockAccess.a(vec3d1, vec3d2, axisalignedbb1, (blockposition1, i2) -> axisalignedbb.b(blockposition1) ? true : this.a(this.l.an(), vec3d1, vec3d2, blockposition1, flag, flag1));
        }

        private boolean a(IBlockAccess iblockaccess, @Nullable Vec3D vec3d, @Nullable Vec3D vec3d1, BlockPosition blockposition, boolean flag, boolean flag1) {
            boolean flag3;
            boolean flag2;
            IBlockData iblockdata = iblockaccess.a_(blockposition);
            if (iblockdata.l()) {
                return true;
            }
            boolean bl = flag2 = vec3d != null && vec3d1 != null;
            boolean bl2 = flag2 ? !this.l.a(vec3d, vec3d1, iblockdata.g(iblockaccess, blockposition).a(new Vec3D(blockposition)).e()) : (flag3 = iblockdata.g(iblockaccess, blockposition).c());
            if (!this.n) {
                return flag3;
            }
            if (iblockdata.a(TagsBlock.bC)) {
                return false;
            }
            Fluid fluid = iblockaccess.b_(blockposition);
            if (!(fluid.c() || flag2 && !this.l.a(fluid, blockposition, vec3d, vec3d1))) {
                if (fluid.a(TagsFluid.a)) {
                    return flag;
                }
                if (fluid.a(TagsFluid.b)) {
                    return flag1;
                }
            }
            return flag3;
        }
    }

    public static class PathfinderGoalGhastIdleMove
    extends PathfinderGoal {
        private static final int a = 64;
        private final EntityInsentient b;
        private final int c;

        public PathfinderGoalGhastIdleMove(EntityInsentient entityinsentient) {
            this(entityinsentient, 0);
        }

        public PathfinderGoalGhastIdleMove(EntityInsentient entityinsentient, int i2) {
            this.b = entityinsentient;
            this.c = i2;
            this.a(EnumSet.of(PathfinderGoal.Type.a));
        }

        @Override
        public boolean b() {
            double d2;
            double d1;
            ControllerMove controllermove = this.b.Q();
            if (!controllermove.b()) {
                return true;
            }
            double d0 = controllermove.d() - this.b.dK();
            double d3 = d0 * d0 + (d1 = controllermove.e() - this.b.dM()) * d1 + (d2 = controllermove.f() - this.b.dQ()) * d2;
            return d3 < 1.0 || d3 > 3600.0;
        }

        @Override
        public boolean c() {
            return false;
        }

        @Override
        public void d() {
            Vec3D vec3d = PathfinderGoalGhastIdleMove.a(this.b, this.c);
            this.b.Q().a(vec3d.a(), vec3d.b(), vec3d.c(), 1.0);
        }

        public static Vec3D a(EntityInsentient entityinsentient, int i2) {
            BlockPosition blockposition;
            int k2;
            World world = entityinsentient.an();
            RandomSource randomsource = entityinsentient.ek();
            Vec3D vec3d = entityinsentient.dD();
            Vec3D vec3d1 = null;
            for (int j2 = 0; j2 < 64; ++j2) {
                vec3d1 = PathfinderGoalGhastIdleMove.a(entityinsentient, vec3d, randomsource);
                if (vec3d1 == null || !PathfinderGoalGhastIdleMove.a(world, vec3d1, i2)) continue;
                return vec3d1;
            }
            if (vec3d1 == null) {
                vec3d1 = PathfinderGoalGhastIdleMove.a(vec3d, randomsource);
            }
            if ((k2 = world.a(HeightMap.Type.e, (blockposition = BlockPosition.a(vec3d1)).u(), blockposition.w())) < blockposition.v() && k2 > world.M_()) {
                vec3d1 = new Vec3D(vec3d1.a(), entityinsentient.dM() - Math.abs(entityinsentient.dM() - vec3d1.b()), vec3d1.c());
            }
            return vec3d1;
        }

        private static boolean a(World world, Vec3D vec3d, int i2) {
            if (i2 <= 0) {
                return true;
            }
            BlockPosition blockposition = BlockPosition.a(vec3d);
            if (!world.a_(blockposition).l()) {
                return false;
            }
            for (EnumDirection enumdirection : EnumDirection.values()) {
                for (int j2 = 1; j2 < i2; ++j2) {
                    BlockPosition blockposition1 = blockposition.a(enumdirection, j2);
                    if (world.a_(blockposition1).l()) continue;
                    return true;
                }
            }
            return false;
        }

        private static Vec3D a(Vec3D vec3d, RandomSource randomsource) {
            double d0 = vec3d.a() + (double)((randomsource.i() * 2.0f - 1.0f) * 16.0f);
            double d1 = vec3d.b() + (double)((randomsource.i() * 2.0f - 1.0f) * 16.0f);
            double d2 = vec3d.c() + (double)((randomsource.i() * 2.0f - 1.0f) * 16.0f);
            return new Vec3D(d0, d1, d2);
        }

        @Nullable
        private static Vec3D a(EntityInsentient entityinsentient, Vec3D vec3d, RandomSource randomsource) {
            Vec3D vec3d1 = PathfinderGoalGhastIdleMove.a(vec3d, randomsource);
            return entityinsentient.gw() && !entityinsentient.a(vec3d1) ? null : vec3d1;
        }
    }

    public static class PathfinderGoalGhastMoveTowardsTarget
    extends PathfinderGoal {
        private final EntityInsentient a;

        public PathfinderGoalGhastMoveTowardsTarget(EntityInsentient entityinsentient) {
            this.a = entityinsentient;
            this.a(EnumSet.of(PathfinderGoal.Type.b));
        }

        @Override
        public boolean b() {
            return true;
        }

        @Override
        public boolean Y_() {
            return true;
        }

        @Override
        public void a() {
            EntityGhast.a(this.a);
        }
    }

    private static class PathfinderGoalGhastAttackTarget
    extends PathfinderGoal {
        private final EntityGhast b;
        public int a;

        public PathfinderGoalGhastAttackTarget(EntityGhast entityghast) {
            this.b = entityghast;
        }

        @Override
        public boolean b() {
            return this.b.e() != null;
        }

        @Override
        public void d() {
            this.a = 0;
        }

        @Override
        public void e() {
            this.b.x(false);
        }

        @Override
        public boolean Y_() {
            return true;
        }

        @Override
        public void a() {
            EntityLiving entityliving = this.b.e();
            if (entityliving != null) {
                double d0 = 64.0;
                if (entityliving.g(this.b) < 4096.0 && this.b.F(entityliving)) {
                    World world = this.b.an();
                    ++this.a;
                    if (this.a == 10 && !this.b.bm()) {
                        world.a((Entity)null, 1015, this.b.dF(), 0);
                    }
                    if (this.a == 20) {
                        double d1 = 4.0;
                        Vec3D vec3d = this.b.h(1.0f);
                        double d2 = entityliving.dK() - (this.b.dK() + vec3d.g * 4.0);
                        double d3 = entityliving.f(0.5) - (0.5 + this.b.f(0.5));
                        double d4 = entityliving.dQ() - (this.b.dQ() + vec3d.i * 4.0);
                        Vec3D vec3d1 = new Vec3D(d2, d3, d4);
                        if (!this.b.bm()) {
                            world.a((Entity)null, 1016, this.b.dF(), 0);
                        }
                        EntityLargeFireball entitylargefireball = new EntityLargeFireball(world, (EntityLiving)this.b, vec3d1.d(), this.b.m());
                        entitylargefireball.f = this.b.m();
                        entitylargefireball.bukkitYield = entitylargefireball.f;
                        entitylargefireball.a_(this.b.dK() + vec3d.g * 4.0, this.b.f(0.5) + 0.5, entitylargefireball.dQ() + vec3d.i * 4.0);
                        world.b(entitylargefireball);
                        this.a = -40;
                    }
                } else if (this.a > 0) {
                    --this.a;
                }
                this.b.x(this.a > 10);
            }
        }
    }
}

