/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import com.google.common.annotations.VisibleForTesting;
import java.time.LocalDate;
import java.time.temporal.ChronoField;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsFluid;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.ConversionParams;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntityPositionTypes;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreakDoor;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMoveThroughVillage;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRemoveBlock;
import net.minecraft.world.entity.ai.goal.PathfinderGoalZombieAttack;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.animal.EntityChicken;
import net.minecraft.world.entity.animal.EntityIronGolem;
import net.minecraft.world.entity.animal.EntityTurtle;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.EntityPigZombie;
import net.minecraft.world.entity.monster.EntityZombieVillager;
import net.minecraft.world.entity.npc.EntityVillager;
import net.minecraft.world.entity.npc.EntityVillagerAbstract;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.bukkit.entity.Zombie;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityCombustByEntityEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.EntityTransformEvent;

public class EntityZombie
extends EntityMonster {
    private static final MinecraftKey a = MinecraftKey.b("baby");
    private static final AttributeModifier f = new AttributeModifier(a, 0.5, AttributeModifier.Operation.b);
    private static final MinecraftKey ct = MinecraftKey.b("reinforcement_caller_charge");
    private static final AttributeModifier cu = new AttributeModifier(MinecraftKey.b("reinforcement_callee_charge"), -0.05f, AttributeModifier.Operation.a);
    private static final MinecraftKey cv = MinecraftKey.b("leader_zombie_bonus");
    private static final MinecraftKey cw = MinecraftKey.b("zombie_random_spawn_bonus");
    private static final DataWatcherObject<Boolean> cx = DataWatcher.a(EntityZombie.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Integer> cy = DataWatcher.a(EntityZombie.class, DataWatcherRegistry.b);
    public static final DataWatcherObject<Boolean> cz = DataWatcher.a(EntityZombie.class, DataWatcherRegistry.k);
    public static final float b = 0.05f;
    public static final int c = 50;
    public static final int d = 40;
    public static final int e = 7;
    private static final int cA = -1;
    private static final EntitySize cB = EntityTypes.bT.n().a(0.5f).b(0.93f);
    private static final float cC = 0.1f;
    private static final Predicate<EnumDifficulty> cD = enumdifficulty -> enumdifficulty == EnumDifficulty.d;
    private static final boolean cE = false;
    private static final boolean cF = false;
    private static final int cG = 0;
    private final PathfinderGoalBreakDoor cH;
    private boolean cI = false;
    private int cJ = 0;
    public int cK;
    private int lastTick = MinecraftServer.currentTick;

    public EntityZombie(EntityTypes<? extends EntityZombie> entitytypes, World world) {
        super((EntityTypes<? extends EntityMonster>)entitytypes, world);
        this.cH = new PathfinderGoalBreakDoor(this, cD);
    }

    public EntityZombie(World world) {
        this((EntityTypes<? extends EntityZombie>)EntityTypes.bT, world);
    }

    @Override
    protected void H() {
        this.cq.a(4, new a((EntityCreature)this, 1.0, 3));
        this.cq.a(8, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.cq.a(8, new PathfinderGoalRandomLookaround(this));
        this.m();
    }

    protected void m() {
        this.cq.a(2, new PathfinderGoalZombieAttack(this, 1.0, false));
        this.cq.a(6, new PathfinderGoalMoveThroughVillage(this, 1.0, true, 4, this::gO));
        this.cq.a(7, new PathfinderGoalRandomStrollLand(this, 1.0));
        this.cr.a(1, new PathfinderGoalHurtByTarget(this, new Class[0]).a(EntityPigZombie.class));
        this.cr.a(2, new PathfinderGoalNearestAttackableTarget<EntityHuman>((EntityInsentient)this, EntityHuman.class, true));
        this.cr.a(3, new PathfinderGoalNearestAttackableTarget<EntityVillagerAbstract>((EntityInsentient)this, EntityVillagerAbstract.class, false));
        this.cr.a(3, new PathfinderGoalNearestAttackableTarget<EntityIronGolem>((EntityInsentient)this, EntityIronGolem.class, true));
        this.cr.a(5, new PathfinderGoalNearestAttackableTarget<EntityTurtle>(this, EntityTurtle.class, 10, true, false, EntityTurtle.ct));
    }

    public static AttributeProvider.Builder gK() {
        return EntityMonster.gN().a(GenericAttributes.n, 35.0).a(GenericAttributes.w, 0.23f).a(GenericAttributes.c, 3.0).a(GenericAttributes.a, 2.0).a(GenericAttributes.B);
    }

    @Override
    protected void a(DataWatcher.a datawatcher_a) {
        super.a(datawatcher_a);
        datawatcher_a.a(cx, false);
        datawatcher_a.a(cy, 0);
        datawatcher_a.a(cz, false);
    }

    public boolean gL() {
        return this.aC().a(cz);
    }

    public boolean gO() {
        return this.cI;
    }

    public void y(boolean flag) {
        if (this.cp.c()) {
            if (this.cI != flag) {
                this.cI = flag;
                this.cp.e(flag);
                if (flag) {
                    this.cq.a(1, this.cH);
                } else {
                    this.cq.a(this.cH);
                }
            }
        } else if (this.cI) {
            this.cq.a(this.cH);
            this.cI = false;
        }
    }

    @Override
    public boolean g_() {
        return this.aC().a(cx);
    }

    @Override
    protected int f(WorldServer worldserver) {
        if (this.g_()) {
            this.cl = (int)((double)this.cl * 2.5);
        }
        return super.f(worldserver);
    }

    @Override
    public void a(boolean flag) {
        this.aC().a(cx, flag);
        if (this.an() != null && !this.an().D_()) {
            AttributeModifiable attributemodifiable = this.h(GenericAttributes.w);
            attributemodifiable.c(a);
            if (flag) {
                attributemodifiable.b(f);
            }
        }
    }

    @Override
    public void a(DataWatcherObject<?> datawatcherobject) {
        if (cx.equals(datawatcherobject)) {
            this.l_();
        }
        super.a(datawatcherobject);
    }

    protected boolean gI() {
        return true;
    }

    @Override
    public void g() {
        if (!this.an().D_() && this.bX() && !this.gx()) {
            if (this.gL()) {
                int elapsedTicks = MinecraftServer.currentTick - this.lastTick;
                this.cK -= elapsedTicks;
                if (this.cK < 0) {
                    this.af_();
                }
            } else if (this.gI()) {
                if (((Entity)this).a(TagsFluid.a)) {
                    ++this.cJ;
                    if (this.cJ >= 600) {
                        this.r(300);
                    }
                } else {
                    this.cJ = -1;
                }
            }
        }
        super.g();
        this.lastTick = MinecraftServer.currentTick;
    }

    @Override
    public void e_() {
        if (this.bX()) {
            boolean flag;
            boolean bl = flag = this.ag_() && this.gC();
            if (flag) {
                ItemStack itemstack = this.a(EnumItemSlot.f);
                if (!itemstack.f()) {
                    if (itemstack.m()) {
                        Item item = itemstack.h();
                        itemstack.b(itemstack.o() + this.as.a(2));
                        if (itemstack.o() >= itemstack.p()) {
                            this.a(item, EnumItemSlot.f);
                            this.a(EnumItemSlot.f, ItemStack.l);
                        }
                    }
                    flag = false;
                }
                if (flag) {
                    this.e(8.0f);
                }
            }
        }
        super.e_();
    }

    public void r(int i2) {
        this.lastTick = MinecraftServer.currentTick;
        this.cK = i2;
        this.aC().a(cz, true);
    }

    protected void af_() {
        this.b(EntityTypes.N);
        if (!this.bm()) {
            this.an().a((Entity)null, 1040, this.dF(), 0);
        }
    }

    protected void b(EntityTypes<? extends EntityZombie> entitytypes) {
        EntityZombie converted = this.convertTo(entitytypes, ConversionParams.a(this, true, true), entityzombie -> entityzombie.J(entityzombie.an().d_(entityzombie.dF()).d()), EntityTransformEvent.TransformReason.DROWNED, CreatureSpawnEvent.SpawnReason.DROWNED);
        if (converted == null) {
            ((Zombie)this.getBukkitEntity()).setConversionTime(-1);
        }
    }

    @VisibleForTesting
    public boolean a(WorldServer worldserver, EntityVillager entityvillager) {
        return EntityZombie.convertVillagerToZombieVillager(worldserver, entityvillager, this.dF(), this.bm(), EntityTransformEvent.TransformReason.INFECTION, CreatureSpawnEvent.SpawnReason.INFECTION) != null;
    }

    public static EntityZombieVillager convertVillagerToZombieVillager(WorldServer worldserver, EntityVillager entityvillager, BlockPosition blockPosition, boolean silent, EntityTransformEvent.TransformReason transformReason, CreatureSpawnEvent.SpawnReason spawnReason) {
        EntityZombieVillager entityzombievillager = entityvillager.convertTo(EntityTypes.bV, ConversionParams.a(entityvillager, true, true), entityzombievillager1 -> {
            entityzombievillager1.a((WorldAccess)worldserver, worldserver.d_(entityzombievillager1.dF()), EntitySpawnReason.i, new GroupDataZombie(false, true));
            entityzombievillager1.a(entityvillager.gR());
            entityzombievillager1.a(entityvillager.hd().d());
            entityzombievillager1.a(entityvillager.gK().a());
            entityzombievillager1.s(entityvillager.s());
            if (!silent) {
                worldserver.a((Entity)null, 1026, blockPosition, 0);
            }
        }, transformReason, spawnReason);
        return entityzombievillager;
    }

    protected boolean ag_() {
        return true;
    }

    @Override
    public boolean a(WorldServer worldserver, DamageSource damagesource, float f2) {
        if (!super.a(worldserver, damagesource, f2)) {
            return false;
        }
        EntityLiving entityliving = this.e();
        if (entityliving == null && damagesource.d() instanceof EntityLiving) {
            entityliving = (EntityLiving)damagesource.d();
        }
        if (entityliving != null && worldserver.aq() == EnumDifficulty.d && (double)this.as.i() < this.i(GenericAttributes.B) && worldserver.M()) {
            int i2 = MathHelper.a(this.dK());
            int j2 = MathHelper.a(this.dM());
            int k2 = MathHelper.a(this.dQ());
            EntityTypes<? extends EntityZombie> entitytypes = this.ax();
            EntityZombie entityzombie = entitytypes.a(worldserver, EntitySpawnReason.j);
            if (entityzombie == null) {
                return true;
            }
            for (int l2 = 0; l2 < 50; ++l2) {
                int k1;
                int j1;
                int i1 = i2 + MathHelper.a(this.as, 7, 40) * MathHelper.a(this.as, -1, 1);
                BlockPosition blockposition = new BlockPosition(i1, j1 = j2 + MathHelper.a(this.as, 7, 40) * MathHelper.a(this.as, -1, 1), k1 = k2 + MathHelper.a(this.as, 7, 40) * MathHelper.a(this.as, -1, 1));
                if (!EntityPositionTypes.a(entitytypes, worldserver, blockposition) || !EntityPositionTypes.a(entitytypes, worldserver, EntitySpawnReason.j, blockposition, worldserver.z)) continue;
                entityzombie.a_(i1, j1, k1);
                if (worldserver.a((double)i1, (double)j1, (double)k1, 7.0) || !worldserver.f(entityzombie) || !worldserver.g(entityzombie) || !entityzombie.s() && worldserver.d(entityzombie.de())) continue;
                entityzombie.setTarget(entityliving, EntityTargetEvent.TargetReason.REINFORCEMENT_TARGET, true);
                entityzombie.a((WorldAccess)worldserver, worldserver.d_(entityzombie.dF()), EntitySpawnReason.j, (GroupDataEntity)null);
                worldserver.addFreshEntityWithPassengers(entityzombie, CreatureSpawnEvent.SpawnReason.REINFORCEMENTS);
                AttributeModifiable attributemodifiable = this.h(GenericAttributes.B);
                AttributeModifier attributemodifier = attributemodifiable.a(ct);
                double d0 = attributemodifier != null ? attributemodifier.b() : 0.0;
                attributemodifiable.c(ct);
                attributemodifiable.d(new AttributeModifier(ct, d0 - 0.05, AttributeModifier.Operation.a));
                entityzombie.h(GenericAttributes.B).d(cu);
                break;
            }
        }
        return true;
    }

    @Override
    public boolean c(WorldServer worldserver, Entity entity) {
        boolean flag = super.c(worldserver, entity);
        if (flag) {
            float f2 = this.an().d_(this.dF()).b();
            if (this.fq().f() && this.ck() && this.as.i() < f2 * 0.3f) {
                EntityCombustByEntityEvent event = new EntityCombustByEntityEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (org.bukkit.entity.Entity)entity.getBukkitEntity(), (float)(2 * (int)f2));
                this.an().getCraftServer().getPluginManager().callEvent((Event)event);
                if (!event.isCancelled()) {
                    entity.igniteForSeconds(event.getDuration(), false);
                }
            }
        }
        return flag;
    }

    @Override
    protected SoundEffect p() {
        return SoundEffects.FH;
    }

    @Override
    protected SoundEffect e(DamageSource damagesource) {
        return SoundEffects.FR;
    }

    @Override
    protected SoundEffect f_() {
        return SoundEffects.FM;
    }

    protected SoundEffect n() {
        return SoundEffects.FX;
    }

    @Override
    protected void b(BlockPosition blockposition, IBlockData iblockdata) {
        this.a(this.n(), 0.15f, 1.0f);
    }

    public EntityTypes<? extends EntityZombie> ax() {
        return super.ax();
    }

    protected boolean s() {
        return false;
    }

    @Override
    protected void a(RandomSource randomsource, DifficultyDamageScaler difficultydamagescaler) {
        super.a(randomsource, difficultydamagescaler);
        float f2 = randomsource.i();
        float f3 = this.an().aq() == EnumDifficulty.d ? 0.05f : 0.01f;
        if (f2 < f3) {
            int i2 = randomsource.a(3);
            if (i2 == 0) {
                this.a(EnumItemSlot.a, new ItemStack(Items.qH));
            } else {
                this.a(EnumItemSlot.a, new ItemStack(Items.qI));
            }
        }
    }

    @Override
    protected void a(ValueOutput valueoutput) {
        super.a(valueoutput);
        valueoutput.a("IsBaby", this.g_());
        valueoutput.a("CanBreakDoors", this.gO());
        valueoutput.a("InWaterTime", this.bu() ? this.cJ : -1);
        valueoutput.a("DrownedConversionTime", this.gL() ? this.cK : -1);
    }

    @Override
    protected void a(ValueInput valueinput) {
        super.a(valueinput);
        this.a(valueinput.a("IsBaby", false));
        this.y(valueinput.a("CanBreakDoors", false));
        this.cJ = valueinput.a("InWaterTime", 0);
        int i2 = valueinput.a("DrownedConversionTime", -1);
        if (i2 != -1) {
            this.r(i2);
        } else {
            this.aC().a(cz, false);
        }
    }

    @Override
    public boolean a(WorldServer worldserver, EntityLiving entityliving, DamageSource damagesource) {
        boolean flag = super.a(worldserver, entityliving, damagesource);
        if ((worldserver.aq() == EnumDifficulty.c || worldserver.aq() == EnumDifficulty.d) && entityliving instanceof EntityVillager) {
            EntityVillager entityvillager = (EntityVillager)entityliving;
            if (worldserver.aq() != EnumDifficulty.d && this.as.h()) {
                return flag;
            }
            if (this.a(worldserver, entityvillager)) {
                flag = false;
            }
        }
        return flag;
    }

    @Override
    public EntitySize b(EntityPose entitypose) {
        return this.g_() ? cB : super.b(entitypose);
    }

    @Override
    public boolean g(ItemStack itemstack) {
        return itemstack.a(TagsItem.az) && this.g_() && this.cl() ? false : super.g(itemstack);
    }

    @Override
    public boolean c(WorldServer worldserver, ItemStack itemstack) {
        return itemstack.a(Items.tk) ? false : super.c(worldserver, itemstack);
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess worldaccess, DifficultyDamageScaler difficultydamagescaler, EntitySpawnReason entityspawnreason, @Nullable GroupDataEntity groupdataentity) {
        RandomSource randomsource = worldaccess.I_();
        groupdataentity = super.a(worldaccess, difficultydamagescaler, entityspawnreason, groupdataentity);
        float f2 = difficultydamagescaler.d();
        if (entityspawnreason != EntitySpawnReason.i) {
            this.a_(randomsource.i() < 0.55f * f2);
        }
        if (groupdataentity == null) {
            groupdataentity = new GroupDataZombie(EntityZombie.a(randomsource), true);
        }
        if (groupdataentity instanceof GroupDataZombie) {
            GroupDataZombie entityzombie_groupdatazombie = (GroupDataZombie)groupdataentity;
            if (entityzombie_groupdatazombie.a) {
                this.a(true);
                if (entityzombie_groupdatazombie.b) {
                    EntityChicken entitychicken1;
                    if ((double)randomsource.i() < 0.05) {
                        List<Entity> list = worldaccess.a(EntityChicken.class, this.de().c(5.0, 3.0, 5.0), IEntitySelector.c);
                        if (!list.isEmpty()) {
                            EntityChicken entitychicken = (EntityChicken)list.get(0);
                            entitychicken.x(true);
                            this.a((Entity)entitychicken, false, false);
                        }
                    } else if ((double)randomsource.i() < 0.05 && (entitychicken1 = EntityTypes.B.a(this.an(), EntitySpawnReason.g)) != null) {
                        entitychicken1.b(this.dK(), this.dM(), this.dQ(), this.dX(), 0.0f);
                        entitychicken1.a(worldaccess, difficultydamagescaler, EntitySpawnReason.g, (GroupDataEntity)null);
                        entitychicken1.x(true);
                        this.a((Entity)entitychicken1, false, false);
                        worldaccess.addFreshEntity(entitychicken1, CreatureSpawnEvent.SpawnReason.MOUNT);
                    }
                }
            }
            this.y(randomsource.i() < f2 * 0.1f);
            if (entityspawnreason != EntitySpawnReason.i) {
                this.a(randomsource, difficultydamagescaler);
                this.a(worldaccess, randomsource, difficultydamagescaler);
            }
        }
        if (this.a(EnumItemSlot.f).f()) {
            LocalDate localdate = LocalDate.now();
            int i2 = localdate.get(ChronoField.DAY_OF_MONTH);
            int j2 = localdate.get(ChronoField.MONTH_OF_YEAR);
            if (j2 == 10 && i2 == 31 && randomsource.i() < 0.25f) {
                this.a(EnumItemSlot.f, new ItemStack(randomsource.i() < 0.1f ? Blocks.eK : Blocks.eJ));
                this.a(EnumItemSlot.f, 0.0f);
            }
        }
        this.J(f2);
        return groupdataentity;
    }

    @VisibleForTesting
    public void b(int i2) {
        this.cJ = i2;
    }

    @VisibleForTesting
    public void c(int i2) {
        this.cK = i2;
    }

    public static boolean a(RandomSource randomsource) {
        return randomsource.i() < 0.05f;
    }

    protected void J(float f2) {
        this.gP();
        this.h(GenericAttributes.q).c(new AttributeModifier(cf, this.as.j() * (double)0.05f, AttributeModifier.Operation.a));
        double d0 = this.as.j() * 1.5 * (double)f2;
        if (d0 > 1.0) {
            this.h(GenericAttributes.n).c(new AttributeModifier(cw, d0, AttributeModifier.Operation.c));
        }
        if (this.as.i() < f2 * 0.05f) {
            this.h(GenericAttributes.B).c(new AttributeModifier(cv, this.as.j() * 0.25 + 0.5, AttributeModifier.Operation.a));
            this.h(GenericAttributes.t).c(new AttributeModifier(cv, this.as.j() * 3.0 + 1.0, AttributeModifier.Operation.c));
            this.y(true);
        }
    }

    protected void gP() {
        this.h(GenericAttributes.B).a(this.as.j() * (double)0.1f);
    }

    private class a
    extends PathfinderGoalRemoveBlock {
        a(EntityCreature entitycreature, double d0, int i2) {
            super(Blocks.nb, entitycreature, d0, i2);
        }

        @Override
        public void a(GeneratorAccess generatoraccess, BlockPosition blockposition) {
            generatoraccess.a((Entity)null, blockposition, SoundEffects.FN, SoundCategory.f, 0.5f, 0.9f + EntityZombie.this.as.i() * 0.2f);
        }

        @Override
        public void a(World world, BlockPosition blockposition) {
            world.a((Entity)null, blockposition, SoundEffects.CB, SoundCategory.e, 0.7f, 0.9f + world.z.i() * 0.2f);
        }

        @Override
        public double i() {
            return 1.14;
        }
    }

    public static class GroupDataZombie
    implements GroupDataEntity {
        public final boolean a;
        public final boolean b;

        public GroupDataZombie(boolean flag, boolean flag1) {
            this.a = flag;
            this.b = flag1;
        }
    }
}

