/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster.piglin;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.RandomSource;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.InventorySubcontainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.ICrossbow;
import net.minecraft.world.entity.monster.piglin.EntityPiglinAbstract;
import net.minecraft.world.entity.monster.piglin.EntityPiglinArmPose;
import net.minecraft.world.entity.monster.piglin.PiglinAI;
import net.minecraft.world.entity.npc.InventoryCarrier;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemCrossbow;
import net.minecraft.world.item.ItemProjectileWeapon;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public class EntityPiglin
extends EntityPiglinAbstract
implements ICrossbow,
InventoryCarrier {
    private static final DataWatcherObject<Boolean> ct = DataWatcher.a(EntityPiglin.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Boolean> cu = DataWatcher.a(EntityPiglin.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Boolean> cv = DataWatcher.a(EntityPiglin.class, DataWatcherRegistry.k);
    private static final MinecraftKey cw = MinecraftKey.b("baby");
    private static final AttributeModifier cx = new AttributeModifier(cw, 0.2f, AttributeModifier.Operation.b);
    private static final int cy = 16;
    private static final float cz = 0.35f;
    private static final int cA = 5;
    private static final float cB = 0.1f;
    private static final int cC = 3;
    private static final float cD = 0.2f;
    private static final EntitySize cE = EntityTypes.aW.n().a(0.5f).b(0.97f);
    private static final double cF = 0.5;
    private static final boolean cG = false;
    private static final boolean cH = false;
    public final InventorySubcontainer cI = new InventorySubcontainer(8);
    public boolean cJ = false;
    protected static final ImmutableList<SensorType<? extends Sensor<? super EntityPiglin>>> d = ImmutableList.of(SensorType.c, SensorType.d, SensorType.b, SensorType.f, SensorType.l);
    protected static final ImmutableList<MemoryModuleType<?>> e = ImmutableList.of(MemoryModuleType.o, MemoryModuleType.w, MemoryModuleType.g, MemoryModuleType.h, MemoryModuleType.k, MemoryModuleType.l, MemoryModuleType.as, MemoryModuleType.ar, MemoryModuleType.M, MemoryModuleType.aT, MemoryModuleType.y, MemoryModuleType.z, (Object[])new MemoryModuleType[]{MemoryModuleType.n, MemoryModuleType.F, MemoryModuleType.p, MemoryModuleType.q, MemoryModuleType.r, MemoryModuleType.u, MemoryModuleType.af, MemoryModuleType.ag, MemoryModuleType.A, MemoryModuleType.ah, MemoryModuleType.ai, MemoryModuleType.ak, MemoryModuleType.aj, MemoryModuleType.am, MemoryModuleType.an, MemoryModuleType.al, MemoryModuleType.ap, MemoryModuleType.N, MemoryModuleType.av, MemoryModuleType.t, MemoryModuleType.aw, MemoryModuleType.ax, MemoryModuleType.ao, MemoryModuleType.aq, MemoryModuleType.ay, MemoryModuleType.az, MemoryModuleType.aA});
    public Set<Item> allowedBarterItems = new HashSet<Item>();
    public Set<Item> interestItems = new HashSet<Item>();

    public EntityPiglin(EntityTypes<? extends EntityPiglinAbstract> entitytypes, World world) {
        super(entitytypes, world);
        this.cl = 5;
    }

    @Override
    protected void a(ValueOutput valueoutput) {
        super.a(valueoutput);
        valueoutput.a("IsBaby", this.g_());
        valueoutput.a("CannotHunt", this.cJ);
        this.b_(valueoutput);
        ValueOutput.a barterList = valueoutput.a("Bukkit.BarterList", Codec.STRING);
        this.allowedBarterItems.stream().map(BuiltInRegistries.h::b).map(MinecraftKey::toString).forEach(barterList::a);
        ValueOutput.a interestList = valueoutput.a("Bukkit.InterestList", Codec.STRING);
        this.interestItems.stream().map(BuiltInRegistries.h::b).map(MinecraftKey::toString).forEach(interestList::a);
    }

    @Override
    protected void a(ValueInput valueinput) {
        super.a(valueinput);
        this.a(valueinput.a("IsBaby", false));
        this.z(valueinput.a("CannotHunt", false));
        this.a_(valueinput);
        valueinput.b("Bukkit.BarterList", Codec.STRING).ifPresent(list -> {
            this.allowedBarterItems = list.b().map(MinecraftKey::c).map(BuiltInRegistries.h::a).collect(Collectors.toCollection(HashSet::new));
        });
        valueinput.b("Bukkit.InterestList", Codec.STRING).ifPresent(list -> {
            this.interestItems = list.b().map(MinecraftKey::c).map(BuiltInRegistries.h::a).collect(Collectors.toCollection(HashSet::new));
        });
    }

    @Override
    @VisibleForDebug
    public InventorySubcontainer n() {
        return this.cI;
    }

    @Override
    protected void a(WorldServer worldserver, DamageSource damagesource, boolean flag) {
        super.a(worldserver, damagesource, flag);
        this.cI.g().forEach(itemstack -> this.a(worldserver, (ItemStack)itemstack));
    }

    protected ItemStack i(ItemStack itemstack) {
        return this.cI.b(itemstack);
    }

    protected boolean j(ItemStack itemstack) {
        return this.cI.c(itemstack);
    }

    @Override
    protected void a(DataWatcher.a datawatcher_a) {
        super.a(datawatcher_a);
        datawatcher_a.a(ct, false);
        datawatcher_a.a(cu, false);
        datawatcher_a.a(cv, false);
    }

    @Override
    public void a(DataWatcherObject<?> datawatcherobject) {
        super.a(datawatcherobject);
        if (ct.equals(datawatcherobject)) {
            this.l_();
        }
    }

    public static AttributeProvider.Builder gO() {
        return EntityMonster.gN().a(GenericAttributes.t, 16.0).a(GenericAttributes.w, 0.35f).a(GenericAttributes.c, 5.0);
    }

    public static boolean b(EntityTypes<EntityPiglin> entitytypes, GeneratorAccess generatoraccess, EntitySpawnReason entityspawnreason, BlockPosition blockposition, RandomSource randomsource) {
        return !generatoraccess.a_(blockposition.e()).a(Blocks.lG);
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess worldaccess, DifficultyDamageScaler difficultydamagescaler, EntitySpawnReason entityspawnreason, @Nullable GroupDataEntity groupdataentity) {
        RandomSource randomsource = worldaccess.I_();
        if (entityspawnreason != EntitySpawnReason.d) {
            if (randomsource.i() < 0.2f) {
                this.a(true);
            } else if (this.gI()) {
                this.a(EnumItemSlot.a, this.gQ());
            }
        }
        PiglinAI.a(this, worldaccess.I_());
        this.a(randomsource, difficultydamagescaler);
        this.a(worldaccess, randomsource, difficultydamagescaler);
        return super.a(worldaccess, difficultydamagescaler, entityspawnreason, groupdataentity);
    }

    @Override
    public boolean i(double d0) {
        return !this.gr();
    }

    @Override
    protected void a(RandomSource randomsource, DifficultyDamageScaler difficultydamagescaler) {
        if (this.gI()) {
            this.a(EnumItemSlot.f, new ItemStack(Items.ry), randomsource);
            this.a(EnumItemSlot.e, new ItemStack(Items.rz), randomsource);
            this.a(EnumItemSlot.d, new ItemStack(Items.rA), randomsource);
            this.a(EnumItemSlot.c, new ItemStack(Items.rB), randomsource);
        }
    }

    private void a(EnumItemSlot enumitemslot, ItemStack itemstack, RandomSource randomsource) {
        if (randomsource.i() < 0.1f) {
            this.a(enumitemslot, itemstack);
        }
    }

    protected BehaviorController.b<EntityPiglin> er() {
        return BehaviorController.a(e, d);
    }

    @Override
    protected BehaviorController<?> a(Dynamic<?> dynamic) {
        return PiglinAI.a(this, this.er().a(dynamic));
    }

    public BehaviorController<EntityPiglin> eq() {
        return super.eq();
    }

    @Override
    public EnumInteractionResult b(EntityHuman entityhuman, EnumHand enumhand) {
        EnumInteractionResult enuminteractionresult = super.b(entityhuman, enumhand);
        if (enuminteractionresult.a()) {
            return enuminteractionresult;
        }
        World world = this.an();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            return PiglinAI.a(worldserver, this, entityhuman, enumhand);
        }
        boolean flag = PiglinAI.b(this, entityhuman.b(enumhand)) && this.gJ() != EntityPiglinArmPose.d;
        return (EnumInteractionResult)((Object)(flag ? EnumInteractionResult.a : EnumInteractionResult.e));
    }

    @Override
    public EntitySize b(EntityPose entitypose) {
        return this.g_() ? cE : super.b(entitypose);
    }

    @Override
    public void a(boolean flag) {
        this.aC().a(ct, flag);
        if (!this.an().D_()) {
            AttributeModifiable attributemodifiable = this.h(GenericAttributes.w);
            attributemodifiable.c(cx.a());
            if (flag) {
                attributemodifiable.b(cx);
            }
        }
    }

    @Override
    public boolean g_() {
        return this.aC().a(ct);
    }

    private void z(boolean flag) {
        this.cJ = flag;
    }

    @Override
    protected boolean k() {
        return !this.cJ;
    }

    @Override
    protected void a(WorldServer worldserver) {
        GameProfilerFiller gameprofilerfiller = Profiler.a();
        gameprofilerfiller.a("piglinBrain");
        this.eq().a(worldserver, this);
        gameprofilerfiller.c();
        PiglinAI.a(this);
        super.a(worldserver);
    }

    @Override
    protected int f(WorldServer worldserver) {
        return this.cl;
    }

    @Override
    protected void h(WorldServer worldserver) {
        PiglinAI.a(worldserver, this);
        this.cI.g().forEach(itemstack -> this.a(worldserver, (ItemStack)itemstack));
        super.h(worldserver);
    }

    private ItemStack gQ() {
        return (double)this.as.i() < 0.5 ? new ItemStack(Items.yi) : new ItemStack(Items.qC);
    }

    @Override
    @Nullable
    public TagKey<Item> ac() {
        return this.g_() ? null : TagsItem.cj;
    }

    private boolean gR() {
        return this.az.a(cu);
    }

    @Override
    public void b(boolean flag) {
        this.az.a(cu, flag);
    }

    @Override
    public void a() {
        this.bJ = 0;
    }

    @Override
    public EntityPiglinArmPose gJ() {
        return this.gP() ? EntityPiglinArmPose.e : (PiglinAI.a(this.fr()) ? EntityPiglinArmPose.d : (this.gz() && this.gK() ? EntityPiglinArmPose.a : (this.gR() ? EntityPiglinArmPose.c : (this.b(Items.yi) && ItemCrossbow.g(this.el()) ? EntityPiglinArmPose.b : EntityPiglinArmPose.f))));
    }

    public boolean gP() {
        return this.az.a(cv);
    }

    public void y(boolean flag) {
        this.az.a(cv, flag);
    }

    @Override
    public boolean a(WorldServer worldserver, DamageSource damagesource, float f2) {
        Entity entity;
        boolean flag = super.a(worldserver, damagesource, f2);
        if (flag && (entity = damagesource.d()) instanceof EntityLiving) {
            EntityLiving entityliving = (EntityLiving)entity;
            PiglinAI.a(worldserver, this, entityliving);
        }
        return flag;
    }

    @Override
    public void a(EntityLiving entityliving, float f2) {
        this.b(this, 1.6f);
    }

    @Override
    public boolean a(ItemProjectileWeapon itemprojectileweapon) {
        return itemprojectileweapon == Items.yi;
    }

    protected void k(ItemStack itemstack) {
        this.b(EnumItemSlot.a, itemstack);
    }

    protected void l(ItemStack itemstack) {
        if (itemstack.a(PiglinAI.c) || this.allowedBarterItems.contains(itemstack.h())) {
            this.a(EnumItemSlot.b, itemstack);
            this.g(EnumItemSlot.b);
        } else {
            this.b(EnumItemSlot.b, itemstack);
        }
    }

    @Override
    public boolean c(WorldServer worldserver, ItemStack itemstack) {
        return worldserver.S().c(GameRules.d) && this.gc() && PiglinAI.a(this, itemstack);
    }

    protected boolean m(ItemStack itemstack) {
        EnumItemSlot enumitemslot = this.f(itemstack);
        ItemStack itemstack1 = this.a(enumitemslot);
        return this.a(itemstack, itemstack1, enumitemslot);
    }

    @Override
    protected boolean a(ItemStack itemstack, ItemStack itemstack1, EnumItemSlot enumitemslot) {
        boolean flag1;
        if (EnchantmentManager.a(itemstack1, EnchantmentEffectComponents.E)) {
            return false;
        }
        TagKey<Item> tagkey = this.ac();
        boolean flag = PiglinAI.isLovedItem(itemstack, this) || tagkey != null && itemstack.a(tagkey);
        boolean bl = flag1 = PiglinAI.isLovedItem(itemstack1, this) || tagkey != null && itemstack1.a(tagkey);
        return flag && !flag1 ? true : (!flag && flag1 ? false : super.a(itemstack, itemstack1, enumitemslot));
    }

    @Override
    protected void a(WorldServer worldserver, EntityItem entityitem) {
        this.a(entityitem);
        PiglinAI.a(worldserver, this, entityitem);
    }

    @Override
    public boolean a(Entity entity, boolean flag, boolean flag1) {
        if (this.g_() && entity.ax() == EntityTypes.an) {
            entity = this.b(entity, 3);
        }
        return super.a(entity, flag, flag1);
    }

    private Entity b(Entity entity, int i2) {
        List<Entity> list = entity.di();
        return i2 != 1 && !list.isEmpty() ? this.b(list.getFirst(), i2 - 1) : entity;
    }

    @Override
    @Nullable
    protected SoundEffect p() {
        return this.an().D_() ? null : (SoundEffect)PiglinAI.b(this).orElse(null);
    }

    @Override
    protected SoundEffect e(DamageSource damagesource) {
        return SoundEffects.vE;
    }

    @Override
    protected SoundEffect f_() {
        return SoundEffects.vC;
    }

    @Override
    protected void b(BlockPosition blockposition, IBlockData iblockdata) {
        this.a(SoundEffects.vG, 0.15f, 1.0f);
    }

    @Override
    protected void gL() {
        this.b(SoundEffects.vH);
    }
}

