/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.EncoderException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.EnumChatFormat;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentHolder;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.core.component.TypedDataComponent;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.ChatHoverable;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.game.PacketPlayOutBlockChange;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.MathHelper;
import net.minecraft.util.NullOps;
import net.minecraft.util.Unit;
import net.minecraft.util.UtilColor;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.decoration.EntityItemFrame;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.AdventureModePredicate;
import net.minecraft.world.item.EnumItemRarity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemBed;
import net.minecraft.world.item.ItemBlock;
import net.minecraft.world.item.ItemBucket;
import net.minecraft.world.item.ItemSign;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SolidBucketItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.Consumable;
import net.minecraft.world.item.component.DamageResistant;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.item.component.TooltipProvider;
import net.minecraft.world.item.component.TypedEntityData;
import net.minecraft.world.item.component.UseCooldown;
import net.minecraft.world.item.component.UseRemainder;
import net.minecraft.world.item.component.Weapon;
import net.minecraft.world.item.component.WrittenBookContent;
import net.minecraft.world.item.context.ItemActionContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.item.enchantment.Repairable;
import net.minecraft.world.item.equipment.Equippable;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.Spawner;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockBed;
import net.minecraft.world.level.block.BlockSapling;
import net.minecraft.world.level.block.BlockSign;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.BlockWitherSkull;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundEffectType;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntitySign;
import net.minecraft.world.level.block.entity.TileEntitySkull;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.pattern.ShapeDetectorBlock;
import org.apache.commons.lang3.function.TriConsumer;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.TreeType;
import org.bukkit.World;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.v1_21_R6.block.CapturedBlockState;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftLocation;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockFertilizeEvent;
import org.bukkit.event.block.BlockMultiPlaceEvent;
import org.bukkit.event.player.PlayerItemDamageEvent;
import org.bukkit.event.player.PlayerSignOpenEvent;
import org.bukkit.event.world.StructureGrowEvent;
import org.slf4j.Logger;

public final class ItemStack
implements DataComponentHolder {
    private static final List<IChatBaseComponent> m = List.of(IChatBaseComponent.c("item.op_warning.line1").a(EnumChatFormat.m, EnumChatFormat.r), IChatBaseComponent.c("item.op_warning.line2").a(EnumChatFormat.m), IChatBaseComponent.c("item.op_warning.line3").a(EnumChatFormat.m));
    private static final IChatBaseComponent n = IChatBaseComponent.c("item.unbreakable").a(EnumChatFormat.j);
    public static final MapCodec<ItemStack> a = MapCodec.recursive((String)"ItemStack", codec -> RecordCodecBuilder.mapCodec(instance -> instance.group((App)Item.e.fieldOf("id").forGetter(ItemStack::i), (App)ExtraCodecs.a(1, 99).fieldOf("count").orElse((Object)1).forGetter(ItemStack::M), (App)DataComponentPatch.b.optionalFieldOf("components", (Object)DataComponentPatch.a).forGetter(itemstack -> itemstack.t.g())).apply((Applicative)instance, ItemStack::new)));
    public static final Codec<ItemStack> b;
    public static final Codec<ItemStack> c;
    public static final Codec<ItemStack> d;
    public static final Codec<ItemStack> e;
    public static final Codec<ItemStack> f;
    public static final Codec<ItemStack> g;
    public static final StreamCodec<RegistryFriendlyByteBuf, ItemStack> h;
    public static final StreamCodec<RegistryFriendlyByteBuf, ItemStack> i;
    public static final StreamCodec<RegistryFriendlyByteBuf, ItemStack> j;
    public static final StreamCodec<RegistryFriendlyByteBuf, List<ItemStack>> k;
    private static final Logger o;
    public static final ItemStack l;
    private static final IChatBaseComponent p;
    private int q;
    private int r;
    @Deprecated
    @Nullable
    private Item s;
    final PatchedDataComponentMap t;
    @Nullable
    private Entity u;

    public static DataResult<ItemStack> a(ItemStack itemstack) {
        DataResult<Unit> dataresult = ItemStack.a(itemstack.a());
        return dataresult.isError() ? dataresult.map(unit -> itemstack) : (itemstack.M() > itemstack.k() ? DataResult.error(() -> {
            int i2 = itemstack.M();
            return "Item stack with stack size of " + i2 + " was larger than maximum: " + itemstack.k();
        }) : DataResult.success((Object)itemstack));
    }

    private static StreamCodec<RegistryFriendlyByteBuf, ItemStack> b(final StreamCodec<RegistryFriendlyByteBuf, DataComponentPatch> streamcodec) {
        return new StreamCodec<RegistryFriendlyByteBuf, ItemStack>(){

            public ItemStack a(RegistryFriendlyByteBuf registryfriendlybytebuf) {
                int i2 = registryfriendlybytebuf.l();
                if (i2 <= 0) {
                    return l;
                }
                Holder holder = (Holder)Item.f.decode(registryfriendlybytebuf);
                DataComponentPatch datacomponentpatch = (DataComponentPatch)streamcodec.decode(registryfriendlybytebuf);
                ItemStack itemstack = new ItemStack(holder, i2, datacomponentpatch);
                if (!datacomponentpatch.d()) {
                    CraftItemStack.setItemMeta(itemstack, CraftItemStack.getItemMeta(itemstack));
                }
                return itemstack;
            }

            public void a(RegistryFriendlyByteBuf registryfriendlybytebuf, ItemStack itemstack) {
                if (itemstack.f() || itemstack.h() == null) {
                    registryfriendlybytebuf.c(0);
                } else {
                    registryfriendlybytebuf.c(itemstack.M());
                    Item.f.encode(registryfriendlybytebuf, itemstack.i());
                    streamcodec.encode(registryfriendlybytebuf, itemstack.t.g());
                }
            }
        };
    }

    public static StreamCodec<RegistryFriendlyByteBuf, ItemStack> a(final StreamCodec<RegistryFriendlyByteBuf, ItemStack> streamcodec) {
        return new StreamCodec<RegistryFriendlyByteBuf, ItemStack>(){

            public ItemStack a(RegistryFriendlyByteBuf registryfriendlybytebuf) {
                ItemStack itemstack = (ItemStack)streamcodec.decode(registryfriendlybytebuf);
                if (!itemstack.f()) {
                    RegistryOps<Unit> registryops = registryfriendlybytebuf.H().a(NullOps.a);
                    b.encodeStart(registryops, (Object)itemstack).getOrThrow(DecoderException::new);
                }
                return itemstack;
            }

            public void a(RegistryFriendlyByteBuf registryfriendlybytebuf, ItemStack itemstack) {
                streamcodec.encode(registryfriendlybytebuf, itemstack);
            }
        };
    }

    public Optional<TooltipComponent> b() {
        return this.h().k(this);
    }

    @Override
    public DataComponentMap a() {
        return !this.f() ? this.t : DataComponentMap.a;
    }

    public DataComponentMap c() {
        return !this.f() ? this.h().f() : DataComponentMap.a;
    }

    public DataComponentPatch d() {
        return !this.f() ? this.t.g() : DataComponentPatch.a;
    }

    public DataComponentMap e() {
        return !this.f() ? this.t.i() : DataComponentMap.a;
    }

    public boolean d(DataComponentType<?> datacomponenttype) {
        return !this.f() && this.t.d(datacomponenttype);
    }

    public ItemStack(IMaterial imaterial) {
        this(imaterial, 1);
    }

    public ItemStack(Holder<Item> holder) {
        this(holder.a(), 1);
    }

    public ItemStack(Holder<Item> holder, int i2, DataComponentPatch datacomponentpatch) {
        this(holder.a(), i2, PatchedDataComponentMap.a(holder.a().f(), datacomponentpatch));
    }

    public ItemStack(Holder<Item> holder, int i2) {
        this(holder.a(), i2);
    }

    public ItemStack(IMaterial imaterial, int i2) {
        this(imaterial, i2, new PatchedDataComponentMap(imaterial.h().f()));
    }

    private ItemStack(IMaterial imaterial, int i2, PatchedDataComponentMap patcheddatacomponentmap) {
        this.s = imaterial.h();
        this.q = i2;
        this.t = patcheddatacomponentmap;
    }

    private ItemStack(@Nullable Void ovoid) {
        this.s = null;
        this.t = new PatchedDataComponentMap(DataComponentMap.a);
    }

    public static DataResult<Unit> a(DataComponentMap datacomponentmap) {
        if (datacomponentmap.c(DataComponents.d) && datacomponentmap.a(DataComponents.c, 1) > 1) {
            return DataResult.error(() -> "Item cannot be both damageable and stackable");
        }
        ItemContainerContents itemcontainercontents = datacomponentmap.a(DataComponents.ap, ItemContainerContents.a);
        for (ItemStack itemstack : itemcontainercontents.d()) {
            int j2;
            int i2 = itemstack.M();
            if (i2 <= (j2 = itemstack.k())) continue;
            return DataResult.error(() -> "Item stack with count of " + i2 + " was larger than maximum: " + j2);
        }
        return DataResult.success((Object)((Object)Unit.a));
    }

    public boolean f() {
        return this == l || this.s == Items.a || this.q <= 0;
    }

    public boolean a(FeatureFlagSet featureflagset) {
        return this.f() || this.h().a(featureflagset);
    }

    public ItemStack a(int i2) {
        int j2 = Math.min(i2, this.M());
        ItemStack itemstack = this.c(j2);
        this.h(j2);
        return itemstack;
    }

    public ItemStack g() {
        if (this.f()) {
            return l;
        }
        ItemStack itemstack = this.v();
        this.e(0);
        return itemstack;
    }

    public Item h() {
        return this.f() ? Items.a : this.s;
    }

    public Holder<Item> i() {
        return this.h().e();
    }

    public boolean a(TagKey<Item> tagkey) {
        return this.h().e().a(tagkey);
    }

    public boolean a(Item item) {
        return this.h() == item;
    }

    public boolean a(Predicate<Holder<Item>> predicate) {
        return predicate.test(this.h().e());
    }

    public boolean a(Holder<Item> holder) {
        return this.h().e() == holder;
    }

    public boolean a(HolderSet<Item> holderset) {
        return holderset.a(this.i());
    }

    public Stream<TagKey<Item>> j() {
        return this.h().e().c();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EnumInteractionResult a(ItemActionContext itemactioncontext) {
        EnumInteractionResult.d enuminteractionresult_d;
        EnumInteractionResult enuminteractionresult;
        EntityHuman entityhuman = itemactioncontext.o();
        BlockPosition blockposition = itemactioncontext.a();
        if (entityhuman != null && !entityhuman.gC().e && !this.a(new ShapeDetectorBlock(itemactioncontext.q(), blockposition, false))) {
            return EnumInteractionResult.e;
        }
        Item item = this.h();
        DataComponentPatch oldData = this.t.g();
        int oldCount = this.M();
        WorldServer world = (WorldServer)itemactioncontext.q();
        if (!(item instanceof ItemBucket) && !(item instanceof SolidBucketItem)) {
            world.captureBlockStates = true;
            if (item == Items.tC) {
                world.captureTreeGeneration = true;
            }
        }
        try {
            enuminteractionresult = item.a(itemactioncontext);
        }
        finally {
            world.captureBlockStates = false;
        }
        DataComponentPatch newData = this.t.g();
        int newCount = this.M();
        this.e(oldCount);
        this.restorePatch(oldData);
        if (enuminteractionresult.a() && world.captureTreeGeneration && world.capturedBlockStates.size() > 0) {
            world.captureTreeGeneration = false;
            Location location = CraftLocation.toBukkit(blockposition, (World)world.getWorld());
            TreeType treeType = BlockSapling.treeType;
            BlockSapling.treeType = null;
            ArrayList blocks = new ArrayList(world.capturedBlockStates.values());
            world.capturedBlockStates.clear();
            StructureGrowEvent structureEvent = null;
            if (treeType != null) {
                boolean isBonemeal = this.h() == Items.tC;
                structureEvent = new StructureGrowEvent(location, treeType, isBonemeal, (Player)entityhuman.getBukkitEntity(), blocks);
                Bukkit.getPluginManager().callEvent((Event)structureEvent);
            }
            BlockFertilizeEvent fertilizeEvent = new BlockFertilizeEvent((org.bukkit.block.Block)CraftBlock.at(world, blockposition), (Player)entityhuman.getBukkitEntity(), blocks);
            fertilizeEvent.setCancelled(structureEvent != null && structureEvent.isCancelled());
            Bukkit.getPluginManager().callEvent((Event)fertilizeEvent);
            if (!fertilizeEvent.isCancelled()) {
                if (this.M() == oldCount && Objects.equals(this.t.g(), oldData)) {
                    this.restorePatch(newData);
                    this.e(newCount);
                }
                for (CraftBlockState blockstate : blocks) {
                    CapturedBlockState.setBlockState(blockstate);
                }
                entityhuman.b(StatisticList.c.b(item));
            }
            ItemSign.openSign = null;
            return enuminteractionresult;
        }
        world.captureTreeGeneration = false;
        if (entityhuman != null && enuminteractionresult instanceof EnumInteractionResult.d && (enuminteractionresult_d = (EnumInteractionResult.d)enuminteractionresult).c()) {
            EnumHand enumhand = itemactioncontext.p();
            BlockMultiPlaceEvent placeEvent = null;
            ArrayList<BlockState> blocks = new ArrayList<BlockState>(world.capturedBlockStates.values());
            world.capturedBlockStates.clear();
            if (blocks.size() > 1) {
                placeEvent = CraftEventFactory.callBlockMultiPlaceEvent(world, entityhuman, enumhand, blocks, blockposition.u(), blockposition.v(), blockposition.w());
            } else if (blocks.size() == 1) {
                placeEvent = CraftEventFactory.callBlockPlaceEvent(world, entityhuman, enumhand, (BlockState)blocks.get(0), blockposition.u(), blockposition.v(), blockposition.w());
            }
            if (placeEvent != null && (placeEvent.isCancelled() || !placeEvent.canBuild())) {
                enuminteractionresult = EnumInteractionResult.d;
                placeEvent.getPlayer().updateInventory();
                world.preventPoiUpdated = true;
                for (BlockState blockState : blocks) {
                    blockState.update(true, false);
                }
                world.preventPoiUpdated = false;
                BlockPosition placedPos = ((CraftBlock)placeEvent.getBlock()).getPosition();
                for (EnumDirection dir : EnumDirection.values()) {
                    ((EntityPlayer)entityhuman).g.b(new PacketPlayOutBlockChange(world, placedPos.a(dir)));
                }
                ItemSign.openSign = null;
            } else {
                BlockPosition position;
                IBlockData iBlockData;
                if (this.M() == oldCount && Objects.equals(this.t.g(), oldData)) {
                    this.restorePatch(newData);
                    this.e(newCount);
                }
                for (Map.Entry entry : world.capturedTileEntities.entrySet()) {
                    world.b((TileEntity)entry.getValue());
                }
                for (BlockState blockState : blocks) {
                    int updateFlag = ((CraftBlockState)blockState).getFlag();
                    IBlockData oldBlock = ((CraftBlockState)blockState).getHandle();
                    BlockPosition newblockposition = ((CraftBlockState)blockState).getPosition();
                    IBlockData block = world.a_(newblockposition);
                    if (!(block.b() instanceof BlockTileEntity)) {
                        block.onPlace(world, newblockposition, oldBlock, true, itemactioncontext);
                    }
                    world.notifyAndUpdatePhysics(newblockposition, null, oldBlock, block, world.a_(newblockposition), updateFlag, 512);
                }
                if (this.s == Items.wu) {
                    TileEntity tileEntity;
                    BlockPosition bp = blockposition;
                    if (!world.a_(blockposition).v()) {
                        bp = !world.a_(blockposition).e() ? null : bp.a(itemactioncontext.k());
                    }
                    if (bp != null && (tileEntity = world.c_(bp)) instanceof TileEntitySkull) {
                        BlockWitherSkull.a((net.minecraft.world.level.World)world, bp, (TileEntitySkull)tileEntity);
                    }
                }
                if (this.s instanceof ItemSign && ItemSign.openSign != null) {
                    try {
                        TileEntity tileEntity = world.c_(ItemSign.openSign);
                        if (tileEntity instanceof TileEntitySign) {
                            TileEntitySign tileentitysign = (TileEntitySign)tileEntity;
                            Block block = world.a_(ItemSign.openSign).b();
                            if (block instanceof BlockSign) {
                                BlockSign blockSign = (BlockSign)block;
                                blockSign.openTextEdit(entityhuman, tileentitysign, true, PlayerSignOpenEvent.Cause.PLACE);
                            }
                        }
                    }
                    finally {
                        ItemSign.openSign = null;
                    }
                }
                if (placeEvent != null && this.s instanceof ItemBed && (iBlockData = world.a_(position = ((CraftBlock)placeEvent.getBlock()).getPosition())).b() instanceof BlockBed) {
                    world.a(position, Blocks.a);
                    iBlockData.a((GeneratorAccess)world, position, 3);
                }
                if (this.s instanceof ItemBlock) {
                    SoundEffectType soundeffecttype = ((ItemBlock)this.s).c().m().A();
                    world.a((Entity)entityhuman, blockposition, soundeffecttype.e(), SoundCategory.e, (soundeffecttype.a() + 1.0f) / 2.0f, soundeffecttype.b() * 0.8f);
                }
                entityhuman.b(StatisticList.c.b(item));
            }
        }
        world.capturedTileEntities.clear();
        world.capturedBlockStates.clear();
        return enuminteractionresult;
    }

    public float a(IBlockData iblockdata) {
        return this.h().a(this, iblockdata);
    }

    public EnumInteractionResult a(net.minecraft.world.level.World world, EntityHuman entityhuman, EnumHand enumhand) {
        ItemStack itemstack = this.v();
        boolean flag = this.a(entityhuman) <= 0;
        EnumInteractionResult enuminteractionresult = this.h().a(world, entityhuman, enumhand);
        if (flag && enuminteractionresult instanceof EnumInteractionResult.d) {
            EnumInteractionResult.d enuminteractionresult_d;
            return enuminteractionresult_d.a((enuminteractionresult_d = (EnumInteractionResult.d)enuminteractionresult).d() == null ? this.a((EntityLiving)entityhuman, itemstack) : enuminteractionresult_d.d().a((EntityLiving)entityhuman, itemstack));
        }
        return enuminteractionresult;
    }

    public ItemStack a(net.minecraft.world.level.World world, EntityLiving entityliving) {
        ItemStack itemstack = this.v();
        ItemStack itemstack1 = this.h().a(this, world, entityliving);
        return itemstack1.a(entityliving, itemstack);
    }

    private ItemStack a(EntityLiving entityliving, ItemStack itemstack) {
        UseRemainder useremainder = itemstack.a(DataComponents.x);
        UseCooldown usecooldown = itemstack.a(DataComponents.y);
        int i2 = itemstack.M();
        ItemStack itemstack1 = this;
        if (useremainder != null) {
            boolean flag = entityliving.gk();
            Objects.requireNonNull(entityliving);
            itemstack1 = useremainder.a(this, i2, flag, entityliving::b);
        }
        if (usecooldown != null) {
            usecooldown.a(itemstack, entityliving);
        }
        return itemstack1;
    }

    public int k() {
        return this.a(DataComponents.c, Integer.valueOf(1));
    }

    public boolean l() {
        return this.k() > 1 && (!this.m() || !this.n());
    }

    public boolean m() {
        return this.c(DataComponents.d) && !this.c(DataComponents.f) && this.c(DataComponents.e);
    }

    public boolean n() {
        return this.m() && this.o() > 0;
    }

    public int o() {
        return MathHelper.a((int)this.a(DataComponents.e, Integer.valueOf(0)), 0, this.p());
    }

    public void b(int i2) {
        this.b(DataComponents.e, Integer.valueOf(MathHelper.a(i2, 0, this.p())));
    }

    public int p() {
        return this.a(DataComponents.d, Integer.valueOf(0));
    }

    public boolean q() {
        return this.m() && this.o() >= this.p();
    }

    public boolean r() {
        return this.m() && this.o() >= this.p() - 1;
    }

    public void a(int i2, WorldServer worldserver, @Nullable EntityPlayer entityplayer, Consumer<Item> consumer) {
        int j2 = this.a(i2, worldserver, entityplayer);
        if (entityplayer != null) {
            PlayerItemDamageEvent event = new PlayerItemDamageEvent((Player)entityplayer.getBukkitEntity(), (org.bukkit.inventory.ItemStack)CraftItemStack.asCraftMirror(this), j2);
            event.getPlayer().getServer().getPluginManager().callEvent((Event)event);
            if (j2 != event.getDamage() || event.isCancelled()) {
                event.getPlayer().updateInventory();
            }
            if (event.isCancelled()) {
                return;
            }
            j2 = event.getDamage();
        }
        if (j2 != 0) {
            this.a(this.o() + j2, entityplayer, consumer);
        }
    }

    private int a(int i2, WorldServer worldserver, @Nullable EntityPlayer entityplayer) {
        return !this.m() ? 0 : (entityplayer != null && entityplayer.gk() ? 0 : (i2 > 0 ? EnchantmentManager.a(worldserver, this, i2) : i2));
    }

    private void a(int i2, @Nullable EntityPlayer entityplayer, Consumer<Item> consumer) {
        if (entityplayer != null) {
            CriterionTriggers.u.a(entityplayer, this, i2);
        }
        this.b(i2);
        if (this.q()) {
            Item item = this.h();
            if (this.q == 1 && entityplayer != null) {
                CraftEventFactory.callPlayerItemBreakEvent(entityplayer, this);
            }
            this.h(1);
            consumer.accept(item);
        }
    }

    public void a(int i2, EntityHuman entityhuman) {
        if (entityhuman instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)entityhuman;
            int j2 = this.a(i2, entityplayer.A(), entityplayer);
            if (j2 == 0) {
                return;
            }
            int k2 = Math.min(this.o() + j2, this.p() - 1);
            this.a(k2, entityplayer, (Item item) -> {});
        }
    }

    public void a(int i2, EntityLiving entityliving, EnumHand enumhand) {
        this.a(i2, entityliving, enumhand.a());
    }

    public void a(int i2, EntityLiving entityliving, EnumItemSlot enumitemslot) {
        net.minecraft.world.level.World world = entityliving.an();
        if (world instanceof WorldServer) {
            EntityPlayer entityplayer1;
            WorldServer worldserver = (WorldServer)world;
            EntityPlayer entityplayer = entityliving instanceof EntityPlayer ? (entityplayer1 = (EntityPlayer)entityliving) : null;
            this.a(i2, worldserver, entityplayer, (Item item) -> entityliving.a((Item)item, enumitemslot));
        }
    }

    public ItemStack a(int i2, IMaterial imaterial, EntityLiving entityliving, EnumItemSlot enumitemslot) {
        this.a(i2, entityliving, enumitemslot);
        if (this.f()) {
            ItemStack itemstack = this.b(imaterial, 1);
            if (itemstack.m()) {
                itemstack.b(0);
            }
            return itemstack;
        }
        return this;
    }

    public boolean s() {
        return this.h().d(this);
    }

    public int t() {
        return this.h().e(this);
    }

    public int u() {
        return this.h().f(this);
    }

    public boolean a(Slot slot, ClickAction clickaction, EntityHuman entityhuman) {
        return this.h().a(this, slot, clickaction, entityhuman);
    }

    public boolean a(ItemStack itemstack, Slot slot, ClickAction clickaction, EntityHuman entityhuman, SlotAccess slotaccess) {
        return this.h().a(this, itemstack, slot, clickaction, entityhuman, slotaccess);
    }

    public boolean a(EntityLiving entityliving, EntityLiving entityliving1) {
        Item item = this.h();
        item.a(this, entityliving, entityliving1);
        if (this.c(DataComponents.B)) {
            if (entityliving1 instanceof EntityHuman) {
                EntityHuman entityhuman = (EntityHuman)entityliving1;
                entityhuman.b(StatisticList.c.b(item));
            }
            return true;
        }
        return false;
    }

    public void b(EntityLiving entityliving, EntityLiving entityliving1) {
        this.h().b(this, entityliving, entityliving1);
        Weapon weapon = this.a(DataComponents.B);
        if (weapon != null) {
            this.a(weapon.a(), entityliving1, EnumItemSlot.a);
        }
    }

    public void a(net.minecraft.world.level.World world, IBlockData iblockdata, BlockPosition blockposition, EntityHuman entityhuman) {
        Item item = this.h();
        if (item.a(this, world, iblockdata, blockposition, (EntityLiving)entityhuman)) {
            entityhuman.b(StatisticList.c.b(item));
        }
    }

    public boolean b(IBlockData iblockdata) {
        return this.h().b(this, iblockdata);
    }

    public EnumInteractionResult a(EntityHuman entityhuman, EntityLiving entityliving, EnumHand enumhand) {
        EnumInteractionResult enuminteractionresult;
        Equippable equippable = this.a(DataComponents.D);
        if (equippable != null && equippable.j() && (enuminteractionresult = equippable.a(entityhuman, entityliving, this)) != EnumInteractionResult.e) {
            return enuminteractionresult;
        }
        return this.h().a(this, entityhuman, entityliving, enumhand);
    }

    public ItemStack v() {
        if (this.f()) {
            return l;
        }
        ItemStack itemstack = new ItemStack(this.h(), this.q, this.t.h());
        itemstack.d(this.L());
        return itemstack;
    }

    public ItemStack c(int i2) {
        if (this.f()) {
            return l;
        }
        ItemStack itemstack = this.v();
        itemstack.e(i2);
        return itemstack;
    }

    public ItemStack a(IMaterial imaterial) {
        return this.a(imaterial, this.M());
    }

    public ItemStack a(IMaterial imaterial, int i2) {
        return this.f() ? l : this.b(imaterial, i2);
    }

    private ItemStack b(IMaterial imaterial, int i2) {
        return new ItemStack(imaterial.h().e(), i2, this.t.g());
    }

    public static boolean a(ItemStack itemstack, ItemStack itemstack1) {
        return itemstack == itemstack1 ? true : (itemstack.M() != itemstack1.M() ? false : ItemStack.c(itemstack, itemstack1));
    }

    @Deprecated
    public static boolean a(List<ItemStack> list, List<ItemStack> list1) {
        if (list.size() != list1.size()) {
            return false;
        }
        for (int i2 = 0; i2 < list.size(); ++i2) {
            if (ItemStack.a(list.get(i2), list1.get(i2))) continue;
            return false;
        }
        return true;
    }

    public static boolean b(ItemStack itemstack, ItemStack itemstack1) {
        return itemstack.a(itemstack1.h());
    }

    public static boolean c(ItemStack itemstack, ItemStack itemstack1) {
        return !itemstack.a(itemstack1.h()) ? false : (itemstack.f() && itemstack1.f() ? true : Objects.equals(itemstack.t, itemstack1.t));
    }

    public static MapCodec<ItemStack> a(String s2) {
        return b.lenientOptionalFieldOf(s2).xmap(optional -> optional.orElse(l), itemstack -> itemstack.f() ? Optional.empty() : Optional.of(itemstack));
    }

    public static int b(@Nullable ItemStack itemstack) {
        if (itemstack != null) {
            int i2 = 31 + itemstack.h().hashCode();
            return 31 * i2 + itemstack.a().hashCode();
        }
        return 0;
    }

    @Deprecated
    public static int a(List<ItemStack> list) {
        int i2 = 0;
        for (ItemStack itemstack : list) {
            i2 = i2 * 31 + ItemStack.b(itemstack);
        }
        return i2;
    }

    public String toString() {
        int i2 = this.M();
        return i2 + " " + String.valueOf(this.h());
    }

    public void a(net.minecraft.world.level.World world, Entity entity, @Nullable EnumItemSlot enumitemslot) {
        if (this.r > 0) {
            --this.r;
        }
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            this.h().a(this, worldserver, entity, enumitemslot);
        }
    }

    public void a(EntityHuman entityhuman, int i2) {
        entityhuman.a(StatisticList.b.b(this.h()), i2);
        this.h().c(this, entityhuman);
    }

    public void a(net.minecraft.world.level.World world) {
        this.h().a(this, world);
    }

    public int a(EntityLiving entityliving) {
        return this.h().a(this, entityliving);
    }

    public ItemUseAnimation w() {
        return this.h().b(this);
    }

    public void a(net.minecraft.world.level.World world, EntityLiving entityliving, int i2) {
        ItemStack itemstack1;
        ItemStack itemstack = this.v();
        if (this.h().a(this, world, entityliving, i2) && (itemstack1 = this.a(entityliving, itemstack)) != this) {
            entityliving.a(entityliving.fP(), itemstack1);
        }
    }

    public boolean x() {
        return this.h().e_(this);
    }

    public void restorePatch(DataComponentPatch datacomponentpatch) {
        this.t.b(datacomponentpatch);
    }

    @Nullable
    public <T> T b(DataComponentType<T> datacomponenttype, @Nullable T t0) {
        return this.t.b(datacomponenttype, t0);
    }

    @Nullable
    public <T> T a(TypedDataComponent<T> typeddatacomponent) {
        return this.t.a(typeddatacomponent);
    }

    public <T> void a(DataComponentType<T> datacomponenttype, DataComponentGetter datacomponentgetter) {
        this.b(datacomponenttype, datacomponentgetter.a(datacomponenttype));
    }

    @Nullable
    public <T, U> T a(DataComponentType<T> datacomponenttype, T t0, U u0, BiFunction<T, U, T> bifunction) {
        return this.b(datacomponenttype, bifunction.apply(this.a(datacomponenttype, t0), u0));
    }

    @Nullable
    public <T> T a(DataComponentType<T> datacomponenttype, T t0, UnaryOperator<T> unaryoperator) {
        T t1 = this.a(datacomponenttype, t0);
        return this.b(datacomponenttype, unaryoperator.apply(t1));
    }

    @Nullable
    public <T> T e(DataComponentType<? extends T> datacomponenttype) {
        return this.t.e(datacomponenttype);
    }

    public void a(DataComponentPatch datacomponentpatch) {
        DataComponentPatch datacomponentpatch1 = this.t.g();
        this.t.a(datacomponentpatch);
        Optional optional = ItemStack.a(this).error();
        if (optional.isPresent()) {
            o.error("Failed to apply component patch '{}' to item: '{}'", (Object)datacomponentpatch, (Object)((DataResult.Error)optional.get()).message());
            this.t.b(datacomponentpatch1);
        }
    }

    public void b(DataComponentPatch datacomponentpatch) {
        this.t.a(datacomponentpatch);
    }

    public void b(DataComponentMap datacomponentmap) {
        this.t.a(datacomponentmap);
    }

    public IChatBaseComponent y() {
        IChatBaseComponent ichatbasecomponent = this.z();
        return ichatbasecomponent != null ? ichatbasecomponent : this.A();
    }

    @Nullable
    public IChatBaseComponent z() {
        String s2;
        IChatBaseComponent ichatbasecomponent = this.a(DataComponents.g);
        if (ichatbasecomponent != null) {
            return ichatbasecomponent;
        }
        WrittenBookContent writtenbookcontent = this.a(DataComponents.V);
        if (writtenbookcontent != null && !UtilColor.h(s2 = writtenbookcontent.d().a())) {
            return IChatBaseComponent.b(s2);
        }
        return null;
    }

    public IChatBaseComponent A() {
        return this.h().a(this);
    }

    public IChatBaseComponent B() {
        IChatMutableComponent ichatmutablecomponent = IChatBaseComponent.i().b(this.y()).a(this.D().a());
        if (this.c(DataComponents.g)) {
            ichatmutablecomponent.a(EnumChatFormat.u);
        }
        return ichatmutablecomponent;
    }

    public <T extends TooltipProvider> void a(DataComponentType<T> datacomponenttype, Item.b item_b, TooltipDisplay tooltipdisplay, Consumer<IChatBaseComponent> consumer, TooltipFlag tooltipflag) {
        TooltipProvider t0 = (TooltipProvider)this.a(datacomponenttype);
        if (t0 != null && tooltipdisplay.a(datacomponenttype)) {
            t0.a(item_b, consumer, tooltipflag, this.t);
        }
    }

    public List<IChatBaseComponent> a(Item.b item_b, @Nullable EntityHuman entityhuman, TooltipFlag tooltipflag) {
        TooltipDisplay tooltipdisplay = this.a(DataComponents.q, TooltipDisplay.c);
        if (!tooltipflag.b() && tooltipdisplay.a()) {
            boolean flag = this.h().a(this, entityhuman);
            return flag ? m : List.of();
        }
        ArrayList list = Lists.newArrayList();
        list.add(this.B());
        Objects.requireNonNull(list);
        this.a(item_b, tooltipdisplay, entityhuman, tooltipflag, list::add);
        return list;
    }

    public void a(Item.b item_b, TooltipDisplay tooltipdisplay, @Nullable EntityHuman entityhuman, TooltipFlag tooltipflag, Consumer<IChatBaseComponent> consumer) {
        boolean flag;
        AdventureModePredicate adventuremodepredicate1;
        AdventureModePredicate adventuremodepredicate;
        this.h().a(this, item_b, tooltipdisplay, consumer, tooltipflag);
        this.a(DataComponents.aC, item_b, tooltipdisplay, consumer, tooltipflag);
        this.a(DataComponents.ab, item_b, tooltipdisplay, consumer, tooltipflag);
        this.a(DataComponents.M, item_b, tooltipdisplay, consumer, tooltipflag);
        this.a(DataComponents.ar, item_b, tooltipdisplay, consumer, tooltipflag);
        this.a(DataComponents.at, item_b, tooltipdisplay, consumer, tooltipflag);
        this.a(DataComponents.ap, item_b, tooltipdisplay, consumer, tooltipflag);
        this.a(DataComponents.am, item_b, tooltipdisplay, consumer, tooltipflag);
        this.a(DataComponents.ao, item_b, tooltipdisplay, consumer, tooltipflag);
        this.a(DataComponents.V, item_b, tooltipdisplay, consumer, tooltipflag);
        this.a(DataComponents.P, item_b, tooltipdisplay, consumer, tooltipflag);
        this.a(DataComponents.aj, item_b, tooltipdisplay, consumer, tooltipflag);
        this.a(DataComponents.ai, item_b, tooltipdisplay, consumer, tooltipflag);
        this.a(DataComponents.R, item_b, tooltipdisplay, consumer, tooltipflag);
        this.a(DataComponents.ae, item_b, tooltipdisplay, consumer, tooltipflag);
        this.a(DataComponents.W, item_b, tooltipdisplay, consumer, tooltipflag);
        this.a(DataComponents.J, item_b, tooltipdisplay, consumer, tooltipflag);
        this.a(DataComponents.l, item_b, tooltipdisplay, consumer, tooltipflag);
        this.a(DataComponents.K, item_b, tooltipdisplay, consumer, tooltipflag);
        this.a(DataComponents.ak, item_b, tooltipdisplay, consumer, tooltipflag);
        this.a(DataComponents.j, item_b, tooltipdisplay, consumer, tooltipflag);
        this.a(consumer, tooltipdisplay, entityhuman);
        if (this.c(DataComponents.f) && tooltipdisplay.a(DataComponents.f)) {
            consumer.accept(n);
        }
        this.a(DataComponents.ad, item_b, tooltipdisplay, consumer, tooltipflag);
        this.a(DataComponents.T, item_b, tooltipdisplay, consumer, tooltipflag);
        this.a(DataComponents.aq, item_b, tooltipdisplay, consumer, tooltipflag);
        this.a(DataComponents.Y, item_b, tooltipdisplay, consumer, tooltipflag);
        if ((this.a(Items.fr) || this.a(Items.Bg)) && tooltipdisplay.a(DataComponents.aa)) {
            TypedEntityData<TileEntityTypes<?>> typedentitydata = this.a(DataComponents.aa);
            Spawner.a(typedentitydata, consumer, "SpawnData");
        }
        if ((adventuremodepredicate = this.a(DataComponents.n)) != null && tooltipdisplay.a(DataComponents.n)) {
            consumer.accept(CommonComponents.a);
            consumer.accept(AdventureModePredicate.c);
            adventuremodepredicate.a(consumer);
        }
        if ((adventuremodepredicate1 = this.a(DataComponents.m)) != null && tooltipdisplay.a(DataComponents.m)) {
            consumer.accept(CommonComponents.a);
            consumer.accept(AdventureModePredicate.d);
            adventuremodepredicate1.a(consumer);
        }
        if (tooltipflag.a()) {
            if (this.n() && tooltipdisplay.a(DataComponents.e)) {
                consumer.accept(IChatBaseComponent.a("item.durability", this.p() - this.o(), this.p()));
            }
            consumer.accept(IChatBaseComponent.b(BuiltInRegistries.h.b(this.h()).toString()).a(EnumChatFormat.i));
            int i2 = this.t.d();
            if (i2 > 0) {
                consumer.accept(IChatBaseComponent.a("item.components", i2).a(EnumChatFormat.i));
            }
        }
        if (entityhuman != null && !this.h().a(entityhuman.an().O())) {
            consumer.accept(p);
        }
        if (flag = this.h().a(this, entityhuman)) {
            m.forEach(consumer);
        }
    }

    private void a(Consumer<IChatBaseComponent> consumer, TooltipDisplay tooltipdisplay, @Nullable EntityHuman entityhuman) {
        if (tooltipdisplay.a(DataComponents.o)) {
            for (EquipmentSlotGroup equipmentslotgroup : EquipmentSlotGroup.values()) {
                MutableBoolean mutableboolean = new MutableBoolean(true);
                this.a(equipmentslotgroup, (TriConsumer<Holder<AttributeBase>, AttributeModifier, ItemAttributeModifiers.b>)((TriConsumer)(holder, attributemodifier, itemattributemodifiers_b) -> {
                    if (itemattributemodifiers_b != ItemAttributeModifiers.b.b()) {
                        if (mutableboolean.isTrue()) {
                            consumer.accept(CommonComponents.a);
                            consumer.accept(IChatBaseComponent.c("item.modifiers." + equipmentslotgroup.c()).a(EnumChatFormat.h));
                            mutableboolean.setFalse();
                        }
                        itemattributemodifiers_b.a(consumer, entityhuman, (Holder<AttributeBase>)holder, (AttributeModifier)attributemodifier);
                    }
                }));
            }
        }
    }

    public boolean C() {
        Boolean obool = this.a(DataComponents.t);
        return obool != null ? obool.booleanValue() : this.h().d_(this);
    }

    public EnumItemRarity D() {
        EnumItemRarity enumitemrarity = this.a(DataComponents.k, EnumItemRarity.a);
        if (!this.F()) {
            return enumitemrarity;
        }
        return switch (enumitemrarity) {
            case EnumItemRarity.a, EnumItemRarity.b -> EnumItemRarity.c;
            case EnumItemRarity.c -> EnumItemRarity.d;
            default -> enumitemrarity;
        };
    }

    public boolean E() {
        if (!this.c(DataComponents.C)) {
            return false;
        }
        ItemEnchantments itemenchantments = this.a(DataComponents.l);
        return itemenchantments != null && itemenchantments.d();
    }

    public void a(Holder<Enchantment> holder, int i2) {
        EnchantmentManager.a(this, (ItemEnchantments.a itemenchantments_a) -> itemenchantments_a.b(holder, i2));
    }

    public boolean F() {
        return !this.a(DataComponents.l, ItemEnchantments.a).d();
    }

    public ItemEnchantments G() {
        return this.a(DataComponents.l, ItemEnchantments.a);
    }

    public boolean H() {
        return this.u instanceof EntityItemFrame;
    }

    public void a(@Nullable Entity entity) {
        if (!this.f()) {
            this.u = entity;
        }
    }

    @Nullable
    public EntityItemFrame I() {
        return this.u instanceof EntityItemFrame ? (EntityItemFrame)this.J() : null;
    }

    @Nullable
    public Entity J() {
        return !this.f() ? this.u : null;
    }

    public void a(EquipmentSlotGroup equipmentslotgroup, TriConsumer<Holder<AttributeBase>, AttributeModifier, ItemAttributeModifiers.b> triconsumer) {
        ItemAttributeModifiers itemattributemodifiers = this.a(DataComponents.o, ItemAttributeModifiers.a);
        itemattributemodifiers.a(equipmentslotgroup, triconsumer);
        EnchantmentManager.a(this, equipmentslotgroup, (holder, attributemodifier) -> triconsumer.accept(holder, attributemodifier, (Object)ItemAttributeModifiers.b.a()));
    }

    public void a(EnumItemSlot enumitemslot, BiConsumer<Holder<AttributeBase>, AttributeModifier> biconsumer) {
        ItemAttributeModifiers itemattributemodifiers = this.a(DataComponents.o, ItemAttributeModifiers.a);
        itemattributemodifiers.a(enumitemslot, biconsumer);
        EnchantmentManager.a(this, enumitemslot, biconsumer);
    }

    @Deprecated
    public void setItem(Item item) {
        this.s = item;
    }

    public IChatBaseComponent K() {
        IChatMutableComponent ichatmutablecomponent = IChatBaseComponent.i().b(this.y());
        if (this.c(DataComponents.g)) {
            ichatmutablecomponent.a(EnumChatFormat.u);
        }
        IChatMutableComponent ichatmutablecomponent1 = ChatComponentUtils.a(ichatmutablecomponent);
        if (!this.f()) {
            ichatmutablecomponent1.a(this.D().a()).a(chatmodifier -> chatmodifier.a(new ChatHoverable.d(this)));
        }
        return ichatmutablecomponent1;
    }

    public boolean a(ShapeDetectorBlock shapedetectorblock) {
        AdventureModePredicate adventuremodepredicate = this.a(DataComponents.m);
        return adventuremodepredicate != null && adventuremodepredicate.a(shapedetectorblock);
    }

    public boolean b(ShapeDetectorBlock shapedetectorblock) {
        AdventureModePredicate adventuremodepredicate = this.a(DataComponents.n);
        return adventuremodepredicate != null && adventuremodepredicate.a(shapedetectorblock);
    }

    public int L() {
        return this.r;
    }

    public void d(int i2) {
        this.r = i2;
    }

    public int M() {
        return this.f() ? 0 : this.q;
    }

    public void e(int i2) {
        this.q = i2;
    }

    public void f(int i2) {
        if (!this.f() && this.M() > i2) {
            this.e(i2);
        }
    }

    public void g(int i2) {
        this.e(this.M() + i2);
    }

    public void h(int i2) {
        this.g(-i2);
    }

    public void a(int i2, @Nullable EntityLiving entityliving) {
        if (!(entityliving != null && entityliving.gk() || this == l)) {
            this.h(i2);
        }
    }

    public ItemStack b(int i2, @Nullable EntityLiving entityliving) {
        ItemStack itemstack = this.c(i2);
        this.a(i2, entityliving);
        return itemstack;
    }

    public void b(net.minecraft.world.level.World world, EntityLiving entityliving, int i2) {
        Consumable consumable = this.a(DataComponents.w);
        if (consumable != null && consumable.a(i2)) {
            consumable.a(entityliving.ek(), entityliving, this, 5);
        }
        this.h().a(world, entityliving, this, i2);
    }

    public void a(EntityItem entityitem) {
        this.h().a(entityitem);
    }

    public boolean a(DamageSource damagesource) {
        DamageResistant damageresistant = this.a(DataComponents.z);
        return damageresistant == null || !damageresistant.a(damagesource);
    }

    public boolean c(ItemStack itemstack) {
        Repairable repairable = this.a(DataComponents.E);
        return repairable != null && repairable.a(itemstack);
    }

    public boolean a(IBlockData iblockdata, net.minecraft.world.level.World world, BlockPosition blockposition, EntityHuman entityhuman) {
        return this.h().a(this, iblockdata, world, blockposition, (EntityLiving)entityhuman);
    }

    static {
        MapCodec<ItemStack> mapcodec = a;
        Objects.requireNonNull(mapcodec);
        b = Codec.lazyInitialized(() -> mapcodec.codec());
        c = Codec.lazyInitialized(() -> RecordCodecBuilder.create(instance -> instance.group((App)Item.e.fieldOf("id").forGetter(ItemStack::i), (App)DataComponentPatch.b.optionalFieldOf("components", (Object)DataComponentPatch.a).forGetter(itemstack -> itemstack.t.g())).apply((Applicative)instance, (holder, datacomponentpatch) -> new ItemStack((Holder<Item>)holder, 1, (DataComponentPatch)datacomponentpatch))));
        d = b.validate(ItemStack::a);
        e = c.validate(ItemStack::a);
        f = ExtraCodecs.g(b).xmap(optional -> optional.orElse(l), itemstack -> itemstack.f() ? Optional.empty() : Optional.of(itemstack));
        g = Item.e.xmap(ItemStack::new, ItemStack::i);
        h = ItemStack.b(DataComponentPatch.c);
        i = ItemStack.b(DataComponentPatch.d);
        j = new StreamCodec<RegistryFriendlyByteBuf, ItemStack>(){

            public ItemStack a(RegistryFriendlyByteBuf registryfriendlybytebuf) {
                ItemStack itemstack = (ItemStack)h.decode(registryfriendlybytebuf);
                if (itemstack.f()) {
                    throw new DecoderException("Empty ItemStack not allowed");
                }
                return itemstack;
            }

            public void a(RegistryFriendlyByteBuf registryfriendlybytebuf, ItemStack itemstack) {
                if (itemstack.f()) {
                    throw new EncoderException("Empty ItemStack not allowed");
                }
                h.encode(registryfriendlybytebuf, itemstack);
            }
        };
        k = h.a(ByteBufCodecs.a(NonNullList::a));
        o = LogUtils.getLogger();
        l = new ItemStack((Void)null);
        p = IChatBaseComponent.c("item.disabled").a(EnumChatFormat.m);
    }
}

