/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.state;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.DependantName;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.ITileInventory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.flag.FeatureElement;
import net.minecraft.world.flag.FeatureFlag;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.item.context.ItemActionContext;
import net.minecraft.world.level.BlockAccessAir;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.ServerExplosion;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.EnumBlockSupport;
import net.minecraft.world.level.block.EnumRenderType;
import net.minecraft.world.level.block.ITileEntity;
import net.minecraft.world.level.block.SoundEffectType;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.IBlockDataHolder;
import net.minecraft.world.level.block.state.properties.BlockPropertyInstrument;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.level.material.EnumPistonReaction;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.material.MaterialMapColor;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;

public abstract class BlockBase
implements FeatureElement {
    protected static final EnumDirection[] E = new EnumDirection[]{EnumDirection.e, EnumDirection.f, EnumDirection.c, EnumDirection.d, EnumDirection.a, EnumDirection.b};
    protected final boolean F;
    protected final float G;
    protected final boolean H;
    protected final SoundEffectType I;
    protected final float J;
    protected final float K;
    protected final float L;
    protected final boolean M;
    protected final FeatureFlagSet N;
    protected final Info O;
    protected final Optional<ResourceKey<LootTable>> P;
    protected final String Q;

    public BlockBase(Info blockbase_info) {
        this.F = blockbase_info.c;
        this.P = blockbase_info.h();
        this.Q = blockbase_info.q();
        this.G = blockbase_info.f;
        this.H = blockbase_info.i;
        this.I = blockbase_info.d;
        this.J = blockbase_info.j;
        this.K = blockbase_info.k;
        this.L = blockbase_info.l;
        this.M = blockbase_info.F;
        this.N = blockbase_info.G;
        this.O = blockbase_info;
    }

    public Info w() {
        return this.O;
    }

    protected abstract MapCodec<? extends Block> a();

    protected static <B extends Block> RecordCodecBuilder<B, Info> x() {
        return Info.a.fieldOf("properties").forGetter(BlockBase::w);
    }

    public static <B extends Block> MapCodec<B> b(Function<Info, B> function) {
        return RecordCodecBuilder.mapCodec(instance -> instance.group(BlockBase.x()).apply((Applicative)instance, function));
    }

    protected void a(IBlockData iblockdata, GeneratorAccess generatoraccess, BlockPosition blockposition, int i2, int j2) {
    }

    protected boolean a(IBlockData iblockdata, PathMode pathmode) {
        switch (pathmode) {
            case a: {
                return !iblockdata.m(BlockAccessAir.a, BlockPosition.c);
            }
            case b: {
                return iblockdata.y().a(TagsFluid.a);
            }
            case c: {
                return !iblockdata.m(BlockAccessAir.a, BlockPosition.c);
            }
        }
        return false;
    }

    protected IBlockData a(IBlockData iblockdata, IWorldReader iworldreader, ScheduledTickAccess scheduledtickaccess, BlockPosition blockposition, EnumDirection enumdirection, BlockPosition blockposition1, IBlockData iblockdata1, RandomSource randomsource) {
        return iblockdata;
    }

    protected boolean b(IBlockData iblockdata, IBlockData iblockdata1, EnumDirection enumdirection) {
        return false;
    }

    protected void a(IBlockData iblockdata, World world, BlockPosition blockposition, Block block, @Nullable Orientation orientation, boolean flag) {
    }

    protected void a(IBlockData iblockdata, World world, BlockPosition blockposition, IBlockData iblockdata1, boolean flag) {
    }

    protected void onPlace(IBlockData iblockdata, World world, BlockPosition blockposition, IBlockData iblockdata1, boolean flag, @Nullable ItemActionContext context) {
        this.a(iblockdata, world, blockposition, iblockdata1, flag);
    }

    protected void a(IBlockData iblockdata, WorldServer worldserver, BlockPosition blockposition, boolean flag) {
    }

    protected void a(IBlockData iblockdata, WorldServer worldserver, BlockPosition blockposition, Explosion explosion, BiConsumer<ItemStack, BlockPosition> biconsumer) {
        if (!iblockdata.l() && explosion.b() != Explosion.Effect.d) {
            Block block = iblockdata.b();
            boolean flag = explosion.c() instanceof EntityHuman;
            if (block.a(explosion)) {
                TileEntity tileentity = iblockdata.x() ? worldserver.c_(blockposition) : null;
                LootParams.a lootparams_a = new LootParams.a(worldserver).a(LootContextParameters.h, Vec3D.b(blockposition)).a(LootContextParameters.k, ItemStack.l).b(LootContextParameters.j, tileentity).b(LootContextParameters.a, explosion.d());
                if (explosion instanceof ServerExplosion) {
                    ServerExplosion serverExplosion = (ServerExplosion)explosion;
                    if (serverExplosion.yield < 1.0f) {
                        lootparams_a.a(LootContextParameters.l, Float.valueOf(1.0f / serverExplosion.yield));
                    }
                }
                iblockdata.a(worldserver, blockposition, ItemStack.l, flag);
                iblockdata.a(lootparams_a).forEach(itemstack -> biconsumer.accept((ItemStack)itemstack, blockposition));
            }
            worldserver.a(blockposition, Blocks.a.m(), 3);
            block.a(worldserver, blockposition, explosion);
        }
    }

    protected EnumInteractionResult a(IBlockData iblockdata, World world, BlockPosition blockposition, EntityHuman entityhuman, MovingObjectPositionBlock movingobjectpositionblock) {
        return EnumInteractionResult.e;
    }

    protected EnumInteractionResult a(ItemStack itemstack, IBlockData iblockdata, World world, BlockPosition blockposition, EntityHuman entityhuman, EnumHand enumhand, MovingObjectPositionBlock movingobjectpositionblock) {
        return EnumInteractionResult.f;
    }

    protected boolean a(IBlockData iblockdata, World world, BlockPosition blockposition, int i2, int j2) {
        return false;
    }

    protected EnumRenderType a_(IBlockData iblockdata) {
        return EnumRenderType.b;
    }

    protected boolean g_(IBlockData iblockdata) {
        return false;
    }

    protected boolean e_(IBlockData iblockdata) {
        return false;
    }

    protected Fluid b_(IBlockData iblockdata) {
        return FluidTypes.a.g();
    }

    protected boolean c_(IBlockData iblockdata) {
        return false;
    }

    protected float at_() {
        return 0.25f;
    }

    protected float av_() {
        return 0.2f;
    }

    @Override
    public FeatureFlagSet k() {
        return this.N;
    }

    protected boolean o(IBlockData iblockdata) {
        return false;
    }

    protected IBlockData a(IBlockData iblockdata, EnumBlockRotation enumblockrotation) {
        return iblockdata;
    }

    protected IBlockData a(IBlockData iblockdata, EnumBlockMirror enumblockmirror) {
        return iblockdata;
    }

    protected boolean a(IBlockData iblockdata, BlockActionContext blockactioncontext) {
        return iblockdata.v() && (blockactioncontext.n().f() || !blockactioncontext.n().a(this.h()));
    }

    protected boolean a(IBlockData iblockdata, FluidType fluidtype) {
        return iblockdata.v() || !iblockdata.e();
    }

    protected List<ItemStack> a(IBlockData iblockdata, LootParams.a lootparams_a) {
        if (this.P.isEmpty()) {
            return Collections.emptyList();
        }
        LootParams lootparams = lootparams_a.a(LootContextParameters.i, iblockdata).a(LootContextParameterSets.r);
        WorldServer worldserver = lootparams.a();
        LootTable loottable = worldserver.q().bi().a(this.P.get());
        return loottable.a(lootparams);
    }

    protected long a(IBlockData iblockdata, BlockPosition blockposition) {
        return MathHelper.a(blockposition);
    }

    protected VoxelShape f_(IBlockData iblockdata) {
        return iblockdata.f(BlockAccessAir.a, BlockPosition.c);
    }

    protected VoxelShape b_(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition) {
        return this.b(iblockdata, iblockaccess, blockposition, VoxelShapeCollision.a());
    }

    protected VoxelShape a(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition) {
        return VoxelShapes.a();
    }

    protected int i_(IBlockData iblockdata) {
        return iblockdata.s() ? 15 : (iblockdata.f() ? 0 : 1);
    }

    @Nullable
    protected ITileInventory a(IBlockData iblockdata, World world, BlockPosition blockposition) {
        return null;
    }

    protected boolean a(IBlockData iblockdata, IWorldReader iworldreader, BlockPosition blockposition) {
        return true;
    }

    protected float c(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition) {
        return iblockdata.m(iblockaccess, blockposition) ? 0.2f : 1.0f;
    }

    protected int a(IBlockData iblockdata, World world, BlockPosition blockposition, EnumDirection enumdirection) {
        return 0;
    }

    protected VoxelShape a(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition, VoxelShapeCollision voxelshapecollision) {
        return VoxelShapes.b();
    }

    protected VoxelShape b(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition, VoxelShapeCollision voxelshapecollision) {
        return this.F ? iblockdata.f(iblockaccess, blockposition) : VoxelShapes.a();
    }

    protected VoxelShape a(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition, Entity entity) {
        return VoxelShapes.b();
    }

    protected boolean a_(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition) {
        return Block.a(iblockdata.g(iblockaccess, blockposition));
    }

    protected VoxelShape c(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition, VoxelShapeCollision voxelshapecollision) {
        return this.b(iblockdata, iblockaccess, blockposition, voxelshapecollision);
    }

    protected void b(IBlockData iblockdata, WorldServer worldserver, BlockPosition blockposition, RandomSource randomsource) {
    }

    protected void a(IBlockData iblockdata, WorldServer worldserver, BlockPosition blockposition, RandomSource randomsource) {
    }

    protected float a(IBlockData iblockdata, EntityHuman entityhuman, IBlockAccess iblockaccess, BlockPosition blockposition) {
        float f2 = iblockdata.e(iblockaccess, blockposition);
        if (f2 == -1.0f) {
            return 0.0f;
        }
        int i2 = entityhuman.d(iblockdata) ? 30 : 100;
        return entityhuman.c(iblockdata) / f2 / (float)i2;
    }

    protected void a(IBlockData iblockdata, WorldServer worldserver, BlockPosition blockposition, ItemStack itemstack, boolean flag) {
    }

    protected void a_(IBlockData iblockdata, World world, BlockPosition blockposition, EntityHuman entityhuman) {
    }

    protected int a(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition, EnumDirection enumdirection) {
        return 0;
    }

    protected void a(IBlockData iblockdata, World world, BlockPosition blockposition, Entity entity, InsideBlockEffectApplier insideblockeffectapplier, boolean flag) {
    }

    protected int b(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition, EnumDirection enumdirection) {
        return 0;
    }

    public final Optional<ResourceKey<LootTable>> y() {
        return this.P;
    }

    public final String z() {
        return this.Q;
    }

    protected void a(World world, IBlockData iblockdata, MovingObjectPositionBlock movingobjectpositionblock, IProjectile iprojectile) {
    }

    protected boolean d_(IBlockData iblockdata) {
        return !Block.a(iblockdata.f(BlockAccessAir.a, BlockPosition.c)) && iblockdata.y().c();
    }

    protected boolean f(IBlockData iblockdata) {
        return this.H;
    }

    protected SoundEffectType h_(IBlockData iblockdata) {
        return this.I;
    }

    protected ItemStack a(IWorldReader iworldreader, BlockPosition blockposition, IBlockData iblockdata, boolean flag) {
        return new ItemStack(this.h());
    }

    public abstract Item h();

    protected abstract Block o();

    public MaterialMapColor A() {
        return this.O.b.apply(this.o().m());
    }

    public float B() {
        return this.O.g;
    }

    public static class Info {
        public static final Codec<Info> a = Codec.unit(() -> Info.a());
        Function<IBlockData, MaterialMapColor> b = iblockdata -> MaterialMapColor.a;
        boolean c = true;
        SoundEffectType d = SoundEffectType.f;
        ToIntFunction<IBlockData> e = iblockdata -> 0;
        float f;
        float g;
        boolean h;
        boolean i;
        float j = 0.6f;
        float k = 1.0f;
        float l = 1.0f;
        @Nullable
        private ResourceKey<Block> m;
        private DependantName<Block, Optional<ResourceKey<LootTable>>> n = resourcekey -> Optional.of(ResourceKey.a(Registries.bz, resourcekey.a().f("blocks/")));
        private DependantName<Block, String> o = resourcekey -> SystemUtils.a("block", resourcekey.a());
        boolean p = true;
        boolean q;
        boolean r;
        @Deprecated
        boolean s;
        @Deprecated
        boolean t;
        boolean u;
        EnumPistonReaction v = EnumPistonReaction.a;
        boolean w = true;
        BlockPropertyInstrument x = BlockPropertyInstrument.a;
        boolean y;
        e<EntityTypes<?>> z = (iblockdata, iblockaccess, blockposition, entitytypes) -> iblockdata.c(iblockaccess, blockposition, EnumDirection.b) && iblockdata.k() < 14;
        f A = (iblockdata, iblockaccess, blockposition) -> iblockdata.m(iblockaccess, blockposition);
        f B;
        f C = this.B = (iblockdata, iblockaccess, blockposition) -> iblockdata.d() && iblockdata.m(iblockaccess, blockposition);
        f D = (iblockdata, iblockaccess, blockposition) -> false;
        f E = (iblockdata, iblockaccess, blockposition) -> false;
        boolean F;
        FeatureFlagSet G = FeatureFlags.g;
        @Nullable
        b H;

        private Info() {
        }

        public static Info a() {
            return new Info();
        }

        public static Info a(BlockBase blockbase) {
            Info blockbase_info = Info.b(blockbase);
            Info blockbase_info1 = blockbase.O;
            blockbase_info.l = blockbase_info1.l;
            blockbase_info.A = blockbase_info1.A;
            blockbase_info.z = blockbase_info1.z;
            blockbase_info.D = blockbase_info1.D;
            blockbase_info.B = blockbase_info1.B;
            blockbase_info.C = blockbase_info1.C;
            blockbase_info.n = blockbase_info1.n;
            blockbase_info.o = blockbase_info1.o;
            return blockbase_info;
        }

        @Deprecated
        public static Info b(BlockBase blockbase) {
            Info blockbase_info = new Info();
            Info blockbase_info1 = blockbase.O;
            blockbase_info.g = blockbase_info1.g;
            blockbase_info.f = blockbase_info1.f;
            blockbase_info.c = blockbase_info1.c;
            blockbase_info.i = blockbase_info1.i;
            blockbase_info.e = blockbase_info1.e;
            blockbase_info.b = blockbase_info1.b;
            blockbase_info.d = blockbase_info1.d;
            blockbase_info.j = blockbase_info1.j;
            blockbase_info.k = blockbase_info1.k;
            blockbase_info.F = blockbase_info1.F;
            blockbase_info.p = blockbase_info1.p;
            blockbase_info.q = blockbase_info1.q;
            blockbase_info.r = blockbase_info1.r;
            blockbase_info.s = blockbase_info1.s;
            blockbase_info.t = blockbase_info1.t;
            blockbase_info.u = blockbase_info1.u;
            blockbase_info.v = blockbase_info1.v;
            blockbase_info.h = blockbase_info1.h;
            blockbase_info.H = blockbase_info1.H;
            blockbase_info.w = blockbase_info1.w;
            blockbase_info.G = blockbase_info1.G;
            blockbase_info.E = blockbase_info1.E;
            blockbase_info.x = blockbase_info1.x;
            blockbase_info.y = blockbase_info1.y;
            return blockbase_info;
        }

        public Info a(EnumColor enumcolor) {
            this.b = iblockdata -> enumcolor.e();
            return this;
        }

        public Info a(MaterialMapColor materialmapcolor) {
            this.b = iblockdata -> materialmapcolor;
            return this;
        }

        public Info a(Function<IBlockData, MaterialMapColor> function) {
            this.b = function;
            return this;
        }

        public Info b() {
            this.c = false;
            this.p = false;
            return this;
        }

        public Info c() {
            this.p = false;
            return this;
        }

        public Info a(float f2) {
            this.j = f2;
            return this;
        }

        public Info b(float f2) {
            this.k = f2;
            return this;
        }

        public Info c(float f2) {
            this.l = f2;
            return this;
        }

        public Info a(SoundEffectType soundeffecttype) {
            this.d = soundeffecttype;
            return this;
        }

        public Info a(ToIntFunction<IBlockData> tointfunction) {
            this.e = tointfunction;
            return this;
        }

        public Info a(float f2, float f1) {
            return this.e(f2).f(f1);
        }

        public Info d() {
            return this.d(0.0f);
        }

        public Info d(float f2) {
            this.a(f2, f2);
            return this;
        }

        public Info e() {
            this.i = true;
            return this;
        }

        public Info f() {
            this.F = true;
            return this;
        }

        public Info g() {
            this.n = DependantName.fixed(Optional.empty());
            return this;
        }

        public Info a(Optional<ResourceKey<LootTable>> optional) {
            this.n = DependantName.fixed(optional);
            return this;
        }

        protected Optional<ResourceKey<LootTable>> h() {
            return this.n.get(Objects.requireNonNull(this.m, "Block id not set"));
        }

        public Info i() {
            this.r = true;
            return this;
        }

        public Info j() {
            this.s = true;
            return this;
        }

        public Info k() {
            this.u = true;
            return this;
        }

        @Deprecated
        public Info l() {
            this.t = true;
            return this;
        }

        public Info a(EnumPistonReaction enumpistonreaction) {
            this.v = enumpistonreaction;
            return this;
        }

        public Info m() {
            this.q = true;
            return this;
        }

        public Info a(e<EntityTypes<?>> blockbase_e) {
            this.z = blockbase_e;
            return this;
        }

        public Info a(f blockbase_f) {
            this.A = blockbase_f;
            return this;
        }

        public Info b(f blockbase_f) {
            this.B = blockbase_f;
            return this;
        }

        public Info c(f blockbase_f) {
            this.C = blockbase_f;
            return this;
        }

        public Info d(f blockbase_f) {
            this.D = blockbase_f;
            return this;
        }

        public Info e(f blockbase_f) {
            this.E = blockbase_f;
            return this;
        }

        public Info n() {
            this.h = true;
            return this;
        }

        public Info e(float f2) {
            this.g = f2;
            return this;
        }

        public Info f(float f2) {
            this.f = Math.max(0.0f, f2);
            return this;
        }

        public Info a(EnumRandomOffset blockbase_enumrandomoffset) {
            this.H = switch (blockbase_enumrandomoffset.ordinal()) {
                case 0 -> null;
                case 1 -> (iblockdata, blockposition) -> {
                    Block block = iblockdata.b();
                    long i2 = MathHelper.b(blockposition.u(), 0, blockposition.w());
                    float f2 = block.at_();
                    double d0 = MathHelper.a(((double)((float)(i2 & 0xFL) / 15.0f) - 0.5) * 0.5, (double)(-f2), (double)f2);
                    double d1 = MathHelper.a(((double)((float)(i2 >> 8 & 0xFL) / 15.0f) - 0.5) * 0.5, (double)(-f2), (double)f2);
                    return new Vec3D(d0, 0.0, d1);
                };
                case 2 -> (iblockdata, blockposition) -> {
                    Block block = iblockdata.b();
                    long i2 = MathHelper.b(blockposition.u(), 0, blockposition.w());
                    double d0 = ((double)((float)(i2 >> 4 & 0xFL) / 15.0f) - 1.0) * (double)block.av_();
                    float f2 = block.at_();
                    double d1 = MathHelper.a(((double)((float)(i2 & 0xFL) / 15.0f) - 0.5) * 0.5, (double)(-f2), (double)f2);
                    double d2 = MathHelper.a(((double)((float)(i2 >> 8 & 0xFL) / 15.0f) - 0.5) * 0.5, (double)(-f2), (double)f2);
                    return new Vec3D(d1, d0, d2);
                };
                default -> throw new MatchException(null, null);
            };
            return this;
        }

        public Info o() {
            this.w = false;
            return this;
        }

        public Info a(FeatureFlag ... afeatureflag) {
            this.G = FeatureFlags.e.a(afeatureflag);
            return this;
        }

        public Info a(BlockPropertyInstrument blockpropertyinstrument) {
            this.x = blockpropertyinstrument;
            return this;
        }

        public Info p() {
            this.y = true;
            return this;
        }

        public Info a(ResourceKey<Block> resourcekey) {
            this.m = resourcekey;
            return this;
        }

        public Info a(String s2) {
            this.o = DependantName.fixed(s2);
            return this;
        }

        protected String q() {
            return this.o.get(Objects.requireNonNull(this.m, "Block id not set"));
        }
    }

    @FunctionalInterface
    public static interface f {
        public boolean test(IBlockData var1, IBlockAccess var2, BlockPosition var3);
    }

    @FunctionalInterface
    public static interface e<A> {
        public boolean test(IBlockData var1, IBlockAccess var2, BlockPosition var3, A var4);
    }

    @FunctionalInterface
    public static interface b {
        public Vec3D evaluate(IBlockData var1, BlockPosition var2);
    }

    public static abstract class BlockData
    extends IBlockDataHolder<Block, IBlockData> {
        private static final EnumDirection[] a = EnumDirection.values();
        private static final VoxelShape[] f = SystemUtils.a(new VoxelShape[a.length], (? super T avoxelshape) -> Arrays.fill(avoxelshape, VoxelShapes.a()));
        private static final VoxelShape[] g = SystemUtils.a(new VoxelShape[a.length], (? super T avoxelshape) -> Arrays.fill(avoxelshape, VoxelShapes.b()));
        private final int h;
        private final boolean i;
        private final boolean j;
        private final boolean k;
        @Deprecated
        private final boolean l;
        @Deprecated
        private boolean m;
        private final EnumPistonReaction n;
        private final MaterialMapColor o;
        public final float p;
        private final boolean q;
        private final boolean r;
        private final f s;
        private final f t;
        private final f u;
        private final f v;
        private final f w;
        @Nullable
        private final b x;
        private final boolean y;
        private final BlockPropertyInstrument z;
        private final boolean A;
        @Nullable
        private Cache B;
        private Fluid C = FluidTypes.a.g();
        private boolean D;
        private boolean E;
        private VoxelShape F;
        private VoxelShape[] G;
        private boolean H;
        private int I;

        protected BlockData(Block block, Reference2ObjectArrayMap<IBlockState<?>, Comparable<?>> reference2objectarraymap, MapCodec<IBlockData> mapcodec) {
            super(block, reference2objectarraymap, mapcodec);
            Info blockbase_info = block.O;
            this.h = blockbase_info.e.applyAsInt(this.B());
            this.i = block.g_(this.B());
            this.j = blockbase_info.q;
            this.k = blockbase_info.r;
            this.l = blockbase_info.s;
            this.n = blockbase_info.v;
            this.o = blockbase_info.b.apply(this.B());
            this.p = blockbase_info.g;
            this.q = blockbase_info.h;
            this.r = blockbase_info.p;
            this.s = blockbase_info.A;
            this.t = blockbase_info.B;
            this.u = blockbase_info.C;
            this.v = blockbase_info.D;
            this.w = blockbase_info.E;
            this.x = blockbase_info.H;
            this.y = blockbase_info.w;
            this.z = blockbase_info.x;
            this.A = blockbase_info.y;
        }

        private boolean H() {
            if (((Block)this.d).O.u) {
                return true;
            }
            if (((Block)this.d).O.t) {
                return false;
            }
            if (this.B == null) {
                return false;
            }
            VoxelShape voxelshape = this.B.a;
            if (voxelshape.c()) {
                return false;
            }
            AxisAlignedBB axisalignedbb = voxelshape.a();
            return axisalignedbb.a() >= 0.7291666666666666 ? true : axisalignedbb.c() >= 1.0;
        }

        public void a() {
            this.C = ((Block)this.d).b_(this.B());
            this.D = ((Block)this.d).f(this.B());
            if (!this.b().n()) {
                this.B = new Cache(this.B());
            }
            this.m = this.H();
            this.F = this.r ? ((Block)this.d).f_(this.B()) : VoxelShapes.a();
            this.E = Block.a(this.F);
            if (this.F.c()) {
                this.G = f;
            } else if (this.E) {
                this.G = g;
            } else {
                this.G = new VoxelShape[a.length];
                for (EnumDirection enumdirection : a) {
                    this.G[enumdirection.ordinal()] = this.F.a(enumdirection);
                }
            }
            this.H = ((Block)this.d).d_(this.B());
            this.I = ((Block)this.d).i_(this.B());
        }

        public Block b() {
            return (Block)this.d;
        }

        public Holder<Block> c() {
            return ((Block)this.d).p();
        }

        @Deprecated
        public boolean d() {
            Block block = this.b();
            return block != Blocks.bz && block != Blocks.nV && this.e();
        }

        @Deprecated
        public boolean e() {
            return this.m;
        }

        public boolean a(IBlockAccess iblockaccess, BlockPosition blockposition, EntityTypes<?> entitytypes) {
            return this.b().O.z.test(this.B(), iblockaccess, blockposition, entitytypes);
        }

        public boolean f() {
            return this.H;
        }

        public int g() {
            return this.I;
        }

        public VoxelShape a(EnumDirection enumdirection) {
            return this.G[enumdirection.ordinal()];
        }

        public VoxelShape h() {
            return this.F;
        }

        public boolean i() {
            return this.B == null || this.B.b;
        }

        public boolean j() {
            return this.i;
        }

        public int k() {
            return this.h;
        }

        public boolean l() {
            return this.j;
        }

        public boolean m() {
            return this.k;
        }

        @Deprecated
        public boolean n() {
            return this.l;
        }

        public MaterialMapColor a(IBlockAccess iblockaccess, BlockPosition blockposition) {
            return this.o;
        }

        public IBlockData a(EnumBlockRotation enumblockrotation) {
            return this.b().a(this.B(), enumblockrotation);
        }

        public IBlockData a(EnumBlockMirror enumblockmirror) {
            return this.b().a(this.B(), enumblockmirror);
        }

        public EnumRenderType o() {
            return this.b().a_(this.B());
        }

        public boolean b(IBlockAccess iblockaccess, BlockPosition blockposition) {
            return this.w.test(this.B(), iblockaccess, blockposition);
        }

        public float c(IBlockAccess iblockaccess, BlockPosition blockposition) {
            return this.b().c(this.B(), iblockaccess, blockposition);
        }

        public boolean d(IBlockAccess iblockaccess, BlockPosition blockposition) {
            return this.s.test(this.B(), iblockaccess, blockposition);
        }

        public boolean p() {
            return this.b().e_(this.B());
        }

        public int a(IBlockAccess iblockaccess, BlockPosition blockposition, EnumDirection enumdirection) {
            return this.b().a(this.B(), iblockaccess, blockposition, enumdirection);
        }

        public boolean q() {
            return this.b().c_(this.B());
        }

        public int a(World world, BlockPosition blockposition, EnumDirection enumdirection) {
            return this.b().a(this.B(), world, blockposition, enumdirection);
        }

        public float e(IBlockAccess iblockaccess, BlockPosition blockposition) {
            return this.p;
        }

        public float a(EntityHuman entityhuman, IBlockAccess iblockaccess, BlockPosition blockposition) {
            return this.b().a(this.B(), entityhuman, iblockaccess, blockposition);
        }

        public int b(IBlockAccess iblockaccess, BlockPosition blockposition, EnumDirection enumdirection) {
            return this.b().b(this.B(), iblockaccess, blockposition, enumdirection);
        }

        public EnumPistonReaction r() {
            return this.n;
        }

        public boolean s() {
            return this.E;
        }

        public boolean t() {
            return this.r;
        }

        public boolean a(IBlockData iblockdata, EnumDirection enumdirection) {
            return this.b().b(this.B(), iblockdata, enumdirection);
        }

        public VoxelShape f(IBlockAccess iblockaccess, BlockPosition blockposition) {
            return this.a(iblockaccess, blockposition, VoxelShapeCollision.a());
        }

        public VoxelShape a(IBlockAccess iblockaccess, BlockPosition blockposition, VoxelShapeCollision voxelshapecollision) {
            return this.b().a(this.B(), iblockaccess, blockposition, voxelshapecollision);
        }

        public VoxelShape g(IBlockAccess iblockaccess, BlockPosition blockposition) {
            return this.B != null ? this.B.a : this.b(iblockaccess, blockposition, VoxelShapeCollision.a());
        }

        public VoxelShape b(IBlockAccess iblockaccess, BlockPosition blockposition, VoxelShapeCollision voxelshapecollision) {
            return this.b().b(this.B(), iblockaccess, blockposition, voxelshapecollision);
        }

        public VoxelShape a(IBlockAccess iblockaccess, BlockPosition blockposition, Entity entity) {
            return this.b().a(this.B(), iblockaccess, blockposition, entity);
        }

        public VoxelShape h(IBlockAccess iblockaccess, BlockPosition blockposition) {
            return this.b().b_(this.B(), iblockaccess, blockposition);
        }

        public VoxelShape c(IBlockAccess iblockaccess, BlockPosition blockposition, VoxelShapeCollision voxelshapecollision) {
            return this.b().c(this.B(), iblockaccess, blockposition, voxelshapecollision);
        }

        public VoxelShape i(IBlockAccess iblockaccess, BlockPosition blockposition) {
            return this.b().a(this.B(), iblockaccess, blockposition);
        }

        public final boolean b(IBlockAccess iblockaccess, BlockPosition blockposition, Entity entity) {
            return this.a(iblockaccess, blockposition, entity, EnumDirection.b);
        }

        public final boolean a(IBlockAccess iblockaccess, BlockPosition blockposition, Entity entity, EnumDirection enumdirection) {
            return Block.a(this.b(iblockaccess, blockposition, VoxelShapeCollision.a(entity)), enumdirection);
        }

        public Vec3D a(BlockPosition blockposition) {
            b blockbase_b = this.x;
            return blockbase_b != null ? blockbase_b.evaluate(this.B(), blockposition) : Vec3D.c;
        }

        public boolean u() {
            return this.x != null;
        }

        public boolean a(World world, BlockPosition blockposition, int i2, int j2) {
            return this.b().a(this.B(), world, blockposition, i2, j2);
        }

        public void a(World world, BlockPosition blockposition, Block block, @Nullable Orientation orientation, boolean flag) {
            this.b().a(this.B(), world, blockposition, block, orientation, flag);
        }

        public final void a(GeneratorAccess generatoraccess, BlockPosition blockposition, int i2) {
            this.a(generatoraccess, blockposition, i2, 512);
        }

        public final void a(GeneratorAccess generatoraccess, BlockPosition blockposition, int i2, int j2) {
            BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
            for (EnumDirection enumdirection : E) {
                blockposition_mutableblockposition.a((BaseBlockPosition)blockposition, enumdirection);
                generatoraccess.a(enumdirection.g(), (BlockPosition)blockposition_mutableblockposition, blockposition, this.B(), i2, j2);
            }
        }

        public final void b(GeneratorAccess generatoraccess, BlockPosition blockposition, int i2) {
            this.b(generatoraccess, blockposition, i2, 512);
        }

        public void b(GeneratorAccess generatoraccess, BlockPosition blockposition, int i2, int j2) {
            this.b().a(this.B(), generatoraccess, blockposition, i2, j2);
        }

        public void a(World world, BlockPosition blockposition, IBlockData iblockdata, boolean flag) {
            this.onPlace(world, blockposition, iblockdata, flag, null);
        }

        public void onPlace(World world, BlockPosition blockposition, IBlockData iblockdata, boolean flag, @Nullable ItemActionContext context) {
            this.b().onPlace(this.B(), world, blockposition, iblockdata, flag, context);
        }

        public void a(WorldServer worldserver, BlockPosition blockposition, boolean flag) {
            this.b().a(this.B(), worldserver, blockposition, flag);
        }

        public void a(WorldServer worldserver, BlockPosition blockposition, Explosion explosion, BiConsumer<ItemStack, BlockPosition> biconsumer) {
            this.b().a(this.B(), worldserver, blockposition, explosion, biconsumer);
        }

        public void a(WorldServer worldserver, BlockPosition blockposition, RandomSource randomsource) {
            this.b().a(this.B(), worldserver, blockposition, randomsource);
        }

        public void b(WorldServer worldserver, BlockPosition blockposition, RandomSource randomsource) {
            this.b().b(this.B(), worldserver, blockposition, randomsource);
        }

        public void a(World world, BlockPosition blockposition, Entity entity, InsideBlockEffectApplier insideblockeffectapplier, boolean flag) {
            this.b().a(this.B(), world, blockposition, entity, insideblockeffectapplier, flag);
        }

        public void a(WorldServer worldserver, BlockPosition blockposition, ItemStack itemstack, boolean flag) {
            this.b().a(this.B(), worldserver, blockposition, itemstack, flag);
        }

        public List<ItemStack> a(LootParams.a lootparams_a) {
            return this.b().a(this.B(), lootparams_a);
        }

        public EnumInteractionResult a(ItemStack itemstack, World world, EntityHuman entityhuman, EnumHand enumhand, MovingObjectPositionBlock movingobjectpositionblock) {
            return this.b().a(itemstack, this.B(), world, movingobjectpositionblock.b(), entityhuman, enumhand, movingobjectpositionblock);
        }

        public EnumInteractionResult a(World world, EntityHuman entityhuman, MovingObjectPositionBlock movingobjectpositionblock) {
            return this.b().a(this.B(), world, movingobjectpositionblock.b(), entityhuman, movingobjectpositionblock);
        }

        public void a(World world, BlockPosition blockposition, EntityHuman entityhuman) {
            this.b().a_(this.B(), world, blockposition, entityhuman);
        }

        public boolean j(IBlockAccess iblockaccess, BlockPosition blockposition) {
            return this.t.test(this.B(), iblockaccess, blockposition);
        }

        public boolean k(IBlockAccess iblockaccess, BlockPosition blockposition) {
            return this.u.test(this.B(), iblockaccess, blockposition);
        }

        public IBlockData a(IWorldReader iworldreader, ScheduledTickAccess scheduledtickaccess, BlockPosition blockposition, EnumDirection enumdirection, BlockPosition blockposition1, IBlockData iblockdata, RandomSource randomsource) {
            return this.b().a(this.B(), iworldreader, scheduledtickaccess, blockposition, enumdirection, blockposition1, iblockdata, randomsource);
        }

        public boolean a(PathMode pathmode) {
            return this.b().a(this.B(), pathmode);
        }

        public boolean a(BlockActionContext blockactioncontext) {
            return this.b().a(this.B(), blockactioncontext);
        }

        public boolean a(FluidType fluidtype) {
            return this.b().a(this.B(), fluidtype);
        }

        public boolean v() {
            return this.A;
        }

        public boolean a(IWorldReader iworldreader, BlockPosition blockposition) {
            return this.b().a(this.B(), iworldreader, blockposition);
        }

        public boolean l(IBlockAccess iblockaccess, BlockPosition blockposition) {
            return this.v.test(this.B(), iblockaccess, blockposition);
        }

        @Nullable
        public ITileInventory a(World world, BlockPosition blockposition) {
            return this.b().a(this.B(), world, blockposition);
        }

        @Override
        public boolean a(TagKey<Block> tagkey) {
            return this.b().p().a(tagkey);
        }

        @Override
        public boolean a(TagKey<Block> tagkey, Predicate<BlockData> predicate) {
            return this.a(tagkey) && predicate.test(this);
        }

        @Override
        public boolean a(HolderSet<Block> holderset) {
            return holderset.a(this.b().p());
        }

        @Override
        public boolean a(Holder<Block> holder) {
            return this.a(holder.a());
        }

        public Stream<TagKey<Block>> w() {
            return this.b().p().c();
        }

        public boolean x() {
            return this.b() instanceof ITileEntity;
        }

        public boolean a(IBlockData iblockdata) {
            return this.b().o(iblockdata);
        }

        @Nullable
        public <T extends TileEntity> BlockEntityTicker<T> a(World world, TileEntityTypes<T> tileentitytypes) {
            return this.b() instanceof ITileEntity ? ((ITileEntity)((Object)this.b())).a(world, this.B(), tileentitytypes) : null;
        }

        public boolean a(Block block) {
            return this.b() == block;
        }

        @Override
        public boolean a(ResourceKey<Block> resourcekey) {
            return this.b().p().a(resourcekey);
        }

        public Fluid y() {
            return this.C;
        }

        public boolean z() {
            return this.D;
        }

        public long b(BlockPosition blockposition) {
            return this.b().a(this.B(), blockposition);
        }

        public SoundEffectType A() {
            return this.b().h_(this.B());
        }

        public void a(World world, IBlockData iblockdata, MovingObjectPositionBlock movingobjectpositionblock, IProjectile iprojectile) {
            this.b().a(world, iblockdata, movingobjectpositionblock, iprojectile);
        }

        public boolean c(IBlockAccess iblockaccess, BlockPosition blockposition, EnumDirection enumdirection) {
            return this.a(iblockaccess, blockposition, enumdirection, EnumBlockSupport.a);
        }

        public boolean a(IBlockAccess iblockaccess, BlockPosition blockposition, EnumDirection enumdirection, EnumBlockSupport enumblocksupport) {
            return this.B != null ? this.B.a(enumdirection, enumblocksupport) : enumblocksupport.a(this.B(), iblockaccess, blockposition, enumdirection);
        }

        public boolean m(IBlockAccess iblockaccess, BlockPosition blockposition) {
            return this.B != null ? this.B.c : this.b().a_(this.B(), iblockaccess, blockposition);
        }

        public ItemStack a(IWorldReader iworldreader, BlockPosition blockposition, boolean flag) {
            return this.b().a(iworldreader, blockposition, this.B(), flag);
        }

        protected abstract IBlockData B();

        public boolean C() {
            return this.q;
        }

        public boolean D() {
            return this.y;
        }

        public BlockPropertyInstrument E() {
            return this.z;
        }

        private static final class Cache {
            private static final EnumDirection[] d = EnumDirection.values();
            private static final int e = EnumBlockSupport.values().length;
            protected final VoxelShape a;
            protected final boolean b;
            private final boolean[] f;
            protected final boolean c;

            Cache(IBlockData iblockdata) {
                Block block = iblockdata.b();
                this.a = block.b(iblockdata, (IBlockAccess)BlockAccessAir.a, BlockPosition.c, VoxelShapeCollision.a());
                if (!this.a.c() && iblockdata.u()) {
                    throw new IllegalStateException(String.format(Locale.ROOT, "%s has a collision shape and an offset type, but is not marked as dynamicShape in its properties.", BuiltInRegistries.e.b(block)));
                }
                this.b = Arrays.stream(EnumDirection.EnumAxis.values()).anyMatch(enumdirection_enumaxis -> this.a.b((EnumDirection.EnumAxis)enumdirection_enumaxis) < 0.0 || this.a.c((EnumDirection.EnumAxis)enumdirection_enumaxis) > 1.0);
                this.f = new boolean[d.length * e];
                for (EnumDirection enumdirection : d) {
                    for (EnumBlockSupport enumblocksupport : EnumBlockSupport.values()) {
                        this.f[Cache.b((EnumDirection)enumdirection, (EnumBlockSupport)enumblocksupport)] = enumblocksupport.a(iblockdata, BlockAccessAir.a, BlockPosition.c, enumdirection);
                    }
                }
                this.c = Block.a(iblockdata.g(BlockAccessAir.a, BlockPosition.c));
            }

            public boolean a(EnumDirection enumdirection, EnumBlockSupport enumblocksupport) {
                return this.f[Cache.b(enumdirection, enumblocksupport)];
            }

            private static int b(EnumDirection enumdirection, EnumBlockSupport enumblocksupport) {
                return enumdirection.ordinal() * e + enumblocksupport.ordinal();
            }
        }
    }

    public static enum EnumRandomOffset {
        a,
        b,
        c;

    }
}

