/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportedException;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.SectionPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.protocol.game.ClientboundLevelChunkPacketData;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.ProblemReporter;
import net.minecraft.util.debug.DebugStructureInfo;
import net.minecraft.util.debug.DebugSubscriptions;
import net.minecraft.util.debug.DebugValueSource;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFluids;
import net.minecraft.world.level.block.BlockMinecartTrackAbstract;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ITileEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.TickingBlockEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.ChunkConverter;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.gameevent.EuclideanGameEventListenerRegistry;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.GameEventListenerRegistry;
import net.minecraft.world.level.levelgen.ChunkProviderDebug;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.blending.BlendingData;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.lighting.LightEngine;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.ticks.LevelChunkTicks;
import net.minecraft.world.ticks.TickContainerAccess;
import org.bukkit.craftbukkit.v1_21_R6.CraftChunk;
import org.bukkit.craftbukkit.v1_21_R6.CraftServer;
import org.bukkit.craftbukkit.v1_21_R6.CraftWorld;
import org.bukkit.event.Event;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.event.world.ChunkPopulateEvent;
import org.bukkit.event.world.ChunkUnloadEvent;
import org.bukkit.generator.BlockPopulator;
import org.slf4j.Logger;

public class Chunk
extends IChunkAccess
implements DebugValueSource {
    static final Logger m = LogUtils.getLogger();
    private static final TickingBlockEntity n = new TickingBlockEntity(){

        @Override
        public void a() {
        }

        @Override
        public boolean b() {
            return true;
        }

        @Override
        public BlockPosition c() {
            return BlockPosition.c;
        }

        @Override
        public String d() {
            return "<null>";
        }
    };
    private final Map<BlockPosition, d> o = Maps.newHashMap();
    public boolean p;
    public final WorldServer q;
    @Nullable
    private Supplier<FullChunkStatus> r;
    @Nullable
    private c s;
    private final Int2ObjectMap<GameEventListenerRegistry> t;
    private final LevelChunkTicks<Block> u;
    private final LevelChunkTicks<FluidType> v;
    private e w = chunkcoordintpair1 -> {};
    public boolean mustNotSave;
    public boolean needsDecoration;

    public Chunk(World world, ChunkCoordIntPair chunkcoordintpair) {
        this(world, chunkcoordintpair, ChunkConverter.a, new LevelChunkTicks<Block>(), new LevelChunkTicks<FluidType>(), 0L, null, null, null);
    }

    public Chunk(World world, ChunkCoordIntPair chunkcoordintpair, ChunkConverter chunkconverter, LevelChunkTicks<Block> levelchunkticks, LevelChunkTicks<FluidType> levelchunkticks1, long i2, @Nullable ChunkSection[] achunksection, @Nullable c chunk_c, @Nullable BlendingData blendingdata) {
        super(chunkcoordintpair, chunkconverter, world, world.ao(), i2, achunksection, blendingdata);
        this.q = (WorldServer)world;
        this.t = new Int2ObjectOpenHashMap();
        for (HeightMap.Type heightmap_type : HeightMap.Type.values()) {
            if (!ChunkStatus.n.e().contains(heightmap_type)) continue;
            this.g.put(heightmap_type, new HeightMap(this, heightmap_type));
        }
        this.s = chunk_c;
        this.u = levelchunkticks;
        this.v = levelchunkticks1;
    }

    public Chunk(WorldServer worldserver, ProtoChunk protochunk, @Nullable c chunk_c) {
        this(worldserver, protochunk.f(), protochunk.t(), protochunk.L(), protochunk.M(), protochunk.w(), protochunk.d(), chunk_c, protochunk.v());
        if (!Collections.disjoint(protochunk.i.keySet(), protochunk.j.keySet())) {
            m.error("Chunk at {} contains duplicated block entities", (Object)protochunk.f());
        }
        for (TileEntity tileentity : protochunk.I().values()) {
            this.a(tileentity);
        }
        this.i.putAll(protochunk.K());
        for (int i2 = 0; i2 < protochunk.p().length; ++i2) {
            this.b[i2] = protochunk.p()[i2];
        }
        this.a(protochunk.g());
        this.b(protochunk.h());
        for (Map.Entry<HeightMap.Type, HeightMap> map_entry : protochunk.e()) {
            if (!ChunkStatus.n.e().contains(map_entry.getKey())) continue;
            this.a(map_entry.getKey(), map_entry.getValue().a());
        }
        this.h = protochunk.h;
        this.a(protochunk.x());
        this.i();
        this.needsDecoration = true;
        this.persistentDataContainer = protochunk.persistentDataContainer;
    }

    public void a(e chunk_e) {
        this.w = chunk_e;
        if (this.m()) {
            chunk_e.setUnsaved(this.c);
        }
    }

    @Override
    public void i() {
        boolean flag = this.m();
        super.i();
        if (!flag) {
            this.w.setUnsaved(this.c);
        }
    }

    @Override
    public TickContainerAccess<Block> q() {
        return this.u;
    }

    @Override
    public TickContainerAccess<FluidType> r() {
        return this.v;
    }

    @Override
    public IChunkAccess.b a(long i2) {
        return new IChunkAccess.b(this.u.a(i2), this.v.a(i2));
    }

    @Override
    public GameEventListenerRegistry a(int i2) {
        WorldServer world = this.q;
        if (world instanceof WorldServer) {
            WorldServer worldserver = world;
            return (GameEventListenerRegistry)this.t.computeIfAbsent(i2, j2 -> new EuclideanGameEventListenerRegistry(worldserver, i2, this::c));
        }
        return super.a(i2);
    }

    @Override
    public IBlockData a_(BlockPosition blockposition) {
        int i2 = blockposition.u();
        int j2 = blockposition.v();
        int k2 = blockposition.w();
        if (this.q.am()) {
            IBlockData iblockdata = null;
            if (j2 == 60) {
                iblockdata = Blocks.iO.m();
            }
            if (j2 == 70) {
                iblockdata = ChunkProviderDebug.a(i2, k2);
            }
            return iblockdata == null ? Blocks.a.m() : iblockdata;
        }
        try {
            ChunkSection chunksection;
            int l2 = this.f(j2);
            if (l2 >= 0 && l2 < this.l.length && !(chunksection = this.l[l2]).c()) {
                return chunksection.a(i2 & 0xF, j2 & 0xF, k2 & 0xF);
            }
            return Blocks.a.m();
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.a(throwable, "Getting block state");
            CrashReportSystemDetails crashreportsystemdetails = crashreport.a("Block being got");
            crashreportsystemdetails.a("Location", () -> CrashReportSystemDetails.a((LevelHeightAccessor)this, i2, j2, k2));
            throw new ReportedException(crashreport);
        }
    }

    @Override
    public Fluid b_(BlockPosition blockposition) {
        return this.a(blockposition.u(), blockposition.v(), blockposition.w());
    }

    public Fluid a(int i2, int j2, int k2) {
        try {
            ChunkSection chunksection;
            int l2 = this.f(j2);
            if (l2 >= 0 && l2 < this.l.length && !(chunksection = this.l[l2]).c()) {
                return chunksection.b(i2 & 0xF, j2 & 0xF, k2 & 0xF);
            }
            return FluidTypes.a.g();
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.a(throwable, "Getting fluid state");
            CrashReportSystemDetails crashreportsystemdetails = crashreport.a("Block being got");
            crashreportsystemdetails.a("Location", () -> CrashReportSystemDetails.a((LevelHeightAccessor)this, i2, j2, k2));
            throw new ReportedException(crashreport);
        }
    }

    @Override
    @Nullable
    public IBlockData a(BlockPosition blockposition, IBlockData iblockdata, int i2) {
        WorldServer world;
        boolean flag4;
        int i1;
        int l2;
        int j2 = blockposition.v();
        ChunkSection chunksection = this.b(this.f(j2));
        boolean flag = chunksection.c();
        if (flag && iblockdata.l()) {
            return null;
        }
        int k2 = blockposition.u() & 0xF;
        IBlockData iblockdata1 = chunksection.a(k2, l2 = j2 & 0xF, i1 = blockposition.w() & 0xF, iblockdata);
        if (iblockdata1 == iblockdata) {
            return null;
        }
        Block block = iblockdata.b();
        ((HeightMap)this.g.get(HeightMap.Type.e)).a(k2, j2, i1, iblockdata);
        ((HeightMap)this.g.get(HeightMap.Type.f)).a(k2, j2, i1, iblockdata);
        ((HeightMap)this.g.get(HeightMap.Type.d)).a(k2, j2, i1, iblockdata);
        ((HeightMap)this.g.get(HeightMap.Type.b)).a(k2, j2, i1, iblockdata);
        boolean flag1 = chunksection.c();
        if (flag != flag1) {
            this.q.n().a().a(blockposition, flag1);
            this.q.n().a(this.c.h, SectionPosition.a(j2), this.c.i, flag1);
        }
        if (LightEngine.a(iblockdata1, iblockdata)) {
            GameProfilerFiller gameprofilerfiller = Profiler.a();
            gameprofilerfiller.a("updateSkyLightSources");
            this.h.a((IBlockAccess)this, k2, j2, i1);
            gameprofilerfiller.b("queueCheckLight");
            this.q.n().a().a(blockposition);
            gameprofilerfiller.c();
        }
        boolean flag2 = !iblockdata1.a(block);
        boolean flag3 = (i2 & 0x40) != 0;
        boolean bl = flag4 = (i2 & 0x100) == 0;
        if (flag2 && iblockdata1.x() && !iblockdata.a(iblockdata1)) {
            TileEntity tileentity;
            if (!this.q.D_() && flag4 && (tileentity = this.q.c_(blockposition)) != null) {
                tileentity.a(blockposition, iblockdata1);
            }
            this.d(blockposition);
        }
        if ((flag2 || block instanceof BlockMinecartTrackAbstract) && (world = this.q) instanceof WorldServer) {
            WorldServer worldserver = world;
            if ((i2 & 1) != 0 || flag3) {
                iblockdata1.a(worldserver, blockposition, flag3);
            }
        }
        if (!chunksection.a(k2, l2, i1).a(block)) {
            return null;
        }
        if (!(this.q.D_() || (i2 & 0x200) != 0 || this.q.captureBlockStates && !(block instanceof BlockTileEntity))) {
            iblockdata.a((World)this.q, blockposition, iblockdata1, flag3);
        }
        if (iblockdata.x()) {
            TileEntity tileentity1 = this.a(blockposition, EnumTileEntityState.c);
            if (tileentity1 != null && !tileentity1.b(iblockdata)) {
                m.warn("Found mismatched block entity @ {}: type = {}, state = {}", new Object[]{blockposition, tileentity1.s().a().h().a(), iblockdata});
                this.d(blockposition);
                tileentity1 = null;
            }
            if (tileentity1 == null) {
                tileentity1 = ((ITileEntity)((Object)block)).a(blockposition, iblockdata);
                if (tileentity1 != null) {
                    this.b(tileentity1);
                }
            } else {
                tileentity1.c(iblockdata);
                this.c(tileentity1);
            }
        }
        this.i();
        return iblockdata1;
    }

    @Override
    @Deprecated
    public void a(Entity entity) {
    }

    @Nullable
    private TileEntity g(BlockPosition blockposition) {
        IBlockData iblockdata = this.a_(blockposition);
        return !iblockdata.x() ? null : ((ITileEntity)((Object)iblockdata.b())).a(blockposition, iblockdata);
    }

    @Override
    @Nullable
    public TileEntity c_(BlockPosition blockposition) {
        return this.a(blockposition, EnumTileEntityState.c);
    }

    @Nullable
    public TileEntity a(BlockPosition blockposition, EnumTileEntityState chunk_enumtileentitystate) {
        TileEntity tileentity1;
        NBTTagCompound nbttagcompound;
        TileEntity tileentity = (TileEntity)this.q.capturedTileEntities.get(blockposition);
        if (tileentity == null) {
            tileentity = (TileEntity)this.j.get(blockposition);
        }
        if (tileentity == null && (nbttagcompound = (NBTTagCompound)this.i.remove(blockposition)) != null && (tileentity1 = this.a(blockposition, nbttagcompound)) != null) {
            return tileentity1;
        }
        if (tileentity == null) {
            if (chunk_enumtileentitystate == EnumTileEntityState.a && (tileentity = this.g(blockposition)) != null) {
                this.b(tileentity);
            }
        } else if (tileentity.p()) {
            this.j.remove(blockposition);
            return null;
        }
        return tileentity;
    }

    public void b(TileEntity tileentity) {
        this.a(tileentity);
        if (this.M()) {
            WorldServer world = this.q;
            if (world instanceof WorldServer) {
                WorldServer worldserver = world;
                this.b(tileentity, worldserver);
            }
            this.q.a(tileentity);
            this.c(tileentity);
        }
    }

    private boolean M() {
        return this.p || this.q.D_();
    }

    boolean h(BlockPosition blockposition) {
        if (!this.q.u().a(blockposition)) {
            return false;
        }
        WorldServer world = this.q;
        if (!(world instanceof WorldServer)) {
            return true;
        }
        WorldServer worldserver = world;
        return this.G().a(FullChunkStatus.c) && worldserver.c(ChunkCoordIntPair.a(blockposition));
    }

    @Override
    public void a(TileEntity tileentity) {
        BlockPosition blockposition = tileentity.aD_();
        IBlockData iblockdata = this.a_(blockposition);
        if (!iblockdata.x()) {
            m.warn("Trying to set block entity {} at position {}, but state {} does not allow it", new Object[]{tileentity, blockposition, iblockdata});
            new Exception().printStackTrace();
        } else {
            IBlockData iblockdata1 = tileentity.o();
            if (iblockdata != iblockdata1) {
                if (!tileentity.s().a(iblockdata)) {
                    m.warn("Trying to set block entity {} at position {}, but state {} does not allow it", new Object[]{tileentity, blockposition, iblockdata});
                    return;
                }
                if (iblockdata.b() != iblockdata1.b()) {
                    m.warn("Block state mismatch on block entity {} in position {}, {} != {}, updating", new Object[]{tileentity, blockposition, iblockdata, iblockdata1});
                }
                tileentity.c(iblockdata);
            }
            tileentity.a(this.q);
            tileentity.q();
            TileEntity tileentity1 = this.j.put(blockposition.j(), tileentity);
            if (tileentity1 != null && tileentity1 != tileentity) {
                tileentity1.ay_();
            }
        }
    }

    @Override
    @Nullable
    public NBTTagCompound a(BlockPosition blockposition, HolderLookup.a holderlookup_a) {
        TileEntity tileentity = this.c_(blockposition);
        if (tileentity != null && !tileentity.p()) {
            NBTTagCompound nbttagcompound = tileentity.b(this.q.L_());
            nbttagcompound.a("keepPacked", false);
            return nbttagcompound;
        }
        NBTTagCompound nbttagcompound1 = (NBTTagCompound)this.i.get(blockposition);
        if (nbttagcompound1 != null) {
            nbttagcompound1 = nbttagcompound1.l();
            nbttagcompound1.a("keepPacked", true);
        }
        return nbttagcompound1;
    }

    @Override
    public void d(BlockPosition blockposition) {
        if (this.M()) {
            TileEntity tileentity = (TileEntity)this.j.remove(blockposition);
            if (!this.i.isEmpty()) {
                this.i.remove(blockposition);
            }
            if (tileentity != null) {
                WorldServer world = this.q;
                if (world instanceof WorldServer) {
                    WorldServer worldserver = world;
                    this.a(tileentity, worldserver);
                    worldserver.U().a(blockposition);
                }
                tileentity.ay_();
            }
        }
        this.k(blockposition);
    }

    private <T extends TileEntity> void a(T t0, WorldServer worldserver) {
        GameEventListener gameeventlistener;
        Block block = t0.o().b();
        if (block instanceof ITileEntity && (gameeventlistener = ((ITileEntity)((Object)block)).a(worldserver, t0)) != null) {
            int i2 = SectionPosition.a(t0.aD_().v());
            GameEventListenerRegistry gameeventlistenerregistry = this.a(i2);
            gameeventlistenerregistry.b(gameeventlistener);
        }
    }

    private void c(int i2) {
        this.t.remove(i2);
    }

    private void k(BlockPosition blockposition) {
        d chunk_d = this.o.remove(blockposition);
        if (chunk_d != null) {
            chunk_d.a(n);
        }
    }

    public void H() {
        if (this.s != null) {
            this.s.run(this);
            this.s = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadCallback() {
        CraftServer server = this.q.getCraftServer();
        if (server != null) {
            CraftChunk bukkitChunk = new CraftChunk(this);
            server.getPluginManager().callEvent((Event)new ChunkLoadEvent((org.bukkit.Chunk)bukkitChunk, this.needsDecoration));
            if (this.needsDecoration) {
                this.needsDecoration = false;
                Random random = new Random();
                random.setSeed(this.q.H());
                long xRand = random.nextLong() / 2L * 2L + 1L;
                long zRand = random.nextLong() / 2L * 2L + 1L;
                random.setSeed((long)this.c.h * xRand + (long)this.c.i * zRand ^ this.q.H());
                CraftWorld world = this.q.getWorld();
                if (world != null) {
                    this.q.populating = true;
                    try {
                        for (BlockPopulator populator : world.getPopulators()) {
                            populator.populate((org.bukkit.World)world, random, (org.bukkit.Chunk)bukkitChunk);
                        }
                    }
                    finally {
                        this.q.populating = false;
                    }
                }
                server.getPluginManager().callEvent((Event)new ChunkPopulateEvent((org.bukkit.Chunk)bukkitChunk));
            }
        }
    }

    public void unloadCallback() {
        CraftServer server = this.q.getCraftServer();
        CraftChunk bukkitChunk = new CraftChunk(this);
        ChunkUnloadEvent unloadEvent = new ChunkUnloadEvent((org.bukkit.Chunk)bukkitChunk, this.m());
        server.getPluginManager().callEvent((Event)unloadEvent);
        this.mustNotSave = !unloadEvent.isSaveChunk();
    }

    @Override
    public boolean m() {
        return super.m() && !this.mustNotSave;
    }

    public boolean F() {
        return false;
    }

    public void a(PacketDataSerializer packetdataserializer, Map<HeightMap.Type, long[]> map, Consumer<ClientboundLevelChunkPacketData.b> consumer) {
        this.K();
        for (ChunkSection chunksection : this.l) {
            chunksection.a(packetdataserializer);
        }
        map.forEach(this::a);
        this.C();
        try (ProblemReporter.j problemreporter_j = new ProblemReporter.j(this.E(), m);){
            consumer.accept((blockposition, tileentitytypes, nbttagcompound) -> {
                TileEntity tileentity = this.a(blockposition, EnumTileEntityState.a);
                if (tileentity != null && nbttagcompound != null && tileentity.s() == tileentitytypes) {
                    tileentity.b(TagValueInput.a(problemreporter_j.a(tileentity.v()), (HolderLookup.a)this.q.L_(), nbttagcompound));
                }
            });
        }
    }

    public void a(PacketDataSerializer packetdataserializer) {
        for (ChunkSection chunksection : this.l) {
            chunksection.b(packetdataserializer);
        }
    }

    public void b(boolean flag) {
        this.p = flag;
    }

    public World I() {
        return this.q;
    }

    public Map<BlockPosition, TileEntity> J() {
        return this.j;
    }

    public void a(WorldServer worldserver) {
        ChunkCoordIntPair chunkcoordintpair = this.f();
        for (int i2 = 0; i2 < this.b.length; ++i2) {
            if (this.b[i2] == null) continue;
            for (Short oshort : this.b[i2]) {
                IBlockData iblockdata1;
                BlockPosition blockposition = ProtoChunk.a(oshort, this.h(i2), chunkcoordintpair);
                IBlockData iblockdata = this.a_(blockposition);
                Fluid fluid = iblockdata.y();
                if (!fluid.c()) {
                    fluid.a(worldserver, blockposition, iblockdata);
                }
                if (iblockdata.b() instanceof BlockFluids || (iblockdata1 = Block.b(iblockdata, (GeneratorAccess)worldserver, blockposition)) == iblockdata) continue;
                worldserver.a(blockposition, iblockdata1, 276);
            }
            this.b[i2].clear();
        }
        for (BlockPosition blockposition1 : ImmutableList.copyOf(this.i.keySet())) {
            this.c_(blockposition1);
        }
        this.i.clear();
        this.e.a(this);
    }

    @Nullable
    private TileEntity a(BlockPosition blockposition, NBTTagCompound nbttagcompound) {
        TileEntity tileentity;
        IBlockData iblockdata = this.a_(blockposition);
        if ("DUMMY".equals(nbttagcompound.b("id", ""))) {
            if (iblockdata.x()) {
                tileentity = ((ITileEntity)((Object)iblockdata.b())).a(blockposition, iblockdata);
            } else {
                tileentity = null;
                m.warn("Tried to load a DUMMY block entity @ {} but found not block entity block {} at location", (Object)blockposition, (Object)iblockdata);
            }
        } else {
            tileentity = TileEntity.a(blockposition, iblockdata, nbttagcompound, this.q.L_());
        }
        if (tileentity != null) {
            tileentity.a(this.q);
            this.b(tileentity);
        } else {
            m.warn("Tried to load a block entity for block {} but failed at location {}", (Object)iblockdata, (Object)blockposition);
        }
        return tileentity;
    }

    public void d(long i2) {
        this.u.b(i2);
        this.v.b(i2);
    }

    public void b(WorldServer worldserver) {
        worldserver.o().a(this.c, this.u);
        worldserver.p().a(this.c, this.v);
    }

    public void c(WorldServer worldserver) {
        worldserver.o().a(this.c);
        worldserver.p().a(this.c);
    }

    @Override
    public void a(WorldServer worldserver, DebugValueSource.a debugvaluesource_a) {
        if (!this.g().isEmpty()) {
            debugvaluesource_a.a(DebugSubscriptions.m, () -> {
                ArrayList<DebugStructureInfo> list = new ArrayList<DebugStructureInfo>();
                for (StructureStart structurestart : this.g().values()) {
                    StructureBoundingBox structureboundingbox = structurestart.a();
                    List<StructurePiece> list1 = structurestart.i();
                    ArrayList<DebugStructureInfo.a> list2 = new ArrayList<DebugStructureInfo.a>(list1.size());
                    for (int i2 = 0; i2 < list1.size(); ++i2) {
                        boolean flag = i2 == 0;
                        list2.add(new DebugStructureInfo.a(list1.get(i2).f(), flag));
                    }
                    list.add(new DebugStructureInfo(structureboundingbox, list2));
                }
                return list;
            });
        }
        debugvaluesource_a.a(DebugSubscriptions.l, () -> worldserver.E().a(this.c));
    }

    @Override
    public ChunkStatus n() {
        return ChunkStatus.n;
    }

    public FullChunkStatus G() {
        return this.r == null ? FullChunkStatus.b : this.r.get();
    }

    public void b(Supplier<FullChunkStatus> supplier) {
        this.r = supplier;
    }

    public void K() {
        this.j.values().forEach(TileEntity::ay_);
        this.j.clear();
        this.o.values().forEach(chunk_d -> chunk_d.a(n));
        this.o.clear();
    }

    public void L() {
        this.j.values().forEach(tileentity -> {
            WorldServer world = this.q;
            if (world instanceof WorldServer) {
                WorldServer worldserver = world;
                this.b(tileentity, worldserver);
            }
            this.q.a((TileEntity)tileentity);
            this.c(tileentity);
        });
    }

    private <T extends TileEntity> void b(T t0, WorldServer worldserver) {
        GameEventListener gameeventlistener;
        Block block = t0.o().b();
        if (block instanceof ITileEntity && (gameeventlistener = ((ITileEntity)((Object)block)).a(worldserver, t0)) != null) {
            this.a(SectionPosition.a(t0.aD_().v())).a(gameeventlistener);
        }
    }

    private <T extends TileEntity> void c(T t0) {
        IBlockData iblockdata = t0.o();
        BlockEntityTicker<?> blockentityticker = iblockdata.a((World)this.q, t0.s());
        if (blockentityticker == null) {
            this.k(t0.aD_());
        } else {
            this.o.compute(t0.aD_(), (blockposition, chunk_d) -> {
                TickingBlockEntity tickingblockentity = this.a(t0, blockentityticker);
                if (chunk_d != null) {
                    chunk_d.a(tickingblockentity);
                    return chunk_d;
                }
                if (this.M()) {
                    d chunk_d1 = new d(tickingblockentity);
                    this.q.a(chunk_d1);
                    return chunk_d1;
                }
                return null;
            });
        }
    }

    private <T extends TileEntity> TickingBlockEntity a(T t0, BlockEntityTicker<T> blockentityticker) {
        return new a(t0, blockentityticker);
    }

    @FunctionalInterface
    public static interface c {
        public void run(Chunk var1);
    }

    @FunctionalInterface
    public static interface e {
        public void setUnsaved(ChunkCoordIntPair var1);
    }

    public static enum EnumTileEntityState {
        a,
        b,
        c;

    }

    private static class d
    implements TickingBlockEntity {
        private TickingBlockEntity a;

        d(TickingBlockEntity tickingblockentity) {
            this.a = tickingblockentity;
        }

        void a(TickingBlockEntity tickingblockentity) {
            this.a = tickingblockentity;
        }

        @Override
        public void a() {
            this.a.a();
        }

        @Override
        public boolean b() {
            return this.a.b();
        }

        @Override
        public BlockPosition c() {
            return this.a.c();
        }

        @Override
        public String d() {
            return this.a.d();
        }

        public String toString() {
            return String.valueOf(this.a) + " <wrapped>";
        }
    }

    private class a<T extends TileEntity>
    implements TickingBlockEntity {
        private final T b;
        private final BlockEntityTicker<T> c;
        private boolean d;

        a(TileEntity tileentity, BlockEntityTicker blockentityticker) {
            this.b = tileentity;
            this.c = blockentityticker;
        }

        @Override
        public void a() {
            BlockPosition blockposition;
            if (!((TileEntity)this.b).p() && ((TileEntity)this.b).n() && Chunk.this.h(blockposition = ((TileEntity)this.b).aD_())) {
                try {
                    GameProfilerFiller gameprofilerfiller = Profiler.a();
                    gameprofilerfiller.a(this::d);
                    IBlockData iblockdata = Chunk.this.a_(blockposition);
                    if (((TileEntity)this.b).s().a(iblockdata)) {
                        this.c.tick(Chunk.this.q, ((TileEntity)this.b).aD_(), iblockdata, this.b);
                        this.d = false;
                    } else if (!this.d) {
                        this.d = true;
                        m.warn("Block entity {} @ {} state {} invalid for ticking:", new Object[]{LogUtils.defer(this::d), LogUtils.defer(this::c), iblockdata});
                    }
                    gameprofilerfiller.c();
                }
                catch (Throwable throwable) {
                    CrashReport crashreport = CrashReport.a(throwable, "Ticking block entity");
                    CrashReportSystemDetails crashreportsystemdetails = crashreport.a("Block entity being ticked");
                    ((TileEntity)this.b).a(crashreportsystemdetails);
                    throw new ReportedException(crashreport);
                }
            }
        }

        @Override
        public boolean b() {
            return ((TileEntity)this.b).p();
        }

        @Override
        public BlockPosition c() {
            return ((TileEntity)this.b).aD_();
        }

        @Override
        public String d() {
            return TileEntityTypes.a(((TileEntity)this.b).s()).toString();
        }

        public String toString() {
            String s2 = this.d();
            return "Level ticker for " + s2 + "@" + String.valueOf(this.c());
        }
    }
}

