/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.shorts.ShortArrayList;
import it.unimi.dsi.fastutil.shorts.ShortList;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportedException;
import net.minecraft.SharedConstants;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.QuartPos;
import net.minecraft.core.SectionPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.BiomeResolver;
import net.minecraft.world.level.biome.BiomeSettingsGeneration;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.ChunkConverter;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.LightChunk;
import net.minecraft.world.level.chunk.PalettedContainerFactory;
import net.minecraft.world.level.chunk.StructureAccess;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.gameevent.GameEventListenerRegistry;
import net.minecraft.world.level.levelgen.BelowZeroRetrogen;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.NoiseChunk;
import net.minecraft.world.level.levelgen.blending.BlendingData;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.lighting.ChunkSkyLightSources;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.ticks.TickContainerAccess;
import net.minecraft.world.ticks.TickListChunk;
import org.bukkit.craftbukkit.v1_21_R6.persistence.CraftPersistentDataTypeRegistry;
import org.bukkit.craftbukkit.v1_21_R6.persistence.DirtyCraftPersistentDataContainer;
import org.slf4j.Logger;

public abstract class IChunkAccess
implements BiomeManager.Provider,
LightChunk,
StructureAccess {
    public static final int a = -1;
    private static final Logger m = LogUtils.getLogger();
    private static final LongSet n = new LongOpenHashSet();
    protected final ShortList[] b;
    private volatile boolean o;
    private volatile boolean p;
    protected final ChunkCoordIntPair c;
    private long q;
    @Nullable
    @Deprecated
    private BiomeSettingsGeneration r;
    @Nullable
    protected NoiseChunk d;
    protected final ChunkConverter e;
    @Nullable
    protected BlendingData f;
    public final Map<HeightMap.Type, HeightMap> g = Maps.newEnumMap(HeightMap.Type.class);
    protected ChunkSkyLightSources h;
    private final Map<Structure, StructureStart> s = Maps.newHashMap();
    private final Map<Structure, LongSet> t = Maps.newHashMap();
    protected final Map<BlockPosition, NBTTagCompound> i = Maps.newHashMap();
    public final Map<BlockPosition, TileEntity> j = new Object2ObjectOpenHashMap();
    protected final LevelHeightAccessor k;
    protected final ChunkSection[] l;
    private static final CraftPersistentDataTypeRegistry DATA_TYPE_REGISTRY = new CraftPersistentDataTypeRegistry();
    public DirtyCraftPersistentDataContainer persistentDataContainer = new DirtyCraftPersistentDataContainer(DATA_TYPE_REGISTRY);

    public IChunkAccess(ChunkCoordIntPair chunkcoordintpair, ChunkConverter chunkconverter, LevelHeightAccessor levelheightaccessor, PalettedContainerFactory palettedcontainerfactory, long i2, @Nullable ChunkSection[] achunksection, @Nullable BlendingData blendingdata) {
        this.c = chunkcoordintpair;
        this.e = chunkconverter;
        this.k = levelheightaccessor;
        this.l = new ChunkSection[levelheightaccessor.as()];
        this.q = i2;
        this.b = new ShortList[levelheightaccessor.as()];
        this.f = blendingdata;
        this.h = new ChunkSkyLightSources(levelheightaccessor);
        if (achunksection != null) {
            if (this.l.length == achunksection.length) {
                System.arraycopy(achunksection, 0, this.l, 0, this.l.length);
            } else {
                m.warn("Could not set level chunk sections, array length is {} instead of {}", (Object)achunksection.length, (Object)this.l.length);
            }
        }
        IChunkAccess.a(palettedcontainerfactory, this.l);
    }

    private static void a(PalettedContainerFactory palettedcontainerfactory, ChunkSection[] achunksection) {
        for (int i2 = 0; i2 < achunksection.length; ++i2) {
            if (achunksection[i2] != null) continue;
            achunksection[i2] = new ChunkSection(palettedcontainerfactory);
        }
    }

    public GameEventListenerRegistry a(int i2) {
        return GameEventListenerRegistry.a;
    }

    @Nullable
    public IBlockData a(BlockPosition blockposition, IBlockData iblockdata) {
        return this.a(blockposition, iblockdata, 3);
    }

    @Nullable
    public abstract IBlockData a(BlockPosition var1, IBlockData var2, int var3);

    public abstract void a(TileEntity var1);

    public abstract void a(Entity var1);

    public int a() {
        ChunkSection[] achunksection = this.d();
        for (int i2 = achunksection.length - 1; i2 >= 0; --i2) {
            ChunkSection chunksection = achunksection[i2];
            if (chunksection.c()) continue;
            return i2;
        }
        return -1;
    }

    @Deprecated(forRemoval=true)
    public int b() {
        int i2 = this.a();
        return i2 == -1 ? this.M_() : SectionPosition.c(this.h(i2));
    }

    public Set<BlockPosition> c() {
        HashSet set = Sets.newHashSet(this.i.keySet());
        set.addAll(this.j.keySet());
        return set;
    }

    public ChunkSection[] d() {
        return this.l;
    }

    public ChunkSection b(int i2) {
        return this.d()[i2];
    }

    public Collection<Map.Entry<HeightMap.Type, HeightMap>> e() {
        return Collections.unmodifiableSet(this.g.entrySet());
    }

    public void a(HeightMap.Type heightmap_type, long[] along) {
        this.a(heightmap_type).a(this, heightmap_type, along);
    }

    public HeightMap a(HeightMap.Type heightmap_type) {
        return this.g.computeIfAbsent(heightmap_type, heightmap_type1 -> new HeightMap(this, (HeightMap.Type)heightmap_type1));
    }

    public boolean b(HeightMap.Type heightmap_type) {
        return this.g.get(heightmap_type) != null;
    }

    public int a(HeightMap.Type heightmap_type, int i2, int j2) {
        HeightMap heightmap = this.g.get(heightmap_type);
        if (heightmap == null) {
            if (SharedConstants.be && this instanceof Chunk) {
                m.error("Unprimed heightmap: {} {} {}", new Object[]{heightmap_type, i2, j2});
            }
            HeightMap.a(this, EnumSet.of(heightmap_type));
            heightmap = this.g.get(heightmap_type);
        }
        return heightmap.a(i2 & 0xF, j2 & 0xF) - 1;
    }

    public ChunkCoordIntPair f() {
        return this.c;
    }

    @Override
    @Nullable
    public StructureStart a(Structure structure) {
        return this.s.get(structure);
    }

    @Override
    public void a(Structure structure, StructureStart structurestart) {
        this.s.put(structure, structurestart);
        this.i();
    }

    public Map<Structure, StructureStart> g() {
        return Collections.unmodifiableMap(this.s);
    }

    public void a(Map<Structure, StructureStart> map) {
        this.s.clear();
        this.s.putAll(map);
        this.i();
    }

    @Override
    public LongSet b(Structure structure) {
        return this.t.getOrDefault(structure, n);
    }

    @Override
    public void a(Structure structure, long i2) {
        this.t.computeIfAbsent(structure, structure1 -> new LongOpenHashSet()).add(i2);
        this.i();
    }

    @Override
    public Map<Structure, LongSet> h() {
        return Collections.unmodifiableMap(this.t);
    }

    @Override
    public void b(Map<Structure, LongSet> map) {
        this.t.clear();
        this.t.putAll(map);
        this.i();
    }

    public boolean a(int i2, int j2) {
        if (i2 < this.M_()) {
            i2 = this.M_();
        }
        if (j2 > this.ar()) {
            j2 = this.ar();
        }
        for (int k2 = i2; k2 <= j2; k2 += 16) {
            if (this.b(this.f(k2)).c()) continue;
            return false;
        }
        return true;
    }

    public void i() {
        this.o = true;
    }

    public boolean j() {
        if (this.o) {
            this.o = false;
            this.persistentDataContainer.dirty(false);
            return true;
        }
        return false;
    }

    public boolean m() {
        return this.o || this.persistentDataContainer.dirty();
    }

    public abstract ChunkStatus n();

    public ChunkStatus o() {
        ChunkStatus chunkstatus = this.n();
        BelowZeroRetrogen belowzeroretrogen = this.z();
        if (belowzeroretrogen != null) {
            ChunkStatus chunkstatus1 = belowzeroretrogen.a();
            return ChunkStatus.a(chunkstatus1, chunkstatus);
        }
        return chunkstatus;
    }

    public abstract void d(BlockPosition var1);

    public void e(BlockPosition blockposition) {
        m.warn("Trying to mark a block for PostProcessing @ {}, but this operation is not supported.", (Object)blockposition);
    }

    public ShortList[] p() {
        return this.b;
    }

    public void a(ShortList shortlist, int i2) {
        IChunkAccess.a(this.p(), i2).addAll(shortlist);
    }

    public void a(NBTTagCompound nbttagcompound) {
        BlockPosition blockposition = TileEntity.a(this.c, nbttagcompound);
        if (!this.j.containsKey(blockposition)) {
            this.i.put(blockposition, nbttagcompound);
        }
    }

    @Nullable
    public NBTTagCompound f(BlockPosition blockposition) {
        return this.i.get(blockposition);
    }

    @Nullable
    public abstract NBTTagCompound a(BlockPosition var1, HolderLookup.a var2);

    @Override
    public final void a(BiConsumer<BlockPosition, IBlockData> biconsumer) {
        this.a((IBlockData iblockdata) -> iblockdata.k() != 0, biconsumer);
    }

    public void a(Predicate<IBlockData> predicate, BiConsumer<BlockPosition, IBlockData> biconsumer) {
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
        for (int i2 = this.at(); i2 <= this.au(); ++i2) {
            ChunkSection chunksection = this.b(this.g(i2));
            if (!chunksection.a(predicate)) continue;
            BlockPosition blockposition = SectionPosition.a(this.c, i2).j();
            for (int j2 = 0; j2 < 16; ++j2) {
                for (int k2 = 0; k2 < 16; ++k2) {
                    for (int l2 = 0; l2 < 16; ++l2) {
                        IBlockData iblockdata = chunksection.a(l2, j2, k2);
                        if (!predicate.test(iblockdata)) continue;
                        biconsumer.accept(blockposition_mutableblockposition.a(blockposition, l2, j2, k2), iblockdata);
                    }
                }
            }
        }
    }

    public abstract TickContainerAccess<Block> q();

    public abstract TickContainerAccess<FluidType> r();

    public boolean s() {
        return true;
    }

    public abstract b a(long var1);

    public ChunkConverter t() {
        return this.e;
    }

    public boolean u() {
        return this.f != null;
    }

    @Nullable
    public BlendingData v() {
        return this.f;
    }

    public long w() {
        return this.q;
    }

    public void b(long i2) {
        this.q += i2;
    }

    public void c(long i2) {
        this.q = i2;
    }

    public static ShortList a(ShortList[] ashortlist, int i2) {
        if (ashortlist[i2] == null) {
            ashortlist[i2] = new ShortArrayList();
        }
        return ashortlist[i2];
    }

    public boolean x() {
        return this.p;
    }

    public void a(boolean flag) {
        this.p = flag;
        this.i();
    }

    @Override
    public int M_() {
        return this.k.M_();
    }

    @Override
    public int N_() {
        return this.k.N_();
    }

    public NoiseChunk a(Function<IChunkAccess, NoiseChunk> function) {
        if (this.d == null) {
            this.d = function.apply(this);
        }
        return this.d;
    }

    @Deprecated
    public BiomeSettingsGeneration a(Supplier<BiomeSettingsGeneration> supplier) {
        if (this.r == null) {
            this.r = supplier.get();
        }
        return this.r;
    }

    @Override
    public Holder<BiomeBase> getNoiseBiome(int i2, int j2, int k2) {
        try {
            int l2 = QuartPos.a(this.M_());
            int i1 = l2 + QuartPos.a(this.N_()) - 1;
            int j1 = MathHelper.a(j2, l2, i1);
            int k1 = this.f(QuartPos.c(j1));
            return this.l[k1].c(i2 & 3, j1 & 3, k2 & 3);
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.a(throwable, "Getting biome");
            CrashReportSystemDetails crashreportsystemdetails = crashreport.a("Biome being got");
            crashreportsystemdetails.a("Location", () -> CrashReportSystemDetails.a((LevelHeightAccessor)this, i2, j2, k2));
            throw new ReportedException(crashreport);
        }
    }

    public void setBiome(int i2, int j2, int k2, Holder<BiomeBase> biome) {
        try {
            int l2 = QuartPos.a(this.M_());
            int i1 = l2 + QuartPos.a(this.N_()) - 1;
            int j1 = MathHelper.a(j2, l2, i1);
            int k1 = this.f(QuartPos.c(j1));
            this.l[k1].setBiome(i2 & 3, j1 & 3, k2 & 3, biome);
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.a(throwable, "Setting biome");
            CrashReportSystemDetails crashreportsystemdetails = crashreport.a("Biome being set");
            crashreportsystemdetails.a("Location", () -> CrashReportSystemDetails.a((LevelHeightAccessor)this, i2, j2, k2));
            throw new ReportedException(crashreport);
        }
    }

    public void a(BiomeResolver biomeresolver, Climate.Sampler climate_sampler) {
        ChunkCoordIntPair chunkcoordintpair = this.f();
        int i2 = QuartPos.a(chunkcoordintpair.d());
        int j2 = QuartPos.a(chunkcoordintpair.e());
        LevelHeightAccessor levelheightaccessor = this.B();
        for (int k2 = levelheightaccessor.at(); k2 <= levelheightaccessor.au(); ++k2) {
            ChunkSection chunksection = this.b(this.g(k2));
            int l2 = QuartPos.d(k2);
            chunksection.a(biomeresolver, climate_sampler, i2, l2, j2);
        }
    }

    public boolean y() {
        return !this.h().isEmpty();
    }

    @Nullable
    public BelowZeroRetrogen z() {
        return null;
    }

    public boolean A() {
        return this.z() != null;
    }

    public LevelHeightAccessor B() {
        return this;
    }

    public void C() {
        this.h.a(this);
    }

    @Override
    public ChunkSkyLightSources D() {
        return this.h;
    }

    public static ProblemReporter.f a(ChunkCoordIntPair chunkcoordintpair) {
        return new a(chunkcoordintpair);
    }

    public ProblemReporter.f E() {
        return IChunkAccess.a(this.f());
    }

    private record a(ChunkCoordIntPair a) implements ProblemReporter.f
    {
        @Override
        public String get() {
            return "chunk@" + String.valueOf(this.a);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "pos", "a"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "pos", "a"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "pos", "a"}, this, o2);
        }
    }

    public record b(List<TickListChunk<Block>> a, List<TickListChunk<FluidType>> b) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "blocks;fluids", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "blocks;fluids", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "blocks;fluids", "a", "b"}, this, o2);
        }
    }
}

