/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk.storage;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.logging.LogUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.profiling.jfr.JvmProfiler;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.chunk.storage.RegionFileBitSet;
import net.minecraft.world.level.chunk.storage.RegionFileCompression;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;
import org.slf4j.Logger;

public class RegionFile
implements AutoCloseable {
    private static final Logger c = LogUtils.getLogger();
    private static final int d = 4096;
    @VisibleForTesting
    protected static final int a = 1024;
    private static final int e = 5;
    private static final int f = 0;
    private static final ByteBuffer g = ByteBuffer.allocateDirect(1);
    private static final String h = ".mcc";
    private static final int i = 128;
    private static final int j = 256;
    private static final int k = 0;
    final RegionStorageInfo l;
    private final Path m;
    private final FileChannel n;
    private final Path o;
    final RegionFileCompression p;
    private final ByteBuffer q = ByteBuffer.allocateDirect(8192);
    private final IntBuffer r;
    private final IntBuffer s;
    @VisibleForTesting
    protected final RegionFileBitSet b = new RegionFileBitSet();

    public RegionFile(RegionStorageInfo regionstorageinfo, Path path, Path path1, boolean flag) throws IOException {
        this(regionstorageinfo, path, path1, RegionFileCompression.a(), flag);
    }

    public RegionFile(RegionStorageInfo regionstorageinfo, Path path, Path path1, RegionFileCompression regionfilecompression, boolean flag) throws IOException {
        this.l = regionstorageinfo;
        this.m = path;
        this.p = regionfilecompression;
        if (!Files.isDirectory(path1, new LinkOption[0])) {
            throw new IllegalArgumentException("Expected directory, got " + String.valueOf(path1.toAbsolutePath()));
        }
        this.o = path1;
        this.r = this.q.asIntBuffer();
        ((Buffer)this.r).limit(1024);
        ((Buffer)this.q).position(4096);
        this.s = this.q.asIntBuffer();
        this.n = flag ? FileChannel.open(path, StandardOpenOption.CREATE, StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.DSYNC) : FileChannel.open(path, StandardOpenOption.CREATE, StandardOpenOption.READ, StandardOpenOption.WRITE);
        this.b.a(0, 2);
        ((Buffer)this.q).position(0);
        int i2 = this.n.read(this.q, 0L);
        if (i2 != -1) {
            if (i2 != 8192) {
                c.warn("Region file {} has truncated header: {}", (Object)path, (Object)i2);
            }
            long j2 = Files.size(path);
            for (int k2 = 0; k2 < 1024; ++k2) {
                int l2 = this.r.get(k2);
                if (l2 == 0) continue;
                int i1 = RegionFile.b(l2);
                int j1 = RegionFile.a(l2);
                if (i1 < 2) {
                    c.warn("Region file {} has invalid sector at index: {}; sector {} overlaps with header", new Object[]{path, k2, i1});
                    this.r.put(k2, 0);
                    continue;
                }
                if (j1 == 0) {
                    c.warn("Region file {} has an invalid sector at index: {}; size has to be > 0", (Object)path, (Object)k2);
                    this.r.put(k2, 0);
                    continue;
                }
                if ((long)i1 * 4096L > j2) {
                    c.warn("Region file {} has an invalid sector at index: {}; sector {} is out of bounds", new Object[]{path, k2, i1});
                    this.r.put(k2, 0);
                    continue;
                }
                this.b.a(i1, j1);
            }
        }
    }

    public Path a() {
        return this.m;
    }

    private Path f(ChunkCoordIntPair chunkcoordintpair) {
        String s2 = "c." + chunkcoordintpair.h + "." + chunkcoordintpair.i + h;
        return this.o.resolve(s2);
    }

    @Nullable
    public synchronized DataInputStream a(ChunkCoordIntPair chunkcoordintpair) throws IOException {
        int i2 = this.g(chunkcoordintpair);
        if (i2 == 0) {
            return null;
        }
        int j2 = RegionFile.b(i2);
        int k2 = RegionFile.a(i2);
        int l2 = k2 * 4096;
        ByteBuffer bytebuffer = ByteBuffer.allocate(l2);
        this.n.read(bytebuffer, j2 * 4096);
        ((Buffer)bytebuffer).flip();
        if (bytebuffer.remaining() < 5) {
            c.error("Chunk {} header is truncated: expected {} but read {}", new Object[]{chunkcoordintpair, l2, bytebuffer.remaining()});
            return null;
        }
        int i1 = bytebuffer.getInt();
        byte b0 = bytebuffer.get();
        if (i1 == 0) {
            c.warn("Chunk {} is allocated, but stream is missing", (Object)chunkcoordintpair);
            return null;
        }
        int j1 = i1 - 1;
        if (RegionFile.a(b0)) {
            if (j1 != 0) {
                c.warn("Chunk has both internal and external streams");
            }
            return this.a(chunkcoordintpair, RegionFile.b(b0));
        }
        if (j1 > bytebuffer.remaining()) {
            c.error("Chunk {} stream is truncated: expected {} but read {}", new Object[]{chunkcoordintpair, j1, bytebuffer.remaining()});
            return null;
        }
        if (j1 < 0) {
            c.error("Declared size {} of chunk {} is negative", (Object)i1, (Object)chunkcoordintpair);
            return null;
        }
        JvmProfiler.f.a(this.l, chunkcoordintpair, this.p, j1);
        return this.a(chunkcoordintpair, b0, RegionFile.a(bytebuffer, j1));
    }

    private static int c() {
        return (int)(SystemUtils.e() / 1000L);
    }

    private static boolean a(byte b0) {
        return (b0 & 0x80) != 0;
    }

    private static byte b(byte b0) {
        return (byte)(b0 & 0xFFFFFF7F);
    }

    @Nullable
    private DataInputStream a(ChunkCoordIntPair chunkcoordintpair, byte b0, InputStream inputstream) throws IOException {
        RegionFileCompression regionfilecompression = RegionFileCompression.a(b0);
        if (regionfilecompression == RegionFileCompression.e) {
            String s2 = new DataInputStream(inputstream).readUTF();
            MinecraftKey minecraftkey = MinecraftKey.c(s2);
            if (minecraftkey != null) {
                c.error("Unrecognized custom compression {}", (Object)minecraftkey);
                return null;
            }
            c.error("Invalid custom compression id {}", (Object)s2);
            return null;
        }
        if (regionfilecompression == null) {
            c.error("Chunk {} has invalid chunk stream version {}", (Object)chunkcoordintpair, (Object)b0);
            return null;
        }
        return new DataInputStream(regionfilecompression.a(inputstream));
    }

    @Nullable
    private DataInputStream a(ChunkCoordIntPair chunkcoordintpair, byte b0) throws IOException {
        Path path = this.f(chunkcoordintpair);
        if (!Files.isRegularFile(path, new LinkOption[0])) {
            c.error("External chunk path {} is not file", (Object)path);
            return null;
        }
        return this.a(chunkcoordintpair, b0, Files.newInputStream(path, new OpenOption[0]));
    }

    private static ByteArrayInputStream a(ByteBuffer bytebuffer, int i2) {
        return new ByteArrayInputStream(bytebuffer.array(), bytebuffer.position(), i2);
    }

    private int a(int i2, int j2) {
        return i2 << 8 | j2;
    }

    private static int a(int i2) {
        return i2 & 0xFF;
    }

    private static int b(int i2) {
        return i2 >> 8 & 0xFFFFFF;
    }

    private static int c(int i2) {
        return (i2 + 4096 - 1) / 4096;
    }

    public boolean b(ChunkCoordIntPair chunkcoordintpair) {
        int i2 = this.g(chunkcoordintpair);
        if (i2 == 0) {
            return false;
        }
        int j2 = RegionFile.b(i2);
        int k2 = RegionFile.a(i2);
        ByteBuffer bytebuffer = ByteBuffer.allocate(5);
        try {
            this.n.read(bytebuffer, j2 * 4096);
            ((Buffer)bytebuffer).flip();
            if (bytebuffer.remaining() != 5) {
                return false;
            }
            int l2 = bytebuffer.getInt();
            byte b0 = bytebuffer.get();
            if (RegionFile.a(b0)) {
                if (!RegionFileCompression.b(RegionFile.b(b0))) {
                    return false;
                }
                if (!Files.isRegularFile(this.f(chunkcoordintpair), new LinkOption[0])) {
                    return false;
                }
            } else {
                if (!RegionFileCompression.b(b0)) {
                    return false;
                }
                if (l2 == 0) {
                    return false;
                }
                int i1 = l2 - 1;
                if (i1 < 0 || i1 > 4096 * k2) {
                    return false;
                }
            }
            return true;
        }
        catch (IOException ioexception) {
            return false;
        }
    }

    public DataOutputStream c(ChunkCoordIntPair chunkcoordintpair) throws IOException {
        return new DataOutputStream(this.p.a(new ChunkBuffer(chunkcoordintpair)));
    }

    public void b() throws IOException {
        this.n.force(true);
    }

    public void d(ChunkCoordIntPair chunkcoordintpair) throws IOException {
        int i2 = RegionFile.h(chunkcoordintpair);
        int j2 = this.r.get(i2);
        if (j2 != 0) {
            this.r.put(i2, 0);
            this.s.put(i2, RegionFile.c());
            this.e();
            Files.deleteIfExists(this.f(chunkcoordintpair));
            this.b.b(RegionFile.b(j2), RegionFile.a(j2));
        }
    }

    protected synchronized void a(ChunkCoordIntPair chunkcoordintpair, ByteBuffer bytebuffer) throws IOException {
        b regionfile_b;
        int k1;
        int i2 = RegionFile.h(chunkcoordintpair);
        int j2 = this.r.get(i2);
        int k2 = RegionFile.b(j2);
        int l2 = RegionFile.a(j2);
        int i1 = bytebuffer.remaining();
        int j1 = RegionFile.c(i1);
        if (j1 >= 256) {
            Path path = this.f(chunkcoordintpair);
            c.warn("Saving oversized chunk {} ({} bytes} to external file {}", new Object[]{chunkcoordintpair, i1, path});
            j1 = 1;
            k1 = this.b.a(j1);
            regionfile_b = this.a(path, bytebuffer);
            ByteBuffer bytebuffer1 = this.d();
            this.n.write(bytebuffer1, k1 * 4096);
        } else {
            k1 = this.b.a(j1);
            regionfile_b = () -> Files.deleteIfExists(this.f(chunkcoordintpair));
            this.n.write(bytebuffer, k1 * 4096);
        }
        this.r.put(i2, this.a(k1, j1));
        this.s.put(i2, RegionFile.c());
        this.e();
        regionfile_b.run();
        if (k2 != 0) {
            this.b.b(k2, l2);
        }
    }

    private ByteBuffer d() {
        ByteBuffer bytebuffer = ByteBuffer.allocate(5);
        bytebuffer.putInt(1);
        bytebuffer.put((byte)(this.p.b() | 0x80));
        ((Buffer)bytebuffer).flip();
        return bytebuffer;
    }

    private b a(Path path, ByteBuffer bytebuffer) throws IOException {
        Path path1 = Files.createTempFile(this.o, "tmp", (String)null, new FileAttribute[0]);
        try (FileChannel filechannel = FileChannel.open(path1, StandardOpenOption.CREATE, StandardOpenOption.WRITE);){
            ((Buffer)bytebuffer).position(5);
            filechannel.write(bytebuffer);
        }
        return () -> Files.move(path1, path, StandardCopyOption.REPLACE_EXISTING);
    }

    private void e() throws IOException {
        ((Buffer)this.q).position(0);
        this.n.write(this.q, 0L);
    }

    private int g(ChunkCoordIntPair chunkcoordintpair) {
        return this.r.get(RegionFile.h(chunkcoordintpair));
    }

    public boolean e(ChunkCoordIntPair chunkcoordintpair) {
        return this.g(chunkcoordintpair) != 0;
    }

    private static int h(ChunkCoordIntPair chunkcoordintpair) {
        return chunkcoordintpair.j() + chunkcoordintpair.k() * 32;
    }

    @Override
    public void close() throws IOException {
        try {
            this.f();
        }
        finally {
            try {
                this.n.force(true);
            }
            finally {
                this.n.close();
            }
        }
    }

    private void f() throws IOException {
        int j2;
        int i2 = (int)this.n.size();
        if (i2 != (j2 = RegionFile.c(i2) * 4096)) {
            ByteBuffer bytebuffer = g.duplicate();
            ((Buffer)bytebuffer).position(0);
            this.n.write(bytebuffer, j2 - 1);
        }
    }

    private class ChunkBuffer
    extends ByteArrayOutputStream {
        private final ChunkCoordIntPair b;

        public ChunkBuffer(ChunkCoordIntPair chunkcoordintpair) {
            super(8096);
            super.write(0);
            super.write(0);
            super.write(0);
            super.write(0);
            super.write(RegionFile.this.p.b());
            this.b = chunkcoordintpair;
        }

        @Override
        public void close() throws IOException {
            ByteBuffer bytebuffer = ByteBuffer.wrap(this.buf, 0, this.count);
            int i2 = this.count - 5 + 1;
            JvmProfiler.f.b(RegionFile.this.l, this.b, RegionFile.this.p, i2);
            bytebuffer.putInt(0, i2);
            RegionFile.this.a(this.b, bytebuffer);
        }
    }

    private static interface b {
        public void run() throws IOException;
    }
}

