/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.function.Function;
import net.minecraft.core.QuartPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.dimension.DimensionManager;

public final class NoiseSettings
extends Record {
    private final int g;
    private final int h;
    private final int i;
    private final int j;
    public static final Codec<NoiseSettings> a = RecordCodecBuilder.create(var0 -> var0.group((App)Codec.intRange((int)DimensionManager.e, (int)DimensionManager.d).fieldOf("min_y").forGetter(NoiseSettings::c), (App)Codec.intRange((int)0, (int)DimensionManager.c).fieldOf("height").forGetter(NoiseSettings::d), (App)Codec.intRange((int)1, (int)4).fieldOf("size_horizontal").forGetter(NoiseSettings::e), (App)Codec.intRange((int)1, (int)4).fieldOf("size_vertical").forGetter(NoiseSettings::f)).apply((Applicative)var0, NoiseSettings::new)).comapFlatMap(NoiseSettings::a, Function.identity());
    protected static final NoiseSettings b = NoiseSettings.a(-64, 384, 1, 2);
    protected static final NoiseSettings c = NoiseSettings.a(0, 128, 1, 2);
    protected static final NoiseSettings d = NoiseSettings.a(0, 128, 2, 1);
    protected static final NoiseSettings e = NoiseSettings.a(-64, 192, 1, 2);
    protected static final NoiseSettings f = NoiseSettings.a(0, 256, 2, 1);

    public NoiseSettings(int var0, int var1, int var2, int var3) {
        this.g = var0;
        this.h = var1;
        this.i = var2;
        this.j = var3;
    }

    private static DataResult<NoiseSettings> a(NoiseSettings var0) {
        if (var0.c() + var0.d() > DimensionManager.d + 1) {
            return DataResult.error(() -> "min_y + height cannot be higher than: " + (DimensionManager.d + 1));
        }
        if (var0.d() % 16 != 0) {
            return DataResult.error(() -> "height has to be a multiple of 16");
        }
        if (var0.c() % 16 != 0) {
            return DataResult.error(() -> "min_y has to be a multiple of 16");
        }
        return DataResult.success((Object)var0);
    }

    public static NoiseSettings a(int var02, int var1, int var2, int var3) {
        NoiseSettings var4 = new NoiseSettings(var02, var1, var2, var3);
        NoiseSettings.a(var4).error().ifPresent(var0 -> {
            throw new IllegalStateException(var0.message());
        });
        return var4;
    }

    public int a() {
        return QuartPos.c(this.f());
    }

    public int b() {
        return QuartPos.c(this.e());
    }

    public NoiseSettings a(LevelHeightAccessor var0) {
        int var1 = Math.max(this.g, var0.M_());
        int var2 = Math.min(this.g + this.h, var0.ar() + 1) - var1;
        return new NoiseSettings(var1, var2, this.i, this.j);
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{NoiseSettings.class, "minY;height;noiseSizeHorizontal;noiseSizeVertical", "g", "h", "i", "j"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{NoiseSettings.class, "minY;height;noiseSizeHorizontal;noiseSizeVertical", "g", "h", "i", "j"}, this);
    }

    @Override
    public final boolean equals(Object var0) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{NoiseSettings.class, "minY;height;noiseSizeHorizontal;noiseSizeVertical", "g", "h", "i", "j"}, this, var0);
    }

    public int c() {
        return this.g;
    }

    public int d() {
        return this.h;
    }

    public int e() {
        return this.i;
    }

    public int f() {
        return this.j;
    }
}

