/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.heightproviders;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.heightproviders.HeightProviderType;
import org.slf4j.Logger;

public class TrapezoidHeight
extends HeightProvider {
    public static final MapCodec<TrapezoidHeight> a = RecordCodecBuilder.mapCodec(var02 -> var02.group((App)VerticalAnchor.a.fieldOf("min_inclusive").forGetter(var0 -> var0.d), (App)VerticalAnchor.a.fieldOf("max_inclusive").forGetter(var0 -> var0.e), (App)Codec.INT.optionalFieldOf("plateau", (Object)0).forGetter(var0 -> var0.f)).apply((Applicative)var02, TrapezoidHeight::new));
    private static final Logger b = LogUtils.getLogger();
    private final VerticalAnchor d;
    private final VerticalAnchor e;
    private final int f;

    private TrapezoidHeight(VerticalAnchor var0, VerticalAnchor var1, int var2) {
        this.d = var0;
        this.e = var1;
        this.f = var2;
    }

    public static TrapezoidHeight a(VerticalAnchor var0, VerticalAnchor var1, int var2) {
        return new TrapezoidHeight(var0, var1, var2);
    }

    public static TrapezoidHeight a(VerticalAnchor var0, VerticalAnchor var1) {
        return TrapezoidHeight.a(var0, var1, 0);
    }

    @Override
    public int a(RandomSource var0, WorldGenerationContext var1) {
        int var3;
        int var2 = this.d.a(var1);
        if (var2 > (var3 = this.e.a(var1))) {
            b.warn("Empty height range: {}", (Object)this);
            return var2;
        }
        int var4 = var3 - var2;
        if (this.f >= var4) {
            return MathHelper.b(var0, var2, var3);
        }
        int var5 = (var4 - this.f) / 2;
        int var6 = var4 - var5;
        return var2 + MathHelper.b(var0, 0, var6) + MathHelper.b(var0, 0, var5);
    }

    @Override
    public HeightProviderType<?> a() {
        return HeightProviderType.e;
    }

    public String toString() {
        if (this.f == 0) {
            return "triangle (" + String.valueOf(this.d) + "-" + String.valueOf(this.e) + ")";
        }
        return "trapezoid(" + this.f + ") in [" + String.valueOf(this.d) + "-" + String.valueOf(this.e) + "]";
    }
}

