/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.phys.shapes;

import com.google.common.collect.Lists;
import com.google.common.math.DoubleMath;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumAxisCycle;
import net.minecraft.core.EnumDirection;
import net.minecraft.util.MathHelper;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.DoubleListOffset;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShapeArray;
import net.minecraft.world.phys.shapes.VoxelShapeDiscrete;
import net.minecraft.world.phys.shapes.VoxelShapeSlice;
import net.minecraft.world.phys.shapes.VoxelShapes;

public abstract class VoxelShape {
    protected final VoxelShapeDiscrete a;
    @Nullable
    private VoxelShape[] b;

    protected VoxelShape(VoxelShapeDiscrete var0) {
        this.a = var0;
    }

    public double b(EnumDirection.EnumAxis var0) {
        int var1 = this.a.a(var0);
        if (var1 >= this.a.c(var0)) {
            return Double.POSITIVE_INFINITY;
        }
        return this.a(var0, var1);
    }

    public double c(EnumDirection.EnumAxis var0) {
        int var1 = this.a.b(var0);
        if (var1 <= 0) {
            return Double.NEGATIVE_INFINITY;
        }
        return this.a(var0, var1);
    }

    public AxisAlignedBB a() {
        if (this.c()) {
            throw SystemUtils.b(new UnsupportedOperationException("No bounds for empty shape."));
        }
        return new AxisAlignedBB(this.b(EnumDirection.EnumAxis.a), this.b(EnumDirection.EnumAxis.b), this.b(EnumDirection.EnumAxis.c), this.c(EnumDirection.EnumAxis.a), this.c(EnumDirection.EnumAxis.b), this.c(EnumDirection.EnumAxis.c));
    }

    public VoxelShape b() {
        if (this.c()) {
            return VoxelShapes.a();
        }
        return VoxelShapes.a(this.b(EnumDirection.EnumAxis.a), this.b(EnumDirection.EnumAxis.b), this.b(EnumDirection.EnumAxis.c), this.c(EnumDirection.EnumAxis.a), this.c(EnumDirection.EnumAxis.b), this.c(EnumDirection.EnumAxis.c));
    }

    protected double a(EnumDirection.EnumAxis var0, int var1) {
        return this.a(var0).getDouble(var1);
    }

    public abstract DoubleList a(EnumDirection.EnumAxis var1);

    public boolean c() {
        return this.a.a();
    }

    public VoxelShape a(Vec3D var0) {
        return this.a(var0.g, var0.h, var0.i);
    }

    public VoxelShape a(BaseBlockPosition var0) {
        return this.a((double)var0.u(), (double)var0.v(), (double)var0.w());
    }

    public VoxelShape a(double var0, double var2, double var4) {
        if (this.c()) {
            return VoxelShapes.a();
        }
        return new VoxelShapeArray(this.a, (DoubleList)new DoubleListOffset(this.a(EnumDirection.EnumAxis.a), var0), (DoubleList)new DoubleListOffset(this.a(EnumDirection.EnumAxis.b), var2), (DoubleList)new DoubleListOffset(this.a(EnumDirection.EnumAxis.c), var4));
    }

    public VoxelShape d() {
        VoxelShape[] var0 = new VoxelShape[]{VoxelShapes.a()};
        this.b((double var1, double var3, double var5, double var7, double var9, double var11) -> {
            var0[0] = VoxelShapes.b(var0[0], VoxelShapes.a(var1, var3, var5, var7, var9, var11), OperatorBoolean.o);
        });
        return var0[0];
    }

    public void a(VoxelShapes.a var0) {
        this.a.a((int var1, int var2, int var3, int var4, int var5, int var6) -> var0.consume(this.a(EnumDirection.EnumAxis.a, var1), this.a(EnumDirection.EnumAxis.b, var2), this.a(EnumDirection.EnumAxis.c, var3), this.a(EnumDirection.EnumAxis.a, var4), this.a(EnumDirection.EnumAxis.b, var5), this.a(EnumDirection.EnumAxis.c, var6)), true);
    }

    public void b(VoxelShapes.a var0) {
        DoubleList var1 = this.a(EnumDirection.EnumAxis.a);
        DoubleList var2 = this.a(EnumDirection.EnumAxis.b);
        DoubleList var3 = this.a(EnumDirection.EnumAxis.c);
        this.a.b((var4, var5, var6, var7, var8, var9) -> var0.consume(var1.getDouble(var4), var2.getDouble(var5), var3.getDouble(var6), var1.getDouble(var7), var2.getDouble(var8), var3.getDouble(var9)), true);
    }

    public List<AxisAlignedBB> e() {
        ArrayList var0 = Lists.newArrayList();
        this.b((double var1, double var3, double var5, double var7, double var9, double var11) -> var0.add(new AxisAlignedBB(var1, var3, var5, var7, var9, var11)));
        return var0;
    }

    public double a(EnumDirection.EnumAxis var0, double var1, double var3) {
        int var8;
        EnumDirection.EnumAxis var5 = EnumAxisCycle.b.a(var0);
        EnumDirection.EnumAxis var6 = EnumAxisCycle.c.a(var0);
        int var7 = this.a(var5, var1);
        int var9 = this.a.a(var0, var7, var8 = this.a(var6, var3));
        if (var9 >= this.a.c(var0)) {
            return Double.POSITIVE_INFINITY;
        }
        return this.a(var0, var9);
    }

    public double b(EnumDirection.EnumAxis var0, double var1, double var3) {
        int var8;
        EnumDirection.EnumAxis var5 = EnumAxisCycle.b.a(var0);
        EnumDirection.EnumAxis var6 = EnumAxisCycle.c.a(var0);
        int var7 = this.a(var5, var1);
        int var9 = this.a.b(var0, var7, var8 = this.a(var6, var3));
        if (var9 <= 0) {
            return Double.NEGATIVE_INFINITY;
        }
        return this.a(var0, var9);
    }

    protected int a(EnumDirection.EnumAxis var0, double var1) {
        return MathHelper.a(0, this.a.c(var0) + 1, var3 -> var1 < this.a(var0, var3)) - 1;
    }

    @Nullable
    public MovingObjectPositionBlock a(Vec3D var0, Vec3D var1, BlockPosition var2) {
        if (this.c()) {
            return null;
        }
        Vec3D var3 = var1.d(var0);
        if (var3.h() < 1.0E-7) {
            return null;
        }
        Vec3D var4 = var0.e(var3.c(0.001));
        if (this.a.e(this.a(EnumDirection.EnumAxis.a, var4.g - (double)var2.u()), this.a(EnumDirection.EnumAxis.b, var4.h - (double)var2.v()), this.a(EnumDirection.EnumAxis.c, var4.i - (double)var2.w()))) {
            return new MovingObjectPositionBlock(var4, EnumDirection.a(var3.g, var3.h, var3.i).g(), var2, true);
        }
        return AxisAlignedBB.a(this.e(), var0, var1, var2);
    }

    public Optional<Vec3D> b(Vec3D var0) {
        if (this.c()) {
            return Optional.empty();
        }
        Vec3D[] var1 = new Vec3D[1];
        this.b((double var2, double var4, double var6, double var8, double var10, double var12) -> {
            double var14 = MathHelper.a(var0.a(), var2, var8);
            double var16 = MathHelper.a(var0.b(), var4, var10);
            double var18 = MathHelper.a(var0.c(), var6, var12);
            if (var1[0] == null || var0.c(var14, var16, var18) < var0.g(var1[0])) {
                var1[0] = new Vec3D(var14, var16, var18);
            }
        });
        return Optional.of(var1[0]);
    }

    public VoxelShape a(EnumDirection var0) {
        VoxelShape var1;
        if (this.c() || this == VoxelShapes.b()) {
            return this;
        }
        if (this.b != null) {
            var1 = this.b[var0.ordinal()];
            if (var1 != null) {
                return var1;
            }
        } else {
            this.b = new VoxelShape[6];
        }
        this.b[var0.ordinal()] = var1 = this.b(var0);
        return var1;
    }

    private VoxelShape b(EnumDirection var0) {
        EnumDirection.EnumAxis var1 = var0.o();
        if (this.d(var1)) {
            return this;
        }
        EnumDirection.EnumAxisDirection var2 = var0.f();
        int var3 = this.a(var1, var2 == EnumDirection.EnumAxisDirection.a ? 0.9999999 : 1.0E-7);
        VoxelShapeSlice var4 = new VoxelShapeSlice(this, var1, var3);
        if (var4.c()) {
            return VoxelShapes.a();
        }
        if (var4.f()) {
            return VoxelShapes.b();
        }
        return var4;
    }

    protected boolean f() {
        for (EnumDirection.EnumAxis var3 : EnumDirection.EnumAxis.d) {
            if (this.d(var3)) continue;
            return false;
        }
        return true;
    }

    private boolean d(EnumDirection.EnumAxis var0) {
        DoubleList var1 = this.a(var0);
        return var1.size() == 2 && DoubleMath.fuzzyEquals((double)var1.getDouble(0), (double)0.0, (double)1.0E-7) && DoubleMath.fuzzyEquals((double)var1.getDouble(1), (double)1.0, (double)1.0E-7);
    }

    public double a(EnumDirection.EnumAxis var0, AxisAlignedBB var1, double var2) {
        return this.a(EnumAxisCycle.a(var0, EnumDirection.EnumAxis.a), var1, var2);
    }

    protected double a(EnumAxisCycle var0, AxisAlignedBB var1, double var2) {
        block11: {
            int var17;
            int var15;
            double var10;
            EnumDirection.EnumAxis var5;
            EnumAxisCycle var4;
            block10: {
                if (this.c()) {
                    return var2;
                }
                if (Math.abs(var2) < 1.0E-7) {
                    return 0.0;
                }
                var4 = var0.a();
                var5 = var4.a(EnumDirection.EnumAxis.a);
                EnumDirection.EnumAxis var6 = var4.a(EnumDirection.EnumAxis.b);
                EnumDirection.EnumAxis var7 = var4.a(EnumDirection.EnumAxis.c);
                double var8 = var1.b(var5);
                var10 = var1.a(var5);
                int var12 = this.a(var5, var10 + 1.0E-7);
                int var13 = this.a(var5, var8 - 1.0E-7);
                int var14 = Math.max(0, this.a(var6, var1.a(var6) + 1.0E-7));
                var15 = Math.min(this.a.c(var6), this.a(var6, var1.b(var6) - 1.0E-7) + 1);
                int var16 = Math.max(0, this.a(var7, var1.a(var7) + 1.0E-7));
                var17 = Math.min(this.a.c(var7), this.a(var7, var1.b(var7) - 1.0E-7) + 1);
                int var18 = this.a.c(var5);
                if (!(var2 > 0.0)) break block10;
                for (int var19 = var13 + 1; var19 < var18; ++var19) {
                    for (int var20 = var14; var20 < var15; ++var20) {
                        for (int var21 = var16; var21 < var17; ++var21) {
                            if (!this.a.a(var4, var19, var20, var21)) continue;
                            double var22 = this.a(var5, var19) - var8;
                            if (var22 >= -1.0E-7) {
                                var2 = Math.min(var2, var22);
                            }
                            return var2;
                        }
                    }
                }
                break block11;
            }
            if (!(var2 < 0.0)) break block11;
            for (int var19 = var12 - 1; var19 >= 0; --var19) {
                for (int var20 = var14; var20 < var15; ++var20) {
                    for (int var21 = var16; var21 < var17; ++var21) {
                        if (!this.a.a(var4, var19, var20, var21)) continue;
                        double var22 = this.a(var5, var19 + 1) - var10;
                        if (var22 <= 1.0E-7) {
                            var2 = Math.max(var2, var22);
                        }
                        return var2;
                    }
                }
            }
        }
        return var2;
    }

    public boolean equals(Object var0) {
        return super.equals(var0);
    }

    public String toString() {
        return this.c() ? "EMPTY" : "VoxelShape[" + String.valueOf(this.a()) + "]";
    }
}

