/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R6.inventory;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.PotionRegistry;
import org.bukkit.Color;
import org.bukkit.configuration.serialization.DelegateDeserialization;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftMetaItem;
import org.bukkit.craftbukkit.v1_21_R6.inventory.ItemMetaKey;
import org.bukkit.craftbukkit.v1_21_R6.inventory.SerializableMeta;
import org.bukkit.craftbukkit.v1_21_R6.potion.CraftPotionEffectType;
import org.bukkit.craftbukkit.v1_21_R6.potion.CraftPotionType;
import org.bukkit.craftbukkit.v1_21_R6.potion.CraftPotionUtil;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;

@DelegateDeserialization(value=SerializableMeta.class)
class CraftMetaPotion
extends CraftMetaItem
implements PotionMeta {
    static final CraftMetaItem.ItemMetaKeyType<PotionContents> POTION_CONTENTS = new CraftMetaItem.ItemMetaKeyType<PotionContents>(DataComponents.R);
    static final CraftMetaItem.ItemMetaKeyType<Float> POTION_DURATION_SCALE = new CraftMetaItem.ItemMetaKeyType<Float>(DataComponents.S, "potion-duration-scale");
    static final ItemMetaKey POTION_EFFECTS = new ItemMetaKey("custom-effects");
    static final ItemMetaKey POTION_COLOR = new ItemMetaKey("custom-color");
    static final ItemMetaKey CUSTOM_NAME = new ItemMetaKey("custom-name");
    static final ItemMetaKey DEFAULT_POTION = new ItemMetaKey("potion-type");
    private PotionType type;
    private List<PotionEffect> customEffects;
    private Color color;
    private String customName;
    private Float potionDurationScale;

    CraftMetaPotion(CraftMetaItem meta) {
        super(meta);
        if (!(meta instanceof CraftMetaPotion)) {
            return;
        }
        CraftMetaPotion potionMeta = (CraftMetaPotion)meta;
        this.type = potionMeta.type;
        this.color = potionMeta.color;
        this.customName = potionMeta.customName;
        if (potionMeta.hasCustomEffects()) {
            this.customEffects = new ArrayList<PotionEffect>(potionMeta.customEffects);
        }
        this.potionDurationScale = potionMeta.potionDurationScale;
    }

    CraftMetaPotion(DataComponentPatch tag) {
        super(tag);
        CraftMetaPotion.getOrEmpty(tag, POTION_CONTENTS).ifPresent(potionContents -> {
            potionContents.e().ifPresent(potion -> {
                this.type = CraftPotionType.minecraftHolderToBukkit(potion);
            });
            potionContents.f().ifPresent(customColor -> {
                try {
                    this.color = Color.fromRGB((int)customColor);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            });
            potionContents.g().ifPresent(name -> {
                this.customName = name;
            });
            List<MobEffect> list = potionContents.d();
            int length = list.size();
            this.customEffects = new ArrayList<PotionEffect>(length);
            for (int i2 = 0; i2 < length; ++i2) {
                MobEffect effect = list.get(i2);
                PotionEffectType type = CraftPotionEffectType.minecraftHolderToBukkit(effect.c());
                if (type == null) continue;
                int amp = effect.e();
                int duration = effect.d();
                boolean ambient = effect.f();
                boolean particles = effect.g();
                boolean icon = effect.h();
                this.customEffects.add(new PotionEffect(type, duration, amp, ambient, particles, icon));
            }
        });
        CraftMetaPotion.getOrEmpty(tag, POTION_DURATION_SCALE).ifPresent(potionDurationScale -> {
            this.potionDurationScale = potionDurationScale;
        });
    }

    CraftMetaPotion(Map<String, Object> map) {
        super(map);
        Iterable rawEffectList;
        String name;
        Color color;
        String typeString = SerializableMeta.getString(map, CraftMetaPotion.DEFAULT_POTION.BUKKIT, true);
        if (typeString != null) {
            this.type = CraftPotionType.stringToBukkit(typeString);
        }
        if ((color = SerializableMeta.getObject(Color.class, map, CraftMetaPotion.POTION_COLOR.BUKKIT, true)) != null) {
            this.setColor(color);
        }
        if ((name = SerializableMeta.getString(map, CraftMetaPotion.CUSTOM_NAME.BUKKIT, true)) != null) {
            this.setCustomName(name);
        }
        if ((rawEffectList = SerializableMeta.getObject(Iterable.class, map, CraftMetaPotion.POTION_EFFECTS.BUKKIT, true)) == null) {
            return;
        }
        for (Object obj : rawEffectList) {
            Preconditions.checkArgument((boolean)(obj instanceof PotionEffect), (String)"Object (%s) in effect list is not valid", obj.getClass());
            this.addCustomEffect((PotionEffect)obj, true);
        }
        Float scale = SerializableMeta.getObject(Float.class, map, CraftMetaPotion.POTION_DURATION_SCALE.BUKKIT, true);
        if (scale != null) {
            this.setDurationScale(scale);
        }
    }

    @Override
    void applyToItem(CraftMetaItem.Applicator tag) {
        super.applyToItem(tag);
        if (this.isPotionEmpty()) {
            return;
        }
        Optional<Holder<PotionRegistry>> defaultPotion = this.hasBasePotionType() ? Optional.of(CraftPotionType.bukkitToMinecraftHolder(this.type)) : Optional.empty();
        Optional<Integer> potionColor = this.hasColor() ? Optional.of(this.color.asRGB()) : Optional.empty();
        Optional<String> customName = Optional.ofNullable(this.customName);
        ArrayList<MobEffect> effectList = new ArrayList<MobEffect>();
        if (this.customEffects != null) {
            for (PotionEffect effect : this.customEffects) {
                effectList.add(new MobEffect(CraftPotionEffectType.bukkitToMinecraftHolder(effect.getType()), effect.getDuration(), effect.getAmplifier(), effect.isAmbient(), effect.hasParticles(), effect.hasIcon()));
            }
        }
        tag.put(POTION_CONTENTS, new PotionContents(defaultPotion, potionColor, effectList, customName));
        if (this.hasDurationScale()) {
            tag.put(POTION_DURATION_SCALE, Float.valueOf(this.getDurationScale()));
        }
    }

    @Override
    boolean isEmpty() {
        return super.isEmpty() && this.isPotionEmpty();
    }

    boolean isPotionEmpty() {
        return this.type == null && !this.hasCustomEffects() && !this.hasColor() && !this.hasCustomName() && !this.hasDurationScale();
    }

    @Override
    public CraftMetaPotion clone() {
        CraftMetaPotion clone = (CraftMetaPotion)super.clone();
        clone.type = this.type;
        if (this.customEffects != null) {
            clone.customEffects = new ArrayList<PotionEffect>(this.customEffects);
        }
        return clone;
    }

    public void setBasePotionData(PotionData data) {
        this.setBasePotionType(CraftPotionUtil.fromBukkit(data));
    }

    public PotionData getBasePotionData() {
        return CraftPotionUtil.toBukkit(this.getBasePotionType());
    }

    public void setBasePotionType(PotionType potionType) {
        this.type = potionType;
    }

    public PotionType getBasePotionType() {
        return this.type;
    }

    public boolean hasBasePotionType() {
        return this.type != null;
    }

    public boolean hasCustomEffects() {
        return this.customEffects != null && !this.customEffects.isEmpty();
    }

    public List<PotionEffect> getCustomEffects() {
        if (this.hasCustomEffects()) {
            return ImmutableList.copyOf(this.customEffects);
        }
        return ImmutableList.of();
    }

    public boolean addCustomEffect(PotionEffect effect, boolean overwrite) {
        Preconditions.checkArgument((effect != null ? 1 : 0) != 0, (Object)"Potion effect cannot be null");
        int index = this.indexOfEffect(effect.getType());
        if (index != -1) {
            if (overwrite) {
                PotionEffect old = this.customEffects.get(index);
                if (old.getAmplifier() == effect.getAmplifier() && old.getDuration() == effect.getDuration() && old.isAmbient() == effect.isAmbient()) {
                    return false;
                }
                this.customEffects.set(index, effect);
                return true;
            }
            return false;
        }
        if (this.customEffects == null) {
            this.customEffects = new ArrayList<PotionEffect>();
        }
        this.customEffects.add(effect);
        return true;
    }

    public boolean removeCustomEffect(PotionEffectType type) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"Potion effect type cannot be null");
        if (!this.hasCustomEffects()) {
            return false;
        }
        boolean changed = false;
        Iterator<PotionEffect> iterator = this.customEffects.iterator();
        while (iterator.hasNext()) {
            PotionEffect effect = iterator.next();
            if (!type.equals(effect.getType())) continue;
            iterator.remove();
            changed = true;
        }
        if (this.customEffects.isEmpty()) {
            this.customEffects = null;
        }
        return changed;
    }

    public boolean hasCustomEffect(PotionEffectType type) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"Potion effect type cannot be null");
        return this.indexOfEffect(type) != -1;
    }

    public boolean setMainEffect(PotionEffectType type) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"Potion effect type cannot be null");
        int index = this.indexOfEffect(type);
        if (index == -1 || index == 0) {
            return false;
        }
        PotionEffect old = this.customEffects.get(0);
        this.customEffects.set(0, this.customEffects.get(index));
        this.customEffects.set(index, old);
        return true;
    }

    private int indexOfEffect(PotionEffectType type) {
        if (!this.hasCustomEffects()) {
            return -1;
        }
        for (int i2 = 0; i2 < this.customEffects.size(); ++i2) {
            if (!this.customEffects.get(i2).getType().equals(type)) continue;
            return i2;
        }
        return -1;
    }

    public boolean clearCustomEffects() {
        boolean changed = this.hasCustomEffects();
        this.customEffects = null;
        return changed;
    }

    public boolean hasColor() {
        return this.color != null;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public boolean hasCustomName() {
        return this.customName != null;
    }

    public String getCustomName() {
        return this.customName;
    }

    public void setCustomName(String customName) {
        this.customName = customName;
    }

    public boolean hasDurationScale() {
        return this.potionDurationScale != null;
    }

    public float getDurationScale() {
        Preconditions.checkState((boolean)this.hasDurationScale(), (Object)"hasDurationScale is false");
        return this.potionDurationScale.floatValue();
    }

    public void setDurationScale(Float scale) {
        this.potionDurationScale = scale;
    }

    @Override
    int applyHash() {
        int original;
        int hash = original = super.applyHash();
        if (this.type != null) {
            hash = 73 * hash + this.type.hashCode();
        }
        if (this.hasColor()) {
            hash = 73 * hash + this.color.hashCode();
        }
        if (this.hasCustomName()) {
            hash = 73 * hash + this.customName.hashCode();
        }
        if (this.hasCustomEffects()) {
            hash = 73 * hash + this.customEffects.hashCode();
        }
        if (this.hasDurationScale()) {
            hash = 73 * hash + this.potionDurationScale.hashCode();
        }
        return original != hash ? CraftMetaPotion.class.hashCode() ^ hash : hash;
    }

    @Override
    public boolean equalsCommon(CraftMetaItem meta) {
        if (!super.equalsCommon(meta)) {
            return false;
        }
        if (meta instanceof CraftMetaPotion) {
            CraftMetaPotion that = (CraftMetaPotion)meta;
            return Objects.equals(this.type, that.type) && (this.hasCustomEffects() ? that.hasCustomEffects() && this.customEffects.equals(that.customEffects) : !that.hasCustomEffects()) && (this.hasColor() ? that.hasColor() && this.color.equals((Object)that.color) : !that.hasColor()) && (this.hasCustomName() ? that.hasCustomName() && this.customName.equals(that.customName) : !that.hasCustomName()) && (this.hasDurationScale() ? that.hasDurationScale() && this.potionDurationScale.equals(that.potionDurationScale) : !that.hasDurationScale());
        }
        return true;
    }

    @Override
    boolean notUncommon(CraftMetaItem meta) {
        return super.notUncommon(meta) && (meta instanceof CraftMetaPotion || this.isPotionEmpty());
    }

    @Override
    ImmutableMap.Builder<String, Object> serialize(ImmutableMap.Builder<String, Object> builder) {
        super.serialize(builder);
        if (this.type != null) {
            builder.put((Object)CraftMetaPotion.DEFAULT_POTION.BUKKIT, (Object)CraftPotionType.bukkitToString(this.type));
        }
        if (this.hasColor()) {
            builder.put((Object)CraftMetaPotion.POTION_COLOR.BUKKIT, (Object)this.getColor());
        }
        if (this.hasCustomName()) {
            builder.put((Object)CraftMetaPotion.CUSTOM_NAME.BUKKIT, (Object)this.getCustomName());
        }
        if (this.hasCustomEffects()) {
            builder.put((Object)CraftMetaPotion.POTION_EFFECTS.BUKKIT, (Object)ImmutableList.copyOf(this.customEffects));
        }
        if (this.hasDurationScale()) {
            builder.put((Object)CraftMetaPotion.POTION_DURATION_SCALE.BUKKIT, (Object)Float.valueOf(this.getDurationScale()));
        }
        return builder;
    }
}

