/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.util.StringRepresentable;
import org.jetbrains.annotations.Contract;

public enum ChatFormatting implements StringRepresentable
{
    BLACK("BLACK", '0', 0, 0),
    DARK_BLUE("DARK_BLUE", '1', 1, 170),
    DARK_GREEN("DARK_GREEN", '2', 2, 43520),
    DARK_AQUA("DARK_AQUA", '3', 3, 43690),
    DARK_RED("DARK_RED", '4', 4, 0xAA0000),
    DARK_PURPLE("DARK_PURPLE", '5', 5, 0xAA00AA),
    GOLD("GOLD", '6', 6, 0xFFAA00),
    GRAY("GRAY", '7', 7, 0xAAAAAA),
    DARK_GRAY("DARK_GRAY", '8', 8, 0x555555),
    BLUE("BLUE", '9', 9, 0x5555FF),
    GREEN("GREEN", 'a', 10, 0x55FF55),
    AQUA("AQUA", 'b', 11, 0x55FFFF),
    RED("RED", 'c', 12, 0xFF5555),
    LIGHT_PURPLE("LIGHT_PURPLE", 'd', 13, 0xFF55FF),
    YELLOW("YELLOW", 'e', 14, 0xFFFF55),
    WHITE("WHITE", 'f', 15, 0xFFFFFF),
    OBFUSCATED("OBFUSCATED", 'k', true),
    BOLD("BOLD", 'l', true),
    STRIKETHROUGH("STRIKETHROUGH", 'm', true),
    UNDERLINE("UNDERLINE", 'n', true),
    ITALIC("ITALIC", 'o', true),
    RESET("RESET", 'r', -1, null);

    public static final Codec<ChatFormatting> CODEC;
    public static final Codec<ChatFormatting> COLOR_CODEC;
    public static final char PREFIX_CODE = '\u00a7';
    private static final Map<String, ChatFormatting> FORMATTING_BY_NAME;
    private static final Pattern STRIP_FORMATTING_PATTERN;
    private final String name;
    public final char code;
    private final boolean isFormat;
    private final String toString;
    private final int id;
    @Nullable
    private final Integer color;

    private static String cleanName(String var0) {
        return var0.toLowerCase(Locale.ROOT).replaceAll("[^a-z]", "");
    }

    private ChatFormatting(String var2, char var3, int var4, Integer var5) {
        this(var2, var3, false, var4, var5);
    }

    private ChatFormatting(String var2, char var3, boolean var4) {
        this(var2, var3, var4, -1, null);
    }

    private ChatFormatting(String var2, char var3, boolean var4, int var5, Integer var6) {
        this.name = var2;
        this.code = var3;
        this.isFormat = var4;
        this.id = var5;
        this.color = var6;
        this.toString = "\u00a7" + String.valueOf(var3);
    }

    public char getChar() {
        return this.code;
    }

    public int getId() {
        return this.id;
    }

    public boolean isFormat() {
        return this.isFormat;
    }

    public boolean isColor() {
        return !this.isFormat && this != RESET;
    }

    @Nullable
    public Integer getColor() {
        return this.color;
    }

    public String getName() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public String toString() {
        return this.toString;
    }

    @Nullable
    @Contract(value="!null->!null;_->_")
    public static String stripFormatting(@Nullable String var0) {
        return var0 == null ? null : STRIP_FORMATTING_PATTERN.matcher(var0).replaceAll("");
    }

    @Nullable
    public static ChatFormatting getByName(@Nullable String var0) {
        if (var0 == null) {
            return null;
        }
        return FORMATTING_BY_NAME.get(ChatFormatting.cleanName(var0));
    }

    @Nullable
    public static ChatFormatting getById(int var0) {
        if (var0 < 0) {
            return RESET;
        }
        for (ChatFormatting var4 : ChatFormatting.values()) {
            if (var4.getId() != var0) continue;
            return var4;
        }
        return null;
    }

    @Nullable
    public static ChatFormatting getByCode(char var0) {
        char var1 = Character.toLowerCase(var0);
        for (ChatFormatting var5 : ChatFormatting.values()) {
            if (var5.code != var1) continue;
            return var5;
        }
        return null;
    }

    public static Collection<String> getNames(boolean var0, boolean var1) {
        ArrayList var2 = Lists.newArrayList();
        for (ChatFormatting var6 : ChatFormatting.values()) {
            if (var6.isColor() && !var0 || var6.isFormat() && !var1) continue;
            var2.add(var6.getName());
        }
        return var2;
    }

    @Override
    public String getSerializedName() {
        return this.getName();
    }

    static {
        CODEC = StringRepresentable.fromEnum(ChatFormatting::values);
        COLOR_CODEC = CODEC.validate(var0 -> var0.isFormat() ? DataResult.error(() -> "Formatting was not a valid color: " + String.valueOf(var0)) : DataResult.success((Object)var0));
        FORMATTING_BY_NAME = Arrays.stream(ChatFormatting.values()).collect(Collectors.toMap(var0 -> ChatFormatting.cleanName(var0.name), var0 -> var0));
        STRIP_FORMATTING_PATTERN = Pattern.compile("(?i)\u00a7[0-9A-FK-OR]");
    }
}

