/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft;

import com.mojang.jtracy.TracyClient;
import com.mojang.jtracy.Zone;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import net.minecraft.SharedConstants;

public record TracingExecutor(ExecutorService service) implements Executor
{
    public Executor forName(String var0) {
        if (SharedConstants.IS_RUNNING_IN_IDE) {
            return var1 -> this.service.execute(() -> {
                Thread var2 = Thread.currentThread();
                String var3 = var2.getName();
                var2.setName(var0);
                try (Zone var4 = TracyClient.beginZone((String)var0, (boolean)SharedConstants.IS_RUNNING_IN_IDE);){
                    var1.run();
                }
                finally {
                    var2.setName(var3);
                }
            });
        }
        if (TracyClient.isAvailable()) {
            return var1 -> this.service.execute(() -> {
                try (Zone var2 = TracyClient.beginZone((String)var0, (boolean)SharedConstants.IS_RUNNING_IN_IDE);){
                    var1.run();
                }
            });
        }
        return this.service;
    }

    @Override
    public void execute(Runnable var0) {
        this.service.execute(TracingExecutor.wrapUnnamed(var0));
    }

    public void shutdownAndAwait(long var0, TimeUnit var2) {
        boolean var3;
        this.service.shutdown();
        try {
            var3 = this.service.awaitTermination(var0, var2);
        }
        catch (InterruptedException var4) {
            var3 = false;
        }
        if (!var3) {
            this.service.shutdownNow();
        }
    }

    private static Runnable wrapUnnamed(Runnable var0) {
        if (!TracyClient.isAvailable()) {
            return var0;
        }
        return () -> {
            try (Zone var1 = TracyClient.beginZone((String)"task", (boolean)SharedConstants.IS_RUNNING_IN_IDE);){
                var0.run();
            }
        };
    }
}

