/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments;

import com.google.gson.JsonObject;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.Dynamic3CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.structure.Structure;

public class ResourceArgument<T>
implements ArgumentType<Holder.Reference<T>> {
    private static final Collection<String> EXAMPLES = Arrays.asList("foo", "foo:bar", "012");
    private static final DynamicCommandExceptionType ERROR_NOT_SUMMONABLE_ENTITY = new DynamicCommandExceptionType(var0 -> Component.translatableEscape("entity.not_summonable", var0));
    public static final Dynamic2CommandExceptionType ERROR_UNKNOWN_RESOURCE = new Dynamic2CommandExceptionType((var0, var1) -> Component.translatableEscape("argument.resource.not_found", var0, var1));
    public static final Dynamic3CommandExceptionType ERROR_INVALID_RESOURCE_TYPE = new Dynamic3CommandExceptionType((var0, var1, var2) -> Component.translatableEscape("argument.resource.invalid_type", var0, var1, var2));
    final ResourceKey<? extends Registry<T>> registryKey;
    private final HolderLookup<T> registryLookup;

    public ResourceArgument(CommandBuildContext var0, ResourceKey<? extends Registry<T>> var1) {
        this.registryKey = var1;
        this.registryLookup = var0.lookupOrThrow(var1);
    }

    public static <T> ResourceArgument<T> resource(CommandBuildContext var0, ResourceKey<? extends Registry<T>> var1) {
        return new ResourceArgument<T>(var0, var1);
    }

    public static <T> Holder.Reference<T> getResource(CommandContext<CommandSourceStack> var0, String var1, ResourceKey<Registry<T>> var2) throws CommandSyntaxException {
        Holder.Reference var3 = (Holder.Reference)var0.getArgument(var1, Holder.Reference.class);
        ResourceKey var4 = var3.key();
        if (var4.isFor(var2)) {
            return var3;
        }
        throw ERROR_INVALID_RESOURCE_TYPE.create((Object)var4.location(), (Object)var4.registry(), (Object)var2.location());
    }

    public static Holder.Reference<Attribute> getAttribute(CommandContext<CommandSourceStack> var0, String var1) throws CommandSyntaxException {
        return ResourceArgument.getResource(var0, var1, Registries.ATTRIBUTE);
    }

    public static Holder.Reference<ConfiguredFeature<?, ?>> getConfiguredFeature(CommandContext<CommandSourceStack> var0, String var1) throws CommandSyntaxException {
        return ResourceArgument.getResource(var0, var1, Registries.CONFIGURED_FEATURE);
    }

    public static Holder.Reference<Structure> getStructure(CommandContext<CommandSourceStack> var0, String var1) throws CommandSyntaxException {
        return ResourceArgument.getResource(var0, var1, Registries.STRUCTURE);
    }

    public static Holder.Reference<EntityType<?>> getEntityType(CommandContext<CommandSourceStack> var0, String var1) throws CommandSyntaxException {
        return ResourceArgument.getResource(var0, var1, Registries.ENTITY_TYPE);
    }

    public static Holder.Reference<EntityType<?>> getSummonableEntityType(CommandContext<CommandSourceStack> var0, String var1) throws CommandSyntaxException {
        Holder.Reference<EntityType<?>> var2 = ResourceArgument.getResource(var0, var1, Registries.ENTITY_TYPE);
        if (!((EntityType)var2.value()).canSummon()) {
            throw ERROR_NOT_SUMMONABLE_ENTITY.create((Object)var2.key().location().toString());
        }
        return var2;
    }

    public static Holder.Reference<MobEffect> getMobEffect(CommandContext<CommandSourceStack> var0, String var1) throws CommandSyntaxException {
        return ResourceArgument.getResource(var0, var1, Registries.MOB_EFFECT);
    }

    public static Holder.Reference<Enchantment> getEnchantment(CommandContext<CommandSourceStack> var0, String var1) throws CommandSyntaxException {
        return ResourceArgument.getResource(var0, var1, Registries.ENCHANTMENT);
    }

    public Holder.Reference<T> parse(StringReader var0) throws CommandSyntaxException {
        ResourceLocation var1 = ResourceLocation.read(var0);
        ResourceKey var2 = ResourceKey.create(this.registryKey, var1);
        return this.registryLookup.get(var2).orElseThrow(() -> ERROR_UNKNOWN_RESOURCE.createWithContext((ImmutableStringReader)var0, (Object)var1, (Object)this.registryKey.location()));
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> var0, SuggestionsBuilder var1) {
        return SharedSuggestionProvider.listSuggestions(var0, var1, this.registryKey, SharedSuggestionProvider.ElementSuggestionType.ELEMENTS);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public /* synthetic */ Object parse(StringReader stringReader) throws CommandSyntaxException {
        return this.parse(stringReader);
    }

    public static class Info<T>
    implements ArgumentTypeInfo<ResourceArgument<T>, Template> {
        @Override
        public void serializeToNetwork(Template var0, FriendlyByteBuf var1) {
            var1.writeResourceKey(var0.registryKey);
        }

        @Override
        public Template deserializeFromNetwork(FriendlyByteBuf var0) {
            return new Template(var0.readRegistryKey());
        }

        @Override
        public void serializeToJson(Template var0, JsonObject var1) {
            var1.addProperty("registry", var0.registryKey.location().toString());
        }

        @Override
        public Template unpack(ResourceArgument<T> var0) {
            return new Template(var0.registryKey);
        }

        @Override
        public /* synthetic */ ArgumentTypeInfo.Template deserializeFromNetwork(FriendlyByteBuf friendlyByteBuf) {
            return this.deserializeFromNetwork(friendlyByteBuf);
        }

        public final class Template
        implements ArgumentTypeInfo.Template<ResourceArgument<T>> {
            final ResourceKey<? extends Registry<T>> registryKey;

            Template(ResourceKey var1) {
                this.registryKey = var1;
            }

            @Override
            public ResourceArgument<T> instantiate(CommandBuildContext var0) {
                return new ResourceArgument(var0, this.registryKey);
            }

            @Override
            public ArgumentTypeInfo<ResourceArgument<T>, ?> type() {
                return Info.this;
            }

            @Override
            public /* synthetic */ ArgumentType instantiate(CommandBuildContext commandBuildContext) {
                return this.instantiate(commandBuildContext);
            }
        }
    }
}

