/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;

public interface ClientAsset {
    public ResourceLocation id();

    public record DownloadedTexture(ResourceLocation texturePath, String url) implements Texture
    {
        @Override
        public ResourceLocation id() {
            return this.texturePath;
        }
    }

    public record ResourceTexture(ResourceLocation id, ResourceLocation texturePath) implements Texture
    {
        public static final Codec<ResourceTexture> CODEC = ResourceLocation.CODEC.xmap(ResourceTexture::new, ResourceTexture::id);
        public static final MapCodec<ResourceTexture> DEFAULT_FIELD_CODEC = CODEC.fieldOf("asset_id");
        public static final StreamCodec<ByteBuf, ResourceTexture> STREAM_CODEC = ResourceLocation.STREAM_CODEC.map(ResourceTexture::new, ResourceTexture::id);

        public ResourceTexture(ResourceLocation var02) {
            this(var02, var02.withPath(var0 -> "textures/" + var0 + ".png"));
        }
    }

    public static interface Texture
    extends ClientAsset {
        public ResourceLocation texturePath();
    }
}

